<?php
/**
 * Containing dynamic css news style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$news_keys = array(
	'inspiry_post_text_color',
	'inspiry_post_border_color'
);

$news_options = realhomes_get_options( $news_keys );

$news_css = array(
	'elements' => '
		.posts-main .post-content, 
		.posts-main .post-summary,
		.single-post-main .post-content,
		.single-post-main .post-summary,
		.search-post-main .post-content,
		.search-post-main .post-summary, 
		.archives-main .post-content,
		.archives-main .post-summary,
		.single article p,
		.single article ul,
		.single article ol,
		#overview .property-item .content,
		.inner-wrapper .hentry
	',
	'property' => 'color',
	'value'    => $news_options['inspiry_post_text_color']
);

$news_css = array(
	'elements' => '
		.format-image .format-icon.image,
		.format-video .format-icon.video,
		.format-gallery .format-icon.gallery,
		.listing-slider .flex-direction-nav a.flex-next,
		.listing-slider .flex-direction-nav a.flex-prev,
		.listing-slider .flex-control-paging li a
	',
	'property' => 'background-color',
	'value'    => $news_options['inspiry_post_border_color'],
);

$news_css = array(
	'elements' => '.post-meta',
	'property' => 'border-bottom-color',
	'value'    => $news_options['inspiry_post_border_color'],
);

$news_css = array(
	'elements' => '
		.format-image .format-icon.image,
		.format-video .format-icon.video,
		.format-gallery .format-icon.gallery
	',
	'property' => 'background-color',
	'value'    => $news_options['inspiry_post_border_color'],
);

$news_css = array(
	'elements' => '
		.rh_comments__header,
		#respond #reply-title
	',
	'property' => 'border-top',
	'value'    => '2px solid ' . $news_options['inspiry_post_border_color'],
);

return $news_css;