<?php
/**
 * Containing dynamic css footer style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$footer_keys = array(
	'theme_disable_footer_bg',
	'theme_footer_bg_img',
	array( 'inspiry_footer_background_color', '#f5f5f5' ),
	'theme_footer_widget_title_color',
	'theme_footer_widget_text_color',
	'theme_footer_widget_link_color',
	'theme_footer_widget_link_hover_color',
	'theme_footer_border_color'
);

$footer_options = realhomes_get_options( $footer_keys );

$footer_css = array(
	'elements' => '#footer-wrapper',
	'property' => 'background-color',
	'value'    => $footer_options['inspiry_footer_background_color']
);

$footer_css = array(
	'elements' => '#footer .widget .title',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_title_color']
);

$footer_css = array(
	'elements' => '
		#footer .widget .textwidget,
		#footer .widget, #footer-bottom p
	',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_text_color']
);

$footer_css = array(
	'elements' => '
		#footer .widget ul li a,
		#footer .widget a, #footer-bottom a
	',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_link_color']
);

$footer_css = array(
	'elements' => '
		#footer .widget ul li a:hover,
		#footer .widget ul li a:focus,
		#footer.widget ul li a:active,
		#footer .widget a:hover,
		#footer .widget a:focus,
		#footer .widget a:active,
		#footer-bottom a:hover,
		#footer-bottom a:focus,
		#footer-bottom a:active
	',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_link_hover_color']
);

$footer_css = array(
	'elements' => '#footer-bottom',
	'property' => 'border-color',
	'value'    => $footer_options['theme_footer_border_color']
);

if ( 'true' == $footer_options['theme_disable_footer_bg'] ) {
	// Disable Footer Background Image.
	$footer_css[] = array(
		'elements' => '#footer-wrapper',
		'property' => 'background-image',
		'value'    => 'none'
	);
	$footer_css[] = array(
		'elements' => '#footer-wrapper',
		'property' => 'padding-bottom',
		'value'    => '0px'
	);
} else {
	if ( ! empty( $footer_options['theme_footer_bg_img'] ) ) {
		// Footer Background Image.
		$footer_css[] = array(
			'elements' => '#footer-wrapper',
			'property' => 'background-image',
			'value'    => 'url( ' . $footer_options['theme_footer_bg_img'] . ' )'
		);
	}
}

return $footer_css;