<?php
if ( ! function_exists( 'generate_dynamic_css' ) ) {
	/**
	 * Function: Generate Dynamic CSS.
	 *
	 * @param $realhomes_classic_custom_css
	 *
	 * @return string
	 */
	function generate_dynamic_css( $realhomes_classic_custom_css ) {

		$core_keys = array(
			array( 'inspiry_default_styles', 'custom' ),
			array( 'inspiry_stp_position_from_bottom', '40px' )
		);

		$core_options = realhomes_get_options( $core_keys );

		$get_styles_options               = $core_options['inspiry_default_styles'];
		$inspiry_stp_position_from_bottom = $core_options['inspiry_stp_position_from_bottom'];

		// Only if background image is provided.
		$inspiry_features_background_image = get_post_meta( get_the_ID(), 'inspiry_features_background_image', true );
		if ( ! empty( $inspiry_features_background_image ) ) {
			$inspiry_features_background_image_url = wp_get_attachment_url( $inspiry_features_background_image );
			$realhomes_classic_custom_css          .= '.home-features-section .home-features-bg { background-image: url(' . esc_url( $inspiry_features_background_image_url ) . ');}';
		}

		$stp_bottom_position = array();
		if ( ! empty( $inspiry_stp_position_from_bottom ) ) {
			$stp_bottom_position[] = array(
				'elements' => '#scroll-top',
				'property' => 'bottom',
				'value'    => $inspiry_stp_position_from_bottom,
			);
		}

		$stp_count = count( $stp_bottom_position );
		if ( $stp_count > 0 ) {
			foreach ( $stp_bottom_position as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_classic_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}
		}

		if ( ( $get_styles_options ) && ( $get_styles_options == 'default' ) ) {
			return $realhomes_classic_custom_css;
		}

		$dynamic_css = array_merge(
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/core.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/header.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/banner.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/slider.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/search.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/property.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/ratings.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/footer.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/buttons.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/home.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/gallery.php' ),
			require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/news.php' )
		);

		// Including responsive file to use its returns
		require( get_template_directory() . '/assets/classic/styles/css/dynamic-css/responsive.php' );

		$dynamic_core_css_above_767px         = realhomes_dynamic_core_css_above_767px();
		$dynamic_css_above_980px              = realhomes_dynamic_css_above_980px();
		$dynamic_css_responsive_header_max979 = realhomes_dynamic_css_responsive_header_below_979px();

		$prop_count = count( $dynamic_css );

		if ( $prop_count > 0 ) {

			foreach ( $dynamic_css as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_classic_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}

			/* CSS For min width 980px */
			$realhomes_classic_custom_css .= "@media (min-width: 980px) {\n";

			foreach ( $dynamic_css_above_980px as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_classic_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}

			$realhomes_classic_custom_css .= "}\n";

			$realhomes_classic_custom_css .= "@media (max-width: 979px) {\n";

			foreach ( $dynamic_css_responsive_header_max979 as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_classic_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}

			$realhomes_classic_custom_css .= "}\n";
			/* CSS For min width 767 */
			$realhomes_classic_custom_css .= "@media (max-width: 767px) {\n";

			foreach ( $dynamic_core_css_above_767px as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_classic_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}

			$realhomes_classic_custom_css .= "}\n";
		}

		return $realhomes_classic_custom_css;
	}
}

add_filter( 'realhomes_classic_custom_css', 'generate_dynamic_css' );
