<?php
/**
 * Header File
 *
 * @package    realhomes
 * @subpackage classic
 */

// Desktop Sticky Header
if ( 'true' === get_option( 'theme_sticky_header', 'false' ) ) {
	?>
    <div class="rh_classic_sticky_header">
		<?php get_template_part( 'assets/classic/partials/header/sticky-header' ); ?>
    </div>
	<?php
}

$mobile_sticky_class = ( 'true' === get_option( 'realhomes_mobile_sticky_header', 'false' ) ) ? ' rh-mobile-sticky-header' : '';
$page_custom_header  = get_post_meta( get_the_ID(), 'REAL_HOMES_custom_header_display', true );

if ( class_exists( 'RHEA_Elementor_Header_Footer' ) && ( 'default' !== get_option( 'realhomes_custom_header', 'default' ) || ( ! empty( $page_custom_header ) && 'default' !== $page_custom_header ) ) ) {
	?>
    <div class="rh-custom-header<?php echo esc_attr( $mobile_sticky_class ); ?>">
		<?php do_action( 'realhomes_elementor_header_content' ); ?>
    </div>
	<?php
} else {
	?>
    <!-- Start Header -->
    <div class="header-wrapper<?php echo esc_attr( $mobile_sticky_class ); ?>">
        <div class="container"><!-- Start Header Container -->
			<?php
			/**
			 * Header Variation
			 */
			$inspiry_header_variation = apply_filters( 'inspiry_header_variation', get_option( 'inspiry_header_variation' ) );

			// For demo purpose only.
			if ( isset( $_GET['header-variation'] ) ) {
				$inspiry_header_variation = $_GET['header-variation'];
			}

			if ( 'center' == $inspiry_header_variation ) {
				get_template_part( 'assets/classic/partials/header/variation-center' );
			} else {
				get_template_part( 'assets/classic/partials/header/variation-simple' );
			}
			?>
        </div> <!-- End Header Container -->
    </div><!-- End Header -->
	<?php
}