<?php
/**
 * RealHomes Child theme functions.
 *
 * @package realhomes-child
 */

if ( ! function_exists( 'inspiry_enqueue_child_styles' ) ) {
	/**
	 * Enqueue Styles in Child Theme.
	 */
	function inspiry_enqueue_child_styles() {
		if ( ! is_admin() ) {
			// dequeue and deregister parent default css.
			wp_dequeue_style( 'parent-default' );
			wp_deregister_style( 'parent-default' );

			// dequeue parent custom css.
			wp_dequeue_style( 'parent-custom' );

			// parent default css.
			wp_enqueue_style(
				'parent-default',
				get_template_directory_uri() . '/style.css',
				array(),
				'3.12.1'
			);

			// parent custom css.
			wp_enqueue_style( 'parent-custom' );

			// child default css.
			wp_enqueue_style(
				'child-default',
				get_stylesheet_uri(),
				array( 'parent-default' ),
				'1.4.2',
				'all'
			);

			// child custom css.
			wp_enqueue_style(
				'child-custom',
				get_stylesheet_directory_uri() . '/css/child-custom.css',
				array( 'child-default' ),
				'1.4.2',
				'all'
			);

			// child custom js.
			wp_enqueue_script(
				'child-custom',
				get_stylesheet_directory_uri() . '/js/child-custom.js',
				array( 'jquery' ),
				'1.4.2',
				true
			);
		}
	}
}
add_action( 'wp_enqueue_scripts', 'inspiry_enqueue_child_styles', PHP_INT_MAX );


if ( ! function_exists( 'inspiry_load_translation_from_child' ) ) {
	/**
	 * Load translation files from child theme.
	 */
	function inspiry_load_translation_from_child() {
		load_child_theme_textdomain( 'framework', get_stylesheet_directory() . '/languages' );
	}

	add_action( 'after_setup_theme', 'inspiry_load_translation_from_child' );
}

function custom_wp_login_logo() {
    ?>
    <style type="text/css">
        #login h1 a {
            background-image: url('https://kochiproperty.royaledge.net/wp-content/uploads/2025/12/cropped-464827112_9412225412170402_3271948125850039645_n-1-e1765280671210-removebg-preview.png');
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            width: 100%;
            height: 100px;
        }
    </style>
    <?php
}
add_action('login_enqueue_scripts', 'custom_wp_login_logo');

add_filter('login_headerurl', function () {
    return home_url();
});

add_filter('login_headertext', function () {
    return get_bloginfo('name');
});

add_action( 'wp_footer', function () {
    ?>
    <script>
        jQuery(document).ready(function ($) {
            $('.rhea_permalink').attr('href', '#');
            $('.rh_prop_card__details_elementor h3 a').attr('href', '#');
            $('.rhea_heading_stylish a').attr('href', '#');
            $('.rhea_fp_permalink').attr('href', '#');
            $('.slide').attr('href', '#');
            $('.rh_prop_card__details h3 a').attr('href', '#');
        });


    </script>
    <?php
});

add_action( 'wp_head', function () {
    ?>
    <style>
        .rhea_permalink,
        .rhea_permalink img {
            cursor: default;
        }
        .rh_prop_card__details_elementor h3 a {
            cursor: default;
        }
        .rhea_heading_stylish a {
            cursor: default;
        }
        .rhea_fp_permalink {
            cursor: default;
        }
		.slide {
            cursor: default;
        }
        .rh_prop_card__details h3 a {
            cursor: default;
        }
    </style>
    <?php
});


