<?php
/**
 * Property WooCommerce Payments Settings.
 *
 * This class is used to initialize the settings page of individual properties payments.
 *
 * @since      1.0.0
 * @package    realhomes-wc-payments-addon
 */

if ( ! class_exists( 'Realhomes_Property_WC_Payment_Settings' ) ) {
	/**
	 * Realhomes_Property_WC_Payment_Settings
	 *
	 * Class for WooCommerce Payments Settings. It is responsible
	 * for handling the settings page of individual properites payments.
	 *
	 * @since 1.0.0
	 */
	class Realhomes_Property_WC_Payment_Settings {

		/**
		 * Add plugin settings page menu to the dashboard settings menu.
		 *
		 * @since  1.0.0
		 */
		public function settings_page_menu() {

			add_submenu_page(
				'easy-real-estate',
				esc_html__( 'Woo Payments Settings', 'realhomes-wc-payments-addon' ),
				esc_html__( 'Woo Payments Settings', 'realhomes-wc-payments-addon' ),
				'manage_options',
				'realhomes-property-wc-payment-settings',
				array( $this, 'render_settings_page' )
			);

		}

		/**
		 * Render property payment settings on its settings page.
		 *
		 * @since  1.0.0
		 */
		public function render_settings_page() {
			$rhwpa_settings = get_option( 'rhwpa_property_payment_settings' );
			?>
            <div id="realhomes-settings-wrap">
                <form action='options.php' method='post'>
                    <header class="settings-header">
                        <h1><?php esc_html_e( 'Property WooCommerce Payments Settings', 'realhomes-wc-payments-addon' ); ?><span class="current-version-tag"><?php echo RHWPA_VERSION; ?></span></h1>
                        <p class="credit">
                            <a class="logo-wrap" href="https://themeforest.net/item/real-homes-wordpress-real-estate-theme/5373914?aid=inspirythemes" target="_blank">
                                <svg xmlns="http://www.w3.org/2000/svg" height="29" width="29" viewBox="0 0 36 41">
                                    <style>
                                        .a {
                                            fill: #4E637B;
                                        }

                                        .b {
                                            fill: white;
                                        }

                                        .c {
                                            fill: #27313D !important;
                                        }
                                    </style>
                                    <g>
                                        <path d="M25.5 14.6C28.9 16.6 30.6 17.5 34 19.5L34 11.1C34 10.2 33.5 9.4 32.8 9 30.1 7.5 28.4 6.5 25.5 4.8L25.5 14.6Z" class="a"></path>
                                        <path d="M15.8 38.4C16.5 38.8 17.4 38.8 18.2 38.4 20.8 36.9 22.5 35.9 25.5 34.2 22.1 32.2 20.4 31.3 17 29.3 13.6 31.3 11.9 32.2 8.5 34.2 11.5 35.9 13.1 36.9 15.8 38.4" mask="url(#mask-2)" class="a"></path>
                                        <path d="M24.3 25.1C25 24.7 25.5 23.9 25.5 23L25.5 14.6 17 19.5 17 29.3 24.3 25.1Z" fill="#C8ED1E"></path>
                                        <path d="M18.2 10.4C17.4 10 16.5 10 15.8 10.4L8.5 14.6 17 19.5 25.5 14.6 18.2 10.4Z" fill="#F9FAF8"></path>
                                        <path d="M8.5 23C8.5 23.9 8.9 24.7 9.7 25.1L17 29.3 17 19.5 8.5 14.6 8.5 23Z" fill="#88B2D7"></path>
                                        <path d="M8.5 14.6C5.1 16.6 3.4 17.5 0 19.5L0 11.1C0 10.2 0.5 9.4 1.2 9 3.8 7.5 5.5 6.5 8.5 4.8L8.5 14.6Z" mask="url(#mask-4)" class="a"></path>
                                        <path d="M34 27.9L34 19.5 25.5 14.6 25.5 23C25.5 23.4 25.4 23.8 25.1 24.2L33.6 29.1C33.8 28.7 34 28.3 34 27.9" fill="#5E9E2D"></path>
                                        <path d="M25.1 24.2C24.9 24.6 24.6 24.9 24.3 25.1L17 29.3 25.5 34.2 32.8 30C33.1 29.8 33.4 29.5 33.6 29.1L25.1 24.2Z" fill="#6FBF2C"></path>
                                        <path d="M17 10.1C17.4 10.1 17.8 10.2 18.2 10.4L25.5 14.6 25.5 4.8 18.2 0.6C17.8 0.4 17.4 0.3 17 0.3L17 10.1Z" fill="#BDD2E1"></path>
                                        <path d="M1.2 30L8.5 34.2 17 29.3 9.7 25.1C9.3 24.9 9 24.6 8.8 24.2L0.3 29.1C0.5 29.5 0.8 29.8 1.2 30" fill="#418EDA"></path>
                                        <path d="M8.8 24.2C8.6 23.8 8.5 23.4 8.5 23L8.5 14.6 0 19.5 0 27.9C0 28.3 0.1 28.7 0.3 29.1L8.8 24.2Z" fill="#3570AA"></path>
                                        <path d="M15.8 0.6L8.5 4.8 8.5 14.6 15.8 10.4C16.2 10.2 16.6 10.1 17 10.1L17 0.3C16.6 0.3 16.2 0.4 15.8 0.6" fill="#A7BAC8"></path>
                                    </g>
                                </svg>InspiryThemes
                            </a>
                        </p>
                    </header>
                    <div class="settings-content">
						<?php settings_errors(); ?>
                        <div class="form-wrapper">							
	                        <?php
	                        settings_fields( 'rhwpa_property_payment_settings_group' );
	                        do_settings_sections( 'rhwpa_property_payment_settings_group' );
	                        ?>
                            <table class="form-table">
                                <tbody>
                                <tr>
                                    <th scope="row">
				                        <?php esc_html_e( 'WooCommerce Payments', 'realhomes-wc-payments-addon' ); ?>
                                    </th>
                                    <td>
				                        <?php $enable_wc_payments = ! empty( $rhwpa_settings['enable_wc_payments'] ) ? $rhwpa_settings['enable_wc_payments'] : ''; ?>
                                        <input id="rhwpa_property_payment_settings[enable_wc_payments]" name="rhwpa_property_payment_settings[enable_wc_payments]" type="checkbox" value="1" <?php checked( 1, $enable_wc_payments ); ?> />
                                        <label for="rhwpa_property_payment_settings[enable_wc_payments]"><?php esc_html_e( 'Enable WooCommerce Payments for Submitted Property.', 'realhomes-wc-payments-addon' ); ?></label>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">
                                        <label for="rhwpa_property_payment_settings[currency_code]"><?php esc_html_e( 'Currency Code*', 'realhomes-wc-payments-addon' ); ?></label>
                                    </th>
                                    <td>
				                        <?php $currency_code = get_woocommerce_currency(); ?>
                                        <input id="rhwpa_property_payment_settings[currency_code]" name="rhwpa_property_payment_settings[currency_code]" class="regular-text" type="text" value="<?php echo esc_attr( $currency_code ); ?>" disabled />
                                        <p class="description"><?php echo sprintf( esc_html__( 'Currency code is set from WooCommerce Currency Settings under General Settings tab. To configure WooCommerce Currency Settings please follow %1$sthis guide%2$s.', 'realhomes-wc-payments-addon' ), '<a href="https://docs.woocommerce.com/document/shop-currency/" target="_blank">', '<a>' ); ?></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">
                                        <label for="rhwpa_property_payment_settings[amount]"><?php esc_html_e( 'Payment Amount Per Property*', 'realhomes-wc-payments-addon' ); ?></label>
                                    </th>
                                    <td>
				                        <?php $amount = ! empty( $rhwpa_settings['amount'] ) ? $rhwpa_settings['amount'] : ''; ?>
                                        <input id="rhwpa_property_payment_settings[amount]" name="rhwpa_property_payment_settings[amount]" class="regular-text" type="text" value="<?php echo esc_attr( $amount ); ?>"/>
                                        <p class="description"><?php esc_html_e( 'Provide the amount that you want to charge for one property. Example: 20.00', 'realhomes-wc-payments-addon' ); ?></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">
                                        <label for="rhwpa_property_payment_settings[button_label]"><?php esc_html_e( 'Payment Button Label', 'realhomes-wc-payments-addon' ); ?></label>
                                    </th>
                                    <td>
				                        <?php $button_label = ! empty( $rhwpa_settings['button_label'] ) ? $rhwpa_settings['button_label'] : ''; ?>
                                        <input id="rhwpa_property_payment_settings[button_label]" name="rhwpa_property_payment_settings[button_label]" class="regular-text" type="text" value="<?php echo esc_attr( $button_label ); ?>" placeholder="<?php esc_attr_e( 'Pay Now', 'realhomes-wc-payments-addon' ); ?>"/>
                                        <p class="description"><?php esc_html_e( 'Default: Pay Now', 'realhomes-wc-payments-addon' ); ?></p>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">
				                        <?php esc_html_e( 'Publish Submitted Property after Payment', 'realhomes-wc-payments-addon' ); ?>
                                    </th>
                                    <td>
				                        <?php $publish_property = isset( $rhwpa_settings['publish_property'] ) ? $rhwpa_settings['publish_property'] : '0'; ?>
                                        <label for="rhwpa_property_payment_settings[publish_property]">
                                            <input id="rhwpa_property_payment_settings[publish_property]" name="rhwpa_property_payment_settings[publish_property]" type="radio" value="1" <?php checked( 1, $publish_property, true ); ?> />
                                            <?php esc_html_e( 'Yes', 'realhomes-wc-payments-addon' ); ?>
                                        </label>
                                        <br />
                                        <label for="rhwpa_property_payment_settings[publish_property]">
                                            <input id="rhwpa_property_payment_settings[publish_property]" name="rhwpa_property_payment_settings[publish_property]" type="radio" value="0" <?php checked( 0, $publish_property, true ); ?> />
                                            <?php esc_html_e( 'No', 'realhomes-wc-payments-addon' ); ?>
                                        </label>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                            <?php submit_button(); ?>
                        </div>
                    </div>
                    <footer class="settings-footer">
                        <p>
                            <span class="dashicons dashicons-editor-help"></span>
							<?php printf( esc_html__( 'For help, please consult the %1$s documentation %2$s of the plugin.', 'realhomes-wc-payments-addon' ), '<a href="https://realhomes.io/documentation/realhomes-woocommerce-payment-setup/" target="_blank">', '</a>' ); ?>
                        </p>
                        <p>
                            <span class="dashicons dashicons-feedback"></span>
							<?php printf( esc_html__( 'For feedback, please provide your %1$s feedback here! %2$s', 'realhomes-wc-payments-addon' ), '<a href="' . esc_url( add_query_arg( array( 'page' => 'realhomes-feedback' ), get_admin_url() . 'admin.php' ) ) . '" target="_blank">', '</a>' ); ?>
                        </p>
                    </footer>
                </form>
            </div>
			<?php
		}

		/**
		 * Register property payment settings.
		 *
		 * @since  1.0.0
		 */
		public function register_settings() {
			register_setting( 'rhwpa_property_payment_settings_group', 'rhwpa_property_payment_settings' );
		}
	}
}