/**
 * RVR Admin Scripts
 *
 * @since 1.4.8
 */
( function ( $ ) {
    "use strict";

    const processingLabel  = rvrBookingAdminStrings.processingLabel,
          invoiceGenerated = rvrBookingAdminStrings.invoiceGenerated,
          somethingWrong   = rvrBookingAdminStrings.somethingWrong;

    $( '.generate_booking_invoice' ).on( 'click', function ( e ) {
        e.preventDefault();

        let $this            = $( this ),
            bookingId        = $this.data( 'booking-id' ),
            messageContainer = $( '.rvr-invoice-details .ere-booking-message-container' );

        // Make ajax call to generate an invoice.
        $.ajax( {
            type       : 'POST',
            dataType   : 'json',
            url        : ajaxurl,
            data       : {
                bookingId,
                action : 'rvr_generate_invoice_ajax'
            },
            beforeSend : function () {
                $this.text( processingLabel );
            },
            success    : function ( response ) {
                if ( response.success ) {
                    $this.remove();
                    messageContainer.append( invoiceGenerated ).fadeIn( 200 );
                } else {
                    $this.remove();
                    messageContainer.append( somethingWrong ).fadeIn( 200 );
                }
            }
        } );
    } );

} )( jQuery );