<?php

/**
 * Trait RHEA_Properties_Partials
 *
 * Trait for properties widgets partials
 *
 * @since 2.4.0
 */

trait RHEA_Properties_Partials {
	/**
	 * Controls for property tags
	 *
	 * @since 2.4.0
	 */
	public function properties_tags_controls() {


		$allowed_html = array(
			'a'      => array(
				'href'  => array(),
				'title' => array()
			),
			'br'     => array(),
			'em'     => array(),
			'strong' => array(),
		);

		$this->start_controls_section(
			'property_tags_section',
			[
				'label' => esc_html__( 'Property Tags', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'ere_show_featured_tag',
			[
				'label'              => esc_html__( 'Show Featured Tag', RHEA_TEXT_DOMAIN ),
				'description'        => esc_html__( 'Show if property is set to featured', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'ere_show_label_tags',
			[
				'label'              => esc_html__( 'Show Property Label Tag', RHEA_TEXT_DOMAIN ),
				'description'        => esc_html__( 'Show if property label text is set', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'ere_property_featured_label',
			[
				'label'              => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::TEXT,
				'default'            => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);


		$this->add_control(
			'rhea_tag_feature_bg',
			[
				'label'     => esc_html__( 'Featured Tag Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_featured:before' => 'border-left-color: {{VALUE}};border-right-color: {{VALUE}};border-top-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_feature_icon',
			[
				'label'     => esc_html__( 'Featured Tag Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_featured svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_label_bg',
			[
				'label'     => esc_html__( 'Label Tag Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_hot:before' => 'border-left-color: {{VALUE}};border-right-color: {{VALUE}};border-top-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_label_icon',
			[
				'label'     => esc_html__( 'Label Tag Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea_latest_properties_2 .rhea_hot svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'rhea_tag_tooltip',
			[
				'label'     => esc_html__( 'Tag Tooltip Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-tags .rhea_tags_tooltip_inner' => 'background: {{VALUE}};',
					'{{WRAPPER}} .rhea-tags .rhea_tags_tooltip:after' => 'border-bottom-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'rhea_tag_tooltip_text',
			[
				'label'     => esc_html__( 'Tag Tooltip Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-tags .rhea_tags_tooltip_inner' => 'color: {{VALUE}};',

				],
			]
		);


		$this->end_controls_section();


	}

	/**
	 * Render markup for property tags
	 *
	 * @since 2.4.0
	 *
	 * @param array  $settings Controls Settings.
	 * @param string $class    Container Class Selector.
	 */
	public function render_properties_tags( $property_id, $settings, $class = '' ) {

		$is_featured = get_post_meta( $property_id, 'REAL_HOMES_featured', true );
		$label_text  = get_post_meta( $property_id, 'inspiry_property_label', true );

		$ere_show_featured_tag = $settings['ere_show_featured_tag'];
		$ere_show_label_tags   = $settings['ere_show_label_tags'];

		if ( 'yes' === $ere_show_featured_tag || 'yes' === $ere_show_label_tags ) {
			?>
            <div class="rhea_tags_wrapper <?php echo esc_attr( $class ) ?>">
				<?php
				if ( 'yes' === $ere_show_featured_tag ) {
					if ( '1' === $is_featured ) {
						?>
                        <span class="rhea-tags rhea_featured">
                            <?php include RHEA_ASSETS_DIR . 'icons/featured.svg'; ?>
                           <span class="rhea_tags_tooltip"><span class="rhea_tags_tooltip_inner"><?php echo esc_html( $settings['ere_property_featured_label'] ) ?></span></span>
                        </span>
						<?php
					}
				}
				if ( 'yes' === $ere_show_label_tags ) {
					if ( isset( $label_text ) && ! empty( $label_text ) ) {
						?>
                        <span class="rhea-tags rhea_hot <?php if ( isset( $label_text_bg ) && ! empty( $label_text_bg ) ) {
							echo esc_attr( 'rhea_default_label' );
						} ?>">
                    <?php include RHEA_ASSETS_DIR . 'icons/hot-icon.svg'; ?>
                           <span class="rhea_tags_tooltip"><span class="rhea_tags_tooltip_inner"><?php echo esc_html( $label_text ); ?></span></span>
                        </span>
						<?php
					}
				}
				?>
            </div>
			<?php
		}
	}

	/**
	 * meta_icons_controls
	 *
	 * Meta Icon Controls
	 *
	 * @since 2.4.0
	 *
	 * @param bool $rvr_is_enabled Check if RVR is enabled.
	 */
	public function meta_icons_controls( $rvr_is_enabled = false ) {

		$this->start_controls_section(
			'ere_properties_meta_settings',
			[
				'label' => esc_html__( 'Meta Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'hide_meta_label',
			[
				'label'        => esc_html__( 'Hide Meta Labels', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'layout' => [ 'carousel', 'grid' ],
					'card'   => [ '4' ],
				],
			]
		);

		$get_meta = array(
			'bedrooms'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
			'bathrooms'  => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
			'area'       => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
			'garage'     => esc_html__( 'Garages/Parking', RHEA_TEXT_DOMAIN ),
			'year-built' => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
			'lot-size'   => esc_html__( 'Lot Size', RHEA_TEXT_DOMAIN ),
		);

		$meta_defaults = array(
			array(
				'rhea_property_meta_display' => 'bedrooms',
				'rhea_meta_repeater_label'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
			),
			array(
				'rhea_property_meta_display' => 'bathrooms',
				'rhea_meta_repeater_label'   => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
			),
			array(
				'rhea_property_meta_display' => 'area',
				'rhea_meta_repeater_label'   => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
			),
		);

		if ( $rvr_is_enabled ) {
			$get_meta = array(
				'bedrooms'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
				'bathrooms'  => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
				'area'       => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
				'garage'     => esc_html__( 'Garages/Parking', RHEA_TEXT_DOMAIN ),
				'year-built' => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
				'lot-size'   => esc_html__( 'Lot Size', RHEA_TEXT_DOMAIN ),
				'guests'     => esc_html__( 'Guests Capacity', RHEA_TEXT_DOMAIN ),
				'min-stay'   => esc_html__( 'Min Stay', RHEA_TEXT_DOMAIN ),
			);

			$meta_defaults = array(
				array(
					'rhea_property_meta_display' => 'bedrooms',
					'rhea_meta_repeater_label'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
				),
				array(
					'rhea_property_meta_display' => 'bathrooms',
					'rhea_meta_repeater_label'   => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
				),
				array(
					'rhea_property_meta_display' => 'guests',
					'rhea_meta_repeater_label'   => esc_html__( 'Guests', RHEA_TEXT_DOMAIN ),
				),
				array(
					'rhea_property_meta_display' => 'area',
					'rhea_meta_repeater_label'   => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
				),
			);
		}

		$get_meta = apply_filters( 'rhea_custom_fields_meta_icons', $get_meta );

		$meta_repeater = new \Elementor\Repeater();

		$meta_repeater->add_control(
			'rhea_property_meta_display',
			[
				'label'   => esc_html__( 'Select Meta', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => $get_meta,
			]
		);

		$meta_repeater->add_control(
			'rhea_meta_repeater_label',
			[
				'label'   => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add Label', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'rhea_add_meta_select',
			[
				'label'       => esc_html__( 'Add Meta', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $meta_repeater->get_controls(),
				'default'     => $meta_defaults,
				'title_field' => ' {{{ rhea_meta_repeater_label }}}',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * action_button_controls_v2
	 *
	 * Action Buttons Controls Varition 2
	 *
	 * @since 2.4.0
	 *
	 */
	public function action_button_controls_v2() {

		$this->start_controls_section(
			'property_action_button_section',
			[
				'label' => esc_html__( 'Action Buttons', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_action_button_typography',
				'label'    => esc_html__( 'Action Buttons Labels', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-action-button-box .rhea-ultra-action-buttons a,
				{{WRAPPER}} .rhea-action-button-box .rhea-ultra-action-buttons span',
			]
		);

		if ( 'rhea-properties-grid-v15' === $this->get_name() ) {
			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'property_wide_action_button_typography',
					'label'    => esc_html__( 'Wide Span Action Buttons Labels', RHEA_TEXT_DOMAIN ),
					'global'   => [
						'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
					],
					'selector' => '{{WRAPPER}} .rhea-action-button-box .rhea-ultra-action-buttons a,
				{{WRAPPER}} .rhea-action-button-box .rhea-ultra-action-buttons span',
				]
			);
		}

		$this->add_control(
			'action_buttons_background',
			[
				'label'     => esc_html__( 'Media Count Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span'             => 'background: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a'                => 'background: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span span'           => 'background: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a'              => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action_buttons_background_hover',
			[
				'label'     => esc_html__( 'Media Count Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red'        => 'background: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap span:hover'             => 'background: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover'                => 'background: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight'           => 'background: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span span:hover'           => 'background: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover'              => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action_buttons_text',
			[
				'label'     => esc_html__( 'Media Count Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span'             => 'color: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a'                => 'color: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span span'           => 'color: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a'              => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action_buttons_text_hover',
			[
				'label'     => esc_html__( 'Media Count Text Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red'        => 'color: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap span:hover'             => 'color: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover'                => 'color: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight'           => 'color: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span span:hover'           => 'color: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover'              => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-stroke-dark',
			[
				'label'     => esc_html__( 'Icon Stroke Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-action-button-box .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-stroke-dark-hover',
			[
				'label'     => esc_html__( 'Icon Stroke Dark Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-stroke-dark'        => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-stroke-dark'                => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-stroke-dark'           => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-stroke-dark'              => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-stroke-light',
			[
				'label'     => esc_html__( 'Icon Stroke Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-action-button-box .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'action-icon-stroke-light-hover',
			[
				'label'     => esc_html__( 'Icon Stroke Light Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-stroke-light'        => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-stroke-light'                => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-stroke-light'           => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-stroke-light'              => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'action-icon-fill-dark',
			[
				'label'     => esc_html__( 'Icon Fill Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-action-button-box .rh-ultra-dark' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea-action-button-box .st0'           => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-fill-dark-hover',
			[
				'label'     => esc_html__( 'Icon Fill Dark Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-dark'        => 'fill: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-dark'                => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-dark'           => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-dark'              => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover .rh-ultra-dark' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover .st0'           => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-icon-fill-light',
			[
				'label'     => esc_html__( 'Icon Fill Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-action-button-box .rh-ultra-light' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea-action-button-box .st1'            => 'fill: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'action-icon-fill-light-hover',
			[
				'label'     => esc_html__( 'Icon Fill Light Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap .highlight__red .rh-ultra-light'        => 'fill: {{VALUE}}',
					'{{WRAPPER}} .favorite-btn-wrap a:hover .rh-ultra-light'                => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span .highlight .rh-ultra-light'           => 'fill: {{VALUE}}',
					'{{WRAPPER}} .add-to-compare-span a:hover .rh-ultra-light'              => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover .rh-ultra-light' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea_ultra_media_count .rhea_media:hover .st1'            => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'action-added-buttons',
			[
				'label'     => esc_html__( 'Action Button Added State', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'fav-fill-dark-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Fill Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'fav-fill-light-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Fill Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-light' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'fav-stroke-dark-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Stroke Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'fav-stroke-light-added',
			[
				'label'     => esc_html__( 'Favourite Icon Added Stroke Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .favorite-btn-wrap span.highlight__red .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'compare-fill-dark-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Fill Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'compare-fill-light-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Fill Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-light' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'compare-stroke-dark-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Stroke Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'compare-stroke-light-added',
			[
				'label'     => esc_html__( 'Compare Icon Added Stroke Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-to-compare-span span.highlight .rh-ultra-stroke-light' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * render_meta_icons
	 *
	 * Render Meta Icons
	 *
	 * @since 2.4.0
	 *
	 * @param int    $property_id Property ID.
	 * @param array  $settings    Controls Settings.
	 * @param string $class       Container Class Selector.
	 */
	public function render_meta_icons( $property_id, $settings, $class = '' ) {
		$rhea_add_meta_select = array();

		if ( ! empty( $settings['rhea_add_meta_select'] ) ) {
			$rhea_add_meta_select = $settings['rhea_add_meta_select'];
		}

		$settings_to_keys = array(
			'bedrooms'   => array(
				'key'     => 'REAL_HOMES_property_bedrooms',
				'icon'    => 'ultra-bedrooms',
				'postfix' => ''
			),
			'bathrooms'  => array(
				'key'     => 'REAL_HOMES_property_bathrooms',
				'icon'    => 'ultra-bathrooms',
				'postfix' => ''
			),
			'area'       => array(
				'key'     => 'REAL_HOMES_property_size',
				'icon'    => 'ultra-area',
				'postfix' => 'REAL_HOMES_property_size_postfix'
			),
			'garage'     => array(
				'key'     => 'REAL_HOMES_property_garage',
				'icon'    => 'ultra-garagers',
				'postfix' => ''
			),
			'year-built' => array(
				'key'     => 'REAL_HOMES_property_year_built',
				'icon'    => 'ultra-calender',
				'postfix' => ''
			),
			'lot-size'   => array(
				'key'     => 'REAL_HOMES_property_lot_size',
				'icon'    => 'ultra-lot-size',
				'postfix' => 'REAL_HOMES_property_lot_size_postfix'
			),
		);

		if ( rhea_is_rvr_enabled() ) {
			$rvr_meta = array(
				'guests'   => array(
					'key'     => 'rvr_guests_capacity',
					'icon'    => 'guests-icons',
					'postfix' => ''
				),
				'min-stay' => array(
					'key'     => 'rvr_min_stay',
					'icon'    => 'icon-min-stay',
					'postfix' => ''
				),
			);

			$settings_to_keys = array_merge( $settings_to_keys, $rvr_meta );
		}

		if ( isset( $rhea_add_meta_select ) && ! empty( $rhea_add_meta_select ) ) {
			?>
            <div class="rh_prop_card_meta_wrap_ultra rh-ul-tooltip <?php echo esc_attr( $class ); ?>">
				<?php
				foreach ( $rhea_add_meta_select as $i => $meta ) {
					if ( ! empty( $meta['rhea_property_meta_display'] ) &&
						isset( $settings_to_keys[ $meta['rhea_property_meta_display'] ] )
					) {
						rhea_ultra_meta(
							$meta['rhea_meta_repeater_label'],
							$settings_to_keys[ $meta['rhea_property_meta_display'] ]['key'],
							$settings_to_keys[ $meta['rhea_property_meta_display'] ]['icon'],
							$settings_to_keys[ $meta['rhea_property_meta_display'] ]['postfix'],
							$i + 1

						);
					}
				}

				// display additional fields icons
				do_action( 'rhea_property_listing_additional_fields_icons', $property_id );
				?>
            </div>
			<?php
		}
	}
}

