<?php
/**
 * Property Walkscore Elementor widget for single property
 *
 * @since 2.1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Single_Walk_Score extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	public function get_name() {
		return 'rhea-ultra-single-property-walk-score';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Walk Score', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-number-field rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		// Enable support for title variations
		$this->enable_title_variation_support();
		$this->title_section_content_tab_controls( esc_html__( 'Walkscore', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'features_colors_section',
			[
				'label' => esc_html__( 'Basic Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'container_padding',
			[
				'label'     => esc_html__( 'Container Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh_property__walkscore' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'border-radius',
			[
				'label'      => esc_html__( 'Section Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_property__walkscore' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'bg-color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_property__walkscore' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'section-margin-bottom',
			[
				'label'     => esc_html__( 'Section Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_property__walkscore_wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .rh_property__walkscore',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings            = $this->get_settings_for_display();
		$post_id             = get_the_ID();
		$editor_styles_class = '';

		// Sample Post id for Elementor editor only
		if ( rhea_is_preview_mode() ) {
			$post_id = rhea_get_sample_property_id();
		}

		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$editor_styles_class = 'rhea-section-editor-class';
		}
		?>
        <div class="rh_property__walkscore_wrap margin-bottom-40px <?php realhomes_printable_section( 'walkscore' ); ?>">
			<?php $this->render_section_title( $settings ); ?>
            <div class="rh_property__walkscore <?php echo esc_attr( $editor_styles_class ); ?>">
				<?php
				rhea_print_no_result_for_editor( esc_html__( 'Walk Score will be displayed on frontend only', RHEA_TEXT_DOMAIN ) );
				inspiry_walkscore( $post_id );
				?>
            </div>
        </div>
		<?php
	}
}