<?php
/**
 * Property Analytics Elementor widget for single property
 *
 * @since 2.1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Single_Property_Analytics extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	public function get_name() {
		return 'rhea-ultra-single-property-analytics';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Analytics', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://elementor.github.io/elementor-icons/
		return 'eicon-hotspot rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		// Enable support for title variations
		$this->enable_title_variation_support();
		$this->title_section_content_tab_controls( esc_html__( 'Property Views', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'features_colors_section',
			[
				'label' => esc_html__( 'Basic Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'container_padding',
			[
				'label'     => esc_html__( 'Container Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .chartjs-render-monitor' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'container_border_radius',
			[
				'label'      => esc_html__( 'Container Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .chartjs-render-monitor' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'bg-color',
			[
				'label' => esc_html__( 'Graph Background Color', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'border-color',
			[
				'label' => esc_html__( 'Graph Border Color', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::COLOR,
			]
		);

		$this->add_responsive_control(
			'section-margin-bottom',
			[
				'label'     => esc_html__( 'Section Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_property__views_wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .chartjs-render-monitor',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$post_id  = get_the_ID();

		// Sample Post id for Elementor editor only
		if ( rhea_is_preview_mode() ) {
			$post_id = rhea_get_sample_property_id();
		}
		?>
        <div class="rh_property__views_wrap margin-bottom-40px">
	        <?php $this->render_section_title( $settings ); ?>
			<?php
			if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
				echo '<div class="rhea-section-editor-class">';
				rhea_print_no_result( esc_html__( 'Property Analytics will be displayed on frontend only', RHEA_TEXT_DOMAIN ) );
			} else {
				?>
                <canvas id="property-views-graph" data-bg-color="<?php echo esc_attr( $settings['bg-color'] ) ?>" data-border-color="<?php echo esc_attr( $settings['border-color'] ) ?>" data-property-id="<?php echo esc_attr( $post_id ) ?>"></canvas>
				<?php
			}
			if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
				echo '</div>';
			}
			?>
        </div>
		<?php
	}
}