<?php
/**
 * Property Meta Icons Elementor widget for single property
 *
 * @since 2.1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Single_Property_Meta_Icons extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-ultra-single-property-meta-icons';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Meta V1', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-product-meta rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	public function get_keywords() {
		return [ 'RealHomes', 'Beds', 'Bath', 'Parking', 'Bedrooms', 'Bathroom', 'Area' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'section_title',
			[
				'label'   => esc_html__( 'Section Title', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Overview', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'section_title_color',
			[
				'label'     => esc_html__( 'Section Title Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_property__heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'section_title_typography',
				'label'    => esc_html__( 'Section Title Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_property__heading',
			]
		);
		$this->add_control(
			'property_id_label',
			[
				'label'   => esc_html__( 'Property ID Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Property ID :', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'property_id_separator_color',
			[
				'label'     => esc_html__( 'Property ID Separator Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-overview-separator' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'property_id_color',
			[
				'label'     => esc_html__( 'Property ID Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-property-id span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'proeprty_id_typography',
				'label'    => esc_html__( 'Property ID Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-property-id span',
			]
		);
		$this->add_control(
			'ere_property_featured_label',
			[
				'label'   => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Featured', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'proeprty_featured_typography',
				'label'    => esc_html__( 'Featured Tag Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-ultra-featured',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'property_meta_labels',
			[
				'label' => esc_html__( 'Labels', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'rhea-important-note-control',
			[
				'label' => esc_html__( 'Note: If field is empty, global labels from "Customize >  Property Detail Page > Basics" will be applied. ', RHEA_TEXT_DOMAIN ),
				'type'  => 'rhea-important-note',
			]
		);

		$this->add_control(
			'bedrooms_label',
			[
				'label' => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'bathrooms_label',
			[
				'label' => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'garages_label',
			[
				'label' => esc_html__( 'Garage', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'area_label',
			[
				'label' => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'lot_size_label',
			[
				'label' => esc_html__( 'Lot Size', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'year_built_label',
			[
				'label' => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		if ( rhea_is_rvr_enabled() ) {

			$this->add_control(
				'guests_capacity_label',
				[
					'label' => esc_html__( 'Guests Capacity', RHEA_TEXT_DOMAIN ),
					'type'  => \Elementor\Controls_Manager::TEXT,
				]
			);
			$this->add_control(
				'min_stay_label',
				[
					'label' => esc_html__( 'Min Stay', RHEA_TEXT_DOMAIN ),
					'type'  => \Elementor\Controls_Manager::TEXT,
				]
			);

		}

		$this->end_controls_section();

		$this->start_controls_section(
			'meta_colors_section',
			[
				'label' => esc_html__( 'Basic Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'featured_tag_padding',
			[
				'label'      => esc_html__( 'Featured Tag Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-featured' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'featured_tag_border_radius',
			[
				'label'      => esc_html__( 'Featured Tag Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-ultra-featured' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'meta-padding',
			[
				'label'      => esc_html__( 'Meta Icon Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_ultra_prop_card__meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'meta-icons-border',
				'label'    => esc_html__( 'Meta Icon Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh_ultra_prop_card__meta',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'meta-icons-border-hover',
				'label'    => esc_html__( 'Meta Icon Border Hover', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh_ultra_prop_card__meta:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control(
			'meta-border-radius',
			[
				'label'      => esc_html__( 'Meta Icon Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_ultra_prop_card__meta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'meta-column-gap',
			[
				'label'     => esc_html__( 'Meta Column Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_prop_card_meta_wrap' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'meta-row-gap',
			[
				'label'     => esc_html__( 'Meta Row Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_prop_card_meta_wrap' => 'row-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'meta-margin-bottom',
			[
				'label'     => esc_html__( 'Meta Wrapper Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_prop_card_meta_wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_control(
			'rhea_property_featured_background',
			[
				'label'     => esc_html__( 'Featured Tag Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-featured' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_property_featured_background_hover',
			[
				'label'     => esc_html__( 'Featured Tag Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-featured:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_property_featured_border',
			[
				'label'     => esc_html__( 'Featured Tag Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-featured' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_property_featured_border_hover',
			[
				'label'     => esc_html__( 'Featured Tag Border Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-featured:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_property_featured_color',
			[
				'label'     => esc_html__( 'Featured Tag Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-featured' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_property_featured_color_hover',
			[
				'label'     => esc_html__( 'Featured Tag Text Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-ultra-featured:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'meta-card-bg',
			[
				'label'     => esc_html__( 'Meta Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_prop_card__meta' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta-card-hover',
			[
				'label'     => esc_html__( 'Meta Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_prop_card__meta:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta-card-label',
			[
				'label'     => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_meta_icon_wrapper .rh-ultra-meta-label' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta-card-icon-dark',
			[
				'label'     => esc_html__( 'Meta Icon Dark', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-dark'        => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta-card-icon-light',
			[
				'label'     => esc_html__( 'Meta Icon Light', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-light'       => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-stroke-dark' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta-card-figure',
			[
				'label'     => esc_html__( 'Meta Figure', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_meta_icon_wrapper .figure' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'meta-card-figure-label',
			[
				'label'     => esc_html__( 'Meta Figure Postfix', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_ultra_prop_card_meta_wrap .label' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'meta_typography',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'meta_label_typography',
				'label'    => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_ultra_meta_icon_wrapper .rh-ultra-meta-label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'meta_figure_typography',
				'label'    => esc_html__( 'Meta Figure', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_ultra_meta_icon_wrapper .figure',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'meta_figure_postfix_typography',
				'label'    => esc_html__( 'Meta Figure Postfix', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_ultra_prop_card_meta_wrap .label',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		/**
		 * Property meta of single property template.
		 *
		 * @since      4.0.1
		 * @package    realhomes
		 * @subpackage ultra
		 */

		$settings = $this->get_settings_for_display();

		// Sample Post id for Elementor editor only
		if ( rhea_is_preview_mode() ) {
			$post_id = rhea_get_sample_property_id();
		} else {
			$post_id = get_the_ID();
		}

		// get property custom meta
		$post_meta_data = get_post_custom( $post_id );

		$meta_to_display = array(
			[
				'id'           => 'REAL_HOMES_property_bedrooms',
				'label'        => 'inspiry_bedrooms_field_label',
				'widget_label' => 'bedrooms_label',
				'default'      => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
				'icon'         => 'ultra-bedrooms',
				'post-fix'     => ''
			],
			[
				'id'           => 'REAL_HOMES_property_bathrooms',
				'label'        => 'inspiry_bathrooms_field_label',
				'widget_label' => 'bathrooms_label',
				'default'      => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
				'icon'         => 'ultra-bathrooms',
				'post-fix'     => ''
			],
			[
				'id'           => 'REAL_HOMES_property_garage',
				'label'        => 'inspiry_garages_field_label',
				'widget_label' => 'garages_label',
				'default'      => esc_html__( 'Garage', RHEA_TEXT_DOMAIN ),
				'icon'         => 'ultra-garagers',
				'post-fix'     => ''
			],
			[
				'id'           => 'REAL_HOMES_property_size',
				'label'        => 'inspiry_area_field_label',
				'widget_label' => 'area_label',
				'default'      => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
				'icon'         => 'ultra-area',
				'post-fix'     => 'REAL_HOMES_property_size_postfix'
			],
			[
				'id'           => 'REAL_HOMES_property_lot_size',
				'label'        => 'inspiry_lot_size_field_label',
				'widget_label' => 'lot_size_label',
				'default'      => esc_html__( 'Lot Size', RHEA_TEXT_DOMAIN ),
				'icon'         => 'ultra-lot-size',
				'post-fix'     => 'REAL_HOMES_property_lot_size_postfix'
			],
			[
				'id'           => 'REAL_HOMES_property_year_built',
				'label'        => 'inspiry_year_built_field_label',
				'widget_label' => 'year_built_label',
				'default'      => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
				'icon'         => 'ultra-calender',
				'post-fix'     => ''
			]
		);

		if ( rhea_is_rvr_enabled() ) {
			$rvr_meta_to_display = array(
				[
					'id'           => 'rvr_guests_capacity',
					'label'        => 'inspiry_rvr_guests_field_label',
					'widget_label' => 'guests_capacity_label',
					'default'      => esc_html__( 'Capacity', RHEA_TEXT_DOMAIN ),
					'icon'         => 'guests-icons'
				],
				[
					'id'           => 'rvr_min_stay',
					'label'        => 'inspiry_rvr_min_stay_label',
					'widget_label' => 'min_stay_label',
					'default'      => esc_html__( 'Min Stay', RHEA_TEXT_DOMAIN ),
					'icon'         => 'icon-min-stay'
				],
			);
			array_splice( $meta_to_display, 2, 0, $rvr_meta_to_display );
		}

		$meta_to_display = apply_filters( 'inspiry_property_detail_meta', $meta_to_display );
		?>
        <div class="rh-ultra-overview-box">
            <h4 class="rh_property__heading"><?php echo esc_html( $settings['section_title'] ); ?></h4>
			<?php
			$property_id = get_post_meta( $post_id, 'REAL_HOMES_property_id', true );
			if ( ! empty( $property_id ) ) {
				?>
                <span class="rh-overview-separator">|</span>
                <div class="rh-property-id">
                    <span><?php echo esc_html( $settings['property_id_label'] ); ?></span>
                    <span><?php echo esc_html( $property_id ); ?></span>
                </div>
				<?php
				$is_featured = get_post_meta( $post_id, 'REAL_HOMES_featured', true );
				if ( $is_featured == '1' ) {
					?>
                    <span class="rhea-ultra-featured">
                        <?php
                        if ( ! empty( $settings['ere_property_featured_label'] ) ) {
	                        echo esc_html( $settings['ere_property_featured_label'] );
                        } else {
	                        esc_html_e( 'Featured', RHEA_TEXT_DOMAIN );
                        }
                        ?>
                    </span>
					<?php
				}
			}
			?>
        </div>
        <div class="rh_ultra_prop_card_meta_wrap margin-bottom-40px">
			<?php
			foreach ( $meta_to_display as $key => $value ) {
				if ( ! empty( $post_meta_data[ $value['id'] ][0] ) ) {
					$widget_label = $settings[ $value['widget_label'] ];
					if ( ! empty( $widget_label ) ) {
						$label = $widget_label;
					} else {
						$label = get_option( $value['label'] );
					}
					?>
                    <div class="rh_ultra_prop_card__meta">
                        <div class="rh_ultra_meta_icon_wrapper">
                            <span class="rh-ultra-meta-label"><?php echo ( empty ( $label ) ) ? $value['default'] : esc_html( $label ); ?></span>
                            <div class="rh-ultra-meta-icon-wrapper">
                                <span class="rh_ultra_meta_icon"><?php rhea_property_meta_icon( $value['id'], $value['icon'] ); ?></span>
                                <span class="rh_ultra_meta_box">
                                  <span class="figure"><?php echo esc_html( $post_meta_data[ $value['id'] ][0] ); ?></span>
                                    <?php
                                    if ( ! empty( $value['post-fix'] ) ) {
                                        // The "post-fix" value can either be:
                                        //   - a known postfix meta key (REAL_HOMES_property_size_postfix, lot_size_postfix, etc.)
                                        //   - or a custom meta key stored against the property
                                        $postfix_key   = sanitize_text_field( $value['post-fix'] );
                                        $postfix_value = '';

                                        // Handle property size and lot size separately with helper functions (preferred for units).
                                        if ( 'REAL_HOMES_property_size_postfix' === $postfix_key ) {
                                            $postfix_value = realhomes_get_area_unit( $post_id );
                                        } else if ( 'REAL_HOMES_property_lot_size_postfix' === $postfix_key ) {
                                            $postfix_value = realhomes_get_lot_unit( $post_id );
                                        } else {
                                            // Fallback: fetch the postfix directly from property meta.
                                            $postfix_value = get_post_meta( $post_id, $postfix_key, true );
                                        }

                                        if ( ! empty( $postfix_value ) ) : ?>
                                            <span class="label"><?php echo esc_html( $postfix_value ); ?></span>
                                        <?php endif;
                                    }
                                    ?>
                                  </span>
                            </div>
                        </div>
                    </div>
					<?php
				}
			}
			/**
			 * Additional fields created by New Field Builder
			 */
			do_action( 'inspiry_additional_property_meta_fields', $post_id );
			?>
        </div>
		<?php
	}
}