<?php
/**
 * Property Comments Elementor widget for single property
 *
 * @since 2.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Single_Comments extends \Elementor\Widget_Base {

	public function __construct( array $data = [], ?array $args = null ) {
		parent::__construct( $data, $args );
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			add_filter( 'comments_template_query_args', [
				$this,
				'post_id_args_for_comments'
			] );
			add_filter( 'rhea_comment_post_id_for_editor', [
				$this,
				'post_id_for_comment_template'
			] );
		}
	}

	public function get_name() {
		return 'rhea-ultra-single-property-comments';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Comments', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-comments rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'colors_section',
			[
				'label' => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'comment-counter-color',
			[
				'label'     => esc_html__( 'Comment Counter Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_comments__header h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-author-color',
			[
				'label'     => esc_html__( 'Comment Author', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-meta .author a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-author-hover-color',
			[
				'label'     => esc_html__( 'Comment Author Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-meta .author a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-date-color',
			[
				'label'     => esc_html__( 'Comment Date', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .commentlist .comment-meta time' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-date-hover-color',
			[
				'label'     => esc_html__( 'Comment Date Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .commentlist .comment-meta a:hover time' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-body-color',
			[
				'label'     => esc_html__( 'Comment Body', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-body p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-reply-color',
			[
				'label'     => esc_html__( 'Comment Reply', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-reply-link'        => 'color: {{VALUE}}',
					'{{WRAPPER}} .cancel-comment-reply-link' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-reply-color-hover',
			[
				'label'     => esc_html__( 'Comment Reply Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-reply-link:hover'        => 'color: {{VALUE}}',
					'{{WRAPPER}} .cancel-comment-reply-link:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'leave-reply-text-color',
			[
				'label'     => esc_html__( 'Leave Reply Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-reply-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'form_settings',
			[
				'label' => esc_html__( 'Form Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'container_padding',
			[
				'label'     => esc_html__( 'Container Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh_property__comments' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'container_border_radius',
			[
				'label'      => esc_html__( 'Container Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_property__comments' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .rh_property__comments',
			]
		);

		$this->add_responsive_control(
			'form-padding',
			[
				'label'      => esc_html__( 'Contact Form Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'form-top-text-padding',
			[
				'label'      => esc_html__( 'Form Top Text Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} #comments .logged-in-as'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} #comments .comment-notes' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'form-label-padding',
			[
				'label'      => esc_html__( 'Form Label Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field > label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'form-label-margin',
			[
				'label'      => esc_html__( 'Form Label Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field > label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field-inner-margin',
			[
				'label'      => esc_html__( 'Field Inner Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-field' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'form_wrapper_border_heading',
			[
				'label' => esc_html__( 'Form Wrapper Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-wrapper-border',
				'label'    => esc_html__( 'Form Wrapper Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-property-comment-form',
			]
		);
		$this->add_responsive_control(
			'form-border-radius',
			[
				'label'      => esc_html__( 'Contact Form Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'fields-padding',
			[
				'label'      => esc_html__( 'Fields Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'form_fields_border_heading',
			[
				'label' => esc_html__( 'Form Fields Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);


		$this->start_controls_tabs( 'tabs_button_style' );
		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-fields-border',
				'label'    => esc_html__( 'Form Fields Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form-field-wrapper',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Active', 'elementor' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-fields-border-active',
				'label'    => esc_html__( 'Form Fields Active', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form-field-wrapper:focus-within',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();


		$this->add_responsive_control(
			'fields-border-radius',
			[
				'label'      => esc_html__( 'Fields Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'form_button_border_heading',
			[
				'label' => esc_html__( 'Submit Button Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);


		$this->start_controls_tabs( 'tabs_submit_button_style' );
		$this->start_controls_tab(
			'tab_submit_button_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-submit-button-border',
				'label'    => esc_html__( 'Submit Button Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-button',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_submit_button_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-submit-border-hover',
				'label'    => esc_html__( 'Submit Button Border Hover', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-button:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control(
			'submit-button-border-radius',
			[
				'label'      => esc_html__( 'Submit Button Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'submit-button-margin',
			[
				'label'      => esc_html__( 'Submit Button Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'consent_field_heading',
			[
				'label' => esc_html__( 'GDPR Consent Field Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'consent-border-settings',
				'label'    => esc_html__( 'GDPR Consent Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .comment-form-cookies-consent label',
			]
		);

		$this->add_responsive_control(
			'consent-border-radius',
			[
				'label'      => esc_html__( 'GDPR Consent Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .comment-form-cookies-consent label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'consent-padding',
			[
				'label'      => esc_html__( 'GDPR Consent Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .comment-form-cookies-consent label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'consent-margin',
			[
				'label'      => esc_html__( 'GDPR Consent Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .comment-form-cookies-consent label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'display-icons',
			[
				'label'     => esc_html__( 'Display Fields Icons', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => [
					'none'         => esc_html__( 'None', RHEA_TEXT_DOMAIN ),
					'inline-block' => esc_html__( 'Inline', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper label' => 'display: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'form-bg-color',
			[
				'label'     => esc_html__( 'Form Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'login-text-color',
			[
				'label'     => esc_html__( 'Login Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .logged-in-as' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'login-text-links-color',
			[
				'label'     => esc_html__( 'Login Text Links', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .logged-in-as a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .required'       => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'login-text-links-hover-color',
			[
				'label'     => esc_html__( 'Login Text Links', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .logged-in-as a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comments-note-color',
			[
				'label'     => esc_html__( 'Login Text Links', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-notes' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'fields-label-colors',
			[
				'label'     => esc_html__( 'Fields Label Colors', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field > label' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-form-fields-color',
			[
				'label'     => esc_html__( 'Fields Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-field' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-form-placeholder-color',
			[
				'label'     => esc_html__( 'Fields Placeholder', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form ::-webkit-input-placeholder' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-form :-ms-input-placeholder'      => 'color: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-form ::placeholder'               => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-form-border-color',
			[
				'label'     => esc_html__( 'Fields Bottom Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-field' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-form-border-active-color',
			[
				'label'     => esc_html__( 'Fields Bottom Border Active', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-field:focus' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-form-icons-color',
			[
				'label'     => esc_html__( 'Fields Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper .rh-ultra-dark'        => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-form-field-wrapper .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-form-icons-active-color',
			[
				'label'     => esc_html__( 'Fields Icon Active', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper:focus-within .rh-ultra-dark'        => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-form-field-wrapper:focus-within .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow-fields',
				'label'    => esc_html__( 'Fields Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form-field-wrapper',
			]
		);
		$this->add_control(
			'agent-contact-error-color',
			[
				'label'     => esc_html__( 'Error Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form .error-container label' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-submit-color',
			[
				'label'     => esc_html__( 'Submit Button Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-submit-hover-color',
			[
				'label'     => esc_html__( 'Submit Button Text Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-button:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-submit-bg-color',
			[
				'label'     => esc_html__( 'Submit Button Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-button' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-submit-bg-hover-color',
			[
				'label'     => esc_html__( 'Submit Button Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-button:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-submit-border-color',
			[
				'label'     => esc_html__( 'Submit Button Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-button' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent-contact-submit-border-hover-color',
			[
				'label'     => esc_html__( 'Submit Button Border Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-button:hover' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'comment-consent-text-color',
			[
				'label'     => esc_html__( 'Comment Consent Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wp-comment-cookies-consent' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'comment-rating-star-color',
			[
				'label'     => esc_html__( 'Rating Stars', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #comments .fa-star'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .br-theme-fontawesome-stars .br-widget a:after' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'comment-rating-star-color-hover',
			[
				'label'     => esc_html__( 'Rating Stars Hover/Selected', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .br-theme-fontawesome-stars .br-widget a.br-active:after'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .br-theme-fontawesome-stars .br-widget a.br-selected:after' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'rating-stars-margin',
			[
				'label'      => esc_html__( 'Rating Stars Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .br-theme-fontawesome-stars .br-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'typography_settings',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'comments-count-typography',
				'label'    => esc_html__( 'Comments Count', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} #comments-title',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'commenter-title-typography',
				'label'    => esc_html__( 'Commenter Title', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .commentlist .comment-meta cite',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'commenter-date-typography',
				'label'    => esc_html__( 'Commenter Date', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .commentlist .comment-meta time',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'commenter-body-typography',
				'label'    => esc_html__( 'Comment Body', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .commentlist .comment-body > p',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'commenter-reply-title-typography',
				'label'    => esc_html__( 'Comment Reply Title', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .comment-reply-title',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form-top-text-typography',
				'label'    => esc_html__( 'Top Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} #comments .logged-in-as, {{WRAPPER}} #comments .comment-notes',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'cancel-reply-typography',
				'label'    => esc_html__( 'Cancel Reply Title', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .cancel-comment-reply-link',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form-label-typography',
				'label'    => esc_html__( 'Form Label', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-ultra-form-field > label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form-field-typography',
				'label'    => esc_html__( 'Form Field Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-ultra-field',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form-consent-typography',
				'label'    => esc_html__( 'Form Consent Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .wp-comment-cookies-consent',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form-button-typography',
				'label'    => esc_html__( 'Form Button Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-ultra-button',
			]
		);

		$this->end_controls_section();
	}

	public function post_id_args_for_comments( $array ) {
		$array['post_id'] = rhea_get_sample_property_id();

		return $array;
	}

	public function post_id_for_comment_template( $post_id ) {
		$post_id = rhea_get_sample_property_id();

		return $post_id;
	}

	protected function render() {
		if ( rhea_is_preview_mode() || comments_open() || get_comments_number() ) {
			?>
            <section class="property-comments rh_property__comments rh-ultra-property-comment margin-bottom-40px">
				<?php
				// Comments Template
				comments_template();
				?>
            </section>
			<?php
		}
	}
}