<?php
/**
 * Property RVR Availability Calendar
 *
 * @since 2.2.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Single_Availability_Calendar extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-ultra-pdp-availability-calendar';
	}

	public function get_title() {
		return esc_html__( 'RH: Availability Calendar', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-calendar rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'settings_section',
			[
				'label' => esc_html__( 'Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'section_title',
			[
				'label'   => esc_html__( 'Section Title', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Property Availability', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'section_title_typography',
				'label'    => esc_html__( 'Section Title Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_rvr_outdoor_features_wrapper .rh_property__heading'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'item_title_typography',
				'label'    => esc_html__( 'Item Title Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_rvr_outdoor_features_wrapper h5',
			]
		);

		$this->add_control(
			'item_icon_size',
			[
				'label'      => esc_html__( 'Icon Size', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range'      => [
					'px' => [
						'min'  => 1,
						'max'  => 100,
						'step' => 1
					]
				],
				'default'    => [
					'unit' => 'px',
					'size' => 15
				],
				'selectors'  => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper .rh_done_icon svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'styles_section',
			[
				'label' => esc_html__( 'Basic Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'section_title_color',
			[
				'label'     => esc_html__( 'Section Title Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper .rh_property__heading' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'item_icon_color',
			[
				'label'     => esc_html__( 'Item Icon Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper .rh_done_icon' => 'color: {{VALUE}}',
				]
			]
		);

		$this->add_control(
			'item_title_color',
			[
				'label'     => esc_html__( 'Item Title Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper ul li h5' => 'color: {{VALUE}}',
				]
			]
		);


		$this->add_responsive_control(
			'section-padding',
			[
				'label'      => esc_html__( 'Section Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'section-margins',
			[
				'label'      => esc_html__( 'Section Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'list-item-padding',
			[
				'label'      => esc_html__( 'List Item Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'list-item-margin',
			[
				'label'      => esc_html__( 'List Item Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh_rvr_outdoor_features_wrapper ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		$post_id  = get_the_ID();

		// Sample Post id for Elementor editor only
		if ( rhea_is_preview_mode() ) {
			$post_id = rhea_get_sample_property_id();
		}

		$availability_table = get_post_meta( $post_id, 'rvr_property_availability_table', true );
		$rvr_settings       = get_option( 'rvr_settings' );
		$booking_type       = $rvr_settings['rvr_booking_type'] ?? 'full_day';
		$data_dates         = array();

		if ( ! empty( $availability_table ) && is_array( $availability_table ) ) {

			foreach ( $availability_table as $dates ) {

				// Ensure the entry has valid start and end dates
				if ( empty( $dates[0] ) || empty( $dates[1] ) ) {
					continue;
				}

				try {
					$begin = new DateTime( $dates[0] );
					$end   = new DateTime( $dates[1] );

					// Adjust for booking type
					if ( 'full_day' === $booking_type || ( 'split_day' === $booking_type && $begin == $end ) ) {
						$end = $end->modify( '+1 day' );
					}

					$interval  = new DateInterval( 'P1D' );
					$daterange = new DatePeriod( $begin, $interval, $end );

					foreach ( $daterange as $date ) {
						$data_dates[] = $date->format( 'Y-m-d' );
					}
				} catch ( Exception $e ) {
					error_log( sprintf( __( 'Invalid date in availability table: %s', RHEA_TEXT_DOMAIN ), $e->getMessage() ) );
				}
			}
		}

		if ( ! empty( $data_dates ) ) {
			$data_dates = implode( ',', $data_dates );
		} else {
			$data_dates = '0-0-0';
		}
		?>
        <div class="rh_property__ava_calendar_wrap">
			<?php
			$section_title = $settings['section_title'] ?? esc_html__( 'Property Availability', RHEA_TEXT_DOMAIN );
			if ( ! empty( $section_title ) ) {
				?>
                <h4 class="rh_property__heading"><?php echo esc_html( $section_title ); ?></h4>
				<?php
			}
			?>
            <div id="property-availability" class="<?php echo esc_attr( $booking_type ) ?>" data-toggle="calendar" data-dates="<?php echo esc_attr( $data_dates ); ?>"></div>
            <div class="calendar-guide">
                <ul class="clearfix">
                    <li class="available-days"><?php esc_html_e( 'Available', RHEA_TEXT_DOMAIN ); ?></li>
                    <li class="reserved-days"><?php esc_html_e( 'Booked', RHEA_TEXT_DOMAIN ); ?></li>
                    <li class="past-days"><?php esc_html_e( 'Past', RHEA_TEXT_DOMAIN ); ?></li>
                    <li class="today"><?php esc_html_e( 'Today', RHEA_TEXT_DOMAIN ); ?></li>
                </ul>
            </div>
        </div>
		<?php
	}
}