<?php
/**
 * Single Property Video Widget V2.
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Video_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	// Static properties for reusable data.
	private static $property_id;

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

		if ( is_null( self::$property_id ) ) {
			self::$property_id = $this->initialize_property_id();
		}
	}

	public function get_name() {
		return 'rh-single-property-video-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Video V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-slider-video rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->title_section_content_tab_controls( esc_html__( 'Property Video', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'video_section',
			[
				'label' => esc_html__( 'Video', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'container_border_padding',
			[
				'label'     => esc_html__( 'Container Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'container_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider, {{WRAPPER}} .rh-single-property-video-v2-slide' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'selector' => '{{WRAPPER}} .rh-single-property-video-v2-slider',
			]
		);

		$this->add_responsive_control(
			'slide_height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slide img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'play_button',
			[
				'label'     => esc_html__( 'Play Button', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'play_button_size',
			[
				'label'     => esc_html__( 'Button Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .play-btn' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'play_button_icon_size',
			[
				'label'     => esc_html__( 'Button Icon Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .play-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'play_button_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .play-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'play_button_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .play-btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'play_button_bg',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .play-btn' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'play_button_color_hover',
			[
				'label'     => esc_html__( 'Color Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider:hover .play-btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'play_button_bg_hover',
			[
				'label'     => esc_html__( 'Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider:hover .play-btn' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'slider_pagination',
			[
				'label'     => esc_html__( 'Slider Pagination', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'slider_pagination_size',
			[
				'label'     => esc_html__( 'Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .slick-dots li button' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'slider_pagination_gap',
			[
				'label'     => esc_html__( 'Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .slick-dots' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'slider_pagination_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .slick-dots' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'slider_pagination_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .slick-dots li button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'slider_pagination_bg',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .slick-dots li button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'slider_pagination_bg_active',
			[
				'label'     => esc_html__( 'Background (Active)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-video-v2-slider .slick-dots li.slick-active button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		// Check if login required to vew property detail.
		if ( inspiry_prop_detail_login() ) {
			return;
		}

		$settings    = $this->get_settings_for_display();
		$widget_id   = $this->get_id();
		$video_group = get_post_meta( self::$property_id, 'inspiry_video_group', true );

		if ( ! empty( $video_group ) ) {
			?>
            <div id="rh-single-property-video-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-video-v2">
				<?php
				if ( ! empty( $settings['section_title'] ) ) {
					?>
                    <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $settings['section_title'] ); ?></h4>
					<?php
				}
				?>
                <div class="rh-single-property-video-v2-inner rh-single-property-video-v2-slider">
					<?php
					// Loop through each video in the group.
					foreach ( $video_group as $video ) {
						// Check if the video URL is provided.
						if ( ! empty( $video['inspiry_video_group_url'] ) ) {
							$video_url       = $video['inspiry_video_group_url'];
							$video_image_url = '';

							// Check if a video image is set and retrieve its source URL.
							if ( ! empty( $video['inspiry_video_group_image'] ) ) {
								$video_image_id = $video['inspiry_video_group_image'][0] ?? null;

								if ( $video_image_id ) {
									$video_image_src = wp_get_attachment_image_src( $video_image_id, 'property-detail-video-image' );
									if ( ! empty( $video_image_src[0] ) ) {
										$video_image_url = $video_image_src[0];
									}
								}
							}
							?>
                            <div class="rh-single-property-video-v2-slide">
                                <a data-fancybox href="<?php echo esc_url( $video_url ); ?>" class="inspiry-lightbox-item" data-autoplay="true" data-vbtype="video">
                                    <span class="play-btn"><i class="fas fa-play"></i></span>
									<?php
									// Display the video image or fallback options.
									if ( ! empty( $video_image_url ) ) {
										echo '<img src="' . esc_url( $video_image_url ) . '" alt="' . esc_attr( get_the_title( self::$property_id ) ) . '">';
									} else if ( has_post_thumbnail( self::$property_id ) ) {
										the_post_thumbnail( 'property-detail-video-image' );
									} else {
										inspiry_image_placeholder( 'property-detail-video-image' );
									}
									?>
                                </a>
                            </div>
							<?php
						}
					}
					?>
                </div>
            </div>
			<?php
			if ( count( $video_group ) > 1 ) {
				$this->get_script( $widget_id );
			}

		} else {
			rhea_print_no_result_for_editor();
		}
	}

	private function initialize_property_id() {
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			return rhea_get_sample_property_id();
		}

		return get_the_ID();
	}

	public function get_script( $widget_id ) {
		?>
        <script>
            jQuery( document ).ready( function ( $ ) {
                "use strict";
                $( '#rh-single-property-video-v2-<?php echo esc_attr( $widget_id ); ?> .rh-single-property-video-v2-slider' ).slick( {
                    slidesToShow   : 1,
                    slidesToScroll : 1,
                    arrows         : false,
                    dots           : true,
                    fade           : true
                } );
            } );
        </script>
		<?php
	}
}