<?php
/**
 * Single Property Similar Properties Widget V2.
 *
 * @since 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Similar_Properties_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;
	use RHEA_Properties_Partials;
	use RHEA_Properties_Action_buttons;

	private static $is_rvr_enabled;

	private static $property_id;

	public function __construct( array $data = [], ?array $args = null ) {
		parent::__construct( $data, $args );

		if ( is_null( self::$is_rvr_enabled ) ) {
			self::$is_rvr_enabled = rhea_is_rvr_enabled();
		}

		// Initialize static properties if not already set.
		if ( is_null( self::$property_id ) ) {
			self::$property_id = $this->initialize_property_id();
		}

		wp_register_script( 'rh-single-property-similar-properties-v2', RHEA_PLUGIN_URL . 'elementor/js/single-property-similar-properties-v2.js', [ 'elementor-frontend' ], RHEA_VERSION, true );
	}

	public function get_name() {
		return 'rh-single-property-similar-properties-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Similar Properties V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-posts-grid rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-real-homes' ];
	}

	public function get_script_depends() {
		return [ 'rh-single-property-similar-properties-v2' ];
	}

	public function get_style_depends() {
		return [ 'swiper' ];
	}

	protected function register_controls() {

		$allowed_html = array(
			'a'      => array(
				'href'  => array(),
				'title' => array()
			),
			'br'     => array(),
			'em'     => array(),
			'strong' => array(),
		);

		$this->title_section_content_tab_controls( esc_html__( 'Similar Properties', RHEA_TEXT_DOMAIN ) );

		$this->start_controls_section(
			'properties_section',
			[
				'label' => esc_html__( 'Properties', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label'              => esc_html__( 'Layout', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'options'            => [
					'carousel' => esc_html__( 'Carousel', RHEA_TEXT_DOMAIN ),
					'grid'     => esc_html__( 'Grid', RHEA_TEXT_DOMAIN ),
					'list'     => esc_html__( 'List', RHEA_TEXT_DOMAIN ),
				],
				'default'            => 'carousel',
				'frontend_available' => true,
			]
		);

		$this->add_responsive_control(
			'grid_columns',
			[
				'label'              => esc_html__( 'Grid Columns', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'default'            => 3,
				'options'            => [
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				],
				'condition'          => [
					'layout' => 'grid',
				],
				'frontend_available' => true,
			]
		);

		$this->add_responsive_control(
			'list_columns',
			[
				'label'     => esc_html__( 'List Columns', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 1,
				'options'   => [
					1 => 1,
					2 => 2,
					3 => 3
				],
				'condition' => [
					'layout' => 'list',
				],
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'              => esc_html__( 'Properties Per Page', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'min'                => 1,
				'max'                => 12,
				'step'               => 1,
				'default'            => 6,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'similar_properties_criteria',
			[
				'label'       => esc_html__( 'Show Similar Properties Based on', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => [
					'property-feature' => esc_html__( 'Property Features', RHEA_TEXT_DOMAIN ),
					'property-type'    => esc_html__( 'Property Type', RHEA_TEXT_DOMAIN ),
					'property-city'    => esc_html__( 'Property Location', RHEA_TEXT_DOMAIN ),
					'property-status'  => esc_html__( 'Property Status', RHEA_TEXT_DOMAIN ),
					'property-agent'   => esc_html__( 'Agent', RHEA_TEXT_DOMAIN ),
				],
				'default'     => [ 'property-type', 'property-city' ],
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'              => esc_html__( 'Order By', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'options'            => [
					'date'        => esc_html__( 'Time - Recent First', RHEA_TEXT_DOMAIN ),
					'low-to-high' => esc_html__( 'Price - Low to High', RHEA_TEXT_DOMAIN ),
					'high-to-low' => esc_html__( 'Price - High to Low', RHEA_TEXT_DOMAIN ),
					'random'      => esc_html__( 'Random', RHEA_TEXT_DOMAIN ),
				],
				'default'            => 'date',
				'frontend_available' => true,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name'    => 'thumbnail',
				'default' => 'modern-property-child-slider',
			]
		);

		$this->add_control(
			'show_address',
			[
				'label'              => esc_html__( 'Show Address', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'show_old_price',
			[
				'label'              => esc_html__( 'Show Old Price', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'show_agent',
			[
				'label'              => esc_html__( 'Show Agent/Owner', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'show_verification_badge',
			[
				'label'              => esc_html__( 'Show Agent Verification Badge', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'show_property_type',
			[
				'label'              => esc_html__( 'Show Property Type', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'condition'          => [
					'layout' => [ 'list' ]
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'show_property_status',
			[
				'label'              => esc_html__( 'Show Property Status', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'condition'          => [
					'layout' => [ 'list' ]
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'ere_enable_fav_properties',
			[
				'label'              => esc_html__( 'Show Add To Favourite Button', RHEA_TEXT_DOMAIN ),
				'description'        => wp_kses( __( '<strong>Important:</strong> Make sure to select <strong>Show</strong> in Customizer <strong>Dashboard > My Favorites (Add to Favorites Button on Property Detail Page)</strong> settings. ', RHEA_TEXT_DOMAIN ), $allowed_html ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'ere_enable_compare_properties',
			[
				'label'              => esc_html__( 'Show Add To Compare Button  ', RHEA_TEXT_DOMAIN ),
				'description'        => wp_kses( __( '<strong>Important:</strong> Make sure to select <strong>Enable</strong> in Customizer <strong>Floating Features (Compare Properties)</strong> settings. ', RHEA_TEXT_DOMAIN ), $allowed_html ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'ere_properties_labels',
			[
				'label' => esc_html__( 'Labels', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'property_added_date_label',
			[
				'label'              => esc_html__( 'Property Added Date', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::TEXT,
				'default'            => esc_html__( 'Added:', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);

		$this->action_buttons_labels();

		$this->inline_action_buttons_labels();

		$this->end_controls_section();

		$this->start_controls_section(
			'meta_settings',
			[
				'label' => esc_html__( 'Meta Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'meta_layout',
			[
				'label'     => esc_html__( 'Layout', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '1',
				'options'   => [
					'1' => esc_html__( 'Default', RHEA_TEXT_DOMAIN ),
					'2' => esc_html__( 'Simple', RHEA_TEXT_DOMAIN ),
				],
				'condition' => [
					'layout' => [ 'grid', 'list' ],
				],
			]
		);

		$get_meta = array(
			'bedrooms'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
			'bathrooms'  => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
			'area'       => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
			'garage'     => esc_html__( 'Garages/Parking', RHEA_TEXT_DOMAIN ),
			'year-built' => esc_html__( 'Year Built', RHEA_TEXT_DOMAIN ),
			'lot-size'   => esc_html__( 'Lot Size', RHEA_TEXT_DOMAIN ),
		);

		$meta_defaults = array(
			array(
				'rhea_property_meta_display' => 'bedrooms',
				'rhea_meta_repeater_label'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
			),
			array(
				'rhea_property_meta_display' => 'bathrooms',
				'rhea_meta_repeater_label'   => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
			),
			array(
				'rhea_property_meta_display' => 'area',
				'rhea_meta_repeater_label'   => esc_html__( 'Area', RHEA_TEXT_DOMAIN ),
			),
		);

		if ( self::$is_rvr_enabled ) {
			$get_meta['guests']   = esc_html__( 'Guests Capacity', RHEA_TEXT_DOMAIN );
			$get_meta['min-stay'] = esc_html__( 'Min Stay', RHEA_TEXT_DOMAIN );

			$meta_defaults[] = array(
				'rhea_property_meta_display' => 'guests',
				'rhea_meta_repeater_label'   => esc_html__( 'Guests', RHEA_TEXT_DOMAIN ),
			);
		}

		$get_meta = apply_filters( 'rhea_custom_fields_meta_icons', $get_meta );

		$meta_repeater = new \Elementor\Repeater();

		$meta_repeater->add_control(
			'rhea_property_meta_display',
			[
				'label'              => esc_html__( 'Select Meta', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'default'            => '',
				'options'            => $get_meta,
				'frontend_available' => true,
			]
		);

		$meta_repeater->add_control(
			'rhea_meta_repeater_label',
			[
				'label'   => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add Label', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'rhea_add_meta_select',
			[
				'label'              => esc_html__( 'Add Meta', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::REPEATER,
				'fields'             => $meta_repeater->get_controls(),
				'default'            => $meta_defaults,
				'title_field'        => ' {{{ rhea_meta_repeater_label }}}',
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_settings',
			[
				'label'     => esc_html__( 'Carousel Settings', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout' => 'carousel',
				],
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'              => esc_html__( 'Autoplay', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label'              => esc_html__( 'Pause on Hover', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'condition'          => [
					'autoplay' => 'yes',
				],
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'pause_on_interaction',
			[
				'label'              => esc_html__( 'Pause on Interaction', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'yes',
				'condition'          => [
					'autoplay' => 'yes',
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'infinite',
			[
				'label'              => esc_html__( 'Infinite Loop', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label'              => esc_html__( 'Autoplay Speed', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 4000,
				'condition'          => [
					'autoplay' => 'yes',
				],
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'speed',
			[
				'label'              => esc_html__( 'Animation Speed', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 500,
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'navigation_controls',
			[
				'label' => esc_html__( 'Navigation', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label'        => esc_html__( 'Arrows', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_dots',
			[
				'label'        => esc_html__( 'Dots', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->end_controls_section();

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'property_card_section',
			[
				'label' => esc_html__( 'Property Card', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'property_card_wrapper_padding',
			[
				'label'     => esc_html__( 'Card Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-card-v14-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'property_card_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .swiper-container, 
					 {{WRAPPER}} .rh-single-property-similar-properties-v2 .swiper-wrapper,
					 {{WRAPPER}} .rh-single-property-similar-properties-v2-grid-layout .rh-property-card-v14'      => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-grid-layout .rh-property-thumb-wrapper' => 'border-radius: {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} 0 0;',
				],
				'condition' => [
					'layout' => [ 'carousel', 'grid' ],
				],
			]
		);

		$this->add_responsive_control(
			'property_list_card_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-card-v14'                                                               => 'border-radius: {{SIZE}}{{UNIT}}; overflow:hidden;',
					'[data-elementor-device-mode=mobile] {{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-thumb-wrapper,					
					[data-elementor-device-mode=mobile] {{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-thumb-wrapper>a' => 'border-radius: {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} 0 0;',
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-thumb-wrapper,
					{{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-thumb-wrapper>a'                                     => 'border-radius: {{SIZE}}{{UNIT}} 0 0 {{SIZE}}{{UNIT}};',
					'.rtl {{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-thumb-wrapper,
					.rtl {{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-thumb-wrapper>a'                                => 'border-radius: 0 {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} 0;',
				],
				'condition' => [
					'layout' => [ 'list' ],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'property_card_box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-card-v14',
			]
		);

		$this->add_responsive_control(
			'property_card_content_heading',
			[
				'label' => esc_html__( 'Content Wrapper', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'property_card_content_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'property_card_content_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-grid-layout .rh-property-card-v14 .rh-property-content-wrapper,
					 {{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .rh-property-card-v14' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'property_agent_and_price_container_heading',
			[
				'label' => esc_html__( 'Agent and Price Container Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'property_agent_and_price_container_border',
				'label'    => esc_html__( 'Agent and Price Container Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-more-info',
			]
		);

		$this->end_controls_section();

		$this->properties_tags_controls();

		$this->start_controls_section(
			'property_title_section',
			[
				'label' => esc_html__( 'Property Title', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_title_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-similar-properties-v2 .property-title',
			]
		);

		$this->add_control(
			'property_title_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .property-title a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_title_hover_color',
			[
				'label'     => esc_html__( 'Color Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .property-title a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'property_title_margin_bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .property-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property_address_section',
			[
				'label' => esc_html__( 'Property Address', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_address_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-address',
			]
		);

		$this->add_control(
			'property_address_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-address' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_address_icon_color',
			[
				'label'     => esc_html__( 'Icon Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-address-wrapper > .pin-icon' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_address_icon_size',
			[
				'label'     => esc_html__( 'Icon Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-address-wrapper > .pin-icon' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'property_address_margin_bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-address' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property_added_date_section',
			[
				'label' => esc_html__( 'Property Added Date', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_added_date_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-added-date',
			]
		);

		$this->add_control(
			'property_added_date_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-added-date' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'property_added_date_margin_bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh-property-added-date' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property_meta_section',
			[
				'label' => esc_html__( 'Property Meta', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_meta_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .figure,
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .rhea-meta-labels,
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .label, 		
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta .rhea-meta-icons-labels, 
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta .figure,
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta .rhea-meta-labels
				',
			]
		);

		$this->add_control(
			'property_meta_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .figure,
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .rhea-meta-labels,
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .label, 		
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta .rhea-meta-icons-labels, 
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta .figure,				
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta .rhea-meta-labels				
					' => 'color: {{VALUE}}
				',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_meta_postfix_typography',
				'label'    => esc_html__( 'Postfix Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .label',
			]
		);

		$this->add_control(
			'property_meta_postfix_color',
			[
				'label'     => esc_html__( 'Postfix Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_meta_box .label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_meta_svg_color',
			[
				'label'     => esc_html__( 'SVG Icon Fill', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra svg,
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card__meta .rhea_guests,
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rhea_ultra_prop_card__meta svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_meta_svg_stroke',
			[
				'label'     => esc_html__( 'SVG Icon Stroke', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra svg path,
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra svg rect,
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_guests path,
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_guests rect,
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta svg path,
					{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra svg rect' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'property_meta_icon_size',
			[
				'label'     => esc_html__( 'Meta Icon Size (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra svg'                             => 'width: {{SIZE}}{{UNIT}} !important;',
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra .rhea_ultra_prop_card__meta svg' => 'width: {{SIZE}}{{UNIT}}; height:auto;',
				],
			]
		);

		$this->add_responsive_control(
			'property_meta_margin_bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2 .rh_prop_card_meta_wrap_ultra' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property_price_section',
			[
				'label' => esc_html__( 'Property Price', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_price_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-display,
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .property-current-price
				',
			]
		);

		$this->add_control(
			'property_price_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-display,
				{{WRAPPER}} .rh-single-property-similar-properties-v2 .property-current-price
					 ' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_old_price_typography',
				'label'    => esc_html__( 'Old Price, Pre, and Postfix', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .property-old-price,
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-prefix, 
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-slash, 
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-postfix
				 ',
			]
		);

		$this->add_control(
			'property_old_price_color',
			[
				'label'     => esc_html__( 'Old Price, Pre, and Postfix Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .property-old-price,
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-prefix, 
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-slash, 
				 {{WRAPPER}} .rh-single-property-similar-properties-v2 .ere-price-postfix
				 ' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property_agent_section',
			[
				'label' => esc_html__( 'Property Agent', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_agent_title_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-property-agent .agent-title',
			]
		);

		$this->add_control(
			'property_agent_title_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-property-agent .agent-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'property_agent_image_border_radius',
			[
				'label'     => esc_html__( 'Image Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-property-agent .agent-image img' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'property_agent_vb_heading',
			[
				'label' => esc_html__( 'Verification Badge', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'property_agent_vb_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-property-agent svg .verified-sign' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_agent_vb_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-property-agent svg .verification-badge' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property_type_and_status_section',
			[
				'label' => esc_html__( 'Property Type and Status', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'property_type_and_status_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .property-type-and-status-tags a',
			]
		);

		$this->add_control(
			'property_type_and_status_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .property-type-and-status-tags a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_type_and_status_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-list-layout .property-type-and-status-tags a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'carousel_pagination_section',
			[
				'label'     => esc_html__( 'Carousel Navigations', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout' => 'carousel',
				],
			]
		);

		$this->add_control(
			'pagination_bg_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled span' => '--swiper-pagination-bullet-inactive-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'pagination_active_bullet_bg_color',
			[
				'label'     => esc_html__( 'Active Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled span.swiper-pagination-bullet-active,
					 {{WRAPPER}} .swiper-pagination-styled span:hover'            => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .swiper-pagination-styled .select-active-bullet' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pagination_container_section',
			[
				'label' => esc_html__( 'Container Options', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'pagination_container_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-slider-navigations' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_container_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-similar-properties-v2-slider-navigations' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'pagination_items_options_section',
			[
				'label' => esc_html__( 'Items Options', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'property_items_gap',
			[
				'label'     => esc_html__( 'Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-inner' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'property_items_width',
			[
				'label'     => esc_html__( 'Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-pagination-styled .select-active-bullet'     => 'width: calc({{SIZE}}{{UNIT}} + 6px);',
				],
			]
		);

		$this->add_responsive_control(
			'property_items_height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-pagination-styled .select-active-bullet'     => 'height: calc({{SIZE}}{{UNIT}} + 6px);',
				],
			]
		);

		$this->add_responsive_control(
			'property_items_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-styled .swiper-pagination-bullet, {{WRAPPER}} .swiper-pagination-styled .select-active-bullet' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'arrows_options_section',
			[
				'label' => esc_html__( 'Arrows Options', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'arrows_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next svg path, {{WRAPPER}} .swiper-button-prev svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'arrows_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-button-next:hover svg path, {{WRAPPER}} .swiper-button-prev:hover svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->action_button_controls_v2();
	}

	protected function render() {
		global $settings, $widget_id, $properties_args, $properties_query, $key, $column_classes;

		$settings  = $this->get_settings_for_display();
		$widget_id = $this->get_id();
		$key       = 'properties-layout-' . $widget_id;

		if ( $settings['layout'] ) {
			$layout = $settings['layout'];
		} else {
			$layout = 'carousel';
		}

		$properties_args = array(
			'post_type'           => 'property',
			'post_status'         => 'publish',
			'posts_per_page'      => $settings['posts_per_page'],
			'post__not_in'        => array( self::$property_id ),
			'post_parent__not_in' => array( self::$property_id ) // To avoid child posts from appearing in similar properties.
		);

		$similar_properties = $settings['similar_properties_criteria'];

		if ( ! empty( $similar_properties ) && is_array( $similar_properties ) ) {
			$similar_properties_taxonomies = array_diff( $similar_properties, array( 'property-agent' ) );
			$similar_properties_count      = count( $similar_properties_taxonomies );
			$tax_query                     = array();

			for ( $index = 0; $index < $similar_properties_count; $index++ ) {
				// Property Taxonomies array
				$property_terms = get_the_terms( self::$property_id, $similar_properties_taxonomies[ $index ] );
				if ( ! empty( $property_terms ) && is_array( $property_terms ) ) {
					$terms_array = array();
					foreach ( $property_terms as $property_term ) {
						$terms_array[] = $property_term->term_id;
					}
					$tax_query[] = array(
						'taxonomy' => $similar_properties_taxonomies[ $index ],
						'field'    => 'id',
						'terms'    => $terms_array,
					);
				}
			}

			$tax_count = count( $tax_query );   // Count number of taxonomies.
			if ( $tax_count > 1 ) {
				$tax_query['relation'] = 'OR';  // Add OR relation if more than one.
			}

			if ( $tax_count > 0 ) {
				$properties_args['tax_query'] = $tax_query;  // Add taxonomies query.
			}

			if ( in_array( 'property-agent', $similar_properties ) ) {
				$property_agents = get_post_meta( self::$property_id, 'REAL_HOMES_agents' );
				if ( ! empty( $property_agents ) ) {
					$properties_args['meta_query'] = array(
						array(
							'key'     => 'REAL_HOMES_agents',
							'value'   => $property_agents,
							'compare' => 'IN',
						),
					);
				}
			}
		}

		if ( 'low-to-high' == $settings['orderby'] ) {
			$properties_args['orderby']  = 'meta_value_num';
			$properties_args['meta_key'] = 'REAL_HOMES_property_price';
			$properties_args['order']    = 'ASC';
		} else if ( 'high-to-low' == $settings['orderby'] ) {
			$properties_args['orderby']  = 'meta_value_num';
			$properties_args['meta_key'] = 'REAL_HOMES_property_price';
			$properties_args['order']    = 'DESC';
		} else if ( 'random' == $settings['orderby'] ) {
			$properties_args['orderby'] = 'rand';
		}

		$properties_args  = apply_filters( 'inspiry_similar_properties_filter', $properties_args );
		$properties_query = new WP_Query( $properties_args );

		if ( $properties_query->have_posts() ) {

			if ( in_array( $layout, array( 'grid', 'list' ) ) ) {
				$column_classes = $this->get_columns( $layout );
			}

			if ( isset( $_GET[ $key ] ) && in_array( $_GET[ $key ], array( 'grid', 'list' ) ) ) {
				$layout = sanitize_text_field( $_GET[ $key ] );

				if ( 'grid' === $layout ) {
					$default_column = 3;

					if ( $settings['grid_columns_in_toggle_view'] ) {
						$default_column = $settings['grid_columns_in_toggle_view'];
					}
				} else {
					$default_column = 1;
				}

				$column_classes = $this->get_columns( $layout, $default_column );
			}

			if ( ! empty( $settings['section_title'] ) ) {
				?>
                <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $settings['section_title'] ); ?></h4>
				<?php
			}

			if ( 'carousel' === $layout ) {
				$this->carousel();
			} else {
				$this->listings( $layout );
			}

		} else if ( function_exists( 'realhomes_print_no_result' ) ) {
			realhomes_print_no_result();
		}
	}

	/**
	 * Outputs a carousel of properties for the widget.
	 *
	 * @since 2.4.0
	 * @return void
	 */
	public function carousel() {
		global $settings, $widget_id, $properties_query;

		$is_rtl = is_rtl() ? 'dir="rtl"' : '';
		?>
        <section id="rh-single-property-similar-properties-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-similar-properties-v2" data-thumb-size="<?php echo esc_attr( $settings['thumbnail_size'] ); ?>">
            <div class="rh-single-property-similar-properties-v2-slider-wrapper">
                <div class="rh-single-property-similar-properties-v2-inner">
                    <div id="rh-single-property-similar-properties-v2-slider-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-similar-properties-v2-slider swiper swiper-container" <?php echo esc_attr( $is_rtl ); ?>>
                        <div class="swiper-wrapper">
							<?php
							while ( $properties_query->have_posts() ) {
								$properties_query->the_post();

								$property_id      = get_the_ID();
								$args             = array();
								$args['is_rvr']   = self::$is_rvr_enabled;
								$args['slide']    = 'true';
								$args['settings'] = $settings;

								rhea_properties_widget_v14_card( $property_id, $args );
							}

							wp_reset_postdata();
							?>
                        </div>
                    </div>
					<?php
					$show_arrows = ( 'yes' === $settings['show_arrows'] );
					$show_dots   = ( 'yes' === $settings['show_dots'] );

					if ( $show_arrows || $show_dots ) {
						?>
                        <div class="rh-single-property-similar-properties-v2-slider-navigations">
							<?php
							if ( $show_arrows ) {
								?>
                                <div id="swiper-button-prev-<?php echo esc_attr( $widget_id ); ?>" class="swiper-button-prev">
                                    <svg width="24" height="16" viewBox="0 0 24 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M1.0822 7.4174C0.667263 7.83233 0.667263 8.50507 1.0822 8.92L7.8439 15.6817C8.25884 16.0966 8.93157 16.0966 9.34651 15.6817C9.76144 15.2668 9.76144 14.594 9.34651 14.1791L3.3361 8.1687L9.34651 2.15829C9.76144 1.74336 9.76144 1.07062 9.34651 0.655692C8.93157 0.24076 8.25884 0.24076 7.8439 0.655692L1.0822 7.4174ZM23.7918 7.1062H1.8335V9.2312H23.7918V7.1062Z" />
                                    </svg>
                                </div>
								<?php
							}

							if ( $show_dots ) {
								?>
                                <div id="swiper-pagination-<?php echo esc_attr( $widget_id ); ?>" class="swiper-pagination swiper-pagination-styled">
                                    <div class="swiper-pagination-inner"></div>
                                </div>
								<?php
							}

							if ( $show_arrows ) {
								?>
                                <div id="swiper-button-next-<?php echo esc_attr( $widget_id ); ?>" class="swiper-button-next">
                                    <svg width="24" height="16" viewBox="0 0 24 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M22.918 8.92C23.333 8.50507 23.333 7.83233 22.918 7.4174L16.1563 0.655692C15.7414 0.24076 15.0687 0.24076 14.6537 0.655692C14.2388 1.07062 14.2388 1.74336 14.6537 2.15829L20.6641 8.1687L14.6537 14.1791C14.2388 14.594 14.2388 15.2668 14.6537 15.6817C15.0687 16.0966 15.7414 16.0966 16.1563 15.6817L22.918 8.92ZM0.208414 9.2312L22.1667 9.2312L22.1667 7.1062L0.208414 7.1062L0.208414 9.2312Z" />
                                    </svg>
                                </div>
								<?php
							} ?>
                        </div>
						<?php
					}
					?>
                </div>
            </div>
        </section><!-- .rh-single-property-similar-properties-v2 -->
		<?php
	}

	/**
	 * Outputs the given layout based on grid or list view of properties for the widget.
	 *
	 * @since 2.4.0
	 * @return void
	 */
	public function listings( $layout ) {
		global $settings, $widget_id, $properties_query, $column_classes;
		?>
        <div id="rh-single-property-similar-properties-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-similar-properties-v2 rh-single-property-similar-properties-v2-<?php echo esc_attr( $layout ); ?>-layout">
            <div class="rh-properties-container-inner <?php echo esc_attr( $column_classes ); ?>">
				<?php
				while ( $properties_query->have_posts() ) {
					$properties_query->the_post();

					$property_id      = get_the_ID();
					$args             = array();
					$args['is_rvr']   = self::$is_rvr_enabled;
					$args['layout']   = $layout;
					$args['settings'] = $settings;

					rhea_properties_widget_v14_card( $property_id, $args );
				}

				wp_reset_postdata();
				?>
            </div>
        </div><!-- .rh-single-property-similar-properties-v2 -->
		<?php
	}

	/**
	 * Retrieve the CSS column classes based on the specified layout.
	 *
	 * @since 2.4.0
	 *
	 * @param string $default_column The column identifier.
	 * @param string $layout         The layout identifier.
	 *
	 * @return string The CSS classes for the grid or list columns.
	 */
	public function get_columns( $layout, $default_column = '' ) {
		$settings          = $this->get_settings_for_display();
		$setting_id        = "{$layout}_columns";
		$class_prefix      = sprintf( 'rh-properties-%s', str_replace( '_', '-', esc_html( $setting_id ) ) );
		$container_classes = array( $class_prefix );

		// Define the devices list.
		$devices = array(
			"widescreen",
			"laptop",
			"tablet_extra",
			"tablet",
			"mobile_extra",
			"mobile"
		);

		if ( ! empty( $settings[ $setting_id ] ) ) {
			$default_column = $settings[ $setting_id ];
		}

		// Default column class.
		$container_classes[] = $class_prefix . '-' . esc_html( $default_column );

		// Iterate through each device and add device-specific column class.
		foreach ( $devices as $device ) {
			$id = $setting_id . '_' . $device;
			if ( ! empty( $settings[ $id ] ) ) {
				$container_classes[] = $class_prefix . '-' . esc_html( $device ) . '-' . esc_html( $settings[ $id ] );
			}
		}

		// Combine the container classes into a space-separated string and return
		return join( ' ', $container_classes );
	}

	private function initialize_property_id() {
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			return rhea_get_sample_property_id();
		}

		return get_the_ID();
	}
}