<?php
/**
 * Single Property Description Widget V2.
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Description_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	public function get_name() {
		return 'rh-single-property-description-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Description V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-product-description rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	public function get_keywords() {
		return [ 'RealHomes', 'Description' ];
	}

	protected function register_controls() {

		$this->title_section_content_tab_controls( esc_html__( 'Description', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'property_description_style_section',
			[
				'label' => esc_html__( 'Property Description', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'description_content',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-description-v2-inner' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'description_content_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-description-v2-inner',
			]
		);

		$this->add_responsive_control(
			'description_content_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-description-v2-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings    = $this->get_settings_for_display();
		$widget_id   = $this->get_id();
		$property_id = get_the_ID();

		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			// Sample property id for editor side,
			$property_id = rhea_get_sample_property_id();
		}
		?>
        <div id="rh-single-property-description-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-description-v2 <?php realhomes_printable_section( 'content' ); ?>">
			<?php
			if ( ! empty( $settings['section_title'] ) ) {
				?>
                <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $settings['section_title'] ); ?></h4>
				<?php
			}
			?>
            <div class="rh-single-property-description-v2-inner">
				<?php
				$property_content = get_the_content( '', '', $property_id );
				if ( $property_content ) {
					echo $property_content;
				} else {
					rhea_print_no_result_for_editor();
				}
				?>
            </div>
        </div>
		<?php
	}
}