<?php
/**
 * Single Property Common Note Widget V2.
 *
 * @since 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Common_Note_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	private static $property_id;

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

		if ( is_null( self::$property_id ) ) {
			self::$property_id = $this->initialize_property_id();
		}
	}

	public function get_name() {
		return 'rh-single-property-common-note-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Common Note V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-notes rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->title_section_content_tab_controls();

		$this->start_controls_section(
			'common_note_section',
			[
				'label' => esc_html__( 'Common Note', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'common_note',
			[
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Leaving empty will get the content from global customizer settings.', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->end_controls_section();

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'common_note_styles',
			[
				'label' => esc_html__( 'Common Note', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'common_note_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-common-note-v2-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'common_note_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-common-note-v2-inner' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'common_note_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-common-note-v2-inner' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'common_note_bg',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-common-note-v2-inner' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'common_note_border_color',
			[
				'label'     => esc_html__( 'Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-common-note-v2-inner' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-single-property-common-note-v2-inner',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'common_note_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-single-property-common-note-v2-inner',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {

		// Check if login required to vew property detail.
		if ( inspiry_prop_detail_login() ) {
			return;
		}

		$settings  = $this->get_settings_for_display();
		$widget_id = $this->get_id();

		if ( 'true' === get_option( 'theme_display_common_note', false ) ) {

			$common_note = ! empty( $settings['common_note'] ) ? $settings['common_note'] : get_option( 'theme_common_note' );
			if ( ! empty( $common_note ) ) {
				?>
                <div id="rh-single-property-common-note-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-common-note-v2 <?php realhomes_printable_section( 'common-note' ); ?>">
					<?php
					$section_title = ! empty( $settings['section_title'] ) ? $settings['section_title'] : get_option( 'theme_common_note_title' );
					if ( ! empty( $section_title ) ) {
						?>
                        <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $section_title ); ?></h4>
						<?php
					}
					?>
                    <div class="rh-single-property-common-note-v2-inner">
                        <p><?php echo esc_html( $common_note ); ?></p>
                    </div>
                </div>
				<?php
			} else {
				rhea_print_no_result_for_editor();
			}
		}
	}

	private function initialize_property_id() {
		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			return rhea_get_sample_property_id();
		}

		return get_the_ID();
	}
}