<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Property_Taxonomy_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'rhea-property-taxonomy-widget';
	}

	public function get_title() {
		return esc_html__( 'RH: Property Taxonomy', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-image-hotspot rh-modern-widget';
	}

	public function get_categories() {
		return [ 'real-homes' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'property_taxonomy_content_section',
			[
				'label' => esc_html__( 'Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$property_taxonomies = array(
			'property-type'   => esc_html__( 'Type', RHEA_TEXT_DOMAIN ),
			'property-city'   => esc_html__( 'City', RHEA_TEXT_DOMAIN ),
			'property-status' => esc_html__( 'Status', RHEA_TEXT_DOMAIN ),
		);

		$this->add_control(
			'select_property_taxonomy',
			[
				'label'   => esc_html__( 'Select Taxonomy', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'property-type',
				'options' => $property_taxonomies,
			]
		);

		if ( ! empty( $property_taxonomies ) ) {
			foreach ( $property_taxonomies as $property_taxonomy => $label ) {
				$terms_options = array();
				$control_id    = str_replace( '-', '_', $property_taxonomy );

				$property_taxonomy_terms = get_terms( array(
					'taxonomy'   => $property_taxonomy,
					'hide_empty' => false,
				) );

				if ( ! empty( $property_taxonomy_terms ) && ! is_wp_error( $property_taxonomy_terms ) ) {
					foreach ( $property_taxonomy_terms as $property_taxonomy_term ) {
						$terms_options[ $property_taxonomy_term->term_id ] = $property_taxonomy_term->name;
					}
				}
				$first_key = array_key_first( $terms_options );

				$this->add_control(
					$control_id,
					[
						'label'     => esc_html__( 'Select Term', RHEA_TEXT_DOMAIN ),
						'type'      => \Elementor\Controls_Manager::SELECT,
						'options'   => $terms_options,
						'default'   => $first_key,
						'condition' => [
							'select_property_taxonomy' => $property_taxonomy,
						],
					]
				);
			}
		}

		$this->add_control(
			'select_layout',
			[
				'label'   => esc_html__( 'Select Style', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'default'  => esc_html__( 'Default', RHEA_TEXT_DOMAIN ),
					'layout-2' => esc_html__( 'Layout 2', RHEA_TEXT_DOMAIN ),
				),
				'default' => 'default',

			]
		);

		$this->add_control(
			'term_custom_name',
			[
				'label' => esc_html__( 'Custom Name', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'image',
			[
				'label'   => esc_html__( 'Choose Image', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'show_property_count',
			[
				'label'        => esc_html__( 'Show Property Count', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'property_singular_label',
			[
				'label'     => esc_html__( 'Property', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Property', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_property_count' => 'yes',
				],
			]
		);

		$this->add_control(
			'property_plural_label',
			[
				'label'     => esc_html__( 'Properties', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Properties', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_property_count' => 'yes',
				],
			]
		);

		$this->add_control(
			'tax_view_all_label',
			[
				'label'     => esc_html__( 'View All', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'View All', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'select_layout' => 'layout-2',
				],
			]
		);

		$this->add_control(
			'button_icon',
			[
				'label'     => esc_html__( 'View Button Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'default'   => [
					'value'   => 'fas fa-star',
					'library' => 'solid',
				],
				'condition' => [
					'select_layout' => 'layout-2',
				],
			]
		);
		$this->add_responsive_control(
			'icon_size',
			[
				'label'     => esc_html__( 'Icon Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-tax-view-all i' => 'font-size: {{SIZE}}px',
					'{{WRAPPER}} .svg-icon'            => 'width: {{SIZE}}px',
				],
				'condition' => [
					'select_layout' => 'layout-2',
				],
			]
		);
		$this->add_control(
			'icon-color',
			[
				'label'     => esc_html__( 'Icon Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-tax-view-all i'    => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-tax-view-all svg'  => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea-tax-view-all path' => 'fill: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'show_description',
			[
				'label'        => esc_html__( 'Show Description', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'separator'    => 'before'
			]
		);

		$this->add_control(
			'description',
			[
				'label'     => esc_html__( 'Custom Description', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA,
				'rows'      => 3,
				'condition' => [
					'show_description' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'property_taxonomy_style_section',
			array(
				'label' => esc_html__( 'Widget Style', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'widget_style',
			[
				'label'   => esc_html__( 'Preset Height Style', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style-1',
				'options' => [
					'style-1' => esc_html__( 'Style 1', RHEA_TEXT_DOMAIN ),
					'style-2' => esc_html__( 'Style 2 ', RHEA_TEXT_DOMAIN ),
					'style-3' => esc_html__( 'Style 3', RHEA_TEXT_DOMAIN ),
				],
			]
		);

		$this->add_responsive_control(
			'widget_height',
			[
				'label'     => esc_html__( 'Custom Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 50,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-wrapper' => 'height: {{SIZE}}px;',
				],
			]
		);

		$this->add_responsive_control(
			'widget_margin_bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-wrapper' => 'margin-bottom: {{SIZE}}px;',
				],
			]
		);

		$this->add_responsive_control(
			'widget_content_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_widget_border-radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'after',
			]
		);

		$this->add_control(
			'vertical_align',
			[
				'label'     => esc_html__( 'Vertical Align', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'flex-start',
				'options'   => [
					'flex-start'    => esc_html__( 'Top', RHEA_TEXT_DOMAIN ),
					'center'        => esc_html__( 'Middle', RHEA_TEXT_DOMAIN ),
					'flex-end'      => esc_html__( 'Bottom', RHEA_TEXT_DOMAIN ),
					'space-between' => esc_html__( 'Space Between', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-inner' => 'justify-content: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'name_align',
			[
				'label'     => esc_html__( 'Name Alignment', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'flex-start',
				'options'   => [
					'flex-start' => esc_html__( 'Left', RHEA_TEXT_DOMAIN ),
					'center'     => esc_html__( 'Center', RHEA_TEXT_DOMAIN ),
					'flex-end'   => esc_html__( 'Right', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-term-title' => 'align-self: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'property_count_align',
			[
				'label'     => esc_html__( 'Property Count Alignment', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'flex-start',
				'options'   => [
					'flex-start' => esc_html__( 'Left', RHEA_TEXT_DOMAIN ),
					'center'     => esc_html__( 'Center', RHEA_TEXT_DOMAIN ),
					'flex-end'   => esc_html__( 'Right', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-inner' => 'align-items: {{VALUE}};',
				],
				'separator' => 'after',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'name_typography',
				'label'    => esc_html__( 'Name Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-property-taxonomy-term-title',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'counter_label_typography',
				'label'    => esc_html__( 'Counter Label Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-property-taxonomy-property-label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'counter_typography',
				'label'    => esc_html__( 'Counter Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-property-taxonomy-property-count',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'view_all_typography',
				'label'     => esc_html__( 'View All Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-view-all',
				'condition' => [
					'select_layout' => 'layout-2',
				],
			]
		);

		$this->add_control(
			'property_taxonomy_color_hover',
			[
				'label'     => esc_html__( 'Name Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-term-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_counter_label_color',
			[
				'label'     => esc_html__( 'Counter Label Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-property-label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'property_counter_color',
			[
				'label'     => esc_html__( 'Counter Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-property-count' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'view_all_color',
			[
				'label'     => esc_html__( 'View All Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-view-all' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-tax-view-all i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-tax-widget-inner .rhea-view-all:after' => 'background: {{VALUE}}',
				],
				'condition' => [
					'select_layout' => 'layout-2',
				],
			]
		);

		$this->add_control(
			'overlay_heading',
			[
				'label'     => esc_html__( 'First Overlay', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->start_controls_tabs( 'overlay_tabs' );

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => esc_html__( 'Normal', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'overlay_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-wrapper:before' => 'background-color: {{VALUE}}',
				]
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => esc_html__( 'Hover', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'overlay_hover_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-widget-wrapper:hover:before' => 'background-color: {{VALUE}}',
				]
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'content_overlay_heading',
			[
				'label'     => esc_html__( 'Second Overlay', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'       => 'background',
				'show_label' => false,
				'types'      => [ 'gradient' ],
				'exclude'    => [ 'image' ],
				'selector'   => '{{WRAPPER}} .rhea-property-taxonomy-widget-content-overlay',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'description_typography',
				'label'     => esc_html__( 'Description Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rhea-property-taxonomy-description',
				'condition' => [
					'show_description' => 'yes',
				],
			]
		);

		$this->add_control(
			'description_color',
			[
				'label'     => esc_html__( 'Description Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-property-taxonomy-description p' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_description' => 'yes',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		global $settings;
		global $term;
		$settings          = $this->get_settings_for_display();
		$selected_taxonomy = $settings['select_property_taxonomy'];
		$selected_term     = str_replace( '-', '_', $selected_taxonomy );
		$image_attributes  = $settings['image']['url'];
		$term              = get_term_by( 'term_id', $settings[ $selected_term ], $selected_taxonomy );

		if ( ! empty( $settings['image']['id'] ) ) {
			$image_attributes = wp_get_attachment_image_src( $settings['image']['id'], 'large' );
			$image_attributes = $image_attributes[0];
		}

		if ( $term ) {
			$term_id = apply_filters( 'wpml_object_id', $term->term_id, $selected_taxonomy, true );

			$widget_style = 'style-1';
			if ( isset( $settings['widget_style'] ) ) {
				$widget_style = $settings['widget_style'];
			}
			$select_layout = $settings['select_layout'];
			?>
            <div class="rhea-property-taxonomy-widget-outer-wrapper <?php echo esc_attr( $select_layout ) ?>">
                <div class="rhea-property-taxonomy-widget-wrapper rhea-property-taxonomy-<?php echo esc_attr( $widget_style ); ?>" style='background-image: url("<?php echo esc_url( $image_attributes ); ?>")'>
                    <div class="rhea-property-taxonomy-widget-content-overlay"></div>
                    <a class="rhea-property-taxonomy-widget-inner" href="<?php echo get_term_link( $term_id, $selected_taxonomy ); ?>">
						<?php
						if ( ! empty( $select_layout ) ) {
							rhea_get_template_part( 'assets/partials/taxonomy/' . $select_layout );
						}
						?>
                    </a>
                </div>
				<?php
				if ( 'yes' === $settings['show_description'] ) {
					$term_description = term_description( $term_id );
					if ( ! empty( $settings['description'] ) ) {
						?>
                        <div class="rhea-property-taxonomy-description">
                            <p><?php echo esc_html( $settings['description'] ); ?></p>
                        </div>
						<?php
					} else if ( ! empty( $term_description ) ) {
						?>
                        <div class="rhea-property-taxonomy-description">
							<?php echo $term_description; ?>
                        </div>
						<?php
					}
				}
				?>
            </div>
			<?php
		}
	}
}
