<?php
/**
 * Filter form file
 *
 * @since 2.4.0
 */

global $settings;
$hide_empty            = $settings['hide_empty_terms'];
$hide_empty            = filter_var( $hide_empty, FILTER_VALIDATE_BOOLEAN );
$checkboxes_view_limit = $settings['checkbox_view_limit'];
$heading_control_icon = rhea_get_elementor_icon_html( $settings['widget_section_arrow_icon'] );
if ( empty( $heading_control_icon ) ) {
    $heading_control_icon = '<i aria-hidden="true" class="fas fa-angle-down"></i>';
}
?>
<div class="filters-widget-wrap">
    <div class="property-filters">
        <div class="collapse-button">
            <span class="pop-open-all hidden">
                <span class="button-text"><?php esc_html_e( 'Open All', RHEA_TEXT_DOMAIN ); ?></span>&nbsp; <i class="fas fa-angle-double-down"></i>
            </span>
            <span class="pop-collapse-all">
                <span class="button-text"><?php esc_html_e( 'Collapse All', RHEA_TEXT_DOMAIN ); ?></span>&nbsp; <i class="fas fa-angle-double-up"></i>
            </span>
        </div>
		<?php

		// Adding property type taxonomy filter
		if ( $settings['property_type_filter'] === 'yes' && ere_taxonomy_has_terms( 'property-type', $hide_empty ) ) {
			?>
            <div class="filter-wrapper property-types">
                <h4 class="<?php echo 'yes' !== $settings['property_type_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Property Types', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section terms-list" data-taxonomy="types" data-display-title="<?php esc_html_e( 'Type', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['property_type_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
					<?php
					ere_process_filter_widget_taxonomies( 'property-type', $checkboxes_view_limit, $hide_empty );
					?>
                </div>
            </div>
			<?php
		}

		// Adding property city taxonomy filter
		if ( $settings['property_city_filter'] === 'yes' && ere_taxonomy_has_terms( 'property-city', $hide_empty ) ) {
			?>
            <div class="filter-wrapper property-locations">
                <h4 class="<?php echo 'yes' !== $settings['property_city_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Property Locations', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section terms-list" data-taxonomy="locations" data-display-title="<?php esc_html_e( 'Location', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['property_city_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
					<?php
					ere_process_filter_widget_taxonomies( 'property-city', $checkboxes_view_limit, $hide_empty );
					?>
                </div>
            </div>
			<?php
		}

		// Adding property status taxonomy filter
		if ( $settings['property_status_filter'] === 'yes' && ere_taxonomy_has_terms( 'property-status', $hide_empty ) ) {
			?>
            <div class="filter-wrapper property-statuses">
                <h4 class="<?php echo 'yes' !== $settings['property_status_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Property Status', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section terms-list" data-taxonomy="statuses" data-display-title="<?php esc_html_e( 'Status', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['property_status_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
					<?php
					ere_process_filter_widget_taxonomies( 'property-status', $checkboxes_view_limit, $hide_empty );
					?>
                </div>
            </div>
			<?php
		}

		// Adding property features filter
		if ( $settings['property_features_filter'] === 'yes' && ere_taxonomy_has_terms( 'property-feature', $hide_empty ) ) {
			?>
            <div class="filter-wrapper property-features">
                <h4 class="<?php echo 'yes' !== $settings['property_features_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Property Features', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section terms-list" data-taxonomy="features" data-display-title="<?php esc_html_e( 'Feature', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['property_features_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
					<?php
					ere_process_filter_widget_taxonomies( 'property-feature', $checkboxes_view_limit, $hide_empty );
					?>
                </div>
            </div>
			<?php
		}

		// Adding price options
		if ( $settings['price_filter'] === 'yes' ) {
			$price_ranges = array(
				'1000 - 5000',
				'5001 - 10000',
				'10001 - 50000',
				'50001 - 100000',
				'100000 - 150000',
				'150001 - 200000',
				'200001 - 250000'
			);

			// If custom price ranges area set in widget settings
			if ( ! empty( $custom_price_ranges ) ) {
				$custom_prices_array = preg_split( '/\r\n|\r|\n/', $custom_price_ranges );
				$price_ranges        = $custom_prices_array;
			}

			array_unshift( $price_ranges, esc_html__( 'All', RHEA_TEXT_DOMAIN ) );
			?>
            <div class="filter-wrapper price-ranges">
                <h4 class="<?php echo 'yes' !== $settings['price_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Price Ranges', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section range-list" <?php echo 'yes' !== $settings['price_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
					<?php
					if ( is_array( $price_ranges ) ) {
						foreach ( $price_ranges as $p_range ) {
							$prices   = '';
							$range_id = str_replace( ' ', '', $p_range );
							if ( $p_range === 'All' ) {
								$prices = $p_range;
							} else {
								$range_array = explode( ' - ', $p_range );
								if ( 1 < count( $range_array ) && is_numeric( $range_array[0] ) && is_numeric( $range_array[1] ) ) {
									$prices = ere_format_amount( $range_array[0] ) . ' - ' . ere_format_amount( $range_array[1] );
								}
							}
							if ( ! empty( $prices ) ) {
								?>
                                <p class="radio-wrap" data-meta-name="price" data-display-title="<?php esc_html_e( 'Price', RHEA_TEXT_DOMAIN ); ?>">
                                    <input type="radio" id="price-<?php echo esc_attr( $range_id ); ?>" data-display-value="<?php echo esc_attr( $prices ); ?>" name="price-range" value="<?php echo esc_attr( $p_range ); ?>">
                                    <label for="price-<?php echo esc_attr( $range_id ); ?>"><span class="radio-fancy"></span><?php echo esc_html( $prices ); ?></label>
                                </p>
								<?php
							}
						}
					}
					?>
                </div>
            </div>
			<?php
		}

		// Adding area options
		if ( $settings['area_filter'] === 'yes' ) {
			$area_unit   = ! empty( $settings['area_unit'] ) ? $settings['area_unit'] : '';
			$area_ranges = array(
				'50 - 100',
				'101 - 500',
				'501 - 1000',
				'1001 - 5000',
				'5001 - 10000'
			);

			// If custom area ranges area set in widget settings
			if ( ! empty( $custom_area_ranges ) ) {
				$custom_areas_array = preg_split( '/\r\n|\r|\n/', $custom_area_ranges );
				$area_ranges        = $custom_areas_array;
			}

			array_unshift( $area_ranges, esc_html__( 'All', RHEA_TEXT_DOMAIN ) );
			?>
            <div class="filter-wrapper area-ranges">
                <h4 class="<?php echo 'yes' !== $settings['area_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Area Ranges', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section range-list" <?php echo 'yes' !== $settings['area_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
					<?php
					if ( is_array( $area_ranges ) ) {
						foreach ( $area_ranges as $a_range ) {
							$areas    = '';
							$range_id = str_replace( ' ', '', $a_range );
							if ( $a_range === 'All' ) {
								$areas = $a_range;
							} else {
								$range_array = explode( ' - ', $a_range );
								if ( 1 < count( $range_array ) && is_numeric( $range_array[0] ) && is_numeric( $range_array[1] ) ) {
									$areas = $range_array[0] . ' <sub>' . $area_unit . '</sub>' . ' - ' . $range_array[1] . ' <sub>' . $area_unit . '</sub>';
								}
							}

							if ( ! empty( $areas ) ) {
								?>
                                <p class="radio-wrap" data-meta-name="area" data-display-title="<?php esc_html_e( 'Area', RHEA_TEXT_DOMAIN ); ?>">
                                    <input type="radio" id="area-<?php echo esc_attr( $range_id ); ?>" data-display-value="<?php echo esc_attr( wp_strip_all_tags( $areas ) ); ?>" name="area-range" value="<?php echo esc_attr( $a_range ); ?>">
                                    <label for="area-<?php echo esc_attr( $range_id ); ?>"><span class="radio-fancy"></span><?php echo wp_kses_post( $areas ); ?></label>
                                </p>
								<?php
							}
						}
					}
					?>
                </div>
            </div>
			<?php
		}

		if ( $settings['agents_filter'] === 'yes' ) {
			$agents_filter_style = $settings['agents_filter_style'];
			$agent_posts         = wp_count_posts( 'agent' );
			if ( 0 < intval( $agent_posts->publish ) ) {
				$agents_arguments = array(
					'post_type'                  => 'agent',
					'view_limit'                 => $checkboxes_view_limit,
					'wrapper_classes'            => 'agent-options',
					'section_title'              => esc_html__( 'Agents', RHEA_TEXT_DOMAIN ),
					'section_title_icon'         => $heading_control_icon,
					'display_type'               => $agents_filter_style,
					'display_title'              => esc_html__( 'Agent', RHEA_TEXT_DOMAIN ),
					'target_id'                  => 'agent',
					'image_size'                 => ! empty( $settings['agent_thumbnail_size'] ) ? $settings['agent_thumbnail_size'] : 'thumbnail',
					'section_default_view_state' => $settings['agent_filter_view_state']
				);
				rhea_process_filter_widget_post_types( $agents_arguments );
			}
		}

		if ( $settings['agency_filter'] === 'yes' ) {
			$agency_filter_style = $settings['agency_filter_style'];
			$agency_posts        = wp_count_posts( 'agency' );
			if ( 0 < intval( $agency_posts->publish ) ) {
				$agency_arguments = array(
					'post_type'                  => 'agency',
					'view_limit'                 => $checkboxes_view_limit,
					'wrapper_classes'            => 'agency-options',
					'section_title'              => esc_html__( 'Agencies', RHEA_TEXT_DOMAIN ),
					'section_title_icon'         => $heading_control_icon,
					'display_type'               => $agency_filter_style,
					'display_title'              => esc_html__( 'Agency', RHEA_TEXT_DOMAIN ),
					'target_id'                  => 'agencies',
					'image_size'                 => ! empty( $settings['agency_thumbnail_size'] ) ? $settings['agency_thumbnail_size'] : 'thumbnail',
					'section_default_view_state' => $settings['agency_filter_view_state']
				);
				rhea_process_filter_widget_post_types( $agency_arguments );
			}
		}

		if ( $settings['bedroom_filter'] === 'yes' ) {
			?>
            <div class="filter-wrapper radio-buttons">
                <h4 class="<?php echo 'yes' !== $settings['bedroom_filter_view_state'] ? 'collapsed' : ''; ?>">
					<?php esc_html_e( 'Min Bedrooms', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section buttons-list" data-meta-name="bedrooms" data-display-title="<?php esc_html_e( 'Min Beds', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['bedroom_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
                    <div class="number-option-wrap bedroom-options">
                        <span class="option-num">
                            <input type="radio" name="min-bedrooms" id="min-bedroom-all" value="0" checked>
                            <label for="min-bedroom-all"><?php esc_html_e( 'All', RHEA_TEXT_DOMAIN ) ?></label>
                        </span>
						<?php
						if ( empty( $bedrooms_max_value ) || 0 > intval( $bedrooms_max_value ) ) {
							$bedrooms_max_value = 9;
						}
						for ( $bed = 1; $bed <= $bedrooms_max_value; $bed++ ) {
							?>
                            <span class="option-num">
                                <input type="radio" name="min-bedrooms" id="min-bedroom-<?php echo esc_attr( $bed ); ?>" value="<?php echo esc_html( $bed ); ?>">
                                <label for="min-bedroom-<?php echo esc_attr( $bed ); ?>"><?php echo esc_html( $bed ); ?></label>
                            </span>
							<?php
						}
						?>
                    </div>
                </div>
            </div>
			<?php
		}

		if ( $settings['bathroom_filter'] === 'yes' ) {
			?>
            <div class="filter-wrapper radio-buttons">
                <h4 class="<?php echo 'yes' !== $settings['bathroom_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Min Bathrooms', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section buttons-list" data-meta-name="bathrooms" data-display-title="<?php esc_html_e( 'Min Baths', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['bathroom_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
                    <div class="number-option-wrap bathroom-options">
                        <span class="option-num">
                            <input type="radio" name="min-bathrooms" id="min-bathroom-all" value="0" checked>
                            <label for="min-bathroom-all"><?php esc_html_e( 'All', RHEA_TEXT_DOMAIN ) ?></label>
                        </span>
						<?php
						if ( empty( $bathrooms_max_value ) || 0 > intval( $bathrooms_max_value ) ) {
							$bathrooms_max_value = 12;
						}
						for ( $bath = 1; $bath <= $bathrooms_max_value; $bath++ ) {
							?>
                            <span class="option-num">
                                <input type="radio" name="min-bathrooms" id="min-bathroom-<?php echo esc_attr( $bath ); ?>" value="<?php echo esc_html( $bath ); ?>">
                                <label for="min-bathroom-<?php echo esc_attr( $bath ); ?>"><?php echo esc_html( $bath ); ?></label>
                            </span>
							<?php
						}
						?>
                    </div>
                </div>
            </div>
			<?php
		}

		if ( $settings['garage_filter'] === 'yes' ) {
			?>
            <div class="filter-wrapper radio-buttons">
                <h4 class="<?php echo 'yes' !== $settings['garages_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Min Garages', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section buttons-list" data-meta-name="garages" data-display-title="<?php esc_html_e( 'Min Garages', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['garages_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
                    <div class="number-option-wrap garage-options">
                        <span class="option-num">
                            <input type="radio" name="min-garages" id="min-garage-all" value="0" checked>
                            <label for="min-garage-all"><?php esc_html_e( 'All', RHEA_TEXT_DOMAIN ) ?></label>
                        </span>
						<?php
						if ( empty( $garages_max_value ) || 0 > intval( $garages_max_value ) ) {
							$garages_max_value = 5;
						}
						for ( $garage = 1; $garage <= $garages_max_value; $garage++ ) {
							?>
                            <span class="option-num">
                                <input type="radio" name="min-garages" id="min-garage-<?php echo esc_attr( $garage ); ?>" value="<?php echo esc_html( $garage ); ?>">
                                <label for="min-garage-<?php echo esc_attr( $garage ); ?>"><?php echo esc_html( $garage ); ?></label>
                            </span>
							<?php
						}
						?>
                    </div>
                </div>
            </div>
			<?php
		}

		if ( $settings['property_id_filter'] === 'yes' ) {
			?>
            <div class="filter-wrapper input-wrapper">
                <h4 for="property-id" class="<?php echo 'yes' !== $settings['property_id_filter_view_state'] ? 'collapsed' : ''; ?>">
                    <?php esc_html_e( 'Property ID', RHEA_TEXT_DOMAIN ); ?>
                    <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                </h4>
                <div class="filter-section input-filter" data-meta-name="propertyID" data-display-title="<?php esc_html_e( 'Property ID', RHEA_TEXT_DOMAIN ); ?>" <?php echo 'yes' !== $settings['property_id_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
                    <p class="input-wrap" data-meta-name="propertyID">
                        <input type="text" id="property-id" name="property-id" placeholder="<?php esc_html_e( 'Any', RHEA_TEXT_DOMAIN ); ?>">
                    </p>
                </div>
            </div>
			<?php
		}

		// Adding additional meta details
		if ( $settings['additional_fields_filter'] === 'yes' ) {
			$additional_fields = get_option( 'inspiry_property_additional_fields' );

			if ( isset( $additional_fields['inspiry_additional_fields_list'] ) && 0 < count( $additional_fields['inspiry_additional_fields_list'] ) ) {
				$additional_fields = $additional_fields['inspiry_additional_fields_list'];
				if ( is_array( $additional_fields ) && 0 < count( $additional_fields ) && ere_new_field_for_section( 'filters_widget', $additional_fields ) ) {
					?>
                    <div class="filter-wrapper additional-fields">
                        <h4 class="<?php echo 'yes' !== $settings['additional_fields_filter_view_state'] ? 'collapsed' : ''; ?>">
                            <?php esc_html_e( 'Additional Details', RHEA_TEXT_DOMAIN ); ?>
                            <span class="section-control-icon"><?php echo wp_kses( $heading_control_icon, rhea_allowed_html() ); ?></span>
                        </h4>
                        <div class="filter-section additional-items" data-meta-name="additional-fields" <?php echo 'yes' !== $settings['additional_fields_filter_view_state'] ? 'style="display: none;"' : ''; ?>>
							<?php
							foreach ( $additional_fields as $field ) {
								$field_name    = $field['field_name'] ?? '';
								$field_type    = $field['field_type'] ?? '';
								$field_display = $field['field_display'] ?? '';

								if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
									$field_reg_name  = $field_name . ' Label';
									$field_reg_value = $field_name . ' Value';
									$field_name      = apply_filters( 'wpml_translate_single_string', $field_name, 'Additional Fields', $field_reg_name, ICL_LANGUAGE_CODE );
								}

								// Checking if this field is allowed to be displayed here
								if ( is_array( $field_display ) && in_array( 'filters_widget', $field_display ) ) {
									$field_slug = 'inspiry_' . strtolower( str_replace( ' ', '_', $field_name ) );
									?>
                                    <div class="additional-item <?php echo esc_attr( $field_slug );
									echo ' ad-' . esc_attr( $field_type ) . '-wrap'; ?>">
										<?php
										if ( $field_type === 'text' ) {
											?>
                                            <p class="input-wrap input-filter" data-field-name="<?php echo esc_attr( $field_name ); ?>">
                                                <label for="<?php echo esc_attr( $field_slug ); ?>"><?php echo esc_html( $field_name ); ?></label>
                                                <input type="text" id="<?php echo esc_attr( $field_slug ); ?>" name="<?php echo esc_attr( $field_slug ); ?>" placeholder="<?php esc_html_e( 'Any', RHEA_TEXT_DOMAIN ); ?>" value="">
                                            </p>
											<?php
										} else if ( $field_type === 'select' ) {
											$field_options = $field['field_options'];
											if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
												$field_options = apply_filters( 'wpml_translate_single_string', $field_options, 'Additional Fields', $field_reg_value, ICL_LANGUAGE_CODE );
											}
											$field_options = explode( ', ', $field_options );

											if ( ! empty( $field['multi_select'] ) && 'yes' === $field['multi_select'] ) {
												ere_process_filter_widget_tiles(
													array(
														'items_array'     => $field_options,
														'selection_type'  => 'multiselect',
														'view_limit'      => $checkboxes_view_limit,
														'wrapper_classes' => 'items-list multi-select-wrap',
														'section_title'   => $field_name,
														'meta_key'        => $field_slug,
														'display_type'    => $agency_display_type,
														'target_id'       => 'check-list'
													)
												);
											} else {
												if ( is_array( $field_options ) && 0 < count( $field_options ) ) {
													?>
                                                    <p class="select-wrap select-filter" data-field-name="<?php echo esc_attr( $field_name ); ?>" data-field-type="<?php echo esc_attr( $field_type ); ?>">
                                                        <label for="<?php echo esc_attr( $field_slug ); ?>"><?php echo esc_html( $field_name ); ?></label>
                                                        <select name="<?php echo esc_attr( $field_slug ); ?>" id="<?php echo esc_attr( $field_slug ); ?>">
                                                            <option value=""><?php esc_html_e( 'None', RHEA_TEXT_DOMAIN ); ?></option>
															<?php
															foreach ( $field_options as $option ) {
																$option_slug = strtolower( str_replace( ' ', '-', $option ) );
																?>
                                                                <option value="<?php echo esc_attr( $option_slug ); ?>" id="<?php echo esc_attr( $field_slug ) . '-' . esc_attr( $option_slug ); ?>"><?php echo esc_html( $option ); ?></option>
																<?php
															}
															?>
                                                        </select>
                                                    </p>
													<?php
												}
											}
										} else if ( $field_type === 'radio' ) {
											$field_options = $field['field_options'];

											if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
												$field_options = apply_filters( 'wpml_translate_single_string', $field_options, 'Additional Fields', $field_reg_value, ICL_LANGUAGE_CODE );
											}

											$field_options = explode( ', ', $field_options );
											?>
                                            <div class="radio-filter" data-field-name="<?php echo esc_attr( $field_name ); ?>" data-field-slug="<?php echo esc_attr( $field_slug ); ?>">
                                                <h5><?php echo esc_html( $field_name ); ?></h5>
                                                <p class="radio-wrap">
                                                    <input type="radio" id="<?php echo esc_attr( $field_slug ); ?>-none" name="<?php echo esc_attr( $field_slug ); ?>" value="">
                                                    <label for="<?php echo esc_attr( $field_slug ); ?>-none"><span class="radio-fancy"></span> <?php esc_html_e( 'None', RHEA_TEXT_DOMAIN ); ?></label>
                                                </p>
												<?php
												foreach ( $field_options as $option ) {
													$option_slug = strtolower( str_replace( ' ', '-', $option ) );
													?>
                                                    <p class="radio-wrap">
                                                        <input type="radio" id="<?php echo esc_attr( $option_slug ); ?>" name="<?php echo esc_attr( $field_slug ); ?>" value="<?php echo esc_attr( $option ); ?>">
                                                        <label for="<?php echo esc_attr( $option_slug ); ?>"><span class="radio-fancy"></span> <?php echo esc_attr( $option ); ?></label>
                                                    </p>
													<?php
												}
												?>
                                            </div>
											<?php
										} else if ( $field_type === 'checkbox_list' ) {
											$field_options = $field['field_options'];

											if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
												$field_options = apply_filters( 'wpml_translate_single_string', $field_options, 'Additional Fields', $field_reg_value, ICL_LANGUAGE_CODE );
											}

											$field_options = explode( ', ', $field_options );
											?>
                                            <div class="checkbox-wrap checkbox-filter" data-field-name="<?php echo esc_attr( $field_name ); ?>" data-field-slug="<?php echo esc_attr( $field_slug ); ?>">
                                                <h5><?php echo esc_html( $field_name ); ?></h5>
												<?php
												foreach ( $field_options as $option ) {
													$option_slug = strtolower( str_replace( ' ', '-', $option ) );
													?>
                                                    <p class="cb-wrap" data-field-name="<?php echo esc_attr( $field_name ); ?>">
                                                        <input type="checkbox" id="<?php echo esc_attr( $option_slug ); ?>" name="<?php echo esc_attr( $field_slug ); ?>" value="<?php echo esc_attr( $option ); ?>">
                                                        <label for="<?php echo esc_attr( $option_slug ); ?>"><?php echo esc_attr( $option ); ?><i>&#10003;</i></label>
                                                    </p>
													<?php
												}
												?>
                                            </div>
											<?php
										} else if ( $field_type === 'textarea' ) {
											?>
                                            <p class="input-wrap input-filter" data-field-name="<?php echo esc_attr( $field_name ); ?>">
                                                <label for="<?php echo esc_attr( $field_slug ); ?>"><?php echo esc_html( $field_name ); ?></label>
                                                <input type="text" id="<?php echo esc_attr( $field_slug ); ?>" name="<?php echo esc_attr( $field_slug ); ?>" placeholder="<?php esc_html_e( 'Any', RHEA_TEXT_DOMAIN ); ?>">
                                            </p>
											<?php
										}
										?>
                                    </div>
									<?php
								}
							}
							?>
                        </div>
                    </div>
					<?php
				}
			}
		}
		?>
    </div> <!-- .property-filters -->
</div>