<?php
/**
 * RealHomes Elementor News V4 Widget
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_News_v4 extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-news-v4';
	}

	public function get_title() {
		return esc_html__( 'RH: News V4', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-posts-grid rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-real-homes' ];
	}

	protected function register_controls() {
		$grid_size_array = wp_get_additional_image_sizes();

		$prop_grid_size_array = array();
		foreach ( $grid_size_array as $key => $value ) {
			$str_rpl_key = ucwords( str_replace( "-", " ", $key ) );

			$prop_grid_size_array[ $key ] = $str_rpl_key . ' - ' . $value['width'] . 'x' . $value['height'];
		}

		unset( $prop_grid_size_array['partners-logo'] );
		unset( $prop_grid_size_array['property-detail-slider-thumb'] );
		unset( $prop_grid_size_array['post-thumbnail'] );
		unset( $prop_grid_size_array['agent-image'] );
		unset( $prop_grid_size_array['post-featured-image'] );

		if ( INSPIRY_DESIGN_VARIATION == 'modern' ) {
			$default_prop_grid_size = 'modern-property-child-slider';
		} else {
			$default_prop_grid_size = 'gallery-two-column-image';
		}


		$this->start_controls_section(
			'rhea_ultra_news_grid',
			[
				'label' => esc_html__( 'Basic Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'widget_layout',
			[
				'label'   => esc_html__( 'Layout', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => array(
					'1' => esc_html__( 'Layout 1', RHEA_TEXT_DOMAIN ),
					'2' => esc_html__( 'Layout 2', RHEA_TEXT_DOMAIN ),
				)
			]
		);

		$this->add_control(
			'ere_news_grid_thumb_sizes',
			[
				'label'   => esc_html__( 'Thumbnail Size', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => $default_prop_grid_size,
				'options' => $prop_grid_size_array
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'   => esc_html__( 'Number of Posts', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'default' => 3,
			]
		);

		// Select controls for Custom Taxonomies related to Property
		$property_taxonomies = get_object_taxonomies( 'post', 'objects' );
		if ( ! empty( $property_taxonomies ) && ! is_wp_error( $property_taxonomies ) ) {
			foreach ( $property_taxonomies as $single_tax ) {
				$options = [];
				$terms   = get_terms( $single_tax->name );

				if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
					foreach ( $terms as $term ) {
						$options[ $term->slug ] = $term->name;
					}
				}

				$this->add_control(
					$single_tax->name,
					[
						'label'       => $single_tax->label,
						'type'        => \Elementor\Controls_Manager::SELECT2,
						'multiple'    => true,
						'label_block' => true,
						'options'     => $options,
					]
				);
			}
		}


		// Sorting Controls
		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Order By', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'date'       => esc_html__( 'Date', RHEA_TEXT_DOMAIN ),
					'title'      => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
					'menu_order' => esc_html__( 'Menu Order', RHEA_TEXT_DOMAIN ),
					'rand'       => esc_html__( 'Random', RHEA_TEXT_DOMAIN ),
				],
				'default' => 'date',
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__( 'Ascending', RHEA_TEXT_DOMAIN ),
					'desc' => esc_html__( 'Descending', RHEA_TEXT_DOMAIN ),
				],
				'default' => 'desc',
			]
		);


		$this->add_control(
			'offset',
			[
				'label'   => esc_html__( 'Offset or Skip From Start', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => '0'
			]
		);

		$this->add_control(
			'show_author',
			[
				'label'        => esc_html__( 'Show Author', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'by-label',
			[
				'label'     => esc_html__( 'By', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'By', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_author' => 'yes',
				],
			]
		);


		$this->add_control(
			'show_date',
			[
				'label'        => esc_html__( 'Show Date', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_category',
			[
				'label'        => esc_html__( 'Show Category', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'title-trim-length',
			[
				'label'   => esc_html__( 'Title Trim Length', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'default' => 12,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'first_post_styles',
			[
				'label'     => esc_html__( 'First Post Styles', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'widget_layout' => '1',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'first_post_title_typography',
				'label'    => esc_html__( 'Title Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-news-inner.layout-1>:nth-child(1) .rhea-detail h3 a',

			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'first_post_top_tags_typography',
				'label'    => esc_html__( 'Top Tags Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-news-v4 .rhea-news-inner.layout-1>:nth-child(1) .rhea-detail .rhea-date,{{WRAPPER}} .rhea-news-v4 .rhea-news-inner.layout-1>:nth-child(1) .rhea-detail .rhea-tags',
			]
		);

		$this->add_responsive_control(
			'first_content_padding',
			[
				'label'      => esc_html__( 'Content Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-news-inner.layout-1>:nth-child(1) .rhea-detail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'first_top_tags_margin_bottom',
			[
				'label'     => esc_html__( 'Top Tags Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-news-inner.layout-1>:nth-child(1) .rhea-detail .top-tags' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'post_styles',
			[
				'label' => esc_html__( 'Post Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Post Title Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-news-inner h3 a',

			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'top_tags_typography',
				'label'    => esc_html__( 'Top Tags Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-news-inner .rhea-detail .rhea-date,{{WRAPPER}} .rhea-news-inner .rhea-detail .rhea-tags',
			]
		);


		$this->add_responsive_control(
			'content_padding',
			[
				'label'      => esc_html__( 'Content Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-news-inner .rhea-detail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'top_tags_margin_bottom',
			[
				'label'     => esc_html__( 'Top Tags Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-detail .top-tags' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'news_colors_section',
			[
				'label' => esc_html__( 'Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_background',
			[
				'label'     => esc_html__( 'Content Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-news-v4 .rhea-news-inner article .rhea-detail' => '    background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'date-color',
			[
				'label'     => esc_html__( 'Date', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-news-v4 .rhea-detail .rhea-date' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tags-color',
			[
				'label'     => esc_html__( 'Tags', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-news-v4 .rhea-detail .separator' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-news-v4 .rhea-detail .rhea-tags' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tags-hover-color',
			[
				'label'     => esc_html__( 'Tags Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-news-v4 .rhea-detail .rhea-tags:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title-color',
			[
				'label'     => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-news-v4 .rhea-news-inner h3 a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title-color-hover',
			[
				'label'     => esc_html__( 'Title Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .rhea-news-v4 .rhea-news-inner h3 a:hover' => 'color: {{VALUE}}',
				],
			]
		);


		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		global $news_grid_size;
		$news_grid_size = $settings['ere_news_grid_thumb_sizes'];

		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} else if ( get_query_var( 'page' ) ) { // if is static front page
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}

		if ( $settings['offset'] ) {
			$offset = $settings['offset'] + ( $paged - 1 ) * $settings['posts_per_page'];
		} else {
			$offset = '';
		}

		$news_args = array(
			'post_type'      => 'post',
			'posts_per_page' => $settings['posts_per_page'],
			'order'          => $settings['order'],
			'orderby'        => $settings['orderby'],
			'offset'         => $offset,
			'paged'          => $paged,
			'meta_query'     => array(
				'relation' => 'OR',
				array(
					'key'     => '_thumbnail_id',
					'compare' => 'EXISTS'
				),
				array(
					'key'     => 'REAL_HOMES_embed_code',
					'compare' => 'EXISTS'
				),
				array(
					'key'     => 'REAL_HOMES_gallery',
					'compare' => 'EXISTS'
				)
			)
		);

		$news_args['tax_query'] = array(
			array(
				'taxonomy' => 'post_format',
				'field'    => 'slug',
				'terms'    => array( 'post-format-quote', 'post-format-link', 'post-format-audio' ),
				'operator' => 'NOT IN'
			)
		);

		// Filter based on taxonomies
		$post_taxonomies = get_object_taxonomies( 'post', 'objects' );
		if ( ! empty( $post_taxonomies ) && ! is_wp_error( $post_taxonomies ) ) {
			foreach ( $post_taxonomies as $single_tax ) {
				$setting_key = $single_tax->name;
				if ( ! empty( $settings[ $setting_key ] ) ) {
					$news_args['tax_query'][] = [
						'taxonomy' => $setting_key,
						'field'    => 'slug',
						'terms'    => $settings[ $setting_key ],
					];
				}
			}
			if ( isset( $news_args['tax_query'] ) && count( $news_args['tax_query'] ) > 1 ) {
				$news_args['tax_query']['relation'] = 'AND';
			}
		}

		$news_query = new WP_Query( apply_filters( 'rhea_modern_news_widget', $news_args ) );
		?>
        <div id="rh-news-<?php echo $this->get_id(); ?>" class="rhea-news-v4">

			<?php
			if ( $news_query->have_posts() ) {
				?>
                <section class="rhea-news-inner layout-<?php echo esc_attr( $settings['widget_layout'] ) ?>">
					<?php
					while ( $news_query->have_posts() ) {
						$news_query->the_post();
						?>
                        <article class="rhea-post-v4">
                            <div class="rhea-thumbnail">
								<?php rhea_get_template_part( "assets/partials/post-formats/ultra/standard" ); ?>
                            </div>
							<?php
							if ( is_sticky( get_the_ID() ) ) {
								?>
                                <span class="rhea-sticky-pin">
                                    <?php rhea_safe_include_svg( '/icons/pin-v4.svg' ); ?>
                                </span>
								<?php
							}
							?>
                            <div class="rhea-detail">
                                <div class="top-tags">
									<?php
									if ( 'yes' == $settings['show_date'] ) { ?>
                                        <time class="rhea-date" datetime="<?php the_modified_time( 'c' ); ?>"> <?php the_time( get_option( 'date_format' ) ); ?></time>
										<?php
									}
									if ( 'yes' == $settings['show_category'] ) {
										$get_categories = get_the_category();
										if ( is_array( $get_categories ) && ! empty( $get_categories ) ) {
											?>
                                            <span class="separator"> - </span><span class="rhea-tags-box">
                                            <?php
                                            foreach ( $get_categories as $category ) {
	                                            ?>
                                                <a class="rhea-tags" href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><?php echo esc_attr( $category->name ); ?></a>
	                                            <?php
                                            }
                                            ?>
                                            </span>
											<?php
										}
									}
									?>
                                </div>
                                <h3 class="rhea-post-title">
                                    <a href="<?php the_permalink(); ?>"><?php echo esc_html( wp_trim_words( get_the_title(), $settings['title-trim-length'], '...' ) ); ?></a>
                                </h3>

                            </div>
                        </article>

						<?php
					} ?>
                </section>
				<?php
			}
			wp_reset_postdata();
			?>
        </div>

		<?php

	}
}
