<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Schedule_Tour_Form_Widget extends \Elementor\Widget_Base {

	public function __construct( array $data = [], ?array $args = null ) {
		parent::__construct( $data, $args );

		wp_enqueue_style( 'flatpickr' );
		wp_enqueue_script( 'flatpickr' );
	}

	public function get_name() {
		return 'rhea-schedule-tour-form-widget';
	}

	public function get_title() {
		return esc_html__( 'RH: Schedule Tour Form', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-form-horizontal rh-modern-widget';
	}

	public function get_categories() {
		return [ 'real-homes' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'section_subtitle',
			[
				'label'       => esc_html__( 'Sub Title', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'section_title',
			[
				'label'       => esc_html__( 'Main Title', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'target_email',
			[
				'label'       => esc_html__( 'Target Email ( Required )', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'The message will be sent on this email address.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => 'your@email.com',
				'separator'   => 'before'
			]
		);

		$this->add_control(
			'name_field_label',
			[
				'label'   => esc_html__( 'Name Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => '',
			]
		);

		$this->add_control(
			'name_field_width',
			[
				'label'     => esc_html__( 'Name Field Label Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-form input[name="name"]' => '--name-field-width: {{SIZE}}px;',
				],
			]
		);

        $this->add_control(
            'phone_number_field_label',
            [
                'label'   => esc_html__( 'Phone Number Field Label', RHEA_TEXT_DOMAIN ),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' =>'',
            ]
        );

		$this->add_control(
			'phone_number_field_width',
			[
				'label'     => esc_html__( 'Phone Number Field Label Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-form input[name="phone_number"]' => '--phone-number-field-width: {{SIZE}}px;',
				],
			]
		);

		$this->add_control(
			'email_field_label',
			[
				'label'   => esc_html__( 'Email Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' =>'',
			]
		);

		$this->add_control(
			'email_field_width',
			[
				'label'     => esc_html__( 'Email Field Label Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-form input[name="email"]' => '--email-field-width: {{SIZE}}px;',
				],
			]
		);

		$this->add_control(
			'date_field_label',
			[
				'label'   => esc_html__( 'Date and Time Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' =>'',
			]
		);

		$this->add_control(
			'date_field_width',
			[
				'label'     => esc_html__( 'Date and Time Field Label Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-form input[name="date"]' => '--date-field-width: {{SIZE}}px;',
				],
			]
		);

		$this->add_control(
			'message_field_label',
			[
				'label'   => esc_html__( 'Message Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' =>'',
			]
		);

		$this->add_control(
			'message_field_width',
			[
				'label'     => esc_html__( 'Message Field Label Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-form input[name="message"]' => '--message-field-width: {{SIZE}}px;',
				],
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'   => esc_html__( 'Submit Button Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Schedule a Tour', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'contacts_list',
			[
				'label' => esc_html__( 'Contacts List', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_contacts_list',
			[
				'label' => esc_html__( 'Show', RHEA_TEXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off' => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'agent_thumb',
			[
				'label'       => esc_html__( 'Agent Photo', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Recommended Image Size 150x150.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'default'     => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'agent_name',
			[
				'label'   => esc_html__( 'Agent Name', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => 'Jonathan Doe',
			]
		);

		$this->add_control(
			'agent_designation',
			[
				'label'   => esc_html__( 'Designation', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Real Estate Agent', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'contact_number',
			[
				'label'   => esc_html__( 'Number', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => '(223) 546 7594',
			]
		);

		$this->add_control(
			'contact_email_address',
			[
				'label'   => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => 'contact@realhomes.io',
			]
		);

		$this->add_control(
			'contact_address',
			[
				'label'       => esc_html__( 'Address', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'HTML tags a, b, br, em and strong can be used in address.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => '1130, Avenue Villa, Newyork, USA',
			]
		);

		$this->add_control(
			'contact_call_to_action',
			[
				'label'       => esc_html__( 'Call to Action Text', RHEA_TEXT_DOMAIN ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Would you like to Visit the property?', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'contact_call_to_action_link_text',
			[
				'label'       => esc_html__( 'Call to Action Link Text', RHEA_TEXT_DOMAIN ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Schedule a meeting', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'contact_call_to_action_url',
			[
				'label'         => esc_html__( 'Call to Action URL', RHEA_TEXT_DOMAIN ),
				'type'          => \Elementor\Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', RHEA_TEXT_DOMAIN ),
				'show_external' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'container',
			[
				'label' => esc_html__( 'Container', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_wrapper_width',
			[
				'label'     => esc_html__( 'Content Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 600,
						'max' => 1600,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-content' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'content_wrapper_padding',
			[
				'label'      => esc_html__( 'Content Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'container_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-container-bg-color' => 'background: {{VALUE}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'container_bg_width',
			[
				'label'     => esc_html__( 'Background Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'     => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-container-bg-color' => 'width: {{SIZE}}%;',
				],
			]
		);

		$this->add_responsive_control(
			'container_bg_height',
			[
				'label'     => esc_html__( 'Background Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'     => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-container-bg-color' => 'height: {{SIZE}}%;',
				],
			]
		);

		$this->add_control(
			'container_bg_img',
			[
				'label'   => esc_html__( 'Background Image', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name'      => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'exclude'   => [ 'custom' ],
				'default'   => 'full',
				'separator' => 'none',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_head_styles',
			[
				'label' => esc_html__( 'Content', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-section-head-subtitle' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'sub_title_typography',
				'label'    => esc_html__( 'Sub Title Typography', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-stf-section-head-subtitle',
			]
		);

		$this->add_control(
			'main_title_color',
			[
				'label'     => esc_html__( 'Main Title Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-section-head-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'main_title_typography',
				'label'    => esc_html__( 'Main Title Typography', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-stf-section-head-title',
			]
		);

		$this->add_control(
			'heading_form',
			[
				'label' => esc_html__( 'Form', RHEA_TEXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->add_responsive_control(
			'form_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'form_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'form_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-form' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'heading_form_labels',
			[
				'label' => esc_html__( 'Labels', RHEA_TEXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'form_labels_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-form .rhea-stf-form-field label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form_labels_typography',
				'selector' => '{{WRAPPER}} .rhea-stf-form .rhea-stf-form-field label',
			]
		);

		$this->add_control(
			'heading_form_fields',
			[
				'label' => esc_html__( 'Fields', RHEA_TEXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'form_fields_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form input[type="text"], {{WRAPPER}} .rhea-stf-form input[type="email"], {{WRAPPER}} .rhea-stf-form .flatpickr-mobile'  => 'color: {{VALUE}}; border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'form_fields_focus_color',
			[
				'label'     => esc_html__( 'Focus Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form input[type="text"]:focus, {{WRAPPER}} .rhea-stf-form input[type="email"]:focus, {{WRAPPER}} .rhea-stf-form .flatpickr-mobile:focus'  => 'color: {{VALUE}}; border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'form_fields_border_color',
			[
				'label'     => esc_html__( 'Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form input[type="text"], {{WRAPPER}} .rhea-stf-form input[type="email"], {{WRAPPER}} .rhea-stf-form .flatpickr-mobile'  => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form_fields_typography',
				'selector' => '{{WRAPPER}} .rhea-stf-form input[type="text"], {{WRAPPER}} .rhea-stf-form input[type="email"]',
			]
		);

		$this->add_control(
			'heading_submit_button',
			[
				'label' => esc_html__( 'Submit Button', RHEA_TEXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'form_submit_typography',
				'selector' => '{{WRAPPER}} .rhea-stf-form .rhea-stf-submit',
			]
		);

		$this->add_control(
			'form_submit_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form .rhea-stf-submit'  => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'form_submit_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form .rhea-stf-submit'  => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form_submit_border_color',
				'label'    => esc_html__( 'Border Color', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-stf-form .rhea-stf-submit',
			]
		);

		$this->add_control(
			'form_submit_hover_styles_section',
			[
				'label'     => esc_html__( 'Hover Styles', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'form_submit_active_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form .rhea-stf-submit:hover'  => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'form_submit_active_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form .rhea-stf-submit:hover'  => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form_submit_border_hover_color',
				'label'    => esc_html__( 'Border Color', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-stf-form .rhea-stf-submit:hover',
			]
		);

		$this->add_control(
			'form_loader_color',
			[
				'label'     => esc_html__( 'Loader Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-stf-form .rhea-stf-ajax-loader path'  => 'fill: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_contacts_list_styles',
			[
				'label' => esc_html__( 'Contacts List', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'contact_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-contacts-item a, {{WRAPPER}} .rhea-stf-contacts-item span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'contact_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-contacts-item a:hover, {{WRAPPER}} .rhea-stf-contacts-call-to-action-item a:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'contact_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-stf-contacts-item a, {{WRAPPER}} .rhea-stf-contacts-item span',
			]
		);

		$this->add_control(
			'agent_name_color',
			[
				'label'     => esc_html__( 'Agent Name Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-contacts-item .rhea-stf-agent-name' => 'color: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_name_typography',
				'label'    => esc_html__( 'Agent Name Typography', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-stf-contacts-item .rhea-stf-agent-name',
			]
		);


		$this->add_control(
			'cta_text_color',
			[
				'label'     => esc_html__( 'Call To Action Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-contacts-call-to-action-item a, {{WRAPPER}} .rhea-stf-contacts-call-to-action-item span' => 'color: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'cta_text_typography',
				'label'    => esc_html__( 'Call To Action Text Typography', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-stf-contacts-call-to-action-item a, {{WRAPPER}} .rhea-stf-contacts-call-to-action-item span',
			]
		);

		$this->add_control(
			'box_bg_color',
			[
				'label'     => esc_html__( 'Box Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-contacts-wrap:before' => 'background: {{VALUE}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'box_width',
			[
				'label'     => esc_html__( 'Box Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'     => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-contacts-wrap:before' => 'width: {{SIZE}}%;',
				],
			]
		);

		$this->add_responsive_control(
			'box_height',
			[
				'label'     => esc_html__( 'Box Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'     => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-stf-contacts-wrap:before' => 'height: {{SIZE}}%;',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings  = $this->get_settings_for_display();
		$widget_id = $this->get_id();
		?>
        <div id="rhea-stf-container-<?php echo esc_attr( $widget_id ); ?>" class="rhea-stf-container">

            <div class="rhea-stf-container-bg" style="background-image: url('<?php echo esc_url( \Elementor\Group_Control_Image_Size::get_attachment_image_src( $settings['container_bg_img']['id'], 'thumbnail', $settings ) ); ?>')">
                <div class="rhea-stf-container-bg-color"></div>
            </div>

            <div class="rhea-stf-content">
				<?php
				if ( ! empty( $settings['section_subtitle'] ) || ! empty( $settings['section_title'] ) ) :
					?>
                    <div class="rhea-stf-section-head">
						<?php
						if ( ! empty( $settings['section_subtitle'] ) ) :
							?>
                            <span class="rhea-stf-section-head-subtitle">
                                <?php echo esc_html( $settings['section_subtitle'] ); ?>
                            </span>
						<?php
						endif;

						if ( ! empty( $settings['section_title'] ) ) :
							?>
                            <h2 class="rhea-stf-section-head-title">
								<?php echo esc_html( $settings['section_title'] ); ?>
                            </h2>
						<?php
						endif;
						?>
                    </div>
				<?php
				endif;
				?>

                <form class="rhea-stf-form" id="rhea-stf-form-<?php echo esc_attr( $widget_id ); ?>" method="post" action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>">

                    <div class="rhea-stf-form-fields">
                        <div class="rhea-stf-form-field rhea-stf-form-name-field">
							<?php
							$name_field_label = esc_html__( 'Hey my name is', RHEA_TEXT_DOMAIN );
							if ( ! empty( $settings['name_field_label'] ) ) {
								$name_field_label = $settings['name_field_label'];
							}
							?>
                            <label for="name-<?php echo esc_attr( $widget_id ); ?>"><?php echo esc_html( $name_field_label ); ?></label>
                            <input type="text" name="name" id="name-<?php echo esc_attr( $widget_id ); ?>" class="rhea-stf-field required" autocomplete="off" title="<?php esc_attr_e( '* Please provide your name.', RHEA_TEXT_DOMAIN ); ?>">
                        </div>

                        <div class="rhea-stf-form-field rhea-stf-form-email-field">
							<?php
							$email_field_label = esc_html__( 'and my email id is', RHEA_TEXT_DOMAIN );
							if ( ! empty( $settings['email_field_label'] ) ) {
								$email_field_label = $settings['email_field_label'];
							}
							?>
                            <label for="email-<?php echo esc_attr( $widget_id ); ?>"><?php echo esc_html( $email_field_label ); ?></label>
                            <input type="email" name="email" id="email-<?php echo esc_attr( $widget_id ); ?>" class="rhea-stf-field email required" autocomplete="off" title="<?php esc_attr_e( '* Please provide a valid email address.', RHEA_TEXT_DOMAIN ); ?>">
                        </div>

                        <div class="rhea-stf-form-field rhea-stf-form-phone-number-field">
		                    <?php
		                    $phone_number_field_label = esc_html__( 'and phone number is', RHEA_TEXT_DOMAIN );
		                    if ( ! empty( $settings['phone_number_field_label'] ) ) {
			                    $phone_number_field_label = $settings['phone_number_field_label'];
		                    }
		                    ?>
                            <label for="phone-number-<?php echo esc_attr( $widget_id ); ?>"><?php echo esc_html( $phone_number_field_label ); ?></label>
                            <input type="text" name="phone_number" id="phone-number-<?php echo esc_attr( $widget_id ); ?>" class="rhea-stf-field" autocomplete="off">
                        </div>

                        <div class="rhea-stf-form-field rhea-stf-form-date-field" id="date-field-<?php echo esc_attr( $widget_id ); ?>-wrapper">
							<?php
							$date_field_label = esc_html__( 'I would like to schedule a tour at date and time', RHEA_TEXT_DOMAIN );
							if ( ! empty( $settings['date_field_label'] ) ) {
								$date_field_label = $settings['date_field_label'];
							}
							?>
                            <label for="date-<?php echo esc_attr( $widget_id ); ?>"><?php echo esc_html( $date_field_label ); ?></label>
                            <input type="text" name="date" id="date-<?php echo esc_attr( $widget_id ); ?>" class="rhea-stf-field date required" autocomplete="off" title="<?php esc_attr_e( '* Please specify the date.', RHEA_TEXT_DOMAIN ); ?>">
                        </div>

                        <div class="rhea-stf-form-field rhea-stf-form-message-field">
							<?php
							$message_field_label = esc_html__( 'I would like to discuss about', RHEA_TEXT_DOMAIN );
							if ( ! empty( $settings['message_field_label'] ) ) {
								$message_field_label = $settings['message_field_label'];
							}
							?>
                            <label for="message-<?php echo esc_attr( $widget_id ); ?>"><?php echo esc_html( $message_field_label ); ?></label>
                            <input type="text" name="message" id="message-<?php echo esc_attr( $widget_id ); ?>" class="rhea-stf-field required" autocomplete="off" title="<?php esc_attr_e( '* Please provide your message.', RHEA_TEXT_DOMAIN ); ?>">
                        </div>
                    </div>

                    <input type="hidden" name="nonce" value="<?php echo esc_attr( wp_create_nonce( 'schedule_tour_form_nonce' ) ); ?>"/>
                    <input type="hidden" name="target" value="<?php echo esc_attr( antispambot( $settings['target_email'] ) ); ?>"/>
                    <input type="hidden" name="action" value="rhea_schedule_tour_form_mail"/>

                    <div class="rhea-stf-submit-wrapper">
						<?php
						$rhea_stf_button_text = esc_html__( 'Schedule a Tour', RHEA_TEXT_DOMAIN );
						if ( ! empty( $settings['button_text'] ) ) {
							$rhea_stf_button_text = $settings['button_text'];
						}
						?>
                        <input class="rhea-stf-submit" type="submit" name="submit" value="<?php echo esc_attr( $rhea_stf_button_text ); ?>">
                        <div class="rhea-stf-ajax-loader"><?php rhea_safe_include_svg( 'icons/loader.svg' ); ?></div>
                    </div>

                    <div class="rhea-stf-error-container"></div>
                    <div class="rhea-stf-message-container"></div>
                </form>

				<?php
				if ( isset( $settings['show_contacts_list'] ) && 'yes' === $settings['show_contacts_list'] ) {
					?>
                    <div class="rhea-stf-contacts-wrap">
                        <div class="rhea-stf-contacts-item rhea-stf-agent-meta">
							<?php
							if ( ! empty( $settings['agent_thumb'] ) ) :
								?>
                                <div class="rhea-stf-agent-image">
									<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'agent_thumb' ); ?>
                                </div>
							<?php
							endif;

							if ( ! empty( $settings['agent_name'] ) || ! empty( $settings['rhea_testimonial_author_designation'] ) ) : ?>
                                <div class="rhea-stf-agent-details">
									<?php
									if ( ! empty( $settings['agent_name'] ) ) : ?>
                                        <h3 class="rhea-stf-agent-name"><?php echo esc_html( $settings['agent_name'] ); ?></h3><?php
									endif;

									if ( ! empty( $settings['agent_designation'] ) ) : ?>
                                        <span class="rhea-stf-agent-designation"><?php echo esc_html( $settings['agent_designation'] ); ?></span><?php
									endif;
									?>
                                </div>
							<?php
							endif;
							?>
                        </div>
						<?php
						if ( ! empty( $settings['contact_number'] ) || ! empty( $settings['contact_email_address'] ) ) :
							?>
                            <div class="rhea-stf-contacts-item">
								<?php
								if ( ! empty( $settings['contact_email_address'] ) ) :?>
                                    <a href="mailto:<?php echo esc_attr( antispambot( $settings['contact_email_address'] ) ) ?>"
                                       class="rhea-stf-list-text"><?php echo esc_attr( antispambot( $settings['contact_email_address'] ) ) ?></a>
								<?php
								endif;

								if ( ! empty( $settings['contact_number'] ) ) :?>
                                    <a href="tel:<?php echo esc_attr( $settings['contact_number'] ) ?>"
                                       class="rhea-stf-list-text"><?php echo esc_html( $settings['contact_number'] ) ?></a>
								<?php
								endif;
								?>
                            </div>
						<?php
						endif;

						if ( ! empty( $settings['contact_address'] ) ) :
							?>
                            <div class="rhea-stf-contacts-item rhea-stf-contacts-address-item">
                                <span><?php echo wp_kses( $settings['contact_address'], inspiry_allowed_html() ); ?></span>
                            </div>
						<?php
						endif;

						if ( ! empty( $settings['contact_call_to_action'] ) ) :
							?>
                            <div class="rhea-stf-contacts-item rhea-stf-contacts-call-to-action-item">
                                <span><?php echo esc_html( $settings['contact_call_to_action'] ); ?></span>
								<?php
								if ( $settings['contact_call_to_action_url']['url'] ) :
									$target = $settings['contact_call_to_action_url']['is_external'] ? ' target="_blank"' : '';
									$nofollow = $settings['contact_call_to_action_url']['nofollow'] ? ' rel="nofollow"' : '';
									?>
                                    <a href="<?php echo esc_url( $settings['contact_call_to_action_url']['url'] ); ?>"<?php echo $target . $nofollow; ?>>
										<?php echo esc_html( $settings['contact_call_to_action_link_text'] ); ?>
                                    </a>
								<?php
								endif;
								?>
                            </div>
						<?php
						endif;
						?>
                    </div>
					<?php
				}
				?>
            </div>
        </div>
        <script type="application/javascript">
            (function ($) {
                'use strict';
                $(document).ready(function () {
                    flatpickr('#date-<?php echo esc_html( $widget_id ); ?>', {
                        enableTime: true,
                        dateFormat: "Y-m-d H:i",
                    });

                    var dateFieldWrapper = $('#date-field-<?php echo esc_attr( $widget_id ); ?>-wrapper');
                    dateFieldWrapper.find('.flatpickr-mobile').attr('title', dateFieldWrapper.find('#date-<?php echo esc_html( $widget_id ); ?>').attr('title'));

                    rheaScheduleTourForm('#rhea-stf-form-<?php echo esc_attr( $widget_id ); ?>');
                });
            })(jQuery);
        </script>
		<?php
	}
}