<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Inquiry_Form_Widget extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-inquiry-form';
	}

	public function get_title() {
		return esc_html__( 'RH: Inquiry Form', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-form-horizontal rh-modern-widget';
	}

	public function get_categories() {
		return [ 'real-homes' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'rhea_inquiry_form_section',
			[
				'label' => esc_html__( 'Fields', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$options = array(
			'prefix'           => esc_html__( 'Name Prefix', RHEA_TEXT_DOMAIN ),
			'name'             => esc_html__( 'Full Name', RHEA_TEXT_DOMAIN ),
			'email'            => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
			'number'           => esc_html__( 'Mobile Number', RHEA_TEXT_DOMAIN ),
			'home_phone'       => esc_html__( 'Home Number', RHEA_TEXT_DOMAIN ),
			'work_phone'       => esc_html__( 'Work Number', RHEA_TEXT_DOMAIN ),
			'country'          => esc_html__( 'Country', RHEA_TEXT_DOMAIN ),
			'address'          => esc_html__( 'Address', RHEA_TEXT_DOMAIN ),
			'city'             => esc_html__( 'City', RHEA_TEXT_DOMAIN ),
			'state'            => esc_html__( 'State/Province', RHEA_TEXT_DOMAIN ),
			'zipcode'          => esc_html__( 'Zip/Postal', RHEA_TEXT_DOMAIN ),
			'source'           => esc_html__( 'Source', RHEA_TEXT_DOMAIN ),
			'agent-name'       => esc_html__( 'Agent or Negotiator', RHEA_TEXT_DOMAIN ),
			'message'          => esc_html__( 'Message', RHEA_TEXT_DOMAIN ),
			'min_price'        => esc_html__( 'Min Price', RHEA_TEXT_DOMAIN ),
			'max_price'        => esc_html__( 'Max Price', RHEA_TEXT_DOMAIN ),
			'min_beds'         => esc_html__( 'Min Beds', RHEA_TEXT_DOMAIN ),
			'max_beds'         => esc_html__( 'Max Beds', RHEA_TEXT_DOMAIN ),
			'min_baths'        => esc_html__( 'Min Baths', RHEA_TEXT_DOMAIN ),
			'max_baths'        => esc_html__( 'Max Baths', RHEA_TEXT_DOMAIN ),
			'min_garage'       => esc_html__( 'Min Garages', RHEA_TEXT_DOMAIN ),
			'max_garage'       => esc_html__( 'Max Garages', RHEA_TEXT_DOMAIN ),
			'min_area'         => esc_html__( 'Min Area', RHEA_TEXT_DOMAIN ),
			'max_area'         => esc_html__( 'Max Area', RHEA_TEXT_DOMAIN ),
			'property_address' => esc_html__( 'Property Address', RHEA_TEXT_DOMAIN ),
			'property_zipcode' => esc_html__( 'Property Zip/Postal', RHEA_TEXT_DOMAIN ),
			'property_city'    => esc_html__( 'Property City', RHEA_TEXT_DOMAIN ),
			'property_status'  => esc_html__( 'Property Status', RHEA_TEXT_DOMAIN ),
			'property_type'    => esc_html__( 'Property Type', RHEA_TEXT_DOMAIN ),
			'custom'           => esc_html__( 'Custom', RHEA_TEXT_DOMAIN ),
			'gdpr'             => esc_html__( 'GDPR Agreement & Recaptcha', RHEA_TEXT_DOMAIN ),
		);

		$fields_repeater = new \Elementor\Repeater();

		$fields_repeater->add_control(
			'rhea_select_field_type',
			[
				'label'   => esc_html__( 'Select Field', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => $options,
			]
		);

		$custom_field_type = array(
			'text'     => esc_html__( 'Text', RHEA_TEXT_DOMAIN ),
			'number'   => esc_html__( 'Number', RHEA_TEXT_DOMAIN ),
			'select'   => esc_html__( 'Select', RHEA_TEXT_DOMAIN ),
			'checkbox' => esc_html__( 'Checkbox', RHEA_TEXT_DOMAIN ),
			'radio'    => esc_html__( 'Radio', RHEA_TEXT_DOMAIN ),
			'date'     => esc_html__( 'Date', RHEA_TEXT_DOMAIN ),
		);

		$fields_repeater->add_responsive_control(
			'rhea_custom_fields_type',
			[
				'label'     => esc_html__( 'Field Type', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'text',
				'options'   => $custom_field_type,
				'condition' => [
					'rhea_select_field_type' => 'custom',
				],
			]
		);

		$fields_repeater->add_control(
			'rhea_field_label',
			[
				'label' => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$fields_repeater->add_control(
			'rhea_field_placeholder',
			[
				'label'      => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'conditions' => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'rhea_select_field_type',
							'operator' => '!in',
							'value'    => [ 'prefix', 'source', 'agent-name', 'gdpr' ]
						],
						[
							'name'     => 'rhea_custom_fields_type',
							'operator' => '!in',
							'value'    => [ 'date', 'checkbox', 'radio', 'select' ]
						],
					]
				],
			]
		);

		$fields_repeater->add_control(
			'rhea_custom_select_options',
			[
				'label'       => esc_html__( 'Select Options (Comma Separated)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'If this field is empty, default select options from Dashboard -> Real Estate CRM -> Settings will be displayed', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'conditions'  => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_field_type',
							'operator' => 'in',
							'value'    => [ 'prefix', 'source' ]
						],
					],
				],
			]
		);

		$fields_repeater->add_control(
			'rhea_custom_select_option',
			[
				'label'       => esc_html__( 'Options For Field ', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Add comma separated options (I.e Office,Shop,Villa) ', RHEA_TEXT_DOMAIN ),
				'conditions'  => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'rhea_custom_fields_type',
							'operator' => '!in',
							'value'    => [ 'text', 'number', 'date' ]
						],
						[
							'name'     => 'rhea_select_field_type',
							'operator' => '==',
							'value'    => 'custom'
						],
					],

				],
			]
		);

		$fields_repeater->add_control(
			'first_empty',
			[
				'label'        => esc_html__( 'Show First Option Empty?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'conditions'   => [
					'terms' => [
						[
							'name'     => 'rhea_select_field_type',
							'operator' => 'in',
							'value'    => [ 'prefix', 'source' ]
						],
					],
				],
			]
		);

		$fields_repeater->add_responsive_control(
			'rhea_field_size',
			[
				'label'     => esc_html__( 'Field Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '100%',
				'options'   => array(
					'auto'   => esc_html__( 'Custom', RHEA_TEXT_DOMAIN ),
					'10%'    => esc_html__( '10%', RHEA_TEXT_DOMAIN ),
					'20%'    => esc_html__( '20%', RHEA_TEXT_DOMAIN ),
					'25%'    => esc_html__( '25%', RHEA_TEXT_DOMAIN ),
					'33.33%' => esc_html__( '33%', RHEA_TEXT_DOMAIN ),
					'50%'    => esc_html__( '50%', RHEA_TEXT_DOMAIN ),
					'66.66%' => esc_html__( '66%', RHEA_TEXT_DOMAIN ),
					'75%'    => esc_html__( '75%', RHEA_TEXT_DOMAIN ),
					'80%'    => esc_html__( '80%', RHEA_TEXT_DOMAIN ),
					'100%'   => esc_html__( '100%', RHEA_TEXT_DOMAIN ),
				),
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'max-width: {{VALUE}};',
				],
			]
		);

		$fields_repeater->add_responsive_control(
			'field_custom_size',
			[
				'label'      => esc_html__( 'Custom Field Size', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'      => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition'  => [
					'rhea_field_size' => 'auto',
				],
			]
		);

		$fields_repeater->add_control(
			'show_label',
			[
				'label'        => esc_html__( 'Show Label?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'conditions'   => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'rhea_select_field_type',
							'operator' => '!==',
							'value'    => 'gdpr'
						],
					]
				],
			]
		);

		$fields_repeater->add_control(
			'rhea_required_field',
			[
				'label'        => esc_html__( 'Required', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'conditions'   => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'rhea_select_field_type',
							'operator' => '!==',
							'value'    => 'gdpr'
						],
					]
				],
			]
		);

		$fields_repeater->add_control(
			'rhea_error_message',
			[
				'label'       => esc_html__( 'Error Message', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Show text if the required field is empty or invalid (i.e Email field is required)', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( '* This field is required', RHEA_TEXT_DOMAIN ),
				'condition'   => [
					'rhea_required_field' => 'yes',
				],
			]
		);

		$fields_repeater->add_control(
			'add_break_after',
			[
				'label'        => esc_html__( 'Add Break After This Field?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'It will display next field from new row', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$fields_repeater->add_control(
			'field_icon',
			[
				'label' => esc_html__( 'Field Icon', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::ICONS,
			]
		);

		$fields_repeater->add_control(
			'add_separator',
			[
				'label'        => esc_html__( 'Add Separator At Bottom ?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'add_break_after' => 'yes',
				],
			]
		);

		$fields_repeater->add_control(
			'rhea_email_body_label',
			[
				'label'       => esc_html__( 'Field Label In Email Content', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'This text will be shown as label in email content ("Label" field text will be shown if this field is empty)', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => [
					'rhea_select_field_type' => 'custom',
				],
			]
		);

		$this->add_control(
			'rhea_add_field_select',
			[
				'label'       => esc_html__( 'Add Field', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $fields_repeater->get_controls(),
				'title_field' => ' {{{ rhea_field_label }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_inquiry_form_settings',
			[
				'label' => esc_html__( 'Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'label_postfix_text',
			[
				'label' => esc_html__( 'Label Post Fix i.e(* or Required)', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,

			]
		);

		$this->add_control(
			'rhea_submit_text',
			[
				'label'   => esc_html__( 'Submit Button Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Submit', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'rhea_target_email',
			[
				'label'       => esc_html__( 'Target Email', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Target email on which the message will be sent', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'rhea_target_email_cc',
			[
				'label'       => esc_html__( 'Target Email CC', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Target CC emails with coma separated', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'rhea_target_email_bcc',
			[
				'label'       => esc_html__( 'Target Email BCC', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'description' => esc_html__( 'Target BCC emails with coma separated', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'redirect_page',
			[
				'label'       => esc_html__( 'Select Page For Redirection', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => $this->get_pages_list(),
				'default'     => 'none',
				'description' => esc_html__( 'Select a page where the user will be redirected after successfully submitting the form.', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'basic-styles',
			[
				'label' => esc_html__( 'Basic', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'container_style',
			[
				'label'     => esc_html__( 'Container', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'container_margin',
			[
				'label'      => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-form-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'container_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-form-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'container_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-form-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'container_border',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-inquiry-form-wrapper',
			]
		);

		$this->add_control(
			'container_background_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-wrapper' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'fields_wrapper_style',
			[
				'label'     => esc_html__( 'Fields Wrapper', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'fields_wrapper_margin',
			[
				'label'      => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'fields_wrapper_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'fields_wrapper_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'fields_wrapper_border',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-inquiry-field-inner',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'fields_wrapper_box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-inquiry-field-inner',
			]
		);

		$this->add_control(
			'fields_wrapper_background_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-field-inner' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'label_style',
			[
				'label'     => esc_html__( 'Labels', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'label-margin-bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-field label' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'label_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'label_typography',
				'label'    => esc_html__( 'Labels Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-inquiry-form-inner .rhea-inquiry-field label',
			]
		);

		$this->add_control(
			'field-label',
			[
				'label'     => esc_html__( 'Label Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-field label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'label_postfix_typography',
				'label'    => esc_html__( 'Labels Required Mark Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-inquiry-form-inner .rhea-inquiry-field label .label-post-fix',
			]
		);

		$this->add_control(
			'field-label-required-color',
			[
				'label'     => esc_html__( 'Labels Required Mark Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-field label .label-post-fix' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'fields_style',
			[
				'label'     => esc_html__( 'Fields', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'field-between-space',
			[
				'label'     => esc_html__( 'Row Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-inner .rhea-inquiry-field'          => 'padding-right: {{SIZE}}{{UNIT}};padding-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-inquiry-form-inner'                              => 'margin-right: -{{SIZE}}{{UNIT}};margin-left: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-inquiry-form-inner .rhea-inquiry-submit-wrapper' => 'margin-right: {{SIZE}}{{UNIT}};margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-error-container'                                 => 'margin-right: {{SIZE}}{{UNIT}};margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-message-container'                               => 'margin-right: {{SIZE}}{{UNIT}};margin-left: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'field-height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-field:not(textarea)'                        => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field-margin-bottom',
			[
				'label'      => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
					'top'      => 0,
					'right'    => 0,
					'bottom'   => 20,
					'left'     => 0,
					'unit'     => 'px',
					'isLinked' => false,
				],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-form-field, {{WRAPPER}} .rh_inspiry_gdpr, {{WRAPPER}} .inspiry-recaptcha-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'fields-padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} input.rhea-inquiry-form-field'                                                        => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} select.rhea-inquiry-form-field'                                                       => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-inquiry-form-inner .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'fields_typography',
				'label'    => esc_html__( 'Fields Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-inquiry-form-field',
			]
		);

		$this->add_control(
			'field-color',
			[
				'label'     => esc_html__( 'Field Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-field' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'field-background',
			[
				'label'     => esc_html__( 'Field Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-field' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'fields_border_radius',
			[
				'label' => esc_html__( 'Fields Border Radius', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-field'                                     => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker >.dropdown-toggle' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'field-border',
				'label'    => esc_html__( 'Fields Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-inquiry-form-field:not(.rhea_multi_select_picker),{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker >.dropdown-toggle',
			]
		);

		$this->add_control(
			'active-border-color',
			[
				'label'     => esc_html__( 'Active Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-field:focus'        => 'border-color: {{VALUE}} !important',
					'{{WRAPPER}} .dropdown.open button.dropdown-toggle' => 'border-color: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'border-color-error',
			[
				'label'     => esc_html__( 'Invalid Required Field Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-field.error' => 'border-color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'field_placeholder_typography',
				'label'    => esc_html__( 'Placeholder Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-inquiry-form-inner input::placeholder',
			]
		);

		$this->add_control(
			'field-placeholder-color',
			[
				'label'     => esc_html__( 'Placeholder Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-inner ::-webkit-input-placeholder' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-inquiry-form-inner ::-moz-placeholder'          => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-inquiry-form-inner :-ms-input-placeholder'      => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-inquiry-form-inner :-moz-placeholder'           => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'checkbox_radio_typography',
				'label'    => esc_html__( 'Checkbox/Radio Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-custom-checkbox-label',
			]
		);

		$this->add_control(
			'checkbox-text-color',
			[
				'label'     => esc_html__( 'Checkbox/Radio Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-checkbox-label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'textarea_style',
			[
				'label'     => esc_html__( 'Textarea', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'textarea-height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} textarea.rhea-inquiry-form-field' => 'height: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'textarea_margin',
			[
				'label'      => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} textarea.rhea-inquiry-form-field' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'textarea-padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} textarea.rhea-inquiry-form-field' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'separator_style',
			[
				'label'     => esc_html__( 'Separator', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'separator_height',
			[
				'label'     => esc_html__( 'Separator Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-separator' => 'height: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'separator_width',
			[
				'label'      => esc_html__( 'Separator Width (%)', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em' ],
				'range'      => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-form-separator' => 'width: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'separator_top_margin',
			[
				'label'     => esc_html__( 'Separator Top Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-separator' => 'margin-top: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'separator_bottom_margin',
			[
				'label'     => esc_html__( 'Separator Bottom Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-separator' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_control(
			'separator_padding_color',
			[
				'label'     => esc_html__( 'Separator Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-separator' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'icon_style',
			[
				'label'     => esc_html__( 'Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'field_icon_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-field-icon svg, {{WRAPPER}} .rhea-field-icon i' => 'color: {{VALUE}}; fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'field_icon_hover',
			[
				'label'     => esc_html__( 'Color Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-field:hover svg, {{WRAPPER}} .rhea-inquiry-field:hover i' => 'color: {{VALUE}}; fill: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_icon_size',
			[
				'label'     => esc_html__( 'Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-field-icon svg, {{WRAPPER}} .rhea-field-icon i' => 'width: {{SIZE}}{{UNIT}}; font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'field_icon_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rhea-field-icon svg, {{WRAPPER}} .rhea-field-icon i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'error_message_section_heading',
			[
				'label'     => esc_html__( 'Error Container', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'error_message_container_margin',
			[
				'label'      => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-error-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'error_message_container_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-error-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'error_message_text_typography',
				'label'       => esc_html__( 'Invalid/Required Fields Text', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Message appears when there are invalid or empty required fields', RHEA_TEXT_DOMAIN ),
				'global'      => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'    => '{{WRAPPER}} .rhea-error-container .error',
			]
		);

		$this->add_control(
			'error-message-color',
			[
				'label'     => esc_html__( 'Invalid/Required Fields Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-error-container, {{WRAPPER}} .rhea-error-container .error' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'success_message_section_heading',
			[
				'label'     => esc_html__( 'Success Container', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'success_message_container_margin',
			[
				'label'      => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-message-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'success_message_container_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-message-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'submit_message_text_typography',
				'label'       => esc_html__( 'Message After Form Submission', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Controls the typography of the message shown after the form is successfully submitted.', RHEA_TEXT_DOMAIN ),
				'global'      => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'    => '{{WRAPPER}} .rhea-message-container',
			]
		);

		$this->add_control(
			'message-container-color',
			[
				'label'     => esc_html__( 'Message After Submit Form', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-message-container' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'inquiry-submit-button-settings',
			[
				'label' => esc_html__( 'Submit Button Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_type',
			[
				'label'   => esc_html__( 'Animation Type', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => array(
					'default'         => esc_html__( 'Default', RHEA_TEXT_DOMAIN ),
					'slide-in-left'   => esc_html__( 'Slide In Left', RHEA_TEXT_DOMAIN ),
					'slide-in-right'  => esc_html__( 'Slide In Right', RHEA_TEXT_DOMAIN ),
					'slide-in-top'    => esc_html__( 'Slide In Top', RHEA_TEXT_DOMAIN ),
					'slide-in-bottom' => esc_html__( 'Slide In Bottom', RHEA_TEXT_DOMAIN ),
				),
			]
		);

		$this->add_control(
			'submit_button_inline',
			[
				'label'        => esc_html__( 'Make Button Inline', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_responsive_control(
			'rhea_submit_button_size',
			[
				'label'     => esc_html__( 'Button Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '100%',
				'options'   => array(
					'auto'   => esc_html__( 'Custom', RHEA_TEXT_DOMAIN ),
					'10%'    => esc_html__( '10%', RHEA_TEXT_DOMAIN ),
					'20%'    => esc_html__( '20%', RHEA_TEXT_DOMAIN ),
					'25%'    => esc_html__( '25%', RHEA_TEXT_DOMAIN ),
					'33.33%' => esc_html__( '33%', RHEA_TEXT_DOMAIN ),
					'50%'    => esc_html__( '50%', RHEA_TEXT_DOMAIN ),
					'66.66%' => esc_html__( '66%', RHEA_TEXT_DOMAIN ),
					'75%'    => esc_html__( '75%', RHEA_TEXT_DOMAIN ),
					'80%'    => esc_html__( '80%', RHEA_TEXT_DOMAIN ),
					'100%'   => esc_html__( '100%', RHEA_TEXT_DOMAIN ),
				),
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button' => 'max-width: {{VALUE}};'
				],
				'condition' => [
					'submit_button_inline' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'submit_button_custom_size',
			[
				'label'      => esc_html__( 'Button Custom Size', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'      => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rhea-custom-button' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition'  => [
					'submit_button_inline'    => 'yes',
					'rhea_submit_button_size' => 'auto'
				]
			]
		);

		$this->add_responsive_control(
			'submit-button-margin-top',
			[
				'label'     => esc_html__( 'Margin Top', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'submit-button-margin-bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'submit-button-padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-form-inner .rhea-custom-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_submit_align',
			[
				'label'     => esc_html__( 'Alignment', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-h-align-right',
					],
				],
				'default'   => '',
				'toggle'    => true,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-submit-wrapper' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'submit_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-custom-button',
			]
		);

		$this->add_control(
			'submit-button-text-color',
			[
				'label'     => esc_html__( 'Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'submit-button-bg-color',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button.default'  => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rhea-custom-button.slide-bg' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'submit-button-bg-advance',
				'label'    => esc_html__( 'Button Background', RHEA_TEXT_DOMAIN ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .rhea-custom-button.default, {{WRAPPER}} .rhea-custom-button.slide-bg',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'submit-field-border',
				'label'    => esc_html__( 'Submit Button Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-custom-button',
			]
		);

		$this->add_responsive_control(
			'submit_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'button-hover-state',
			[
				'label'     => esc_html__( 'Hover State', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'submit-button-text-hover-color',
			[
				'label'     => esc_html__( 'Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'submit-button-animate-hover-color',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button.default:hover'   => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rhea-custom-button.slide-bg:before' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'     => 'submit-button-bg-advance-hover',
				'label'    => esc_html__( 'Submit Button Background', RHEA_TEXT_DOMAIN ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .rhea-custom-button.default:hover, {{WRAPPER}} .rhea-custom-button.slide-bg:hover',
			]
		);

		$this->add_responsive_control(
			'submit_border_radius_hover',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-custom-button:hover' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'submit-field-border-hover',
				'label'    => esc_html__( 'Submit Button Border Hover', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-custom-button:hover',
			]
		);

		$this->add_control(
			'ajax_loader_section_heading',
			[
				'label'     => esc_html__( 'Loader', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'ajax_loader_color',
			[
				'label'     => esc_html__( 'Loader Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-submit-wrapper .rhea-ajax-loader svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'inquiry-select-fields-settings',
			[
				'label' => esc_html__( 'Select Fields Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'advance_select_field',
			[
				'label'        => esc_html__( 'Enable Advance Select Field', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);


		$this->add_control(
			'dropdown_icon_style',
			[
				'label'     => esc_html__( 'Drop Down Icon Style', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'caret',
				'options'   => array(
					'caret'   => esc_html__( 'Caret', RHEA_TEXT_DOMAIN ),
					'chevron' => esc_html__( 'Chevron', RHEA_TEXT_DOMAIN ),
				),
				'condition' => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'icon_margin',
			[
				'label'     => esc_html__( 'Icon Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle .caret:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-dropdown-style-caret .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle .caret'          => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'chevron_font_size',
			[
				'label'     => esc_html__( 'Chevron Font Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle .caret:before'          => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker_location>.dropdown-toggle .caret:before' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'select-fields-padding',
			[
				'label'      => esc_html__( 'Fields Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'dropdown-select-items-padding',
			[
				'label'      => esc_html__( 'Dropdown Items Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select .dropdown-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'dropdown-border-radius',
			[
				'label'      => esc_html__( 'Dropdown Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select .dropdown-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'select_field_typography',
				'label'    => esc_html__( 'Select Fields', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bootstrap-select .dropdown-toggle .filter-option-inner-inner',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'select_item_typography',
				'label'    => esc_html__( 'Select Fields Items', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bootstrap-select .dropdown-menu li a span.text',
			]
		);

		$this->add_control(
			'rhea_fields_caret_color',
			[
				'label'      => esc_html__( 'Fields Caret Color', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle .caret' => 'border-top-color: {{VALUE}}',
				],
				'conditions' => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'  => 'advance_select_field',
							'value' => 'yes',
						],
						[
							'name'  => 'dropdown_icon_style',
							'value' => 'caret',
						],
					],
				],
			]
		);

		$this->add_control(
			'rhea_fields_chevron_color',
			[
				'label'      => esc_html__( 'Fields Chevron Color', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::COLOR,
				'selectors'  => [
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle .caret:before' => 'color: {{VALUE}};',
				],
				'conditions' => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'  => 'advance_select_field',
							'value' => 'yes',
						],
						[
							'name'  => 'dropdown_icon_style',
							'value' => 'chevron',
						],
					],
				],
			]
		);

		$this->add_control(
			'rhea_select_field_color',
			[
				'label'     => esc_html__( 'Select Field Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select .dropdown-toggle .filter-option-inner-inner' => 'color: {{VALUE}}',
				],
				'condition' => [
					'advance_select_field' => 'yes',
				],
			]
		);


		$this->add_control(
			'rhea_dropdown_bg_color',
			[
				'label'     => esc_html__( 'Dropdown Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu' => 'background: {{VALUE}}',
				],
				'condition' => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_text_color',
			[
				'label'     => esc_html__( 'Dropdown Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li a' => 'color: {{VALUE}}',
				],
				'condition' => [
					'advance_select_field' => 'yes',
				],
			]
		);


		$this->add_control(
			'rhea_dropdown_bg_selected_color',
			[
				'label'     => esc_html__( 'Dropdown Background Select/Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li.selected' => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li:hover'    => 'background: {{VALUE}}',
				],
				'condition' => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_text_selected_color',
			[
				'label'     => esc_html__( 'Dropdown Text Select/Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li.selected a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li:hover a'    => 'color: {{VALUE}}',
				],
				'condition' => [
					'advance_select_field' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'inquiry-gdpr-settings',
			[
				'label' => esc_html__( 'GDPR Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'gdpr_required_typography',
				'label'    => esc_html__( 'GDPR Label', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .gdpr-checkbox-label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'gdpr_required_postfix_typography',
				'label'    => esc_html__( 'GDPR Label Asterisk (*)', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .gdpr-checkbox-label .required-label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'gdpr_text_typography',
				'label'    => esc_html__( 'GDPR Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh_inspiry_gdpr .rh-gdpr-text-inner-wrapper',
			]
		);

		$this->add_control(
			'gdpr-required-label',
			[
				'label'     => esc_html__( 'GDPR Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gdpr-checkbox-label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'gdpr-required-label-postfix',
			[
				'label'     => esc_html__( 'GDPR Label Asterisk (*)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gdpr-checkbox-label .required-label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'gdpr-text-color',
			[
				'label'     => esc_html__( 'GDPR Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'checkbox-border-color',
			[
				'label'     => esc_html__( 'Checkbox Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr label:before' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'checkbox-checked-border-color',
			[
				'label'     => esc_html__( 'Checkbox Checked Border/Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr input:checked + label:before'    => 'border-color: {{VALUE}}',
					'{{WRAPPER}} div.rh_inspiry_gdpr input:checked + label:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'checkbox-checked-tick-color',
			[
				'label'     => esc_html__( 'Checkbox Checked Tick Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh_inspiry_gdpr input:checked + label:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-label-padding',
			[
				'label'      => esc_html__( 'GDPR Label Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field .gdpr-checkbox-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-checkbox-padding',
			[
				'label'      => esc_html__( 'GDPR Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field label[for=rh_inspiry_gdpr]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-checkbox-margin',
			[
				'label'      => esc_html__( 'GDPR Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field label[for=rh_inspiry_gdpr]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'gdpr-checkbox-tick-margin',
			[
				'label'      => esc_html__( 'Checkbox Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-inquiry-field label[for=rh_inspiry_gdpr]:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'gdpr-fields-heading',
			[
				'label'     => esc_html__( 'Fields Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => '',
			]
		);

		$this->add_responsive_control(
			'gdpr-fields_border_radius',
			[
				'label' => esc_html__( 'Fields Border Radius', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::SLIDER,

				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-inner .rhea-inquiry-field label[for=rh_inspiry_gdpr]' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'gdpr-field-border',
				'label'    => esc_html__( 'Fields Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-inquiry-form-inner .rhea-inquiry-field label[for=rh_inspiry_gdpr]',
			]
		);

		$this->add_control(
			'gdpr-border-color-error',
			[
				'label'     => esc_html__( 'Invalid Required Field Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-inquiry-form-inner .rhea-inquiry-field .error+label[for=rh_inspiry_gdpr]' => 'border-color: {{VALUE}} !important',
				],
			]
		);


		$this->end_controls_section();
	}

	protected function render() {
		$settings             = $this->get_settings_for_display();
		$widget_id            = $this->get_id();
		$inquiry_fields       = $settings['rhea_add_field_select'];
		$advance_select_class = 'yes' === $settings['advance_select_field'] ? ' rhea_multi_select_picker ' : '';
		$redirect_url         = '';

		if ( 'none' !== $settings['redirect_page'] ) {
			$redirect_url = 'data-redirect-url="' . esc_url( get_the_permalink( intval( $settings['redirect_page'] ) ) ) . '"';
		}

		if ( $inquiry_fields ) {
			?>
			<div class="rhea-inquiry-form-wrapper rhea-dropdown-style-<?php echo esc_attr( $settings['dropdown_icon_style'] ) ?>">
				<form class="rhea-inquiry-form" id="inquiry_<?php echo esc_attr( $widget_id ); ?>" action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" <?php echo $redirect_url; ?>>
					<div class="rhea-inquiry-form-inner">
						<?php
						foreach ( $inquiry_fields as $fields ) {
							$field_type = $fields['rhea_select_field_type'];
							?>
							<div class="rhea-inquiry-field rhea-field-type-<?php echo esc_attr( $field_type ) ?> elementor-repeater-item-<?php echo esc_attr( $fields['_id'] ) ?>">
								<?php
								if ( 'yes' === $fields['show_label'] && ! empty( $fields['rhea_field_label'] ) ) {
									?>
									<label for="<?php echo esc_attr( $fields['_id'] ) ?>">
										<?php
										echo esc_html( $fields['rhea_field_label'] );
										if ( 'yes' === $fields['rhea_required_field'] && ! empty( $settings['label_postfix_text'] ) ) {
											?>
											<span class="label-post-fix"><?php echo esc_html( $settings['label_postfix_text'] ); ?></span>
											<?php
										}
										?>
									</label>
									<?php
								}

								if ( 'gdpr' !== $field_type ) {
									echo '<div class="rhea-inquiry-field-inner">';

									if ( ! empty( $fields['field_icon']['value'] ) ) {
										?>
										<span class="rhea-field-icon">
			                                <?php \Elementor\Icons_Manager::render_icon( $fields['field_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </span>
										<?php
									}
								}

								if ( 'custom' !== $field_type ) {
									$this->field_types( $field_type, $fields['_id'], $fields['rhea_required_field'], $fields['rhea_error_message'], $fields['rhea_field_placeholder'], $fields['rhea_custom_select_options'], $advance_select_class, $fields['first_empty'] );
								} else {
									if ( ! empty( $fields['rhea_email_body_label'] ) ) {
										$custom_field_label = $fields['rhea_email_body_label'];
									} else {
										$custom_field_label = $fields['rhea_field_label'];
									}
									$this->custom_field_types( $fields['rhea_custom_fields_type'], $fields['_id'], $fields['rhea_required_field'], $fields['rhea_error_message'], $fields['rhea_custom_select_option'], $custom_field_label, $fields['rhea_field_placeholder'], $advance_select_class );
								}

								if ( 'gdpr' !== $field_type ) {
									echo '</div>';
								}
								?>
							</div>
							<?php
							if ( 'yes' == $fields['add_break_after'] ) {
								?>
								<div class="rhea-inquiry-field-break">
									<?php
									if ( 'yes' == $fields['add_separator'] ) {
										?>
										<div class="rhea-inquiry-form-separator"></div>
										<?php
									}
									?>
								</div>
								<?php
							}
						}
						?>
						<input type="hidden" name="nonce" value="<?php echo esc_attr( wp_create_nonce( 'rhea_inquiry_form' ) ); ?>" />
						<input type="hidden" name="target-email" value="<?php echo antispambot( $settings['rhea_target_email'] ) ?>" />
						<?php
						if ( ! empty( $settings['rhea_target_email_cc'] ) ) {
							echo '<input type="hidden" name="target-email-cc" value="' . antispambot( $settings['rhea_target_email_cc'] ) . '" />';
						}

						if ( ! empty( $settings['rhea_target_email_bcc'] ) ) {
							echo '<input type="hidden" name="target-email-bcc" value="' . antispambot( $settings['rhea_target_email_bcc'] ) . '" />';
						}
						?>
						<input type="hidden" name="the_id" value="<?php echo esc_attr( get_the_ID() ); ?>" />
						<input type="hidden" name="action" value="rhea_inquiry_send_message" />

						<?php
						$button_style = 'default';
						if ( 'default' !== $settings['button_type'] ) {
							$button_style = $settings['button_type'] . ' ' . 'slide-bg';
						}

						if ( $settings['submit_button_inline'] ) {
							?>
							<div class="rhea-inquiry-submit-wrapper submit-button-inline">
								<button class="rhea-custom-button <?php echo esc_attr( $button_style ) ?>" type="submit" name="submit" id="inquiry-submit-<?php echo esc_attr( $widget_id ); ?>">
									<span class="rhea-inquiry-button-text"><?php echo esc_html( $settings['rhea_submit_text'] ); ?></span>
									<div class="rhea-ajax-loader">
										<span class="rhea_loader_box"><?php rhea_safe_include_svg( 'icons/loader.svg' ); ?></span>
									</div>
								</button>
							</div>
							<?php
						}
						?>
						<div class="rhea-inquiry-form-break"></div>
						<div class="rhea-message-container"></div>
						<div class="rhea-error-container"></div>
						<?php
						if ( ! $settings['submit_button_inline'] ) {
							?>
							<div class="rhea-inquiry-submit-wrapper">
								<button class="rhea-custom-button <?php echo esc_attr( $button_style ) ?>" type="submit" name="submit" id="inquiry-submit-<?php echo esc_attr( $widget_id ); ?>">
									<span class="rhea-inquiry-button-text"><?php echo esc_html( $settings['rhea_submit_text'] ); ?></span>
									<div class="rhea-ajax-loader">
										<span class="rhea_loader_box"><?php rhea_safe_include_svg( 'icons/loader.svg' ); ?></span>
									</div>
								</button>
							</div>
							<?php
						}
						?>
					</div>
				</form>
			</div>
			<script type="application/javascript">
				<?php if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) { ?>
                rheaSelectPicker( "<?php echo "#inquiry_" . $widget_id; ?> select.rhea_multi_select_picker" );
				<?php } else { ?>
                jQuery( document ).on( 'ready', function () {
                    rheaSelectPicker( "<?php echo "#inquiry_" . $widget_id; ?> select.rhea_multi_select_picker" );
                    rheaSubmitContactForm( "#inquiry_<?php echo esc_attr( $widget_id );?>", "#inquiry-submit-<?php echo esc_attr( $widget_id );?>" );
                } );
				<?php } ?>
			</script>
			<?php
		}
	}

	public function generate_select_field( $tax_array, $type, $id, $required_fields, $error, $first_empty = true, $ph = '', $advance_select_class = '' ) {
		?>
		<select class="rhea-inquiry-form-field <?php echo esc_attr( $advance_select_class . $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" title="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
			<?php
			if ( true === $first_empty ) {
				?>
				<option value=""><?php echo esc_html__( 'None', RHEA_TEXT_DOMAIN ) ?></option>
				<?php
			}
			if ( is_array( $tax_array ) && ! empty( $tax_array ) ) {
				foreach ( $tax_array as $tax ) {
					?>
					<option value="<?php echo esc_attr( $tax->slug ) ?>"><?php echo esc_html( $tax->name ) ?></option>
					<?php
				}
			}
			?>
		</select>
		<?php
	}

	public function field_types( $field_type, $id, $required, $error_message, $placeholder = '', $custom_options = '', $advance_select_class = '', $empty_option = '' ) {
		$type = $field_type;

		if ( ! empty( $placeholder ) ) {
			$ph = $placeholder;
		} else {
			$ph = '';
		}

		if ( 'yes' == $required ) {
			$required_fields = ' required ';
		} else {
			$required_fields = '';
		}

		if ( ! empty( $error_message ) ) {
			$error = $error_message;
		} else {
			$error = '';
		}

		if ( 'yes' == $empty_option ) {
			$first_empty = '<option value="">' . esc_html__( 'None', 'easy-real-estate' ) . '</option>';
		} else {
			$first_empty = '';
		}

		switch ( $type ) {
			case 'prefix' :

				if ( ! empty( $custom_options ) ) {
					$contact_prefix = $custom_options;
				} else {
					$contact_prefix = get_option( 'recrm_settings' )['recrm_contact_prefixes_settings'];
				}
				$option_array = explode( ',', $contact_prefix );

				?>
				<select class="rhea-inquiry-form-field <?php echo esc_attr( $advance_select_class . $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" title="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error_message ) ?>">
					<?php
					echo $first_empty;
					if ( is_array( $option_array ) && ! empty( $option_array ) ) {
						foreach ( $option_array as $single ) {
							?>
							<option value="<?php echo esc_attr( $single ) ?>"><?php echo esc_html( $single ) ?></option>
							<?php
						}
					}
					?>
				</select>
				<?php
				break;

			case 'source' :

				if ( ! empty( $custom_options ) ) {
					$inquiry_sources = $custom_options;
				} else {
					$inquiry_sources = get_option( 'recrm_settings' )['recrm_contact_source_settings'];
				}
				$option_array = explode( ',', $inquiry_sources );

				?>
				<select class="rhea-inquiry-form-field <?php echo esc_attr( $advance_select_class . $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" title="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $ph ) ?>">
					<?php
					echo $first_empty;
					if ( is_array( $option_array ) && ! empty( $option_array ) ) {
						foreach ( $option_array as $single ) {
							?>
							<option value="<?php echo esc_attr( $single ) ?>"><?php echo esc_html( $single ) ?></option>
							<?php
						}
					}
					?>
				</select>
				<?php
				break;

			case 'agent-name' :

				$ere_get_agents_array = ere_get_agents_array();
				?>
				<select class="rhea-inquiry-form-field <?php echo esc_attr( $advance_select_class . $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" title="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
					<?php
					if ( is_array( $ere_get_agents_array ) && ! empty( $ere_get_agents_array ) ) {
						foreach ( $ere_get_agents_array as $agent ) {
							?>
							<option value="<?php echo esc_attr( $agent ) ?>"><?php echo esc_html( $agent ) ?></option>
							<?php
						}
					}
					?>
				</select>
				<?php
				break;

			case 'property_type' :
				$tax_array = get_terms( array( 'taxonomy' => 'property-type', 'hide_empty' => true ) );
				$this->generate_select_field( $tax_array, $type, $id, $required_fields, $error, true, $ph, $advance_select_class );
				break;

			case 'property_status' :
				$tax_array = get_terms( array( 'taxonomy' => 'property-status', 'hide_empty' => true ) );
				$this->generate_select_field( $tax_array, $type, $id, $required_fields, $error, true, $ph, $advance_select_class );
				break;

			case 'property_city' :
				$tax_array = get_terms( array( 'taxonomy' => 'property-city', 'hide_empty' => true ) );
				$this->generate_select_field( $tax_array, $type, $id, $required_fields, $error, true, $ph, $advance_select_class );
				break;

			case 'name' :
			case 'work_phone' :
			case 'home_phone' :
			case 'country' :
			case 'address' :
			case 'city' :
			case 'state' :
			case 'property_address' :
				?>
				<input class="rhea-inquiry-form-field <?php echo esc_attr( $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" type="text" placeholder="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
				<?php
				break;
			case 'number' :
			case 'zipcode' :
			case 'min_price' :
			case 'max_price' :
			case 'min_baths' :
			case 'max_baths' :
			case 'min_beds' :
			case 'max_beds' :
			case 'min_garage' :
			case 'max_garage' :
			case 'min_area' :
			case 'max_area' :
			case 'property_zipcode' :
				?>
				<input class="rhea-inquiry-form-field <?php echo esc_attr( $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" type="number" placeholder="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
				<?php
				break;

			case 'email' :
				if ( ! empty( $error ) ) {
					$invalid_email = $error;
				} else {
					$invalid_email = esc_html__( 'Provide a valid email address', RHEA_TEXT_DOMAIN );
				}
				?>
				<input class="rhea-inquiry-form-field <?php echo esc_attr( $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" type="email" placeholder="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $invalid_email ) ?>">
				<?php
				break;
			case 'message' :
				?>
				<textarea class="rhea-inquiry-form-field <?php echo esc_attr( $required_fields ); ?>" name="<?php echo esc_attr( $type ) ?>" id="<?php echo esc_attr( $id ) ?>" placeholder="<?php echo esc_attr( $ph ); ?>" cols="30" rows="4" data-msg-required="<?php echo esc_attr( $error ) ?>"></textarea>
				<?php
				break;
			case 'gdpr' :
				if ( ere_is_gdpr_enabled() || ere_is_reCAPTCHA_configured() ) {
					?>
					<div class="rhea-inquiry-gdpr-and-recaptcha">
						<?php
						if ( function_exists( 'ere_gdpr_agreement' ) ) {
							ere_gdpr_agreement( array(
								'id'              => 'rh_inspiry_gdpr',
								'container_class' => 'rh_inspiry_gdpr',
								'title_class'     => 'gdpr-checkbox-label'
							) );
						}
						if ( class_exists( 'Easy_Real_Estate' ) ) {
							if ( ere_is_reCAPTCHA_configured() ) {
								$recaptcha_type = get_option( 'inspiry_reCAPTCHA_type', 'v2' );
								?>
								<div class="inspiry-recaptcha-wrapper clearfix g-recaptcha-type-<?php echo esc_attr( $recaptcha_type ); ?>">
									<div class="inspiry-google-recaptcha"></div>
								</div>
								<?php
							}
						}
						?>
					</div>
					<?php
				}
				break;
		}
	}

	public function custom_field_types( $field_type, $id, $required, $error_message, $select_options, $label, $placeholder = '', $advance_select_class = '' ) {
		$type = $field_type;

		$ph = '';
		if ( ! empty( $placeholder ) ) {
			$ph = $placeholder;
		}

		$required_fields = '';
		if ( 'yes' == $required ) {
			$required_fields = ' required ';
		}

		$error = '';
		if ( ! empty( $error_message ) ) {
			$error = $error_message;
		}
		switch ( $type ) {
			case 'date' :
				?>
				<input type="hidden" name="rhea_custom_label[]" value="<?php echo esc_attr( $label ) ?>">
				<input class="rhea-inquiry-form-field <?php echo esc_attr( $required_fields ); ?>" name="rhea_custom_field[]" id="<?php echo esc_attr( $id ) ?>" type="date" placeholder="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
				<?php
				break;
			case 'text' :
				?>
				<input type="hidden" name="rhea_custom_label[]" value="<?php echo esc_attr( $label ) ?>">
				<input class="rhea-inquiry-form-field <?php echo esc_attr( $required_fields ); ?>" name="rhea_custom_field[]" id="<?php echo esc_attr( $id ) ?>" type="text" placeholder="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
				<?php
				break;
			case 'number' :
				?>
				<input type="hidden" name="rhea_custom_label[]" value="<?php echo esc_attr( $label ) ?>">
				<input class="rhea-inquiry-form-field <?php echo esc_attr( $required_fields ); ?>" name="rhea_custom_field[]" id="<?php echo esc_attr( $id ) ?>" type="number" placeholder="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
				<?php
				break;
			case 'select' :

				if ( ! empty( $select_options ) ) {
					$option_array = explode( ',', $select_options );
					?>
					<input type="hidden" name="rhea_custom_label[]" value="<?php echo esc_attr( $label ) ?>">
					<select class="rhea-inquiry-form-field <?php echo esc_attr( $advance_select_class . $required_fields ); ?>" name="rhea_custom_field[]" id="<?php echo esc_attr( $id ) ?>" title="<?php echo esc_attr( $ph ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>">
						<?php
						if ( is_array( $option_array ) && ! empty( $option_array ) ) {
							foreach ( $option_array as $option ) {
								?>
								<option value="<?php echo esc_attr( $option ) ?>"><?php echo esc_html( $option ) ?></option>
								<?php
							}
						}
						?>
					</select>
					<?php
				}
				break;

			case 'checkbox' :
				if ( ! empty( $select_options ) ) {
					$option_array = explode( ',', $select_options );
					?>
					<input type="hidden" name="rhea_custom_label[]" value="<?php echo esc_attr( $label ) ?>">
					<?php
					if ( is_array( $option_array ) && ! empty( $option_array ) ) {
						?>
						<div class="rhea-radio-checkbox-fields">
							<?php
							$i = 1;
							foreach ( $option_array as $option ) {
								?>
								<label>
									<input type="checkbox" name="rhea_custom_field[<?php echo esc_attr( $id ) ?>][]" id="<?php echo esc_attr( $id ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>" value="<?php echo esc_attr( $option ) ?>">
									<span class="rhea-custom-checkbox-label"><?php echo esc_html( $option ) ?></span>
								</label>
								<?php
								$i ++;
							}
							?>
						</div>
						<?php
					}
				}
				break;

			case 'radio' :
				if ( ! empty( $select_options ) ) {
					$option_array = explode( ',', $select_options );
					?>
					<input type="hidden" name="rhea_custom_label[]" value="<?php echo esc_attr( $label ) ?>">
					<?php
					if ( is_array( $option_array ) && ! empty( $option_array ) ) {
						?>
						<div class="rhea-radio-checkbox-fields">
							<?php
							$i = 1;
							foreach ( $option_array as $option ) {
								?>
								<label class="rhea-radio-checkbox-fields">
									<input type="radio" name="rhea_custom_field[<?php echo esc_attr( $id ) ?>][]" id="<?php echo esc_attr( $id ) ?>" data-msg-required="<?php echo esc_attr( $error ) ?>" value="<?php echo esc_attr( $option ) ?>">
									<span class="rhea-custom-checkbox-label"><?php echo esc_html( $option ) ?></span>
								</label>
								<?php
								$i ++;
							}
							?>
						</div>
						<?php
					}
				}
				break;
		}
	}

	private function get_pages_list() {
		$pages   = get_pages();
		$options = [ 'none' => esc_html__( 'None', RHEA_TEXT_DOMAIN ) ];
		if ( ! empty( $pages ) ) {
			foreach ( $pages as $page ) {
				$options[ $page->ID ] = $page->post_title;
			}
		}

		return $options;
	}
}
