<?php
/**
 * Elementor Agents V4 Widget
 *
 * @since 4.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Agents_Widget_V4 extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-agents-widget-v4';
	}

	public function get_title() {
		return esc_html__( 'RH: Agents V4', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-person rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-real-homes' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'rhea_add_agents_section',
			[
				'label' => esc_html__( 'Add Agents', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_verification_badge',
			[
				'label'        => esc_html__( 'Show Agents Verification Badge', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name'    => 'thumbnail',
				'default' => 'modern-property-child-slider',
			]
		);

		$agents_repeater = new \Elementor\Repeater();

		$all_post_ids = get_posts( array(
			'fields'         => 'ids',
			'posts_per_page' => -1,
			'post_type'      => 'agent'
		) );

		$get_agents = array();
		foreach ( $all_post_ids as $rhea_id ) {
			$get_agents["$rhea_id"] = get_the_title( $rhea_id );
		}

		$agents_repeater->add_control(
			'rhea_select_agent',
			[
				'label'   => esc_html__( 'Select Agent', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => $get_agents,
			]
		);

		$agents_repeater->add_control(
			'rhea_agent_title',
			[
				'label'       => esc_html__( 'Agent Title', RHEA_TEXT_DOMAIN ),
				'placeholder' => esc_html__( 'Agent Title', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'It is recommended to add an agent title. If agent is being added through "Agent Post Type, Agent Title will be displayed only as sorting control label " ', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
			]

		);

		$agents_repeater->add_control(
			'featured_images',
			[
				'label'       => esc_html__( 'Add Featured Images', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Max 3 Images are recommended', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::GALLERY,
			]
		);


		$this->add_control(
			'rhea_agent',
			[
				'label'       => esc_html__( 'Add Agent', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $agents_repeater->get_controls(),
				'title_field' => ' {{{rhea_agent_title}}}',

			]
		);


		$this->end_controls_section();
		$this->start_controls_section(
			'rhea_settings_section',
			[
				'label' => esc_html__( 'Basic Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_verified_agents_only',
			[
				'label'        => esc_html__( 'Show Verified Agents Only', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'view-profile-text',
			[
				'label'   => esc_html__( 'View Profile Button Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'View Profile', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'listed-properties-single-text',
			[
				'label'   => esc_html__( 'Listed Properties Singular Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Listed Property', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'listed-properties-text',
			[
				'label'   => esc_html__( 'Listed Properties Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Listed Properties', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'mobile_number',
			[
				'label'        => esc_html__( 'Display Mobile Number', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'office_number',
			[
				'label'        => esc_html__( 'Display Office Number', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'agent_email',
			[
				'label'        => esc_html__( 'Display Agent Email', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'listed_properties',
			[
				'label'        => esc_html__( 'Display Listed Properties', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_settings',
			[
				'label' => esc_html__( 'Carousel Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_responsive_control(
			'slider-overflow',
			[
				'label'     => esc_html__( 'Slider Overflow', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => [
					'hidden'  => esc_html__( 'Hidden', RHEA_TEXT_DOMAIN ),
					'initial' => esc_html__( 'Initial', RHEA_TEXT_DOMAIN ),
				],
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-stage-outer' => 'overflow: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'center',
			[
				'label'              => esc_html__( 'Center Mode', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'number',
			[
				'label'       => esc_html__( 'Number 0f Slides', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => 4,
				'render_type' => 'none',
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'              => esc_html__( 'Autoplay', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);


		$this->add_control(
			'infinite',
			[
				'label'              => esc_html__( 'Infinite Loop', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SWITCHER,
				'label_on'           => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'          => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value'       => 'yes',
				'default'            => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay_delay',
			[
				'label'              => esc_html__( 'Autoplay Delay', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 4000,
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'speed',
			[
				'label'              => esc_html__( 'Animation Speed', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 500,
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title-styles-section',
			[
				'label' => esc_html__( 'Agent Title', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_title_typography',
				'label'    => esc_html__( 'Title Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-v4-agents-wrapper h3 a'
			]
		);

		$this->add_control(
			'agent_title_color',
			[
				'label'     => esc_html__( 'Title Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-v4-agents-wrapper h3 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_title_color_hover',
			[
				'label'     => esc_html__( 'Title Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-v4-agents-wrapper h3 a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'svg_icon_color',
			[
				'label'     => esc_html__( 'SVG Icon Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-verification-icon path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'title_icon_size',
			[
				'label'     => esc_html__( 'Title Icon Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .agent-verification-icon svg' => 'width: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'title_icon_gap',
			[
				'label'     => esc_html__( 'Title Icon Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-v4-agents-wrapper h3' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_margin_bottom',
			[
				'label'     => esc_html__( 'Title Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-v4-agents-wrapper h3' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'contacts-style-section',
			[
				'label' => esc_html__( 'Property Contacts', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_number_typography',
				'label'    => esc_html__( 'Phone Number Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_agent_meta a'
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_email_typography',
				'label'    => esc_html__( 'Email Address Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_agent_meta.email a'
			]
		);

		$this->add_control(
			'phone-number-color',
			[
				'label'     => esc_html__( 'Phone Number Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_agent_meta a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'phone-number-color-hover',
			[
				'label'     => esc_html__( 'Phone Number Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_agent_meta a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'phone-email-color',
			[
				'label'     => esc_html__( 'Email Address Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_agent_meta.email a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'phone-email-color-hover',
			[
				'label'     => esc_html__( 'Phone Address Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_agent_meta.email a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'contact_margin_bottom',
			[
				'label'     => esc_html__( 'Contacts Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_agent_meta a' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'email_margin_bottom',
			[
				'label'     => esc_html__( 'Email Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_agent_meta.email a' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'listed-properties-section',
			[
				'label' => esc_html__( 'Listed Properties', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_listed_counter_typography',
				'label'    => esc_html__( 'Counter Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-agent-listed-box .counter'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_listed_label_typography',
				'label'    => esc_html__( 'Label Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-agent-listed-box .text'
			]
		);

		$this->add_control(
			'agent_counter_color',
			[
				'label'     => esc_html__( 'Counter Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .rhea-agent-listed-box .counter' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agent_label_color',
			[
				'label'     => esc_html__( 'Label Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .rhea-agent-listed-box .text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'counter_margin_bottom',
			[
				'label'     => esc_html__( 'Counter Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-agent-listed-box .counter' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'label_margin_bottom',
			[
				'label'     => esc_html__( 'Label Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-agent-listed-box .text' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'view-profile-section',
			[
				'label' => esc_html__( 'View Profile Button', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_view_button_typography',
				'label'    => esc_html__( 'View Profile', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .agent-view-profile-button'
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label'      => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .agent-view-profile-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_view_btn_border' );

		$this->start_controls_tab(
			'border_normal',
			[
				'label' => esc_html__( 'Normal', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'view_button_bg_color',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-view-profile-button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'view_button_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-view-profile-button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'border_type',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-view-profile-button',
			]
		);
		$this->add_responsive_control(
			'button_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .agent-view-profile-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'border_hover',
			[
				'label' => esc_html__( 'Hover', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'view_button_bg_hover_color',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-view-profile-button:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'view_button_hover_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-view-profile-button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'border_type_hover',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-view-profile-button:hover',
			]
		);
		$this->add_responsive_control(
			'button_border_radius_hover',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .agent-view-profile-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'common-styles-section',
			[
				'label' => esc_html__( 'Common Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'agent_slide_background',
			[
				'label'     => esc_html__( 'Slide Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-v4-agent-slide' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'thumbnail_margin_bottom',
			[
				'label'     => esc_html__( 'Thumbnail Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-agent-thumb' => 'margin-bottom: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_responsive_control(
			'view_profile_padding',
			[
				'label'      => esc_html__( 'Slide Content Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .agent-detail-expander' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'slide-border-radius',
			[
				'label'      => esc_html__( 'Slide Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-v4-agent-slide' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'thumb-border-radius',
			[
				'label'      => esc_html__( 'Thumbnail Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agent-thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'slide_box_shadow',
				'label'    => esc_html__( 'Slide Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-v4-agent-slide',
			]
		);

		$this->add_control(
			'agent_slide_border_bottom',
			[
				'label'     => esc_html__( 'Slide Border Bottom Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-v4-agent-detail' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {
		$settings        = $this->get_settings_for_display();
		$repeater_agents = $settings['rhea_agent'];
		if ( $repeater_agents ) {
			?>
            <div class="rhea-v4-agents-wrapper" id="rhea-agent-<?php echo $this->get_id(); ?>">
                <div id="rhea-carousel-<?php echo $this->get_id(); ?>" class="owl-carousel">
					<?php
					foreach ( $repeater_agents as $agent ) {
                        $agent_id = intval( $agent['rhea_select_agent'] );
						if ( 'yes' === $settings['show_verified_agents_only'] && '1' !== get_post_meta( $agent_id, 'ere_agent_verification_status', true ) ) {
							continue;
						}
						?>
                        <div class="rhea-v4-agent-slide-outer">
                            <div class="rhea-v4-agent-slide">
                                <div class="rhea-agent-thumb rhea_agent_expand_trigger">
									<?php
									if ( has_post_thumbnail( $agent_id ) ) {
										echo get_the_post_thumbnail( $agent_id, $settings['thumbnail_size'] );
									} else {
										inspiry_image_placeholder( $settings['thumbnail_size'] );
									}
									?>
                                </div>
                                <div class="rhea-v4-agent-detail">
                                    <h3>
                                        <a class="rhea_agent_expand_trigger" href="<?php echo get_permalink( $agent_id ) ?>"> <?php echo get_the_title( $agent_id ); ?></a>
										<?php
										if ( 'yes' === $settings['show_verification_badge'] && '1' === get_post_meta( $agent_id, 'ere_agent_verification_status', true ) ) {
											?>
                                            <span class="agent-verification-icon">
                                                <?php rhea_safe_include_svg( '/icons/agent-badge-v4.svg' ); ?>
                                                </span>
											<?php
										}
										?>
                                    </h3>

                                    <div class="agent-detail-expander">
										<?php
										if ( 'yes' === $settings['mobile_number'] ) {
											$agent_mobile = get_post_meta( $agent_id, 'REAL_HOMES_mobile_number', true );
											if ( ! empty( $agent_mobile ) ) {
												?>
                                                <div class="rhea_agent_meta number mobile">
                                                    <a href="tel:<?php echo esc_attr( $agent_mobile ); ?>">
														<?php echo esc_html( $agent_mobile ); ?>
                                                    </a>
                                                </div>
												<?php
											}
										}
										if ( 'yes' === $settings['office_number'] ) {
											$agent_office_number = get_post_meta( $agent_id, 'REAL_HOMES_office_number', true );
											if ( ! empty( $agent_office_number ) ) {
												?>
                                                <div class="rhea_agent_meta number office">
                                                    <a href="tel:<?php echo esc_attr( $agent_office_number ); ?>">
														<?php echo esc_html( $agent_office_number ); ?>
                                                    </a>
                                                </div>
												<?php
											}
										}
										if ( 'yes' === $settings['agent_email'] ) {
											$agent_email = get_post_meta( $agent_id, 'REAL_HOMES_agent_email', true );
											if ( ! empty( $agent_email ) ) {
												?>
                                                <div class="rhea_agent_meta email">
                                                    <a href="mailto:<?php echo esc_attr( antispambot( $agent_email ) ); ?>">
														<?php echo esc_html( antispambot( $agent_email ) ); ?>
                                                    </a>
                                                </div>
												<?php
											}
										}
										if ( 'yes' === $settings['listed_properties'] ) {
											$listed_single     = ! empty( $settings['listed-properties-single-text'] ) ? esc_html( $settings['listed-properties-single-text'] ) : esc_html__( 'Listed Property', RHEA_TEXT_DOMAIN );
											$listed_multiple   = ! empty( $settings['listed-properties-text'] ) ? esc_html( $settings['listed-properties-text'] ) : esc_html__( 'Listed Properties', RHEA_TEXT_DOMAIN );
											$listed_properties = 0;
											if ( function_exists( 'ere_get_agent_properties_count' ) ) {
												$listed_properties = ere_get_agent_properties_count( $agent_id );
											}
											?>
                                            <div class="rhea-agent-listed-box">
                                                <span class="counter"><?php echo ( ! empty( $listed_properties ) ) ? esc_html( $listed_properties ) : 0; ?></span>
                                                <span class="text"><?php echo ( 1 === $listed_properties ) ? esc_html( $listed_single ) : esc_html( $listed_multiple ); ?></span>
                                            </div>
											<?php
										}
										if ( ! empty( $settings['view-profile-text'] ) ) {
											?>
                                            <a class="agent-view-profile-button" href="<?php echo esc_url( get_the_permalink( $agent_id ) ); ?>"><?php echo esc_html( $settings['view-profile-text'] ); ?></a>
											<?php
										}
										?>
                                    </div>
                                </div>
                            </div>
                        </div>
						<?php
					}
					?>
                </div>

            </div>
            <script type="application/javascript">

                ( function ( $ ) {
                    'use strict';
                    $( document ).ready( function () {
                        var owl = $( "#rhea-carousel-<?php echo $this->get_id(); ?>" );

                        owl.owlCarousel( {
                            center          : <?php echo json_encode( "yes" === $settings['center'] ? true : false ); ?>,
                            items           : <?php echo $settings['number']; ?>,
                            nav             : false,
                            autoWidth       : true,
                            dots            : false,
                            loop            : <?php echo json_encode( "yes" === $settings['infinite'] ? true : false ); ?>,
                            rtl             : rheaIsRTL(),
                            autoplay        : <?php echo json_encode( "yes" === $settings['autoplay'] ? true : false ); ?>,
                            autoplayTimeout : <?php echo $settings['autoplay_delay']; ?>,
                            smartSpeed      : <?php echo $settings['speed']; ?>,
                            responsive      : {
                                // breakpoint from 0 up
                                0 : {
                                    center : false,
                                    items  : 1,
                                    margin : 20
                                },
                                // breakpoint from 650 up
                                650 : {
                                    center : false,
                                    items  : 2,
                                    margin : 20
                                },
                                // breakpoint from 1140 up
                                1140 : {
                                    items  : <?php echo $settings['number']; ?>,
                                    margin : 30
                                },
                                1400 : {
                                    margin : 50
                                }
                            }
                        } );

                        rheaAgentToggleV4( '#rhea-agent-<?php echo $this->get_id(); ?>' )

                    } );
                } )( jQuery );
            </script>
			<?php
		}
	}
}