<?php
/**
 * Ultra Agent/Agency Posts Card Widget
 *
 * @since 2.3.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Agent_Agency_Card_Widget extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-ultra-agent-card-widget';
	}

	public function get_title() {
		return esc_html__( 'RH: Agent/Agency Posts Card', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-person rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-real-homes' ];
	}

	public function get_script_depends() {

		wp_register_script(
			'rhea-agent-agency-posts-js',
			RHEA_PLUGIN_URL . '/elementor/js/agent-agency-posts.js',
			array( 'elementor-frontend' ),
			RHEA_VERSION,
			true
		);

		return [ 'rhea-agent-agency-posts-js' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'basic_settings',
			[
				'label' => esc_html__( 'Basic', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'all_agent_agency_posts',
			[
				'label'        => esc_html__( 'Display All Listings', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'By default, this widget displays the single agent/agency details. To display all listings, enable this setting.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'agent_id',
			[
				'label'       => esc_html__( 'Agent/Agency ID', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Use this field to enter an agent or agency post ID to show their profile information anywhere on the site.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'condition'   => [
					'all_agent_agency_posts' => '',
				],
			]
		);

		$this->add_control(
			'select_post_type',
			[
				'label'   => esc_html__( 'Post Type', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT2,
				'default' => 'agent',
				'options' => array(
					'agent'  => esc_html__( 'Agent', RHEA_TEXT_DOMAIN ),
					'agency' => esc_html__( 'Agency', RHEA_TEXT_DOMAIN ),
				),
			]
		);

		$this->add_control(
			'show_agency_agents',
			[
				'label'        => esc_html__( 'Show Single Agency Agents', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'Show agents associated with the current agency on the single page.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'select_post_type'       => 'agent',
					'all_agent_agency_posts' => '',
				]
			]
		);

		$this->add_control(
			'number_of_agency_agents',
			[
				'label'     => esc_html__( 'Number of Agents', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'default'   => '4',
				'condition' => [
					'show_agency_agents'     => 'yes',
					'select_post_type'       => 'agent',
					'all_agent_agency_posts' => '',
				]
			]
		);

		$this->add_control(
			'number_of_posts',
			[
				'label'     => esc_html__( 'Posts Per Page', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'default'   => '10',
				'condition' => [
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_control( 'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_control(
			'show_posts_filter',
			[
				'label'        => esc_html__( 'Show Filters', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_posts_filter_property_count',
			[
				'label'        => esc_html__( 'Show Properties Count Filter', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_control(
			'show_posts_filter_location',
			[
				'label'        => esc_html__( 'Show Location Filter', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_control(
			'show_posts_sorting_options',
			[
				'label'        => esc_html__( 'Show Sorting Filter', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_control(
			'show_verified_posts_filter',
			[
				'label'        => esc_html__( 'Show Verified Checkbox', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_control(
			'show_ratings_filter',
			[
				'label'        => esc_html__( 'Show Ratings Filter', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filters_form_title',
			[
				'label'     => esc_html__( 'Filters Form Title', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Filter Agents', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control( 'hr2',
			[
				'type'      => \Elementor\Controls_Manager::DIVIDER,
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'agency_prefix',
			[
				'label'     => esc_html__( 'Related Agency Prefix', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Company Agent at The', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'select_post_type' => 'agent',
				],
			]
		);

		$this->add_control(
			'show_company_name',
			[
				'label'        => esc_html__( 'Show Company Name', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'select_post_type' => 'agent',
				],
			]
		);

		$this->add_control(
			'show_property_counter',
			[
				'label'        => esc_html__( 'Show Property Counter', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_description',
			[
				'label'        => esc_html__( 'Show Description', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'description_heading',
			[
				'label'     => esc_html__( 'Description Heading', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'About', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_description' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_progress_stats',
			[
				'label'        => esc_html__( 'Show Progress & Stats ', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'To be displayed only on Agent/Agency single page', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'all_agent_agency_posts' => '',
				],
			]
		);

		$this->add_control(
			'stats_count_break_point',
			[
				'label'       => esc_html__( 'Stats Count Break Point', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Break point after which all remaining statuses will be combined in "Others" tag.', RHEA_TEXT_DOMAIN ),
				'default'     => 3,
				'condition'   => [
					'all_agent_agency_posts' => '',
					'show_progress_stats'    => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_heading',
			[
				'label'     => esc_html__( 'Progress & Stats Heading', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Progress & Stats', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'all_agent_agency_posts' => '',
					'show_progress_stats'    => 'yes',
				],
			]
		);

		$this->add_control(
			'property_locations_label',
			[
				'label'     => esc_html__( 'Property Locations Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Property Location', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'all_agent_agency_posts' => '',
					'show_progress_stats'    => 'yes',
				],
			]
		);
		$this->add_control(
			'property_types_label',
			[
				'label'     => esc_html__( 'Property Types Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Property Types', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'all_agent_agency_posts' => '',
					'show_progress_stats'    => 'yes',
				],
			]
		);

		$this->add_control(
			'property_status_label',
			[
				'label'     => esc_html__( 'Property Status Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Property Status', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'all_agent_agency_posts' => '',
					'show_progress_stats'    => 'yes',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'sizes_spaces',
			[
				'label' => esc_html__( 'Sizes & Spaces', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'filter_form_wrapper_height',
			[
				'label'      => esc_html__( 'Filter Form Wrapper Height', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem', 'custom' ],
				'range'      => [
					'px' => [
						'min' => 50,
						'max' => 500,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 170,
				],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agents-search-form' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition'  => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'filter_form_margin',
			[
				'label'      => esc_html__( 'Filter Form Wrapper Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agents-search-form' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'filter_form_padding',
			[
				'label'      => esc_html__( 'Filter Form Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'filter_form_title_margin',
			[
				'label'      => esc_html__( 'Filter Form Title Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agents-search-form h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'filter_form_label_margin',
			[
				'label'      => esc_html__( 'Filter Form Label Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field > label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'filter_form_input_field_padding',
			[
				'label'      => esc_html__( 'Filter Form Input Field Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field input[type=text]'           => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field input[type=number]'         => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field .dropdown .dropdown-toggle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'filter_form_input_field_margin',
			[
				'label'      => esc_html__( 'Filter Form Input Field Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field input[type=text]'           => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field input[type=number]'         => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field .dropdown .dropdown-toggle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
				'separator'  => 'after'
			]
		);

		$this->add_responsive_control(
			'card_padding',
			[
				'label'      => esc_html__( 'Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-single-agent-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'card-border-radius',
			[
				'label'      => esc_html__( 'Wrapper Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-single-agent-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image-card-border-radius',
			[
				'label'      => esc_html__( 'Thumb Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .agent-thumbnail > a'     => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .agent-thumbnail > a img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'custom-svg-icon-size',
			[
				'label'     => esc_html__( 'Custom SVG Icon Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-elementor-icon' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'custom-font-icon-size',
			[
				'label'     => esc_html__( 'Custom FontAwesome Icon Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-elementor-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'custom-contact-icon-gap',
			[
				'label'     => esc_html__( 'Contact Icon Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .agent-contact-item' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'colors',
			[
				'label' => esc_html__( 'Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'filter_form_background',
			[
				'label'     => esc_html__( 'Filter Form Title', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form > h4' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_title',
			[
				'label'     => esc_html__( 'Filter Form background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_labels_color',
			[
				'label'     => esc_html__( 'Filter Form Labels', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form form label' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_field_background_color',
			[
				'label'     => esc_html__( 'Filter Form Fields Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form form input[type=text]'                                                  => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rhea-agents-search-form form input[type=number]'                                                => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field .dropdown .dropdown-toggle' => 'background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_field_text_color',
			[
				'label'     => esc_html__( 'Filter Form Fields Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form form input[type=text]'                                                  => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-agents-search-form form input[type=number]'                                                => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field .dropdown .dropdown-toggle' => 'color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_basic_color',
			[
				'label'     => esc_html__( 'Filter Form Icons Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .main-field .more-filters svg .rh-ultra-dark'                                                          => 'stroke: {{VALUE}}',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field.ratings-filter .rating-options-wrap .checkbox-switch .rating-stars'                 => 'border-color: {{VALUE}}; color: {{VALUE}}',
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field.ratings-filter .rating-options-wrap .checkbox-switch input:checked + .rating-stars' => 'background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_rating_active_color',
			[
				'label'     => esc_html__( 'Filter Form Icons Active Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field.ratings-filter .rating-options-wrap .checkbox-switch input:checked + .rating-stars' => 'color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_verification_switch_bg',
			[
				'label'     => esc_html__( 'Verification Switch Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field.verified-agents .button-switch .button-check' => 'background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_verification_switch_color',
			[
				'label'     => esc_html__( 'Verification Switch Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field.verified-agents .button-switch .button-check span' => 'background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_verification_switch_active_bg',
			[
				'label'     => esc_html__( 'Verification Switch Active Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field.verified-agents .button-switch input:checked+.button-check' => 'background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_verification_switch_active_color',
			[
				'label'     => esc_html__( 'Verification Switch Active Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field.verified-agents .button-switch input:checked+.button-check span' => 'background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_control(
			'filter_buttons_border_color',
			[
				'label'     => esc_html__( 'Buttons Top Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .filter-buttons' => 'border-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				]
			]
		);

		$this->add_control(
			'filter_form_button_background_color',
			[
				'label'     => esc_html__( 'Filter Button Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .filter-posts-button' => 'border-color: {{VALUE}}; background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_button_color',
			[
				'label'     => esc_html__( 'Filter Button Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .filter-posts-button' => 'color: {{VALUE}};'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_button_hover_background_color',
			[
				'label'     => esc_html__( 'Filter Button Hover Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .filter-posts-button:hover' => 'border-color: {{VALUE}}; background-color: {{VALUE}}'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_button_hover_color',
			[
				'label'     => esc_html__( 'Filter Button Hover Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .filter-posts-button:hover' => 'color: {{VALUE}};'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_reset_button_color',
			[
				'label'     => esc_html__( 'Clear Filters Button Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .filter-buttons input.clear-filters-button' => 'color: {{VALUE}};'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
			]
		);

		$this->add_control(
			'filter_form_reset_button_bg_color',
			[
				'label'     => esc_html__( 'Clear Filters Button Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .filter-buttons input.clear-filters-button:hover' => 'color: {{VALUE}};'
				],
				'condition' => [
					'show_posts_filter'      => 'yes',
					'all_agent_agency_posts' => 'yes',
				],
				'separator' => 'after'
			]
		);

		$this->add_control(
			'label_color',
			[
				'label'     => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-title a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'label_hover_color',
			[
				'label'     => esc_html__( 'Title Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-title a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'agency_description_prefix',
			[
				'label'     => esc_html__( 'Related Agency Prefix', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-description span' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_post_type' => 'agent',
				],
			]
		);
		$this->add_control(
			'agency_description_name',
			[
				'label'     => esc_html__( 'Agency Name', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-description a' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_post_type' => 'agent',
				],
			]
		);
		$this->add_control(
			'agency_listed_properties',
			[
				'label'     => esc_html__( 'Listed Properties', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-listing-count' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_social_colors',
			[
				'label'     => esc_html__( 'Social Links', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-agent-card .agent-social-links i'     => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-agent-card .agent-social-links svg'   => 'fill: {{VALUE}}',
					'{{WRAPPER}} .single-agency-card .agency-social-links i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-agency-card .agency-social-links svg' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_social_colors_hover',
			[
				'label'     => esc_html__( 'Social Links Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-agent-card .agent-social-links a:hover i'     => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-agent-card .agent-social-links a:hover svg'   => 'fill: {{VALUE}}',
					'{{WRAPPER}} .single-agency-card .agency-social-links a:hover i'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .single-agency-card .agency-social-links a:hover svg' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_meta_icon',
			[
				'label'     => esc_html__( 'Meta Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_meta_label',
			[
				'label'     => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-contact-item-label' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_meta_value',
			[
				'label'     => esc_html__( 'Meta Value', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-contact-item-inner a'    => 'color: {{VALUE}}',
					'{{WRAPPER}} .agent-contact-item-inner span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_meta_value_hover',
			[
				'label'     => esc_html__( 'Meta Value Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-contact-item-inner a:hover'  => 'color: {{VALUE}}',
					'{{WRAPPER}} .agency-contact-item-inner a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_desc_heading',
			[
				'label'     => esc_html__( 'Description Heading', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-content-heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'agent_description',
			[
				'label'     => esc_html__( 'Description Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .agent-content, {{WRAPPER}} .agent-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'area_box_shadow',
				'label'    => esc_html__( 'Area Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-single-agent-card',
			]
		);

		$this->add_control(
			'progress_stats_heading_color',
			[
				'label'     => esc_html__( 'Progress & Stats Heading', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .stats-charts-wrap > h3' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);
		$this->add_control(
			'progress_stats_labels_color',
			[
				'label'     => esc_html__( 'Progress & Stats Labels', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .stats-charts-wrap .stats-wrapper .tax-stats > h3' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);

		$this->add_control(
			'progress_stats_details_color',
			[
				'label'     => esc_html__( 'Progress & Stats Details', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .stats-charts-wrap .stats-wrapper .tax-stats ul li' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);

		$this->add_control(
			'progress_stats_details_strong_color',
			[
				'label'     => esc_html__( 'Progress & Stats Details Strong', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .stats-charts-wrap .stats-wrapper .tax-stats ul li strong' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);

		$this->add_control(
			'progress_stats_chart_colors_heading',
			[
				'label'     => esc_html__( 'Stats Chart Colors', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_1',
			[
				'label'     => esc_html__( 'Stats Chart Color 1', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_2',
			[
				'label'     => esc_html__( 'Stats Chart Color 2', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_3',
			[
				'label'     => esc_html__( 'Stats Chart Color 3', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_4',
			[
				'label'     => esc_html__( 'Stats Chart Color 4', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_5',
			[
				'label'     => esc_html__( 'Stats Chart Color 5', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_6',
			[
				'label'     => esc_html__( 'Stats Chart Color 6', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_7',
			[
				'label'     => esc_html__( 'Stats Chart Color 7', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_8',
			[
				'label'     => esc_html__( 'Stats Chart Color 8', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_9',
			[
				'label'     => esc_html__( 'Stats Chart Color 9', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->add_control(
			'progress_stats_chart_color_10',
			[
				'label'     => esc_html__( 'Stats Chart Color 10', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'show_progress_stats' => 'yes',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'typography_section',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'filter_form_title',
				'label'    => esc_html__( 'Filter Form Title', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-agents-search-form > h4',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'filter_form_label',
				'label'    => esc_html__( 'Filter Form Label', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field > label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'filter_form_input_field',
				'label'    => esc_html__( 'Filter Form Input Fields', RHEA_TEXT_DOMAIN ),
				'selector' => '
				    {{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field input[type=text],
				    {{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field input[type=number],
				    {{WRAPPER}} .rhea-agents-search-form .rhea-agent-filters-form .rhea-filter-field .dropdown .dropdown-toggle
				'
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'label_typography',
				'label'    => esc_html__( 'Title', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-title',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agency_prefix_typography',
				'label'    => esc_html__( 'Agency Prefix', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-description span',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agency_name_typography',
				'label'    => esc_html__( 'Agency Name', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-description a',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agency_listed_properties_typography',
				'label'    => esc_html__( 'Listed Properties', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-listing-count',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_meta_label_typography',
				'label'    => esc_html__( 'Meta Label', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-contact-item-label',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_meta_value_typography',
				'label'    => esc_html__( 'Meta Value', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-contact-item-inner a, {{WRAPPER}} .agent-contact-item-inner span',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_desc_heading_typography',
				'label'    => esc_html__( 'Description Heading', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-content-heading',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'agent_description_typography',
				'label'    => esc_html__( 'Description Text', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .agent-content, {{WRAPPER}} .agent-content p',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'progress_stats_typography',
				'label'     => esc_html__( 'Progress & Stats', RHEA_TEXT_DOMAIN ),
				'selector'  => '{{WRAPPER}} .stats-charts-wrap > h3',
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'progress_stats_labels_typography',
				'label'     => esc_html__( 'Progress & Stats Labels', RHEA_TEXT_DOMAIN ),
				'selector'  => '{{WRAPPER}} .stats-charts-wrap .stats-wrapper .tax-stats > h3',
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'progress_stats_details_typography',
				'label'     => esc_html__( 'Progress & Stats Details', RHEA_TEXT_DOMAIN ),
				'selector'  => '{{WRAPPER}} .stats-charts-wrap .stats-wrapper .tax-stats ul li',
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'progress_stats_details_strong_typography',
				'label'     => esc_html__( 'Progress & Stats Details Strong', RHEA_TEXT_DOMAIN ),
				'selector'  => '{{WRAPPER}} .stats-charts-wrap .stats-wrapper .tax-stats ul li strong',
				'condition' => [
					'show_progress_stats' => 'yes',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'contacts_section',
			[
				'label' => esc_html__( 'Contact Details', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'license-label',
			[
				'label' => esc_html__( 'License Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'license-icon',
			[
				'label'       => esc_html__( 'License Number Icon', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->add_control(
			'office-label',
			[
				'label' => esc_html__( 'Office Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'office-icon',
			[
				'label'       => esc_html__( 'Office Number Icon', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->add_control(
			'mobile-label',
			[
				'label' => esc_html__( 'Mobile Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'mobile-icon',
			[
				'label'       => esc_html__( 'Mobile Number Icon', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->add_control(
			'whatsapp-label',
			[
				'label' => esc_html__( 'Whatsapp Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'whatsapp-icon',
			[
				'label'       => esc_html__( 'Whatsapp Number Icon', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->add_control(
			'fax-label',
			[
				'label' => esc_html__( 'Fax Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'fax-icon',
			[
				'label'       => esc_html__( 'Fax Number Icon', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->add_control(
			'email-label',
			[
				'label' => esc_html__( 'Email Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'email-icon',
			[
				'label'       => esc_html__( 'Email Icon', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->add_control(
			'address-label',
			[
				'label' => esc_html__( 'Address Label', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'address-icon',
			[
				'label'       => esc_html__( 'Address Icon', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		global $settings;

		$settings                                 = $this->get_settings_for_display();
		$widget_id                                = $this->get_id();
		$card_options['select_post_type']         = $settings['select_post_type'];
		$card_options['all_agent_agency_posts']   = $settings['all_agent_agency_posts'];
		$card_options['show_company_name']        = $settings['show_company_name'];
		$card_options['agency_prefix']            = $settings['agency_prefix'];
		$card_options['show_property_counter']    = $settings['show_property_counter'];
		$card_options['show_description']         = $settings['show_description'];
		$card_options['description_heading']      = $settings['description_heading'];
		$card_options['show_progress_stats']      = $settings['show_progress_stats'];
		$card_options['progress_stats_heading']   = $settings['progress_stats_heading'];
		$card_options['property_locations_label'] = $settings['property_locations_label'];
		$card_options['property_types_label']     = $settings['property_types_label'];
		$card_options['property_status_label']    = $settings['property_status_label'];

		if ( 'yes' === $settings['all_agent_agency_posts'] ) {
			if ( 'yes' == $settings['show_posts_filter'] ) {
				?>
                <div class="rhea-agents-search-form">
					<?php
					if ( ! empty( $settings['filters_form_title'] ) ) {
						?>
                        <h4><?php echo esc_html( $settings['filters_form_title'] ); ?></h4>
						<?php
					}
					?>
                    <form id="agent-filters-<?php echo esc_attr( $widget_id ); ?>" class="rhea-agent-filters-form">
                        <div class="main-field">
                            <div class="rhea-filter-field post-title-filter">
                                <label for="rhea-filter-name-<?php echo esc_attr( $widget_id ); ?>"><?php esc_html_e( 'Name/Title', RHEA_TEXT_DOMAIN ); ?></label>
                                <input type="text" id="rhea-filter-name-<?php echo esc_attr( $widget_id ); ?>" class="posts-filter-name" name="filter-name" placeholder="<?php esc_html_e( 'Enter Name', RHEA_TEXT_DOMAIN ); ?>">
                            </div>
							<?php
							$necessary_keys = array(
								'show_posts_filter_property_count',
								'show_posts_filter_location',
								'show_posts_sorting_options',
								'show_verified_posts_filter',
								'show_ratings_filter'
							);
							if ( rhea_bulk_settings_check( $settings, $necessary_keys, 'yes', 'or' ) ) {
								?>
                                <div class="more-filters">
									<?php rhea_safe_include_svg( '/icons/filters-icon.svg' ); ?>
                                    <span class="tool-tip"><?php esc_html_e( 'More Filters', RHEA_TEXT_DOMAIN ); ?></span>
                                </div>
								<?php
							}
							?>
                            <div class="filter-button">
                                <input class="submit-button rh-btn rh-btn-primary filter-posts-button" type="submit" value="Filter">
                            </div>
                        </div>

                        <div class="dropdown-fields-wrap">
                            <div class="dropdown-fields">
								<?php
								if ( 'yes' == $settings['show_posts_filter_property_count'] ) {
									?>
                                    <div class="rhea-filter-field">
                                        <label for="rhea-property-count-<?php echo esc_attr( $widget_id ); ?>"><?php esc_html_e( 'Number of properties', RHEA_TEXT_DOMAIN ); ?></label>
                                        <input type="number" id="rhea-property-count-<?php echo esc_attr( $widget_id ); ?>" class="posts-filter-property-count" name="property-count" placeholder="<?php esc_html_e( 'Select a number', RHEA_TEXT_DOMAIN ); ?>">
                                    </div>
									<?php
								}

								if ( 'yes' == $settings['show_posts_filter_location'] ) {

									$property_locations = get_terms( array( 'taxonomy' => $card_options['select_post_type'] . '-location' ) );

									if ( ! is_wp_error( $property_locations ) && is_array( $property_locations ) && 0 < count( $property_locations ) ) {
										?>
                                        <div class="rhea-filter-field rh_prop_search__selectwrap">
                                            <label for="rhea-filter-location-<?php echo esc_attr( $widget_id ); ?>"><?php esc_html_e( 'Location', RHEA_TEXT_DOMAIN ); ?></label>
                                            <select name="location" id="rhea-filter-location-<?php echo esc_attr( $widget_id ); ?>" class="post-filter-location inspiry_select_picker_trigger" data-size="5">
                                                <option value=""><?php esc_html_e( 'Select Location', RHEA_TEXT_DOMAIN ); ?></option>
												<?php
												foreach ( $property_locations as $location ) {
													?>
                                                    <option value="<?php echo esc_attr( $location->slug ); ?>"><?php echo esc_html( $location->name ); ?></option>
													<?php
												}
												?>
                                            </select>
                                        </div>
										<?php
									}
								}

								if ( 'yes' == $settings['show_posts_sorting_options'] ) {
									?>
                                    <div class="rhea-filter-field rh_prop_search__selectwrap">
                                        <label for="rhea-sort-posts-<?php echo esc_attr( $widget_id ); ?>"><?php esc_html_e( 'Sort Listings', RHEA_TEXT_DOMAIN ); ?></label>
                                        <select name="sort-posts" id="rhea-sort-posts-<?php echo esc_attr( $widget_id ); ?>" class="posts-sort-by inspiry_select_picker_trigger">
											<?php
											if ( $card_options['select_post_type'] === 'agent' ) {
												inspiry_agent_sort_options();
											} else {
												inspiry_agency_sort_options();
											}
											?>
                                        </select>
                                    </div>
									<?php
								}

								if ( 'yes' == $settings['show_verified_posts_filter'] ) {
									?>
                                    <div class="rhea-filter-field verified-agents">
                                        <label for="post-verification-<?php echo esc_attr( $widget_id ); ?>"><?php esc_html_e( 'Verified Only', RHEA_TEXT_DOMAIN ); ?></label>
                                        <label class="button-switch" for="post-verification-<?php echo esc_attr( $widget_id ); ?>">
                                            <input type="checkbox" id="post-verification-<?php echo esc_attr( $widget_id ); ?>" class="post-verification" name="verified-agents" value="true">
                                            <div class="button-check">
                                                <span></span>
                                            </div>
                                        </label>
                                    </div>
									<?php
								}

								if ( 'yes' == $settings['show_ratings_filter'] ) {
									?>
                                    <div class="rhea-filter-field ratings-filter">
                                        <label><?php esc_html_e( 'Ratings', RHEA_TEXT_DOMAIN ); ?></label>
                                        <div class="rating-options-wrap">
                                            <label class="checkbox-switch" for="rating-1s-<?php echo esc_attr( $widget_id ); ?>">
                                                <input type="radio" id="rating-1s-<?php echo esc_attr( $widget_id ); ?>" class="post-ratings rating-1s" name="ratings-filter-<?php echo esc_attr( $widget_id ); ?>" value="1">
                                                <span class="rating-stars">
                                                    <i class="fas fa-star"></i>
                                                </span>
                                            </label>
                                            <label class="checkbox-switch" for="rating-2s-<?php echo esc_attr( $widget_id ); ?>">
                                                <input type="radio" id="rating-2s-<?php echo esc_attr( $widget_id ); ?>" class="post-ratings rating-2s" name="ratings-filter-<?php echo esc_attr( $widget_id ); ?>" value="2">
                                                <span class="rating-stars">
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                </span>
                                            </label>
                                            <label class="checkbox-switch" for="rating-3s-<?php echo esc_attr( $widget_id ); ?>">
                                                <input type="radio" id="rating-3s-<?php echo esc_attr( $widget_id ); ?>" class="post-ratings rating-3s" name="ratings-filter-<?php echo esc_attr( $widget_id ); ?>" value="3">
                                                <span class="rating-stars">
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                </span>
                                            </label>
                                            <label class="checkbox-switch" for="rating-4s-<?php echo esc_attr( $widget_id ); ?>">
                                                <input type="radio" id="rating-4s-<?php echo esc_attr( $widget_id ); ?>" class="post-ratings rating-4s" name="ratings-filter-<?php echo esc_attr( $widget_id ); ?>" value="4">
                                                <span class="rating-stars">
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                </span>
                                            </label>
                                            <label class="checkbox-switch" for="rating-5s-<?php echo esc_attr( $widget_id ); ?>">
                                                <input type="radio" id="rating-5s-<?php echo esc_attr( $widget_id ); ?>" class="post-ratings rating-5s" name="ratings-filter-<?php echo esc_attr( $widget_id ); ?>" value="5">
                                                <span class="rating-stars">
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                    <i class="fas fa-star"></i>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
									<?php
								}
								?>
                            </div>
                            <div class="filter-buttons">
                                <input class="submit-button rh-btn rh-btn-primary clear-filters-button" type="reset" value="<?php esc_html_e( 'Clear Filters', RHEA_TEXT_DOMAIN ); ?>">
                                <input class="submit-button rh-btn rh-btn-primary filter-posts-button" type="submit" value="<?php esc_html_e( 'Filter', RHEA_TEXT_DOMAIN ); ?>">
                            </div>
                        </div>
                        <input type="hidden" name="post_type" class="rhea-post-type" value="<?php echo esc_attr( $settings['select_post_type'] ); ?>">
                    </form>
                </div>
				<?php
			}
			?>
            <div class="rhea-agent-agency-posts-wrap" data-card-options="<?php echo esc_attr( wp_json_encode( $card_options ) ); ?>">
				<?php
				$paged = 1;
				if ( get_query_var( 'paged' ) ) {
					$paged = get_query_var( 'paged' );
				}

				$agents_args = array(
					'post_type'      => $settings['select_post_type'],
					'posts_per_page' => intval( $settings['number_of_posts'] ),
					'paged'          => $paged,
				);

				$agents_query = new WP_Query( $agents_args );

				if ( $agents_query->have_posts() ) {
					while ( $agents_query->have_posts() ) {
						$agents_query->the_post();
						rhea_get_template_part( 'elementor/widgets/agent/partials/agent-agency-card' );
					}

					inspiry_theme_pagination( $agents_query->max_num_pages );
					wp_reset_postdata();
				} else {
					realhomes_print_no_result();
				}
				?>
            </div>
			<?php
		} else {
			if ( 'agent' === $settings['select_post_type'] && 'yes' === $settings['show_agency_agents'] ) {
				?>
                <div class="agency-agents">
					<?php
					$paged = 1;
					if ( get_query_var( 'paged' ) ) {
						$paged = get_query_var( 'paged' );
					}

					$agency_agents_args = array(
						'post_type'      => 'agent',
						'posts_per_page' => intval( $settings['number_of_agency_agents'] ),
						'paged'          => $paged,
						'meta_query'     => array(
							array(
								'key'     => 'REAL_HOMES_agency',
								'value'   => is_singular( 'agency' ) ? get_the_ID() : $this->get_sample_post_id( $settings ),
								'compare' => '=',
							),
						)
					);

					$agency_agents_query = new WP_Query( $agency_agents_args );
					if ( $agency_agents_query->have_posts() ) {
						while ( $agency_agents_query->have_posts() ) {
							$agency_agents_query->the_post();
							rhea_get_template_part( 'elementor/widgets/agent/partials/agent-agency-card' );
						}

						inspiry_theme_pagination( $agency_agents_query->max_num_pages );

						wp_reset_postdata();
					} else {
						realhomes_print_no_result( esc_html__( 'No Agent Found!', RHEA_TEXT_DOMAIN ) );
					}
					?>
                </div>
				<?php
			} else {
				// Shows the single agent/agency cards
				$settings['sample_post_id'] = $this->get_sample_post_id( $settings );
				rhea_get_template_part( 'elementor/widgets/agent/partials/agent-agency-card' );
			}

		}
	}

	public function get_sample_post_id( $settings ) {
		if ( ! empty( $settings['agent_id'] ) ) {
			$post_id = $settings['agent_id'];
		} else if ( rhea_is_preview_mode() && rhea_get_sample_agent_id() ) {
			$post_id = rhea_get_sample_agent_id();
		} else {
			$post = get_posts( [
				'post_type'      => ( 'yes' === $settings['show_agency_agents'] ) ? 'agency': $settings['select_post_type'],
				'posts_per_page' => 1,
				'orderby'        => 'date',
				'order'          => 'ASC',
				'fields'         => 'ids', // Retrieves only IDs for better performance
			] );

			$post_id = $post[0] ?? null;
		}

		return $post_id;
	}
}
