<?php
/**
 * Agent/Agency Card
 *
 * Partial template for ultra-agent-agency-posts-card.php
 *
 * @since 2.3.0
 */
global $settings;

$post_id = get_the_ID();
if ( ! ( is_singular( 'agent' ) || is_singular( 'agency' ) ) && ! empty( $settings['sample_post_id'] ) ) {
	$post_id = $settings['sample_post_id'];
}

if ( ! empty( $post_id ) ) {
	$RHEA_Elementor_Icons = new RHEA_Elementor_Icons;

	$post_type   = get_post_type( $post_id );
	$agent_title = get_the_title( $post_id );
	?>
    <article class="agent-card single-agent-card rhea-single-agent-card">
        <div class="agent-card-inner">
			<?php
			$the_post_thumbnail = get_the_post_thumbnail( $post_id, 'agent-image', array( 'title' => esc_attr( $agent_title ), 'alt' => esc_attr( $agent_title ) ) );
			if ( ! empty( $the_post_thumbnail ) ) {
				?>
                <figure class="agent-thumbnail">
                    <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>">
						<?php echo $the_post_thumbnail; ?>
                    </a>
                </figure>
				<?php
			} else {
				?>
                <figure class="agent-thumbnail agent-thumb-placeholder">
                    <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>">
                        <i class="fas fa-user-tie"></i>
                    </a>
                </figure>
				<?php
			}
			?>
            <div class="agent-details">
                <header class="agent-card-header">
                    <div class="agent-card-header-inner">
                        <h2 class="agent-title">
                            <a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>">
								<?php echo esc_html( $agent_title ); ?>
                            </a>
							<?php realhomes_verification_badge( $post_type, $post_id ); ?>
                        </h2>
						<?php
						$facebook_url  = get_post_meta( $post_id, 'REAL_HOMES_facebook_url', true );
						$twitter_url   = get_post_meta( $post_id, 'REAL_HOMES_twitter_url', true );
						$linked_in_url = get_post_meta( $post_id, 'REAL_HOMES_linked_in_url', true );
						$instagram_url = get_post_meta( $post_id, 'inspiry_instagram_url', true );
						$youtube_url   = get_post_meta( $post_id, 'inspiry_youtube_url', true );
						$pinterest_url = get_post_meta( $post_id, 'inspiry_pinterest_url', true );
						$agent_website = get_post_meta( $post_id, 'REAL_HOMES_website', true );

						if ( ! empty( $facebook_url ) || ! empty( $twitter_url ) || ! empty( $linked_in_url ) || ! empty( $instagram_url ) || ! empty( $youtube_url ) || ! empty( $pinterest_url ) || ! empty( $agent_website ) ) {
							?>
                            <div class="agent-social-links">
								<?php
								if ( ! empty( $facebook_url ) ) {
									?>
                                    <a class="facebook" target="_blank" href="<?php echo esc_url( $facebook_url ); ?>">
                                        <i class="fab fa-facebook fa-lg"></i>
                                    </a>
									<?php
								}

								if ( ! empty( $twitter_url ) ) {
									?>
                                    <a class="twitter" target="_blank" href="<?php echo esc_url( $twitter_url ); ?>">
										<?php rhea_safe_include_svg( 'icons/x-twitter.svg' ); ?>
                                    </a>
									<?php
								}

								if ( ! empty( $linked_in_url ) ) {
									?>
                                    <a class="linkedin" target="_blank" href="<?php echo esc_url( $linked_in_url ); ?>">
                                        <i class="fab fa-linkedin fa-lg"></i>
                                    </a>
									<?php
								}

								if ( ! empty( $instagram_url ) ) {
									?>
                                    <a class="instagram" target="_blank" href="<?php echo esc_url( $instagram_url ); ?>">
                                        <i class="fab fa-instagram fa-lg"></i>
                                    </a>
									<?php
								}
								if ( ! empty( $youtube_url ) ) {
									?>
                                    <a class="youtube" target="_blank" href="<?php echo esc_url( $youtube_url ); ?>">
                                        <i class="fab fa-youtube-square fa-lg"></i>
                                    </a>
									<?php
								}

								if ( ! empty( $pinterest_url ) ) {
									?>
                                    <a class="pinterest" target="_blank" href="<?php echo esc_url( $pinterest_url ); ?>">
                                        <i class="fab fa-pinterest fa-lg"></i>
                                    </a>
									<?php
								}

								if ( ! empty( $agent_website ) ) {
									?>
                                    <a class="website-icon" target="_blank" href="<?php echo esc_url( $agent_website ); ?>">
                                        <i class="fas fa-globe fa-lg"></i>
                                    </a>
									<?php
								}
								?>
                            </div>
							<?php
						}
						?>
                    </div>
					<?php

					if ( 'yes' === $settings['show_company_name'] ) {
						$agent_agency = get_post_meta( $post_id, 'REAL_HOMES_agency', true );
						if ( ! empty( $agent_agency ) && ( 0 < $agent_agency ) ) {
							?>
                            <p class="agent-description">
								<?php printf( '<span class="agent-agency">%s</span> <a href="%s">%s</a>', esc_html( $settings['agency_prefix'] ), esc_url( get_the_permalink( $agent_agency ) ), esc_html( get_the_title( $agent_agency ) ) ); ?>
                            </p>
							<?php
						}
					}
					if ( 'yes' === $settings['show_property_counter'] ) {
						$listed_properties = 0;

						if ( $post_type === 'agent' ) {
							if ( function_exists( 'ere_get_agent_properties_count' ) ) {
								if ( ! empty( ere_get_agent_properties_count( $post_id ) ) ) {
									$listed_properties = ere_get_agent_properties_count( $post_id );
								}
							}
						} else {
							if ( function_exists( 'ere_get_agency_properties_count' ) ) {
								if ( ! empty( ere_get_agency_properties_count( $post_id ) ) ) {
									$listed_properties = ere_get_agency_properties_count( $post_id );
								}
							}
						}

						$listed_properties_text = sprintf( _n( '%s Listed Property', '%s Listed Properties', $listed_properties, RHEA_TEXT_DOMAIN ), $listed_properties );
						?>
                        <span class="agent-listing-count"><?php echo esc_html( $listed_properties_text ); ?></span>
						<?php
					}
					?>
                    <div class="agent-details-separator"></div>
                </header>

                <div class="agent-contacts-list">
					<?php
					$agent_license_no   = get_post_meta( $post_id, 'REAL_HOMES_license_number', true );
					$agent_mobile       = get_post_meta( $post_id, 'REAL_HOMES_mobile_number', true );
					$agent_whatsapp     = get_post_meta( $post_id, 'REAL_HOMES_whatsapp_number', true );
					$agent_office_phone = get_post_meta( $post_id, 'REAL_HOMES_office_number', true );
					$agent_office_fax   = get_post_meta( $post_id, 'REAL_HOMES_fax_number', true );
					$agent_email        = get_post_meta( $post_id, 'REAL_HOMES_agent_email', true );
					$agent_address      = get_post_meta( $post_id, 'REAL_HOMES_address', true );

					if ( ! empty( $agent_license_no ) ) {
						?>
                        <div class="agent-contact-item agent-license-number">
							<?php
							if ( ! empty( $settings['license-icon']['value'] ) ) {
								$RHEA_Elementor_Icons->generate_elementor_icon( 'license-icon', $settings );
							} else {
								inspiry_safe_include_svg( '/icons/card-number.svg' );
							}
							?>
                            <div class="agent-contact-item-inner">
                                <h4 class="agent-contact-item-label">
									<?php
									if ( ! empty( $settings['license-label'] ) ) {
										echo esc_html( $settings['license-label'] );
									} else {
										esc_html_e( 'License No', RHEA_TEXT_DOMAIN );
									}
									?>
                                </h4>
                                <span><?php echo esc_html( $agent_license_no ); ?></span>
                            </div>
                        </div>
						<?php
					}
					if ( ! empty( $agent_office_phone ) ) {
						?>
                        <div class="agent-contact-item">
							<?php
							if ( is_array( $settings['office-icon'] ) && ! empty( $settings['office-icon']['value'] ) ) {
								$RHEA_Elementor_Icons->generate_elementor_icon( 'office-icon', $settings );
							} else {
								inspiry_safe_include_svg( '/icons/phone.svg' );
							}
							?>
                            <div class="agent-contact-item-inner">
                                <h4 class="agent-contact-item-label">
									<?php
									if ( ! empty( $settings['office-label'] ) ) {
										echo esc_html( $settings['office-label'] );
									} else {
										esc_html_e( 'Office', RHEA_TEXT_DOMAIN );
									}
									?>
                                </h4>
                                <a href="tel:<?php echo esc_attr( str_replace( ' ', '', $agent_office_phone ) ); ?>"><?php echo esc_html( $agent_office_phone ); ?></a>
                            </div>
                        </div>
						<?php
					}
					if ( ! empty( $agent_mobile ) ) {
						?>
                        <div class="agent-contact-item">
							<?php
							if ( is_array( $settings['mobile-icon'] ) && ! empty( $settings['mobile-icon']['value'] ) ) {
								$RHEA_Elementor_Icons->generate_elementor_icon( 'mobile-icon', $settings );
							} else {
								inspiry_safe_include_svg( '/icons/phone.svg' );
							}
							?>
                            <div class="agent-contact-item-inner">
                                <h4 class="agent-contact-item-label">
									<?php
									if ( ! empty( $settings['mobile-label'] ) ) {
										echo esc_html( $settings['mobile-label'] );
									} else {
										esc_html_e( 'Mobile', RHEA_TEXT_DOMAIN );
									}
									?>
                                </h4>
                                <a href="tel:<?php echo esc_attr( str_replace( ' ', '', $agent_mobile ) ); ?>"><?php echo esc_html( $agent_mobile ); ?></a>
                            </div>
                        </div>
						<?php
					}
					if ( ! empty( $agent_whatsapp ) ) {
						?>
                        <div class="agent-contact-item">
							<?php
							if ( is_array( $settings['whatsapp-icon'] ) && ! empty( $settings['whatsapp-icon']['value'] ) ) {
								$RHEA_Elementor_Icons->generate_elementor_icon( 'whatsapp-icon', $settings );
							} else {
								inspiry_safe_include_svg( '/icons/whatsapp.svg' );
							}
							?>
                            <div class="agent-contact-item-inner">
                                <h4 class="agent-contact-item-label">
									<?php
									if ( ! empty( $settings['whatsapp-label'] ) ) {
										echo esc_html( $settings['whatsapp-label'] );
									} else {
										esc_html_e( 'WhatsApp', RHEA_TEXT_DOMAIN );
									}
									?>
                                </h4>
                                <a href="https://wa.me/<?php echo esc_attr( str_replace( ' ', '', $agent_whatsapp ) ); ?>"><?php echo esc_html( $agent_whatsapp ); ?></a>
                            </div>
                        </div>
						<?php
					}
					if ( ! empty( $agent_office_fax ) ) {
						?>
                        <div class="agent-contact-item">
							<?php
							if ( is_array( $settings['fax-icon'] ) && ! empty( $settings['fax-icon']['value'] ) ) {
								$RHEA_Elementor_Icons->generate_elementor_icon( 'fax-icon', $settings );
							} else {
								inspiry_safe_include_svg( '/icons/print.svg' );
							}
							?>
                            <div class="agent-contact-item-inner">
                                <h4 class="agent-contact-item-label">
									<?php
									if ( ! empty( $settings['fax-label'] ) ) {
										echo esc_html( $settings['fax-label'] );
									} else {
										esc_html_e( 'Fax', RHEA_TEXT_DOMAIN );
									}
									?>
                                </h4>
                                <a href="fax:<?php echo esc_attr( str_replace( ' ', '', $agent_office_fax ) ); ?>"><?php echo esc_html( $agent_office_fax ); ?></a>
                            </div>
                        </div>
						<?php
					}
					if ( ! empty( $agent_email ) ) {
						?>
                        <div class="agent-contact-item">
							<?php
							if ( is_array( $settings['email-icon'] ) && ! empty( $settings['email-icon']['value'] ) ) {
								$RHEA_Elementor_Icons->generate_elementor_icon( 'email-icon', $settings );
							} else {
								inspiry_safe_include_svg( '/icons/email.svg' );
							}
							?>
                            <div class="agent-contact-item-inner">
                                <h4 class="agent-contact-item-label">
									<?php
									if ( ! empty( $settings['email-label'] ) ) {
										echo esc_html( $settings['email-label'] );
									} else {
										esc_html_e( 'Email', RHEA_TEXT_DOMAIN );
									}
									?>
                                </h4>
                                <a href="mailto:<?php echo esc_attr( antispambot( $agent_email ) ); ?>"><?php echo esc_html( antispambot( $agent_email ) ); ?></a>
                            </div>
                        </div>
						<?php
					}
					if ( ! empty( $agent_address ) ) {
						?>
                        <div class="agent-contact-item agent-contact-item-address">
							<?php
							if ( is_array( $settings['address-icon'] ) && ! empty( $settings['address-icon']['value'] ) ) {
								$RHEA_Elementor_Icons->generate_elementor_icon( 'address-icon', $settings );
							} else {
								inspiry_safe_include_svg( '/icons/pin-line.svg' );
							}
							?>
                            <div class="agent-contact-item-inner">
                                <h4 class="agent-contact-item-label">
									<?php
									if ( ! empty( $settings['address-label'] ) ) {
										echo esc_html( $settings['address-label'] );
									} else {
										esc_html_e( 'Address', RHEA_TEXT_DOMAIN );
									}
									?>
                                </h4>
                                <span><?php echo inspiry_kses( $agent_address ); ?></span>
                            </div>
                        </div>
						<?php
					}
					?>
                </div>
            </div>
        </div>
		<?php
		if ( 'yes' === $settings['show_description'] ) {
			$agent_content = get_the_content( '', '', $post_id );
			if ( $agent_content ) {
				?>
                <div class="agent-content">
                    <h3 class="agent-content-heading rh-page-heading"><?php echo esc_html( $settings['description_heading'] ) ?></h3>
					<?php echo $agent_content; ?>
                </div>
				<?php
			}
		}

		if ( 'yes' == $settings['show_progress_stats'] && function_exists( 'realhomes_generate_properties_stats_chart' ) ) {
			$stats_break_point   = ! empty( $settings['stats_count_break_point'] ) ? $settings['stats_count_break_point'] : 3;
			$custom_chart_colors = array();
			// Loop through the 10 color options
			for ( $i = 1; $i <= 10; $i++ ) {
				if ( ! empty( $settings[ 'progress_stats_chart_color_' . $i ] ) ) {
					$custom_chart_colors[] = $settings[ 'progress_stats_chart_color_' . $i ];
				}
			}
			?>
            <div class="stats-charts-wrap">
                <h3><?php echo esc_html( $settings['progress_stats_heading'] ); ?></h3>
                <div class="stats-wrapper">
                    <div class="tax-stats property-city">
                        <h3><?php echo preg_replace( '/^(\w+)/isux', '<span>$1</span>', $settings['property_locations_label'] ); ?></h3>
						<?php realhomes_generate_properties_stats_chart( array(
							'post_id'     => $post_id,
							'break_point' => $stats_break_point,
							'colors'      => $custom_chart_colors,
							'post_type'   => $post_type
						) ); ?>
                    </div>
                    <div class="tax-stats property-type">
                        <h3><?php echo preg_replace( '/^(\w+)/isux', '<span>$1</span>', $settings['property_types_label'] ); ?></h3>
						<?php realhomes_generate_properties_stats_chart( array(
							'post_id'       => $post_id,
							'taxonomy_name' => 'property-type',
							'break_point'   => $stats_break_point,
							'colors'        => $custom_chart_colors,
							'post_type'     => $post_type
						) ); ?>
                    </div>
                    <div class="tax-stats property-status">
                        <h3><?php echo preg_replace( '/^(\w+)/isux', '<span>$1</span>', $settings['property_status_label'] ); ?></h3>
						<?php realhomes_generate_properties_stats_chart( array(
							'post_id'       => $post_id,
							'taxonomy_name' => 'property-status',
							'break_point'   => $stats_break_point,
							'colors'        => $custom_chart_colors,
							'post_type'     => $post_type
						) ); ?>
                    </div>
                </div>
            </div>
			<?php
		}
		?>
    </article><!-- /.agent-card -->
	<?php
}
