<?php

namespace OCDI\RealHomes;

/**
 * Helper class for RealHomes demo import.
 *
 * @since 2.1.2
 */
class Helper {

	/**
	 * This function helps to resolve media URLs from options.
	 *
	 * @param $option_value
	 *
	 * @return mixed|string
	 *
	 * @since 2.1.2
	 */
	static function resolve_media_url( $option_value ): mixed {
		$filename = basename( $option_value );

		// Extract month from URL path (handles both multisite and regular WordPress)
		// Matches: /2021/05/ or /sites/11/2021/05/ etc.
		if ( preg_match( '/\/(\d{2})\/[^\/]*$/', $option_value, $matches ) ) {
			$month = $matches[1]; // e.g., "05"

			// Search for attachment by month + filename
			$media = get_posts( array(
				'post_type'   => 'attachment',
				'post_status' => 'inherit',
				'meta_query'  => array(
					array(
						'key'     => '_wp_attached_file',
						'value'   => $month . '/' . $filename,
						'compare' => 'LIKE'
					)
				),
				'numberposts' => 1,
			) );

			if ( ! empty( $media ) && isset( $media[0] ) ) {
				$local_url = wp_get_attachment_url( $media[0]->ID );
				if ( $local_url ) {
					return $local_url;
				}
			}
		}

		// Fallback: search by filename only if month-based search fails
		$media = get_posts( array(
			'post_type'   => 'attachment',
			'post_status' => 'inherit',
			'meta_query'  => array(
				array(
					'key'     => '_wp_attached_file',
					'value'   => $filename,
					'compare' => 'LIKE'
				)
			),
			'numberposts' => 1,
		) );

		if ( ! empty( $media ) && isset( $media[0] ) ) {
			$local_url = wp_get_attachment_url( $media[0]->ID );
			if ( $local_url ) {
				return $local_url;
			}
		}

		return $option_value; // Return original if no match found
	}
}