<?php
/**
 * @link              https://realhomes.io/
 * @since             1.0.0
 * @package           Realhomes_Crm
 *
 * @wordpress-plugin
 * Plugin Name:       RealHomes CRM
 * Plugin URI:        https://themeforest.net/item/real-homes-wordpress-real-estate-theme/5373914
 * Description:       Enhance RealHomes theme with CRM functionality. Effortlessly manage inquiries, capture leads, and track deals to streamline your real estate business.
 * Version:           1.0.1
 * Tested up to:      6.8.3
 * Requires at least: 6.0
 * Requires PHP:      8.3
 * Author:            InspiryThemes
 * Author URI:        https://realhomes.io/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       realhomes-crm
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for the plugin and update it as we release new versions.
 */
define( 'REALHOMES_CRM_VERSION', '1.0.0' );

/**
 * Currently plugin Text Domain.
 */
define( 'REALHOMES_CRM_TEXT_DOMAIN', 'realhomes-crm' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-realhomes-crm-activator.php
 */
function activate_realhomes_crm() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-realhomes-crm-activator.php';
	Realhomes_Crm_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-realhomes-crm-deactivator.php
 */
function deactivate_realhomes_crm() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-realhomes-crm-deactivator.php';
	Realhomes_Crm_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_realhomes_crm' );
register_deactivation_hook( __FILE__, 'deactivate_realhomes_crm' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-realhomes-crm.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_realhomes_crm() {

	$plugin = new Realhomes_Crm();
	$plugin->run();

}

run_realhomes_crm();
