<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://realhomes.io/
 * @since      1.0.0
 *
 * @package    Realhomes_Crm
 * @subpackage Realhomes_Crm/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Realhomes_Crm
 * @subpackage Realhomes_Crm/public
 * @author     InspiryThemes <fahid@inspirythemes.com>
 */
class Realhomes_Crm_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $plugin_name The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $version The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 *
	 * @param string $plugin_name The name of the plugin.
	 * @param string $version     The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version     = $version;
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Realhomes_Crm_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Realhomes_Crm_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/realhomes-crm-public.css', array(), $this->version, 'all' );
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Realhomes_Crm_Loader as all the hooks are defined
		 * in that particular class.
		 *
		 * The Realhomes_Crm_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		$public_dependencies = array( 'jquery' );
		if ( isset( $_GET['submodule'] ) && ( 'crm/deals' === $_GET['submodule'] || 'crm/tasks' === $_GET['submodule'] ) ) {
			$public_dependencies[] = 'jquery-ui-datepicker';
		}

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/realhomes-crm-public.js', $public_dependencies, $this->version, false );

		if ( ( isset( $_GET['submodule'] ) && ( 'crm/deals' === $_GET['submodule'] || 'crm/leads' === $_GET['submodule'] ) ) || ( ! isset( $_GET['submodule'] ) && isset( $_GET['module'] ) && 'properties-crm' === $_GET['module'] ) ) {
			wp_enqueue_script( 'chart.js', plugin_dir_url( __FILE__ ) . 'js/chart.js', array( 'jquery' ), $this->version, false );
		}

		// Localize the public script with the rhCrmData URL
		wp_localize_script( $this->plugin_name, 'rhCrmData', array(
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
			'nonce'   => wp_create_nonce( 'realhomes_crm_ajax_nonce' )
		) );

		// Localize the public script with the translatable strings
		wp_localize_script( $this->plugin_name, 'rhCrmStrings', array(
			'notification' => array(
				'errorLabel'       => esc_html__( 'Error', REALHOMES_CRM_TEXT_DOMAIN ),
				'cancelLabel'      => esc_html__( 'Cancelled', REALHOMES_CRM_TEXT_DOMAIN ),
				'successLabel'     => esc_html__( 'Success', REALHOMES_CRM_TEXT_DOMAIN ),
				'deleteLabel'      => esc_html__( 'Deleted', REALHOMES_CRM_TEXT_DOMAIN ),
				'addedDesc'        => esc_html__( 'The item was added successfully.', REALHOMES_CRM_TEXT_DOMAIN ),
				'deletedDesc'      => esc_html__( 'The item was deleted successfully.', REALHOMES_CRM_TEXT_DOMAIN ),
				'deleteCancelDesc' => esc_html__( 'The {item_type} deletion was cancelled.', REALHOMES_CRM_TEXT_DOMAIN ),
				'errorDesc'        => esc_html__( 'Something went wrong.', REALHOMES_CRM_TEXT_DOMAIN ),
				'emptyNoteDesc'    => esc_html__( 'Please type a note.', REALHOMES_CRM_TEXT_DOMAIN ),
				'csvFile'          => array(
					'deleteCancelDesc'       => esc_html__( 'The file deletion was cancelled.', REALHOMES_CRM_TEXT_DOMAIN ),
					'importFileMissingDesc'  => esc_html__( 'File name is missing. Please check the URL parameter.', REALHOMES_CRM_TEXT_DOMAIN ),
					'uploadFileMissingLabel' => esc_html__( 'You must select a CSV file.', REALHOMES_CRM_TEXT_DOMAIN ),
					'uploadFileMissingDesc'  => esc_html__( 'Please browse and select a CSV file to upload.', REALHOMES_CRM_TEXT_DOMAIN ),
				)
			),
			'confirmation' => array(
				'deleteLabel'     => esc_html__( 'Delete {item_type}', REALHOMES_CRM_TEXT_DOMAIN ),
				'deleteDesc'      => esc_html__( 'Are you sure you want to delete the {item_type}?', REALHOMES_CRM_TEXT_DOMAIN ),
				'deleteBulkLabel' => esc_html__( 'Are you sure you want to delete the selected items?', REALHOMES_CRM_TEXT_DOMAIN ),
				'deleteBulkDesc'  => esc_html__( 'Deleted items will be removed permanently.', REALHOMES_CRM_TEXT_DOMAIN ),
				'csvFile'         => array(
					'deleteFileLabel' => esc_html__( 'Are you sure you want to delete {fileName}?', REALHOMES_CRM_TEXT_DOMAIN ),
					'deleteFileDesc'  => esc_html__( 'Deleted file will be removed permanently.', REALHOMES_CRM_TEXT_DOMAIN ),
				)
			)
		) );
	}

}
