<?php

namespace RealHomes\CRM\Helpers;

class Drawer_Helper {

	public static function header( string $action, ?object $item, string $type, string $custom_heading = '' ): void {
		// Capitalize first letter for display
		$type_label = ucfirst( $type );
		?>
		<div class="flex h-full flex-col overflow-y-scroll py-6 shadow-xl">

		<div class="px-4 sm:px-6">
			<div class="flex items-start justify-between border-b">
				<!-- Drawer heading -->
				<h2 class="text-md">
					<?php
					if ( ! empty( $custom_heading ) ) :
						echo $custom_heading;
					elseif ( 'edit' === $action ) :
						echo match ( $type ) {
							'lead'                    => esc_html__( "Edit", REALHOMES_CRM_TEXT_DOMAIN ) . " " . esc_html( ! empty( $item->display_name ) ? explode( ' ', $item->display_name )[0] : $item->first_name ) . "'s " . esc_html__( $type_label, REALHOMES_CRM_TEXT_DOMAIN ),
							'inquiry', 'deal', 'task' => esc_html__( "Edit", REALHOMES_CRM_TEXT_DOMAIN ) . " '" . esc_html( wp_trim_words( $item->title, 6 ) ) . "' " . esc_html__( $type_label, REALHOMES_CRM_TEXT_DOMAIN ),
							default                   => esc_html__( "Edit", REALHOMES_CRM_TEXT_DOMAIN ) . ' ' . esc_html__( $type_label, REALHOMES_CRM_TEXT_DOMAIN ),
						};
					else :
						if ( 'view' === $action ):
							echo match ( $type ) {
								'lead'                    => esc_html( ! empty( $item->display_name ) ? explode( ' ', $item->display_name )[0] : $item->first_name ) . "<span class='text-gray-500'>" . esc_html__( "'s Lead Preview", REALHOMES_CRM_TEXT_DOMAIN ) . "</span>",
								'inquiry', 'deal', 'task' => esc_html( wp_trim_words( $item->title, 6 ) ) . " <span class='text-gray-500'>" . esc_html__( $type_label, REALHOMES_CRM_TEXT_DOMAIN ) . ' ' . esc_html__( "Preview", REALHOMES_CRM_TEXT_DOMAIN ) . "</span>",
								default                   => esc_html__( "Preview", REALHOMES_CRM_TEXT_DOMAIN ) . ' ' . esc_html__( $type_label, REALHOMES_CRM_TEXT_DOMAIN ),
							};
						else:
							echo esc_html__( "Add New", REALHOMES_CRM_TEXT_DOMAIN ) . ' ' . esc_html__( $type_label, REALHOMES_CRM_TEXT_DOMAIN );
						endif;
					endif; ?>
				</h2>

				<!-- Drawer close button -->
				<div class="ml-3 flex h-7 items-center">
					<button type="button" class="rh-crm-close-drawer relative rounded-md bg-white text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-[var(--dashboard-primary-color)] focus:ring-offset-2">
						<span class="absolute -inset-2.5"></span>
						<?php
						\Realhomes_Crm_SVG::the_svg( 'cross', 'size-8' );
						?>
					</button>
				</div>
			</div>
		</div>

		<?php
		if ( 'add' === $action || 'edit' === $action ):?>
			<div class="relative flex-1 px-4 sm:p-8 text-gray-200"><form id="rh-crm-item-add-update-form" method="POST">
		<?php
		endif;
	}


	public static function footer( string $action, ?object $item = null, string $type = '' ): void {
		$uc_type = ucfirst( $type );
		if ( 'edit' === $action || 'add' === $action ) {
			$is_edit = ( 'edit' === $action );
			$action  = $is_edit ? 'update' : 'add';
			?>


			<input type="hidden" name="item_type" value="<?php
			echo esc_attr( $type ); ?>" /><input type="hidden" name="action_type" value="<?php
			echo esc_attr( $action ); ?>" />

			<?php
			if ( $is_edit ): ?>
				<input type="hidden" name="item_id" value="<?php
				echo esc_attr( $item->id ); ?>" />
			<?php
			endif; ?>

			<button type="submit" name="action_type" value="<?php
			echo esc_attr( $action ); ?>" class="rh-crm-btn-primary w-auto">
				<?php
				\Realhomes_Crm_SVG::the_svg( 'loader', 'size-5 mr-2 hidden' );
				echo $is_edit
					? esc_html__( 'Update ' . $uc_type, REALHOMES_CRM_TEXT_DOMAIN )
					: esc_html__( 'Add ' . $uc_type, REALHOMES_CRM_TEXT_DOMAIN );
				?>
			</button></form></div>
			<?php
		}
		?>
		</div>
		<?php
	}
}