<?php

class Realhomes_Crm_SVG {
	// Define SVGs in an associative array
	private static $svgs = [
		'checkbox_tick' => '<svg class="pointer-events-none col-start-1 row-start-1 self-center justify-self-center stroke-white group-has-[:disabled]:stroke-gray-950/25 {{classes}}" viewBox="0 0 14 14" fill="none">
                                <path class="opacity-0 group-has-[:checked]:opacity-100" d="M3 8L6 11L11 3.5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                <path class="opacity-0 group-has-[:indeterminate]:opacity-100" d="M3 7H11" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>',
		'cross'         => '<svg class="{{classes}}" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
								<path d="M6.28 5.22a.75.75 0 0 0-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 1 0 1.06 1.06L10 11.06l3.72 3.72a.75.75 0 1 0 1.06-1.06L11.06 10l3.72-3.72a.75.75 0 0 0-1.06-1.06L10 8.94 6.28 5.22Z" />
							</svg>',
		'close'         => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon">
		                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12" />
		                    </svg>',
		'clock'         => '<svg class="{{classes}}" viewBox="0 0 24 24" data-name="Layer 1" id="Layer_1">
		                        <g stroke-width="0"></g>
		                        <g stroke-linecap="round" stroke-linejoin="round"></g>
		                        <g>
		                            <path d="M12,13.41,13.41,12,8.46,7.05,7.05,8.46Zm7.07-8.48A9.93,9.93,0,0,0,12,2H11V6h2V4.06A8,8,0,1,1,6.34,6.34l.71-.7L5.64,4.22l-.71.71A10,10,0,1,0,19.07,19.07a10,10,0,0,0,0-14.14Z"></path>
		                        </g>
		                    </svg>',
		'delete'        => '<svg class="mr-2 text-red-400 {{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
			                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 13h6m2 9H7a2 2 0 0 1-2-2V7h14v11a2 2 0 0 1-2 2zM10 3h4a1 1 0 0 1 1 1v1H9V4a1 1 0 0 1 1-1z" />
			                 </svg>',
		'chevron'       => '<svg class="pointer-events-none col-start-1 row-start-1 mr-4 self-center justify-self-end text-gray-500 {{classes}}" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true" data-slot="icon">
                                <path fill-rule="evenodd" d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z" clip-rule="evenodd" />
                            </svg>',
		'stage'         => '<svg class="{{classes}}" viewBox="0 0 16 16" fill="none"></g>
		                        <g stroke-linecap="round" stroke-linejoin="round"></g>
		                        <g>
		                            <path fill="#000000" fill-rule="evenodd" d="M14.1026,4.43011 C14.6139,4.22135 15.1977,4.46661 15.4064,4.97792 C17.0765,9.06841 15.1143,13.7383 11.0239,15.4083 C8.66289,16.3723 6.10818,16.1252 4.05194,14.9602 C3.57143,14.6879 3.40261,14.0776 3.67487,13.5971 C3.94713,13.1166 4.55737,12.9478 5.03789,13.2201 C6.58414,14.0962 8.49796,14.2793 10.2679,13.5567 C13.3357,12.3042 14.8073,8.80177 13.5548,5.73391 C13.346,5.2226 13.5913,4.63886 14.1026,4.43011 Z M2.19544,9.52389 C2.26141,9.77396 2.3444,10.023 2.44513,10.2698 C2.54587,10.5165 2.66092,10.7525 2.78882,10.9773 C3.06197,11.4573 2.89426,12.0678 2.41425,12.341 C1.93424,12.6141 1.32368,12.4464 1.05054,11.9664 C0.879967,11.6666 0.727034,11.3528 0.593515,11.0257 C0.459996,10.6987 0.349566,10.3675 0.261594,10.034 C0.120724,9.50001 0.439434,8.9529 0.973451,8.81203 C1.50747,8.67116 2.05457,8.98987 2.19544,9.52389 Z M2.45915,3.60703 C2.93624,3.88526 3.09744,4.49756 2.81922,4.97464 C2.55491,5.42786 2.35056,5.91419 2.21184,6.42018 C2.06582,6.95281 1.51566,7.26622 0.983026,7.12019 C0.450396,6.97416 0.136992,6.424 0.283019,5.89137 C0.467702,5.21774 0.739666,4.57047 1.09154,3.96709 C1.36977,3.49001 1.98207,3.3288 2.45915,3.60703 Z M10.1104,0.28485 C10.7841,0.469533 11.4313,0.741497 12.0347,1.09338 C12.5118,1.3716 12.673,1.9839 12.3948,2.46098 C12.1166,2.93807 11.5043,3.09927 11.0272,2.82105 C10.574,2.55674 10.0876,2.3524 9.58163,2.21367 C9.049,2.06765 8.7356,1.51749 8.88162,0.984857 C9.02765,0.452227 9.57781,0.138823 10.1104,0.28485 Z M7.18978,0.975282 C7.33065,1.5093 7.01194,2.0564 6.47792,2.19727 C6.22785,2.26324 5.97878,2.34623 5.73205,2.44696 C5.48531,2.5477 5.24933,2.66275 5.02455,2.79066 C4.54454,3.0638 3.93398,2.89609 3.66084,2.41608 C3.3877,1.93607 3.55541,1.32551 4.03542,1.05237 C4.33519,0.881798 4.64904,0.728865 4.97607,0.595346 C5.30309,0.461827 5.6343,0.351397 5.96779,0.263425 C6.50181,0.122556 7.04891,0.441265 7.18978,0.975282 Z"></path>
		                        </g>
		                    </svg>',
		'user'          => '<svg class="{{classes}}" viewBox="0 0 24 24" fill="none">
		                        <g stroke-width="0"></g>
		                        <g stroke-linecap="round" stroke-linejoin="round"></g>
		                        <g>
		                            <circle cx="12" cy="9" r="3" stroke="#1C274C" stroke-width="1.5"></circle>
		                            <path d="M17.9691 20C17.81 17.1085 16.9247 15 11.9999 15C7.07521 15 6.18991 17.1085 6.03076 20" stroke="#1C274C" stroke-width="1.5" stroke-linecap="round"></path>
		                            <path d="M7 3.33782C8.47087 2.48697 10.1786 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 10.1786 2.48697 8.47087 3.33782 7" stroke="#1C274C" stroke-width="1.5" stroke-linecap="round"></path>
		                        </g>
		                    </svg>',
		'email'         => '<svg class="text-gray-500 {{classes}}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
	                            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.75 5.25L3 6V18L3.75 18.75H20.25L21 18V6L20.25 5.25H3.75ZM4.5 7.6955V17.25H19.5V7.69525L11.9999 14.5136L4.5 7.6955ZM18.3099 6.75H5.68986L11.9999 12.4864L18.3099 6.75Z" />
	                        </svg>',
		'mobile'        => '<svg class="text-gray-700 fill-gray-500 {{classes}}" viewBox="0 0 24 24" fill="none">
	                            <g stroke-width="0"></g>
	                            <g stroke-linecap="round" stroke-linejoin="round"></g>
	                            <g>
	                                <path d="M16.1007 13.359L15.5719 12.8272H15.5719L16.1007 13.359ZM16.5562 12.9062L17.085 13.438H17.085L16.5562 12.9062ZM18.9728 12.5894L18.6146 13.2483L18.9728 12.5894ZM20.8833 13.628L20.5251 14.2869L20.8833 13.628ZM21.4217 16.883L21.9505 17.4148L21.4217 16.883ZM20.0011 18.2954L19.4723 17.7636L20.0011 18.2954ZM18.6763 18.9651L18.7459 19.7119H18.7459L18.6763 18.9651ZM8.81536 14.7266L9.34418 14.1947L8.81536 14.7266ZM4.00289 5.74561L3.2541 5.78816L3.2541 5.78816L4.00289 5.74561ZM10.4775 7.19738L11.0063 7.72922H11.0063L10.4775 7.19738ZM10.6342 4.54348L11.2346 4.09401L10.6342 4.54348ZM9.37326 2.85908L8.77286 3.30855V3.30855L9.37326 2.85908ZM6.26145 2.57483L6.79027 3.10667H6.79027L6.26145 2.57483ZM4.69185 4.13552L4.16303 3.60368H4.16303L4.69185 4.13552ZM12.0631 11.4972L12.5919 10.9654L12.0631 11.4972ZM16.6295 13.8909L17.085 13.438L16.0273 12.3743L15.5719 12.8272L16.6295 13.8909ZM18.6146 13.2483L20.5251 14.2869L21.2415 12.9691L19.331 11.9305L18.6146 13.2483ZM20.8929 16.3511L19.4723 17.7636L20.5299 18.8273L21.9505 17.4148L20.8929 16.3511ZM18.6067 18.2184C17.1568 18.3535 13.4056 18.2331 9.34418 14.1947L8.28654 15.2584C12.7186 19.6653 16.9369 19.8805 18.7459 19.7119L18.6067 18.2184ZM9.34418 14.1947C5.4728 10.3453 4.83151 7.10765 4.75168 5.70305L3.2541 5.78816C3.35456 7.55599 4.14863 11.144 8.28654 15.2584L9.34418 14.1947ZM10.7195 8.01441L11.0063 7.72922L9.9487 6.66555L9.66189 6.95073L10.7195 8.01441ZM11.2346 4.09401L9.97365 2.40961L8.77286 3.30855L10.0338 4.99296L11.2346 4.09401ZM5.73263 2.04299L4.16303 3.60368L5.22067 4.66736L6.79027 3.10667L5.73263 2.04299ZM10.1907 7.48257C9.66189 6.95073 9.66117 6.95144 9.66045 6.95216C9.66021 6.9524 9.65949 6.95313 9.659 6.95362C9.65802 6.95461 9.65702 6.95561 9.65601 6.95664C9.65398 6.95871 9.65188 6.96086 9.64972 6.9631C9.64539 6.96759 9.64081 6.97245 9.63599 6.97769C9.62634 6.98816 9.61575 7.00014 9.60441 7.01367C9.58174 7.04072 9.55605 7.07403 9.52905 7.11388C9.47492 7.19377 9.41594 7.2994 9.36589 7.43224C9.26376 7.70329 9.20901 8.0606 9.27765 8.50305C9.41189 9.36833 10.0078 10.5113 11.5343 12.0291L12.5919 10.9654C11.1634 9.54499 10.8231 8.68059 10.7599 8.27309C10.7298 8.07916 10.761 7.98371 10.7696 7.96111C10.7748 7.94713 10.7773 7.9457 10.7709 7.95525C10.7677 7.95992 10.7624 7.96723 10.7541 7.97708C10.75 7.98201 10.7451 7.98759 10.7394 7.99381C10.7365 7.99692 10.7335 8.00019 10.7301 8.00362C10.7285 8.00534 10.7268 8.00709 10.725 8.00889C10.7241 8.00979 10.7232 8.0107 10.7223 8.01162C10.7219 8.01208 10.7212 8.01278 10.7209 8.01301C10.7202 8.01371 10.7195 8.01441 10.1907 7.48257ZM11.5343 12.0291C13.0613 13.5474 14.2096 14.1383 15.0763 14.2713C15.5192 14.3392 15.8763 14.285 16.1472 14.1841C16.28 14.1346 16.3858 14.0763 16.4658 14.0227C16.5058 13.9959 16.5392 13.9704 16.5663 13.9479C16.5799 13.9367 16.5919 13.9262 16.6024 13.9166C16.6077 13.9118 16.6126 13.9073 16.6171 13.903C16.6194 13.9008 16.6215 13.8987 16.6236 13.8967C16.6246 13.8957 16.6256 13.8947 16.6266 13.8937C16.6271 13.8932 16.6279 13.8925 16.6281 13.8923C16.6288 13.8916 16.6295 13.8909 16.1007 13.359C15.5719 12.8272 15.5726 12.8265 15.5733 12.8258C15.5735 12.8256 15.5742 12.8249 15.5747 12.8244C15.5756 12.8235 15.5765 12.8226 15.5774 12.8217C15.5793 12.82 15.581 12.8183 15.5827 12.8166C15.5862 12.8133 15.5895 12.8103 15.5926 12.8074C15.5988 12.8018 15.6044 12.7969 15.6094 12.7929C15.6192 12.7847 15.6265 12.7795 15.631 12.7764C15.6403 12.7702 15.6384 12.773 15.6236 12.7785C15.5991 12.7876 15.501 12.8189 15.3038 12.7886C14.8905 12.7253 14.02 12.3853 12.5919 10.9654L11.5343 12.0291ZM9.97365 2.40961C8.95434 1.04802 6.94996 0.83257 5.73263 2.04299L6.79027 3.10667C7.32195 2.578 8.26623 2.63181 8.77286 3.30855L9.97365 2.40961ZM4.75168 5.70305C4.73201 5.35694 4.89075 4.9954 5.22067 4.66736L4.16303 3.60368C3.62571 4.13795 3.20329 4.89425 3.2541 5.78816L4.75168 5.70305ZM19.4723 17.7636C19.1975 18.0369 18.9029 18.1908 18.6067 18.2184L18.7459 19.7119C19.4805 19.6434 20.0824 19.2723 20.5299 18.8273L19.4723 17.7636ZM11.0063 7.72922C11.9908 6.7503 12.064 5.2019 11.2346 4.09401L10.0338 4.99295C10.4373 5.53193 10.3773 6.23938 9.9487 6.66555L11.0063 7.72922ZM20.5251 14.2869C21.3429 14.7315 21.4703 15.7769 20.8929 16.3511L21.9505 17.4148C23.2908 16.0821 22.8775 13.8584 21.2415 12.9691L20.5251 14.2869ZM17.085 13.438C17.469 13.0562 18.0871 12.9616 18.6146 13.2483L19.331 11.9305C18.2474 11.3414 16.9026 11.5041 16.0273 12.3743L17.085 13.438Z"></path>
	                            </g>
	                        </svg>',
		'paper-plane'   => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
		                        <path stroke-linecap="round" stroke-linejoin="round" d="M3.5 10.5l17-7-7 17-3-6-7-4z" />
		                    </svg>',
		'upload'        => '<svg class="{{classes}}" viewBox="0 0 24 24" fill="none">
			                    <g stroke-width="0"></g>
			                    <g stroke-linecap="round" stroke-linejoin="round"></g>
			                    <g>
			                        <path fill-rule="evenodd" clip-rule="evenodd" d="M8 10C8 7.79086 9.79086 6 12 6C14.2091 6 16 7.79086 16 10V11H17C18.933 11 20.5 12.567 20.5 14.5C20.5 16.433 18.933 18 17 18H16C15.4477 18 15 18.4477 15 19C15 19.5523 15.4477 20 16 20H17C20.0376 20 22.5 17.5376 22.5 14.5C22.5 11.7793 20.5245 9.51997 17.9296 9.07824C17.4862 6.20213 15.0003 4 12 4C8.99974 4 6.51381 6.20213 6.07036 9.07824C3.47551 9.51997 1.5 11.7793 1.5 14.5C1.5 17.5376 3.96243 20 7 20H8C8.55228 20 9 19.5523 9 19C9 18.4477 8.55228 18 8 18H7C5.067 18 3.5 16.433 3.5 14.5C3.5 12.567 5.067 11 7 11H8V10ZM15.7071 13.2929L12.7071 10.2929C12.3166 9.90237 11.6834 9.90237 11.2929 10.2929L8.29289 13.2929C7.90237 13.6834 7.90237 14.3166 8.29289 14.7071C8.68342 15.0976 9.31658 15.0976 9.70711 14.7071L11 13.4142V19C11 19.5523 11.4477 20 12 20C12.5523 20 13 19.5523 13 19V13.4142L14.2929 14.7071C14.6834 15.0976 15.3166 15.0976 15.7071 14.7071C16.0976 14.3166 16.0976 13.6834 15.7071 13.2929Z" fill="currentColor"></path>
			                    </g>
			                </svg>',
		'file'          => '<svg class="{{classes}}" viewBox="-4 0 64 64" fill="#000000">
		                        <g stroke-width="0"></g>
		                        <g stroke-linecap="round" stroke-linejoin="round"></g>
		                        <g>
		                            <path d="M5.106 0c-2.802 0-5.073 2.272-5.073 5.074v53.841c0 2.803 2.271 5.074 5.073 5.074h45.774c2.801 0 5.074-2.271 5.074-5.074v-38.605l-18.903-20.31h-31.945z" fill-rule="evenodd" clip-rule="evenodd" fill="#45B058"></path>
		                            <path d="M20.306 43.197c.126.144.198.324.198.522 0 .378-.306.72-.703.72-.18 0-.378-.072-.504-.234-.702-.846-1.891-1.387-3.007-1.387-2.629 0-4.627 2.017-4.627 4.88 0 2.845 1.999 4.879 4.627 4.879 1.134 0 2.25-.486 3.007-1.369.125-.144.324-.233.504-.233.415 0 .703.359.703.738 0 .18-.072.36-.198.504-.937.972-2.215 1.693-4.015 1.693-3.457 0-6.176-2.521-6.176-6.212s2.719-6.212 6.176-6.212c1.8.001 3.096.721 4.015 1.711zm6.802 10.714c-1.782 0-3.187-.594-4.213-1.495-.162-.144-.234-.342-.234-.54 0-.361.27-.757.702-.757.144 0 .306.036.432.144.828.739 1.98 1.314 3.367 1.314 2.143 0 2.827-1.152 2.827-2.071 0-3.097-7.112-1.386-7.112-5.672 0-1.98 1.764-3.331 4.123-3.331 1.548 0 2.881.467 3.853 1.278.162.144.252.342.252.54 0 .36-.306.72-.703.72-.144 0-.306-.054-.432-.162-.882-.72-1.98-1.044-3.079-1.044-1.44 0-2.467.774-2.467 1.909 0 2.701 7.112 1.152 7.112 5.636.001 1.748-1.187 3.531-4.428 3.531zm16.994-11.254l-4.159 10.335c-.198.486-.685.81-1.188.81h-.036c-.522 0-1.008-.324-1.207-.81l-4.142-10.335c-.036-.09-.054-.18-.054-.288 0-.36.323-.793.81-.793.306 0 .594.18.72.486l3.889 9.992 3.889-9.992c.108-.288.396-.486.72-.486.468 0 .81.378.81.793.001.09-.017.198-.052.288z" fill="#ffffff"></path>
		                            <g fill-rule="evenodd" clip-rule="evenodd">
		                                <path d="M56.001 20.357v1h-12.8s-6.312-1.26-6.128-6.707c0 0 .208 5.707 6.003 5.707h12.925z" fill="#349C42"></path>
		                                <path d="M37.098.006v14.561c0 1.656 1.104 5.791 6.104 5.791h12.8l-18.904-20.352z" opacity=".5" fill="#ffffff"></path>
		                            </g>
		                        </g>
		                    </svg>',
		'fields'        => '<svg class="{{classes}}" viewBox="0 0 16 16" fill="#45b058">
	                            <g stroke-width="0"></g>
	                            <g stroke-linecap="round" stroke-linejoin="round"></g>
	                            <g>
	                                <path fill="#45b058" d="M15 2v2h-9v-2h9zM16 1h-11v4h11v-4z"></path>
	                                <path fill="#45b058" d="M0 1h4v4h-4v-4z"></path>
	                                <path fill="#45b058" d="M15 7v2h-9v-2h9zM16 6h-11v4h11v-4z"></path>
	                                <path fill="#45b058" d="M0 6h4v4h-4v-4z"></path>
	                                <path fill="#45b058" d="M15 12v2h-9v-2h9zM16 11h-11v4h11v-4z"></path>
	                                <path fill="#45b058" d="M0 11h4v4h-4v-4z"></path>
	                            </g>
	                        </svg>',
		'import'        => '<svg class="{{classes}}" viewBox="0 0 1920 1920"><g stroke-width="0"></g><g stroke-linecap="round" stroke-linejoin="round"></g><g> <path d="m807.186 686.592 272.864 272.864H0v112.94h1080.05l-272.864 272.978 79.736 79.849 409.296-409.183-409.296-409.184-79.736 79.736ZM1870.419 434.69l-329.221-329.11C1509.688 74.07 1465.979 56 1421.48 56H451.773v730.612h112.94V168.941h790.584v451.762h451.762v1129.405H564.714v-508.233h-112.94v621.173H1920V554.52c0-45.176-17.619-87.754-49.58-119.83Zm-402.181-242.37 315.443 315.442h-315.443V192.319Z" fill-rule="evenodd"></path> </g></svg>',
		'export'        => '<svg class="{{classes}}" fill="currentColor" viewBox="0 0 1920 1920">
		                        <g stroke-width="0"></g>
		                        <g stroke-linecap="round" stroke-linejoin="round"></g>
		                        <g>
		                            <path d="m0 1016.081 409.186 409.073 79.85-79.736-272.867-272.979h1136.415V959.611H216.169l272.866-272.866-79.85-79.85L0 1016.082ZM1465.592 305.32l315.445 315.445h-315.445V305.32Zm402.184 242.372-329.224-329.11C1507.042 187.07 1463.334 169 1418.835 169h-743.83v677.647h112.94V281.941h564.706v451.765h451.765v903.53H787.946V1185.47H675.003v564.705h1242.353V667.522c0-44.498-18.07-88.207-49.581-119.83Z" fill-rule="evenodd"></path>
		                        </g>
		                    </svg>',
		'menu-dots'     => '<svg class="{{classes}}" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon">
                                <path d="M10 3a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM10 8.5a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM11.5 15.5a1.5 1.5 0 1 0-3 0 1.5 1.5 0 0 0 3 0Z" />
                            </svg>',
		'view'          => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
	                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.5c4.142 0 7.5 3.358 7.5 7.5s-3.358 7.5-7.5 7.5-7.5-3.358-7.5-7.5S7.858 4.5 12 4.5zM12 9a3 3 0 1 0 0 6 3 3 0 0 0 0-6z" />
	                        </svg>',
		'edit'          => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
	                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.232 5.232l3.536 3.536m-2.121-6.364a1.5 1.5 0 0 1 2.121 2.121l-10.607 10.607-4.243 1.414 1.414-4.243L16.95 3.05z" />
	                        </svg>',
		'warning'       => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v4m0 4h.01M10.29 3.86L2.82 19.14a1.5 1.5 0 0 0 1.3 2.36h16.76a1.5 1.5 0 0 0 1.3-2.36L13.71 3.86a1.5 1.5 0 0 0-2.42 0Z" />
                            </svg>',
		'info'          => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
	                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 17v-4m0-4h.01M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
	                        </svg>',
		'error'         => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg>',
		'success'       => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
	                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
	                        </svg>',
		'broken_page'   => '<svg class="{{classes}}" fill="currentColor" version="1.1" viewBox="0 0 512 512" xml:space="preserve"><g stroke-width="0"></g>
		                        <g stroke-linecap="round" stroke-linejoin="round"></g>
		                        <g>
		                            <g>
		                                <g>
		                                    <path d="M362.087,164.017H149.915c-6.62,0-11.988,5.367-11.988,11.988c0,6.621,5.367,11.988,11.988,11.988h212.172 c6.621,0,11.988-5.368,11.988-11.988C374.075,169.384,368.708,164.017,362.087,164.017z"></path>
		                                </g>
		                            </g>
		                            <g>
		                                <g>
		                                    <path d="M362.087,236.355H149.915c-6.62,0-11.988,5.368-11.988,11.988c0,6.621,5.367,11.988,11.988,11.988h212.172 c6.621,0,11.988-5.368,11.988-11.988S368.708,236.355,362.087,236.355z"></path>
		                                </g>
		                            </g>
		                            <g>
		                                <g>
		                                    <path d="M447.937,103.439c-0.082-3.008-1.276-5.944-3.489-8.158l-91.69-91.69c-2.176-2.214-5.2-3.592-8.55-3.592H89.285 c-13.92,0-25.247,11.325-25.247,25.248l0.005,299.353c0,0.106,0.013,0.207,0.016,0.313c0.164,6.065,3.303,11.562,8.484,14.779 l41.352,25.667c13.649,8.469,30.605,8.469,44.252-0.001l28.381-17.614c5.849-3.631,13.116-3.63,18.965-0.001l28.381,17.615 c6.824,4.237,14.474,6.355,22.126,6.354c7.651,0,15.304-2.118,22.126-6.354l28.381-17.615c5.849-3.629,13.116-3.629,18.965,0 l28.381,17.615c13.645,8.472,30.6,8.472,44.252,0l41.355-25.667c5.179-3.215,8.317-8.713,8.482-14.777 c0.002-0.104,0.016-0.207,0.016-0.313l0.005-220.845C447.964,103.64,447.946,103.543,447.937,103.439z M356.193,40.935h0.001 l50.834,50.834h-49.573c-0.695,0-1.262-0.567-1.262-1.262V40.935z M423.983,321.08l-38.52,23.908 c-5.849,3.631-13.116,3.63-18.965,0.001l-28.381-17.616c-13.649-8.469-30.605-8.468-44.252,0.001l-28.381,17.615 c-5.849,3.629-13.116,3.629-18.965,0l-28.381-17.615c-13.646-8.472-30.602-8.472-44.252,0l-28.381,17.615 c-5.849,3.629-13.116,3.629-18.965,0l-38.52-23.909L88.014,25.248c0-0.701,0.571-1.272,1.271-1.272h242.933v66.532 c0,13.916,11.321,25.238,25.238,25.238h66.532L423.983,321.08z"></path>
		                                </g>
		                            </g>
		                            <g>
		                                <g>
		                                    <path d="M447.958,395.948c0.001-0.031-0.004-0.061-0.004-0.092s0.005-0.061,0.005-0.092c0-6.521-3.541-12.544-9.242-15.714 c-5.7-3.168-12.682-3.003-18.223,0.436l-35.44,21.994c-5.598,3.473-12.554,3.473-18.15,0.001l-29.197-18.121 c-13.397-8.317-30.042-8.317-43.437,0l-29.197,18.12c-5.598,3.473-12.553,3.473-18.151,0.001l-29.197-18.121 c-13.396-8.315-30.042-8.315-43.437,0l-29.195,18.12c-5.598,3.473-12.554,3.474-18.15,0l-35.439-21.994 c-5.541-3.438-12.523-3.608-18.224-0.436c-5.7,3.171-9.242,9.192-9.242,15.714c0,0.031,0.005,0.061,0.005,0.092 c0,0.031-0.005,0.061-0.005,0.092l-0.005,90.804c0,13.922,11.325,25.248,25.247,25.248h333.434 c13.92,0,25.247-11.325,25.247-25.249L447.958,395.948z M422.717,488.024H89.285c-0.7,0-1.271-0.571-1.271-1.271l0.004-80.215 l26.285,16.314c13.398,8.312,30.042,8.312,43.436-0.001l29.195-18.121c5.597-3.474,12.551-3.473,18.151,0l29.195,18.122 c6.699,4.156,14.209,6.235,21.719,6.235c7.509,0,15.02-2.079,21.719-6.236l29.195-18.121c5.597-3.474,12.551-3.475,18.151,0 l29.197,18.122c13.4,8.314,30.042,8.312,43.436,0l26.285-16.314l0.004,80.214C423.988,487.453,423.418,488.024,422.717,488.024z"></path>
		                                </g>
		                            </g>
		                        </g>
		                    </svg>',
		'plus'          => '<svg class="{{classes}}" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
	                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
	                        </svg>',
		'previous'      => '<svg class="{{classes}}" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon">
	                            <path fill-rule="evenodd" d="M11.78 5.22a.75.75 0 0 1 0 1.06L8.06 10l3.72 3.72a.75.75 0 1 1-1.06 1.06l-4.25-4.25a.75.75 0 0 1 0-1.06l4.25-4.25a.75.75 0 0 1 1.06 0Z" clip-rule="evenodd" />
	                        </svg>',
		'next'          => '<svg class="{{classes}}" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon">
	                            <path fill-rule="evenodd" d="M8.22 5.22a.75.75 0 0 1 1.06 0l4.25 4.25a.75.75 0 0 1 0 1.06l-4.25 4.25a.75.75 0 0 1-1.06-1.06L11.94 10 8.22 6.28a.75.75 0 0 1 0-1.06Z" clip-rule="evenodd" />
	                        </svg>',
		'search'        => '<svg class="{{classes}}" viewBox="0 0 24 24" fill="currentColor">
		                        <path fill-rule="evenodd" d="M10.5 3.75a6.75 6.75 0 1 0 0 13.5 6.75 6.75 0 0 0 0-13.5ZM2.25 10.5a8.25 8.25 0 1 1 14.59 5.28l4.69 4.69a.75.75 0 1 1-1.06 1.06l-4.69-4.69A8.25 8.25 0 0 1 2.25 10.5Z" clip-rule="evenodd" />
		                    </svg>',
		'loader'        => '<svg class="rh-crm-loader text-white animate-spin fill-slate-700 {{classes}}" viewBox="0 0 100 101" fill="none">
								<path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/><path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
		                    </svg>',
		'document'      => '<svg class="{{classes}}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
							    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
							    <polyline points="14 2 14 8 20 8"></polyline>
							    <line x1="16" y1="13" x2="8" y2="13"></line>
							    <line x1="16" y1="17" x2="8" y2="17"></line>
							    <polyline points="10 9 9 9 8 9"></polyline>
							</svg>',
		'flag'          => '<svg class="{{classes}}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
						    <path d="M4 15s1-1 4-1 5 2 8 2 4-1 4-1V3s-1 1-4 1-5-2-8-2-4 1-4 1z"></path>
						    <line x1="4" y1="22" x2="4" y1="15"></line>
						</svg>',
		'calendar'      => '<svg class="{{classes}}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
						    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
						    <line x1="16" y1="2" x2="16" y2="6"></line>
						    <line x1="8" y1="2" x2="8" y2="6"></line>
						    <line x1="3" y1="10" x2="21" y2="10"></line>
						</svg>',
		'last_updated'  => '<svg class="{{classes}}" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
							    <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"></path>
							    <path d="M21 3v5h-5"></path>
							    <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"></path>
							    <path d="M8 16H3v5"></path>
							</svg>',
		'star'          => '<svg class="{{classes}}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
								<path d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z" />
							</svg>'
	];

	/**
	 * Get the SVG by name.
	 *
	 * @param string $name    The name of the SVG.
	 * @param string $classes Additional CSS classes to add to the SVG.
	 *
	 * @return string         The SVG markup or an empty string if not found.
	 */
	public static function get_svg( $name, $classes = '' ) {
		if ( isset( self::$svgs[ $name ] ) ) {
			return str_replace( '{{classes}}', esc_attr( $classes ), self::$svgs[ $name ] );
		}

		return ''; // Return empty string if SVG not found
	}

	/**
	 * Display the SVG by name (echo the result).
	 *
	 * @param string $name    The name of the SVG.
	 * @param string $classes Additional CSS classes to add to the SVG.
	 */
	public static function the_svg( $name, $classes = '' ) {
		echo self::get_svg( $name, $classes );
	}
}
