<?php

/**
 * The file that defines the forms data collector actions class.
 *
 * @link       https://realhomes.io/
 * @since      1.0.0
 *
 * @package    Realhomes_Crm
 * @subpackage Realhomes_Crm/includes
 */

/**
 * The data collector class.
 *
 * This is used to define on which forms hooks data will be collected and then
 * trigger the callback function.
 *
 * @since      1.0.0
 * @package    Realhomes_Crm
 * @subpackage Realhomes_Crm/includes
 * @author     InspiryThemes <fahid@inspirythemes.com>
 */
class Realhomes_Crm_Data_Collector {

	/**
	 * Leads class object.
	 *
	 * @var Realhomes_Crm_Leads
	 */
	private $lead;

	/**
	 * Inquiries class object.
	 *
	 * @var Realhomes_Crm_Inquiries
	 */
	private $inquiry;

	/**
	 * Activities class object.
	 *
	 * @var Realhomes_Crm_Activities
	 */
	private $activity;

	public function __construct() {
		$this->lead     = new Realhomes_Crm_Leads();
		$this->inquiry  = new Realhomes_Crm_Inquiries();
		$this->activity = new Realhomes_Crm_Activities();

		add_action( 'ere_after_contact_form_submission', array( $this, 'collect_form_data' ) ); // Contact page contact forms
		add_action( 'ere_after_agent_agency_form_submission', array( $this, 'collect_form_data' ) ); // Agent & Agencies pages contact forms
		add_action( 'ere_after_cfos_submission', array( $this, 'collect_form_data' ) );  // Contact form over image slider forms
		add_action( 'rhea_after_inquiry_form_submission', array( $this, 'collect_form_data' ) );  // Custom Inquiry forms

		add_action( 'realhomes_after_insert_comment', array( $this->activity, 'record_comment_activity' ) );
		add_action( 'rvr_after_booking_form_submission', array( $this->activity, 'record_booking_activity' ) );
	}

	/**
	 * Data collector for the leads and inquiries.
	 * @return void
	 */
	public function collect_form_data() {
		$current_hook = current_filter();
		$lead_id      = $this->lead->insert_lead();

		if ( ! empty( $lead_id ) && ! is_wp_error( $lead_id ) ) {
			$this->activity->insert_activity( $current_hook );

			// Insert an inquiry if it needs to be.
			if ( 'rhea_after_inquiry_form_submission' === $current_hook || ! empty( $_POST['property_id'] ) ) {
				$this->inquiry->insert_inquiry( $lead_id, $current_hook );
			}
		}
	}
}

new Realhomes_Crm_Data_Collector();