<?php

/**
 * Fired during plugin activation
 *
 * @link       https://realhomes.io/
 * @since      1.0.0
 *
 * @package    Realhomes_Crm
 * @subpackage Realhomes_Crm/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Realhomes_Crm
 * @subpackage Realhomes_Crm/includes
 * @author     InspiryThemes <fahid@inspirythemes.com>
 */
class Realhomes_Crm_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		global $wpdb;

		// Set table names with the WordPress database prefix
		$table_inquiries  = $wpdb->prefix . Realhomes_Crm_Helper::$table_inquiries;
		$table_activities = $wpdb->prefix . Realhomes_Crm_Helper::$table_activities;
		$table_leads      = $wpdb->prefix . Realhomes_Crm_Helper::$table_leads;
		$table_deals      = $wpdb->prefix . Realhomes_Crm_Helper::$table_deals;
		$table_tasks      = $wpdb->prefix . Realhomes_Crm_Helper::$table_tasks;
		$table_notes      = $wpdb->prefix . Realhomes_Crm_Helper::$table_notes;

		// Set the charset collate
		$charset_collate = $wpdb->get_charset_collate();

		// SQL query to create 'realhomes_crm_activities' table
		$sql_activities = "CREATE TABLE IF NOT EXISTS $table_activities (
		    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
		    type VARCHAR(100) NOT NULL,
		    data TEXT NOT NULL,
		    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
		    PRIMARY KEY (id)
		) $charset_collate;";

		// SQL query to create 'realhomes_crm_leads' table
		$sql_leads = "CREATE TABLE IF NOT EXISTS $table_leads (
	        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
	        lead_author_id BIGINT(20) UNSIGNED NOT NULL,
		    name_prefix VARCHAR(100) DEFAULT NULL,        -- e.g., Mr., Ms., Dr.
		    display_name VARCHAR(255) NOT NULL,           -- Full display name
		    first_name VARCHAR(100) NOT NULL,             -- First name
		    last_name VARCHAR(100) NOT NULL,              -- Last name
		    email VARCHAR(255) NOT NULL,                  -- Email address
		    mobile VARCHAR(20) DEFAULT NULL,              -- Mobile phone
		    home_phone VARCHAR(20) DEFAULT NULL,          -- Home phone
		    work_phone VARCHAR(20) DEFAULT NULL,          -- Work phone
		    address VARCHAR(255) DEFAULT NULL,            -- Full address
		    city VARCHAR(100) DEFAULT NULL,               -- City
		    state VARCHAR(100) DEFAULT NULL,              -- State or region
		    country VARCHAR(100) DEFAULT NULL,            -- Country
		    zipcode VARCHAR(20) DEFAULT NULL,             -- Zip/postal code
		    type VARCHAR(100) DEFAULT NULL,                -- Lead type (e.g., buyer, seller)
		    status VARCHAR(100) DEFAULT NULL,              -- Status of the lead (e.g., new, contacted, closed)
		    source VARCHAR(100) DEFAULT NULL,             -- Lead source (e.g., website, social media)
		    source_url VARCHAR(255) DEFAULT NULL,         -- URL of the lead source (if applicable)
		    x_url VARCHAR(255) DEFAULT NULL,              -- General custom URL (optional)
		    facebook_url VARCHAR(255) DEFAULT NULL,       -- Facebook profile link
		    linkedin_url VARCHAR(255) DEFAULT NULL,       -- LinkedIn profile link
		    private_note TEXT DEFAULT NULL,               -- Internal private note
		    message TEXT DEFAULT NULL,                    -- Message from the lead
		    created_at DATETIME DEFAULT CURRENT_TIMESTAMP, -- When the lead was created
		    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, -- When the lead was last updated
		    PRIMARY KEY (id),
		    KEY lead_author_id (lead_author_id),
		    KEY email (email),
		    KEY mobile (mobile)
	    ) $charset_collate;";

		// SQL query to create 'realhomes_crm_inquiries' table
		$sql_inquiries = "CREATE TABLE IF NOT EXISTS $table_inquiries (
		    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
		    lead_id BIGINT(20) UNSIGNED NOT NULL,
		    property_id BIGINT(20) UNSIGNED NOT NULL,
		    inquired_user_id BIGINT(20) UNSIGNED NOT NULL,
		    inquired_user_type VARCHAR(100) NOT NULL,
		    message TEXT NOT NULL,
		    private_note TEXT,
		    status VARCHAR(100) NOT NULL,
		    type VARCHAR(100) NOT NULL,
		    query TEXT,
		    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
		    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		    PRIMARY KEY (id),
		    KEY lead_id (lead_id),
		    KEY property_id (property_id),
		    KEY inquired_user_id (inquired_user_id)
		) $charset_collate;";

		// SQL query to create 'realhomes_crm_deals' table
		$sql_deals = "CREATE TABLE IF NOT EXISTS $table_deals (
		    id INT AUTO_INCREMENT PRIMARY KEY,
		    title VARCHAR(200) NOT NULL,
		    description TEXT,
		    lead_id INT NOT NULL,
		    agent_id INT NOT NULL,
		    last_step VARCHAR(100),
            last_step_date DATE,
		    next_step VARCHAR(100),
		    next_step_date DATE,
		    estimated_value VARCHAR(100),
		    deal_stage VARCHAR(200),
		    probability VARCHAR(100),
		    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
		) $charset_collate;";

		// SQL query to create 'realhomes_crm_tasks' table
		$sql_tasks = "CREATE TABLE IF NOT EXISTS $table_tasks (
		    id INT AUTO_INCREMENT PRIMARY KEY,
		    title VARCHAR(255) NOT NULL,
		    description TEXT,
		    due_date DATE,
		    priority VARCHAR(100),    -- Flexible priority field
		    status VARCHAR(100),      -- Flexible status field
		    type VARCHAR(100),        -- Flexible type field
		    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
		) $charset_collate;";

		// SQL query to create 'realhomes_crm_notes' table
		$sql_notes = "CREATE TABLE IF NOT EXISTS $table_notes (
		    id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,         -- Unique ID for each note
		    user_id BIGINT(20) UNSIGNED NOT NULL,                   -- The ID of the user who created the note
		    related_item_id BIGINT(20) UNSIGNED NOT NULL,           -- The ID of the related item (inquiry, lead, deal, or task)
		    note TEXT NOT NULL,                                     -- The actual note content
		    type VARCHAR(100) NOT NULL DEFAULT 'general',           -- Type of related item (inquiry, lead, deal, task)
		    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,          -- When the note was created
		    PRIMARY KEY (id),                                       -- Primary key on id
		    KEY user_id (user_id),                                  -- Index for user_id for faster queries
		    KEY related_item_id (related_item_id),                  -- Index for related item ID
		    KEY type (type)                                         -- Index for type to filter by related item type
		) $charset_collate;";


		// Include the WordPress upgrade file for dbDelta function
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		// Execute the queries to create the tables
		dbDelta( $sql_leads );
		dbDelta( $sql_inquiries );
		dbDelta( $sql_activities );
		dbDelta( $sql_deals );
		dbDelta( $sql_tasks );
		dbDelta( $sql_notes );
	}

}
