<?php
/**
 * Widget: Agent Featured Properties Widget
 *
 */

if ( ! class_exists( 'Agent_Featured_Properties_Widget' ) ) {

	/**
	 * Agent_Featured_Properties_Widget.
	 *
	 * Widget of agent featured properties.
	 */
	class Agent_Featured_Properties_Widget extends WP_Widget {

		function __construct() {
			$widget_ops = array(
				'classname'                   => 'Agent_Featured_Properties_Widget',
				'description'                 => esc_html__( 'Important: This widget is only for the Agent Sidebar.', ERE_TEXT_DOMAIN ),
				'customize_selective_refresh' => true,
			);
			parent::__construct( 'Agent_Featured_Properties_Widget', esc_html__( 'RealHomes - Agent Featured Properties', ERE_TEXT_DOMAIN ), $widget_ops );
		}

		function widget( $args, $instance ) {

			extract( $args );

			// Title
			if ( isset( $instance['title'] ) ) {
				$title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
			}

			if ( isset( $instance['view_property'] ) ) {
				$view_property = apply_filters( 'view_property', $instance['view_property'], $instance, $this->id_base );
			}

			if ( isset( $instance['featured_text'] ) ) {
				global $featured_text;
				$featured_text = apply_filters( 'featured_text', $instance['featured_text'], $instance, $this->id_base );
			}

			if ( empty( $title ) ) {
				$title = false;
			}

			// Count
			$count = 1;
			if ( isset( $instance['count'] ) ) {
				$count = intval( $instance['count'] );
			}

			$agent_featured_properties_args = array(
				'post_type'      => 'property',
				'posts_per_page' => $count,
				'meta_query'     => array(
					array(
						'key'     => 'REAL_HOMES_featured',     // Show only Featured Properties
						'value'   => 1,
						'compare' => '=',
						'type'    => 'NUMERIC',
					),
				),
			);

			// If author user author id otherwise if agent use agent id
			if ( is_author() ) {
				global $wp_query;
				$current_author                           = $wp_query->get_queried_object();
				$agent_featured_properties_args['author'] = $current_author->ID;
			} else if ( is_singular( 'agent' ) ) {
				$agent_id                                                 = get_the_ID();
				$agent_featured_properties_args['meta_query'][]           = array(
					'key'     => 'REAL_HOMES_agents',
					'value'   => $agent_id,
					'compare' => '=',
				);
				$agent_featured_properties_args['meta_query']['relation'] = 'AND';
			}

			// Order by
			$sort_by = 'recent';
			if ( isset( $instance['sort_by'] ) ) {
				$sort_by = $instance['sort_by'];
			}

			if ( $sort_by == 'random' ) :
				$agent_featured_properties_args['orderby'] = 'rand';
			else :
				$agent_featured_properties_args['orderby'] = 'date';
			endif;

			$agent_featured_properties_query = new WP_Query( apply_filters( 'ere_agent_featured_properties_widget', $agent_featured_properties_args ) );

			if ( is_author() || is_singular( 'agent' ) ) {  // it only works on author page or agent single page

				echo $before_widget;

				if ( $title ) :
					echo $before_title;
					echo $title;
					echo $after_title;
				endif;

				if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {

					if ( $agent_featured_properties_query->have_posts() ) :
						?>
                        <ul class="featured-properties">
							<?php
							while ( $agent_featured_properties_query->have_posts() ) :
								$agent_featured_properties_query->the_post();
								?>
                                <li>
                                    <figure>
                                        <a href="<?php the_permalink(); ?>">
											<?php
											if ( has_post_thumbnail() ) {
												the_post_thumbnail( 'property-thumb-image' );
											} else {
												if ( function_exists( 'inspiry_image_placeholder' ) ) {
													inspiry_image_placeholder( 'property-thumb-image' );
												}
											}
											?>
                                        </a>
                                    </figure>

                                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                    <p><?php
										ere_framework_excerpt( 7 );
										if ( isset( $view_property ) && ! empty( $view_property ) ) {
											?>
                                            <ahref="<?php the_permalink(); ?>"><?php echo esc_html( $view_property ); ?></a><?php
										} else {
											?>
                                            <ahref="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', ERE_TEXT_DOMAIN ); ?></a><?php
										}
										?></p><?php
									$price = ere_get_property_price();
									if ( $price ) {
										echo '<span class="price">' . $price . '</span>';
									}
									?>
                                </li>
							<?php
							endwhile;
							?>
                        </ul>
						<?php
						wp_reset_postdata();
					else :
						?>
                        <ul class="featured-properties">
							<?php
							echo '<li>';
							esc_html_e( 'No featured property found for this agent.', ERE_TEXT_DOMAIN );
							echo '</li>';
							?>
                        </ul>
					<?php
					endif;

				} else if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
					if ( $agent_featured_properties_query->have_posts() ) :
						if ( isset( $instance['card_design'] ) && 'default' != $instance['card_design'] ) {
							$property_card_variation = $instance['card_design'];
						} else {
							$inspiry_property_card_variation = get_option( 'inspiry_property_card_variation', '1' );
							$property_card_variation         = $inspiry_property_card_variation;
						}

						while ( $agent_featured_properties_query->have_posts() ) :
							$agent_featured_properties_query->the_post();

							ere_get_template_part( 'includes/widgets/grid-cards/grid-card-' . $property_card_variation );

							?>
                            <!-- /.rh_prop_card -->
						<?php
						endwhile;
						wp_reset_postdata();
					else :
						?>
                        <div class="rh_alert-wrapper rh_alert__widget">
                            <h4 class="no-results"><?php esc_html_e( 'No Featured Property Found For This Agent', ERE_TEXT_DOMAIN ); ?></h4>
                        </div>
					<?php
					endif;
				} else if ( 'ultra' === INSPIRY_DESIGN_VARIATION ) {
					global $this_widget_id;
					$this_widget_id = $this->id;

					if ( $agent_featured_properties_query->have_posts() ) :
						?>
                        <div class="ere-ultra-side-properties-wrapper">
                            <div class="ere-ultra-side-properties ere-ultra-properties-slider owl-carousel rh-ultra-slider-nav">
								<?php

								while ( $agent_featured_properties_query->have_posts() ) :
									$agent_featured_properties_query->the_post();
									?>
                                    <div class="ere-properties-slide item">
										<?php
										ere_get_template_part( 'includes/widgets/ultra-grid-cards/grid-card-2' );

										?>
                                    </div>
								<?php
								endwhile;
								?>
                            </div>
							<?php
							if ( $agent_featured_properties_query->post_count > 1 ) {
								?>
                                <div class="rh-ultra-widget-dots"></div>
								<?php
							}
							?>
                        </div>
						<?php
						wp_reset_postdata();
					else :
						?>
                        <div class="rh_alert-wrapper rh_alert__widget">
                            <h4 class="no-results"><?php esc_html_e( 'No Featured Property Found!', ERE_TEXT_DOMAIN ); ?></h4>
                        </div>
					<?php
					endif;

				}

				echo $after_widget;
			}
		}


		function form( $instance ) {
			// default for modern
			if ( 'ultra' === INSPIRY_DESIGN_VARIATION ) {
				$label_property = '';
			} else if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
				$label_property = esc_html__( 'View Property', ERE_TEXT_DOMAIN );
			} else if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
				$label_property = esc_html__( 'Read More', ERE_TEXT_DOMAIN );
			}
			$instance      = wp_parse_args(
				(array)$instance,
				array(
					'title'         => esc_html__( 'Featured Properties', ERE_TEXT_DOMAIN ),
					'count'         => 1,
					'sort_by'       => 'random',
					'view_property' => $label_property,
					'featured_text' => esc_html__( 'Featured', ERE_TEXT_DOMAIN ),
				)
			);
			$title         = $instance['title'];
			$count         = $instance['count'];
			$sort_by       = $instance['sort_by'];
			$card_design   = isset( $instance['card_design'] ) ? $instance['card_design'] : 'default';
			$view_property = $instance['view_property'];
			$featured_text = $instance['featured_text'];
			?>
            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Widget Title', ERE_TEXT_DOMAIN ); ?></label>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
            </p>
			<?php
			if ( 'ultra' !== INSPIRY_DESIGN_VARIATION ) {
				?>
                <p>
                    <label for="<?php echo esc_attr( $this->get_field_id( 'card_design' ) ); ?>"><?php esc_html_e( 'Property Card Design', ERE_TEXT_DOMAIN ); ?></label>
                    <select name="<?php echo esc_attr( $this->get_field_name( 'card_design' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'card_design' ) ); ?>" class="widefat">
                        <option value="default"<?php selected( $card_design, 'default' ); ?>><?php esc_html_e( 'Default', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="1"<?php selected( $card_design, '1' ); ?>><?php esc_html_e( 'One', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="2"<?php selected( $card_design, '2' ); ?>><?php esc_html_e( 'Two', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="3"<?php selected( $card_design, '3' ); ?>><?php esc_html_e( 'Three', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="4"<?php selected( $card_design, '4' ); ?>><?php esc_html_e( 'Four', ERE_TEXT_DOMAIN ); ?></option>
                        <option value="5"<?php selected( $card_design, '5' ); ?>><?php esc_html_e( 'Five', ERE_TEXT_DOMAIN ); ?></option>
                    </select>
                </p>
				<?php
			}
			?>

            <p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'sort_by' ) ); ?>"><?php esc_html_e( 'Sort By:', ERE_TEXT_DOMAIN ); ?></label>
                <select name="<?php echo esc_attr( $this->get_field_name( 'sort_by' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'sort_by' ) ); ?>" class="widefat">
                    <option value="recent"<?php selected( $sort_by, 'recent' ); ?>><?php esc_html_e( 'Most Recent', ERE_TEXT_DOMAIN ); ?></option>
                    <option value="random"<?php selected( $sort_by, 'random' ); ?>><?php esc_html_e( 'Random', ERE_TEXT_DOMAIN ); ?></option>
                </select>
            </p><p>
                <label for="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>"><?php esc_html_e( 'Number of Properties', ERE_TEXT_DOMAIN ); ?></label>
                <input id="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count' ) ); ?>" type="text" value="<?php echo esc_attr( $count ); ?>" size="3" />
            </p><p>
				<?php
				if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
					?>
                    <label for="<?php echo esc_attr( $this->get_field_id( 'view_property' ) ); ?>"><?php esc_html_e( 'View Property', ERE_TEXT_DOMAIN ); ?></label>
					<?php
				} else if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
					?>
                    <label for="<?php echo esc_attr( $this->get_field_id( 'view_property' ) ); ?>"><?php esc_html_e( 'Read More', ERE_TEXT_DOMAIN ); ?></label>
					<?php
				}
				?>
                <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'view_property' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'view_property' ) ); ?>" type="text" value="<?php echo esc_attr( $view_property ); ?>" />
            </p>
			<?php
			if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
				?>
                <p>
                    <label for="<?php echo esc_attr( $this->get_field_id( 'featured_text' ) ); ?>"><?php esc_html_e( 'Featured Tag Text', ERE_TEXT_DOMAIN ); ?></label>
                    <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'featured_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'featured_text' ) ); ?>" type="text" value="<?php echo esc_attr( $featured_text ); ?>" />
                </p>
				<?php
			}
			?><?php
		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;

			$instance['title']         = sanitize_text_field( isset( $new_instance['title'] ) ? $new_instance['title'] : '' );
			$instance['view_property'] = sanitize_text_field( isset( $new_instance['view_property'] ) ? $new_instance['view_property'] : '' );
			$instance['featured_text'] = sanitize_text_field( isset( $new_instance['featured_text'] ) ? $new_instance['featured_text'] : '' );
			$instance['sort_by']       = isset( $new_instance['sort_by'] ) ? $new_instance['sort_by'] : '';
			$instance['card_design']   = isset( $new_instance['card_design'] ) ? $new_instance['card_design'] : '';
			$instance['count']         = isset( $new_instance['count'] ) ? $new_instance['count'] : 1;

			return $instance;

		}

	}
}

if ( ! function_exists( 'register_agent_featured_properties_widget' ) ) {
	function register_agent_featured_properties_widget() {
		if ( post_type_exists( 'agent' ) ) {
			register_widget( 'Agent_Featured_Properties_Widget' );
		}
	}

	add_action( 'widgets_init', 'register_agent_featured_properties_widget' );
}
