<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$theme_show_social_menu = $this->get_option( 'theme_show_social_menu', 'true' );
$otp_login_attempts     = $this->get_option( 'ere_otp_max_login_attempts' );
$theme_facebook_link    = $this->get_option( 'theme_facebook_link' );
$theme_twitter_link     = $this->get_option( 'theme_twitter_link' );
$theme_linkedin_link    = $this->get_option( 'theme_linkedin_link' );
$theme_instagram_link   = $this->get_option( 'theme_instagram_link' );
$theme_youtube_link     = $this->get_option( 'theme_youtube_link' );
$theme_pinterest_link   = $this->get_option( 'theme_pinterest_link' );
$theme_rss_link         = $this->get_option( 'theme_rss_link' );
$theme_skype_username   = $this->get_option( 'theme_skype_username' );
$theme_line_id          = $this->get_option( 'theme_line_id' );

if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'inspiry_ere_settings' ) ) {

	// Saving RealHomes Social Login Settings.
	if ( isset( $_POST['rsl_settings'] ) ) {
		update_option( 'rsl_settings', $_POST['rsl_settings'] );
	}

	// Saving Social Profiles Settings.
	update_option( 'theme_show_social_menu', $theme_show_social_menu );
	update_option( 'ere_otp_max_login_attempts', $otp_login_attempts );
	update_option( 'theme_facebook_link', $theme_facebook_link );
	update_option( 'theme_twitter_link', $theme_twitter_link );
	update_option( 'theme_linkedin_link', $theme_linkedin_link );
	update_option( 'theme_instagram_link', $theme_instagram_link );
	update_option( 'theme_youtube_link', $theme_youtube_link );
	update_option( 'theme_pinterest_link', $theme_pinterest_link );
	update_option( 'theme_rss_link', $theme_rss_link );
	update_option( 'theme_skype_username', $theme_skype_username );
	update_option( 'theme_line_id', $theme_line_id );

	// Additional social networks
	if ( isset( $_POST['inspiry_ere_social_networks'] ) && ! empty( $_POST['inspiry_ere_social_networks'] ) ) {

		$additional_social_networks = $_POST['inspiry_ere_social_networks'];
		if ( is_array( $additional_social_networks ) ) {
			foreach ( $additional_social_networks as $social_network => $values ) {
				$r = array_filter( $values, 'strlen' );
				if ( empty( $r ) ) {
					unset( $additional_social_networks[ $social_network ] );
				}
			}

			$additional_social_networks = $this->sanitize_social_networks( $additional_social_networks );
			update_option( 'theme_social_networks', $additional_social_networks );
		}
	} else {
		delete_option( 'theme_social_networks' );
	}
}
?>
<div class="inspiry-ere-page-content">
    <div class="ere-admin-setting-tabs">
        <div class="tab current" data-target="social-icons"><span><?php esc_html_e( 'Social Links', ERE_TEXT_DOMAIN ); ?></span></div>
        <div class="tab" data-target="social-login"><span><?php esc_html_e( 'Social Login', ERE_TEXT_DOMAIN ); ?></span></div>
    </div>

    <div class="ere-admin-setting-sections">

        <div id="social-icons" class="ere-section current">
            <h2 class="title"><?php esc_html_e( 'Social Links', ERE_TEXT_DOMAIN ); ?></h2>
            <div class="description">
                <p><?php esc_html_e( 'Add URLs to your favorite social media services.', ERE_TEXT_DOMAIN ); ?></p>
            </div>

            <form method="post" action="" novalidate="novalidate">
                <div class="main-options-wrap">
                    <div class="left">
                        <h3><?php esc_html_e( 'Show or Hide Social Links', ERE_TEXT_DOMAIN ); ?></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                        <span class="allow">
                            <input type="radio" id="ere_show_social_menu_show" name="theme_show_social_menu" value="true" <?php checked( $theme_show_social_menu, 'true' ) ?>>
                            <label class="button-primary" for="ere_show_social_menu_show"><?php esc_html_e( 'Show', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                            <span class="deny">
                            <input type="radio" id="ere_show_social_menu_hide" name="theme_show_social_menu" value="false" <?php checked( $theme_show_social_menu, 'false' ) ?>>
                            <label class="button-primary" for="ere_show_social_menu_hide"><?php esc_html_e( 'Hide', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                        </p>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h3><?php esc_html_e( 'Add Social Links', ERE_TEXT_DOMAIN ); ?></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-text-option">
                            <label for="theme_facebook_link"><?php esc_html_e( 'Facebook URL', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_facebook_link" type="url" id="theme_facebook_link" value="<?php echo esc_url( $theme_facebook_link ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="theme_twitter_link"><?php esc_html_e( 'Twitter URL', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_twitter_link" type="url" id="theme_twitter_link" value="<?php echo esc_url( $theme_twitter_link ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="theme_linkedin_link"><?php esc_html_e( 'Linkedin URL', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_linkedin_link" type="url" id="theme_linkedin_link" value="<?php echo esc_url( $theme_linkedin_link ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="theme_instagram_link"><?php esc_html_e( 'Instagram URL', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_instagram_link" type="url" id="theme_instagram_link" value="<?php echo esc_url( $theme_instagram_link ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="theme_youtube_link"><?php esc_html_e( 'YouTube URL', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_youtube_link" type="url" id="theme_youtube_link" value="<?php echo esc_url( $theme_youtube_link ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="theme_pinterest_link"><?php esc_html_e( 'Pinterest URL', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_pinterest_link" type="url" id="theme_pinterest_link" value="<?php echo esc_url( $theme_pinterest_link ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="theme_rss_link"><?php esc_html_e( 'RSS URL', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_rss_link" type="url" id="theme_rss_link" value="<?php echo esc_url( $theme_rss_link ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="theme_skype_username"><?php esc_html_e( 'Skype Username', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_skype_username" type="text" id="theme_skype_username" value="<?php echo esc_attr( $theme_skype_username ); ?>" class="regular-text code">
                        </p>
                        <p class="fancy-text-option">
                            <label for="realhomes_line_link"><?php esc_html_e( 'LINE ID', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input name="theme_line_id" type="url" id="theme_line_id" value="<?php echo esc_attr( $theme_line_id ); ?>" class="regular-text code">
                        </p>
                    </div>
                </div>
                <hr>

                <table id="inspiry-ere-social-networks-table" class="form-table">
                    <tbody>
					<?php
					$theme_social_networks = get_option( 'theme_social_networks', array() );
					if ( is_array( $theme_social_networks ) && ! empty( $theme_social_networks ) ) :
						foreach ( $theme_social_networks as $i => $social_network ) :
							$title = $social_network['title'];
							$url           = $social_network['url'];
							$icon          = $social_network['icon'];
							?>
                            <tr class="inspiry-ere-sn-tr">
                                <th scope="row">
                                    <label for="inspiry-ere-sn-title-<?php echo esc_attr( $i ); ?>" class="inspiry-ere-sn-title"><?php echo esc_html( $title ); ?></label>
                                    <label for="inspiry-ere-sn-title-<?php echo esc_attr( $i ); ?>" class="inspiry-ere-sn-field hide"><strong><?php esc_html_e( 'Title', ERE_TEXT_DOMAIN ); ?></strong></label>
                                    <input type="text" id="inspiry-ere-sn-title-<?php echo esc_attr( $i ); ?>" name="inspiry_ere_social_networks[<?php echo esc_attr( $i ); ?>][title]" value="<?php echo esc_attr( $title ); ?>" class="inspiry-ere-sn-field hide code">
                                </th>
                                <td>
                                    <div>
                                        <label for="inspiry-ere-sn-url-<?php echo esc_attr( $i ); ?>" class="inspiry-ere-sn-field hide"><strong><?php esc_html_e( 'Profile URL', ERE_TEXT_DOMAIN ); ?></strong></label>
                                        <input type="text" id="inspiry-ere-sn-url-<?php echo esc_attr( $i ); ?>" name="inspiry_ere_social_networks[<?php echo esc_attr( $i ); ?>][url]" value="<?php echo esc_attr( $url ); ?>" class="regular-text code">
                                    </div>
                                    <div>
                                        <label for="inspiry-ere-sn-icon-<?php echo esc_attr( $i ); ?>" class="inspiry-ere-sn-field hide"><strong><?php esc_html_e( 'Icon Class', ERE_TEXT_DOMAIN ); ?></strong> <small>- <em><?php esc_html_e( 'Example: fa-flicker', ERE_TEXT_DOMAIN ); ?></em></small></label>
                                        <input type="text" id="inspiry-ere-sn-icon-<?php echo esc_attr( $i ); ?>" name="inspiry_ere_social_networks[<?php echo esc_attr( $i ); ?>][icon]" value="<?php echo esc_attr( $icon ); ?>" class="inspiry-ere-sn-field  hide code">
                                        <div class="inspiry-ere-sn-actions">
                                            <a href="#" class="inspiry-ere-edit-sn"><?php esc_html_e( 'Edit', ERE_TEXT_DOMAIN ); ?></a>
                                            <a href="#" class="inspiry-ere-update-sn hide"><?php esc_html_e( 'Ok', ERE_TEXT_DOMAIN ); ?></a>
                                            -
                                            <a href="#" class="inspiry-ere-remove-sn"><?php esc_html_e( 'Remove', ERE_TEXT_DOMAIN ); ?></a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
						<?php
						endforeach;
					endif;
					?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th scope="row"></th>
                        <td><a href="#" id="inspiry-ere-add-sn" class="inspiry-ere-add-sn"><?php esc_html_e( '+ Add New Social Network', ERE_TEXT_DOMAIN ); ?></a></p></td>
                    </tr>
                    </tfoot>
                </table>

                <div class="submit">
					<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
                </div>
            </form>
        </div>

        <div id="social-login" class="ere-section">
            <h2 class="title"><?php esc_html_e( 'Social Login Settings', ERE_TEXT_DOMAIN ); ?></h2>
            <div class="description">
                <p><?php esc_html_e( 'Manage social login platform settings', ERE_TEXT_DOMAIN ); ?></p>
            </div>

            <form method="post" action="" novalidate="novalidate">

                <?php $rsl_settings = get_option( 'rsl_settings' ); ?>

                <!-- Login Attempts -->
                <div class="main-options-wrap">
                    <?php $otp_login_attempts = get_option( 'ere_otp_max_login_attempts', 5 ); ?>
                    <div class="left">
                        <h3><?php esc_html_e( 'OTP Max Login Attempts', ERE_TEXT_DOMAIN ); ?></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-checkbox-button-option">
                            <input type="number" id="ere_otp_max_login_attempts" name="ere_otp_max_login_attempts" value="<?php echo esc_attr( $otp_login_attempts ); ?>" />
                        </p>
                        <label for="ere_otp_max_login_attempts"><?php esc_html_e( 'How many attempts a user have for otp login. It is to prevent bruteforce attacks.', ERE_TEXT_DOMAIN ); ?></label>
                    </div>
                </div>

                <br><hr><br>

                <!-- Facebook Login -->
                <div class="main-options-wrap">
	                <?php
	                $enable_social_login_facebook = ! empty( $rsl_settings['enable_social_login_facebook'] ) ? $rsl_settings['enable_social_login_facebook'] : '';
	                $facebook_app_id              = ! empty( $rsl_settings['facebook_app_id'] ) ? $rsl_settings['facebook_app_id'] : '';
	                $facebook_app_secret          = ! empty( $rsl_settings['facebook_app_secret'] ) ? $rsl_settings['facebook_app_secret'] : '';
	                ?>
                    <div class="left">
                        <h3><?php esc_html_e( 'Facebook Login', ERE_TEXT_DOMAIN ); ?></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-checkbox-button-option">
                            <span class="checkbox-wrapper">
                                <input class="toggle-check" id="rsl_settings[enable_social_login_facebook]" name="rsl_settings[enable_social_login_facebook]" type="checkbox" value="1" <?php checked( 1, $enable_social_login_facebook ); ?> />
                                <label class="tgl-btn" for="rsl_settings[enable_social_login_facebook]" data-tg-off="<?php esc_html_e( 'OFF', ERE_TEXT_DOMAIN ); ?>" data-tg-on="<?php esc_html_e( 'ON', ERE_TEXT_DOMAIN ); ?>"></label>
                            </span>
                        </p>
                        <h4><?php esc_html_e( 'Enable login/register with facebook on login forms.', ERE_TEXT_DOMAIN ); ?></h4>
                        <span class="description"><?php echo sprintf( esc_html__( 'Learn how to get Facebook APP ID and Secret by %s.', ERE_TEXT_DOMAIN ), '<a href="https://inspirythemes.com/realhomes-social-login-setup/#facebook-login-setup" target="_blank">'. esc_html__( 'clicking here', ERE_TEXT_DOMAIN ) .'</a>' ); ?></span>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h3></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <label for="rsl_settings[facebook_app_id]"><?php esc_html_e( 'App ID*', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input id="rsl_settings[facebook_app_id]" name="rsl_settings[facebook_app_id]" type="text" class="regular-text" value="<?php echo esc_attr( $facebook_app_id ); ?>" />
                        </p>
                        <p class="fancy-radio-option">
                            <label for="rsl_settings[facebook_app_secret]"><?php esc_html_e( 'App Secret*', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input id="rsl_settings[facebook_app_secret]" name="rsl_settings[facebook_app_secret]" type="text" class="regular-text" value="<?php echo esc_attr( $facebook_app_secret ); ?>" />
                        </p>
                    </div>
                </div>

                <br><hr><br>

                <!-- Google Login -->
                <div class="main-options-wrap">
	                <?php
	                $enable_social_login_google = ! empty( $rsl_settings['enable_social_login_google'] ) ? $rsl_settings['enable_social_login_google'] : '';
	                $google_app_api_key         = ! empty( $rsl_settings['google_app_api_key'] ) ? $rsl_settings['google_app_api_key'] : '';
	                $google_app_client_id       = ! empty( $rsl_settings['google_app_client_id'] ) ? $rsl_settings['google_app_client_id'] : '';
	                $google_app_client_secret   = ! empty( $rsl_settings['google_app_client_secret'] ) ? $rsl_settings['google_app_client_secret'] : '';
	                ?>
                    <div class="left">
                        <h3><?php esc_html_e( 'Google Login', ERE_TEXT_DOMAIN ); ?></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-checkbox-button-option">
                            <span class="checkbox-wrapper">
                                <input class="toggle-check" id="rsl_settings[enable_social_login_google]" name="rsl_settings[enable_social_login_google]" type="checkbox" value="1" <?php checked( 1, $enable_social_login_google ); ?> />
                                <label class="tgl-btn" for="rsl_settings[enable_social_login_google]" data-tg-off="<?php esc_html_e( 'OFF', ERE_TEXT_DOMAIN ); ?>" data-tg-on="<?php esc_html_e( 'ON', ERE_TEXT_DOMAIN ); ?>"></label>
                            </span>
                        </p>
                        <h4><?php esc_html_e( 'Enable login/register with google on login forms.', ERE_TEXT_DOMAIN ); ?></h4>
                        <span class="description"><?php echo sprintf( esc_html__( 'Learn how to get Facebook APP ID and Secret by %s.', ERE_TEXT_DOMAIN ), '<a href="https://inspirythemes.com/realhomes-social-login-setup/#facebook-login-setup" target="_blank">'. esc_html__( 'clicking here', ERE_TEXT_DOMAIN ) .'</a>' ); ?></span>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h3></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <label for="rsl_settings[google_app_api_key]"><?php esc_html_e( 'API Key*', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input id="rsl_settings[google_app_api_key]" name="rsl_settings[google_app_api_key]" type="text" class="regular-text" value="<?php echo esc_attr( $google_app_api_key ); ?>" />
                        </p>
                        <p class="fancy-radio-option">
                            <label for="rsl_settings[google_app_client_id]"><?php esc_html_e( 'Client ID*', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input id="rsl_settings[google_app_client_id]" name="rsl_settings[google_app_client_id]" type="text" class="regular-text" value="<?php echo esc_attr( $google_app_client_id ); ?>" />
                        </p>
                        <p class="fancy-radio-option">
                            <label for="rsl_settings[google_app_client_secret]"><?php esc_html_e( 'Client Secret*', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input id="rsl_settings[google_app_client_secret]" name="rsl_settings[google_app_client_secret]" type="text" class="regular-text" value="<?php echo esc_attr( $google_app_client_secret ); ?>" />
                        </p>
                    </div>
                </div>

                <br><hr><br>

                <!-- Twitter Login -->
                <div class="main-options-wrap">
	                <?php
	                $enable_social_login_twitter = ! empty( $rsl_settings['enable_social_login_twitter'] ) ? $rsl_settings['enable_social_login_twitter'] : '';
	                $twitter_app_consumer_key    = ! empty( $rsl_settings['twitter_app_consumer_key'] ) ? $rsl_settings['twitter_app_consumer_key'] : '';
	                $twitter_app_consumer_secret = ! empty( $rsl_settings['twitter_app_consumer_secret'] ) ? $rsl_settings['twitter_app_consumer_secret'] : '';

	                ?>
                    <div class="left">
                        <h3><?php esc_html_e( 'Twitter Login', ERE_TEXT_DOMAIN ); ?></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-checkbox-button-option">
                            <span class="checkbox-wrapper">
                                <input class="toggle-check" id="rsl_settings[enable_social_login_twitter]" name="rsl_settings[enable_social_login_twitter]" type="checkbox" value="1" <?php checked( 1, $enable_social_login_twitter ); ?> />
                                <label class="tgl-btn" for="rsl_settings[enable_social_login_twitter]" data-tg-off="<?php esc_html_e( 'OFF', ERE_TEXT_DOMAIN ); ?>" data-tg-on="<?php esc_html_e( 'ON', ERE_TEXT_DOMAIN ); ?>"></label>
                            </span>
                        </p>
                        <h4><?php esc_html_e( 'Enable login/register with twitter on login forms.', ERE_TEXT_DOMAIN ); ?></h4>
                        <span class="description"><?php echo sprintf( esc_html__( 'Learn how to get Twitter Consumer Key and Consumer Secret by %s.', ERE_TEXT_DOMAIN ), '<a href="https://inspirythemes.com/realhomes-social-login-setup/#twitter-login-setup" target="_blank">'. esc_html__( 'clicking here', ERE_TEXT_DOMAIN ) .'</a>' ); ?></span>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h3></h3>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <label for="rsl_settings[twitter_app_consumer_key]"><?php esc_html_e( 'Consumer Key*', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input id="rsl_settings[twitter_app_consumer_key]" name="rsl_settings[twitter_app_consumer_key]" type="text" class="regular-text" value="<?php echo esc_attr( $twitter_app_consumer_key ); ?>" />
                        </p>
                        <p class="fancy-radio-option">
                            <label for="rsl_settings[twitter_app_consumer_secret]"><?php esc_html_e( 'Consumer Secret*', ERE_TEXT_DOMAIN ); ?></label><br>
                            <input id="rsl_settings[twitter_app_consumer_secret]" name="rsl_settings[twitter_app_consumer_secret]" type="text" class="regular-text" value="<?php echo esc_attr( $twitter_app_consumer_secret ); ?>" />
                        </p>
                    </div>
                </div>

                <div class="submit">
					<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
                </div>
            </form>
        </div>
    </div>
</div>