<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Post type values
$ere_agent_post_type_status   = $this->get_option( 'ere_agent_post_type_status', 'enable' );
$ere_agency_post_type_status  = $this->get_option( 'ere_agency_post_type_status', 'enable' );
$ere_owner_post_type_status   = $this->get_option( 'ere_owner_post_type_status', 'enable' );
$ere_partner_post_type_status = $this->get_option( 'ere_partner_post_type_status', 'enable' );
$ere_slides_post_type_status  = $this->get_option( 'ere_slides_post_type_status', 'enable' );

// Slug values
$inspiry_property_slug         = $this->get_option( 'inspiry_property_slug', esc_html__( 'property', ERE_TEXT_DOMAIN ) );
$inspiry_agent_slug            = $this->get_option( 'inspiry_agent_slug', esc_html__( 'agent', ERE_TEXT_DOMAIN ) );
$ere_agent_location_slug       = $this->get_option( 'ere_agent_location_slug', esc_html__( 'agent-location', ERE_TEXT_DOMAIN ) );
$inspiry_agency_slug           = $this->get_option( 'inspiry_agency_slug', esc_html__( 'agency', ERE_TEXT_DOMAIN ) );
$ere_agency_location_slug      = $this->get_option( 'ere_agency_location_slug', esc_html__( 'agency-location', ERE_TEXT_DOMAIN ) );
$inspiry_property_city_slug    = $this->get_option( 'inspiry_property_city_slug', esc_html__( 'property-location', ERE_TEXT_DOMAIN ) );
$inspiry_property_status_slug  = $this->get_option( 'inspiry_property_status_slug', esc_html__( 'property-status', ERE_TEXT_DOMAIN ) );
$inspiry_property_type_slug    = $this->get_option( 'inspiry_property_type_slug', esc_html__( 'property-type', ERE_TEXT_DOMAIN ) );
$inspiry_property_feature_slug = $this->get_option( 'inspiry_property_feature_slug', esc_html__( 'property-feature', ERE_TEXT_DOMAIN ) );

// Post type verification
$ere_agent_post_type_verification_status  = $this->get_option( 'realhomes_agents_verification_status', 'show' );
$ere_agency_post_type_verification_status = $this->get_option( 'realhomes_agencies_verification_status', 'show' );
$ere_owners_post_type_verification_status  = $this->get_option( 'ere_owners_post_type_verification_status', 'hide' );

if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'inspiry_ere_settings' ) ) {
	// Post type option updates
	update_option( 'ere_agent_post_type_status', $ere_agent_post_type_status );
	update_option( 'ere_agency_post_type_status', $ere_agency_post_type_status );
	update_option( 'ere_owner_post_type_status', $ere_owner_post_type_status );
	update_option( 'ere_partner_post_type_status', $ere_partner_post_type_status );
	update_option( 'ere_slides_post_type_status', $ere_slides_post_type_status );


	// Slug option updates
	update_option( 'inspiry_property_slug', $inspiry_property_slug );
	update_option( 'inspiry_agent_slug', $inspiry_agent_slug );
	update_option( 'ere_agent_location_slug', $ere_agent_location_slug );
	update_option( 'inspiry_agency_slug', $inspiry_agency_slug );
	update_option( 'ere_agency_location_slug', $ere_agency_location_slug );
	update_option( 'inspiry_property_city_slug', $inspiry_property_city_slug );
	update_option( 'inspiry_property_status_slug', $inspiry_property_status_slug );
	update_option( 'inspiry_property_type_slug', $inspiry_property_type_slug );
	update_option( 'inspiry_property_feature_slug', $inspiry_property_feature_slug );
    
    // Post type verification
	update_option( 'realhomes_agents_verification_status', $ere_agent_post_type_verification_status );
	update_option( 'realhomes_agencies_verification_status', $ere_agency_post_type_verification_status );
	update_option( 'ere_owners_post_type_verification_status', $ere_owners_post_type_verification_status );
}
?>
<div class="inspiry-ere-page-content">
    <div class="ere-admin-setting-tabs">
        <div class="tab current" data-target="post-types"><span><?php esc_html_e( 'Post Types', ERE_TEXT_DOMAIN ); ?></span></div>
        <div class="tab" data-target="url-slugs"><span><?php esc_html_e( 'URL Slugs', ERE_TEXT_DOMAIN ); ?></span></div>
        <div class="tab" data-target="post-type-verification"><span><?php esc_html_e( 'Post Type Verification', ERE_TEXT_DOMAIN ); ?></span></div>
    </div>

    <div class="ere-admin-setting-sections">

        <div id="post-types" class="ere-section current">
            <h2 class="title"><?php esc_html_e( 'Post Types Management', 'easy-real-esate' ); ?></h2>
            <div class="description">
                <p><?php esc_html_e( 'Manage post types to enable/disable on your current installation.', ERE_TEXT_DOMAIN ); ?></p>
            </div>
            <form id="ere-settings-post-type-form" method="post" action="" novalidate="novalidate">
                <div class="main-options-wrap">
                    <div class="left">
                        <h4><?php esc_html_e( 'Agent Post Type', ERE_TEXT_DOMAIN ); ?></h4>
                        <legend class="screen-reader-text">
                            <span><?php esc_html_e( 'Enable/disable agent post type', ERE_TEXT_DOMAIN ); ?></span>
                        </legend>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <span class="allow">
                                <input type="radio" id="ere_agent_post_type_enable" name="ere_agent_post_type_status" value="enable" <?php checked( $ere_agent_post_type_status, 'enable' ) ?>>
                                <label class="button-primary" for="ere_agent_post_type_enable"><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                            <span class="deny">
                                <input type="radio" id="ere_agent_post_type_disable" name="ere_agent_post_type_status" value="disable" <?php checked( $ere_agent_post_type_status, 'disable' ) ?>>
                                <label class="button-primary" for="ere_agent_post_type_disable"><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                        </p>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h4><?php esc_html_e( 'Agency Post Type', ERE_TEXT_DOMAIN ); ?></h4>
                        <legend class="screen-reader-text">
                            <span><?php esc_html_e( 'Enable/disable agency post type', ERE_TEXT_DOMAIN ); ?></span>
                        </legend>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <span class="allow">
                                <input type="radio" id="ere_agency_post_type_enable" name="ere_agency_post_type_status" value="enable" <?php checked( $ere_agency_post_type_status, 'enable' ) ?>>
                                <label class="button-primary" for="ere_agency_post_type_enable"><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                            <span class="deny">
                                <input type="radio" id="ere_agency_post_type_disable" name="ere_agency_post_type_status" value="disable" <?php checked( $ere_agency_post_type_status, 'disable' ) ?>>
                                <label class="button-primary" for="ere_agency_post_type_disable"><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                        </p>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h4><?php esc_html_e( 'Owner Post Type', ERE_TEXT_DOMAIN ); ?></h4>
                        <legend class="screen-reader-text">
                            <span><?php esc_html_e( 'Enable/disable owner post type', ERE_TEXT_DOMAIN ); ?></span>
                        </legend>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <span class="allow">
                                <input type="radio" id="ere_owner_post_type_enable" name="ere_owner_post_type_status" value="enable" <?php checked( $ere_owner_post_type_status, 'enable' ) ?>>
                                <label class="button-primary" for="ere_owner_post_type_enable"><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                            <span class="deny">
                                <input type="radio" id="ere_owner_post_type_disable" name="ere_owner_post_type_status" value="disable" <?php checked( $ere_owner_post_type_status, 'disable' ) ?>>
                                <label class="button-primary" for="ere_owner_post_type_disable"><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                        </p>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h4><?php esc_html_e( 'Partner Post Type', ERE_TEXT_DOMAIN ); ?></h4>
                        <legend class="screen-reader-text">
                            <span><?php esc_html_e( 'Enable/disable partner post type', ERE_TEXT_DOMAIN ); ?></span>
                        </legend>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <span class="allow">
                                <input type="radio" id="ere_partner_post_type_enable" name="ere_partner_post_type_status" value="enable" <?php checked( $ere_partner_post_type_status, 'enable' ) ?>>
                                <label class="button-primary" for="ere_partner_post_type_enable"><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                            <span class="deny">
                                <input type="radio" id="ere_partner_post_type_disable" name="ere_partner_post_type_status" value="disable" <?php checked( $ere_partner_post_type_status, 'disable' ) ?>>
                                <label class="button-primary" for="ere_partner_post_type_disable"><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                        </p>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
                        <h4><?php esc_html_e( 'Slides Post Type', ERE_TEXT_DOMAIN ); ?></h4>
                        <legend class="screen-reader-text">
                            <span><?php esc_html_e( 'Enable/disable slides post type', ERE_TEXT_DOMAIN ); ?></span>
                        </legend>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <span class="allow">
                                <input type="radio" id="ere_slides_post_type_enable" name="ere_slides_post_type_status" value="enable" <?php checked( $ere_slides_post_type_status, 'enable' ) ?>>
                                <label class="button-primary" for="ere_slides_post_type_enable"><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                            <span class="deny">
                                <input type="radio" id="ere_slides_post_type_disable" name="ere_slides_post_type_status" value="disable" <?php checked( $ere_slides_post_type_status, 'disable' ) ?>>
                                <label class="button-primary" for="ere_slides_post_type_disable"><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                        </p>
                    </div>
                </div>

                <div class="submit">
					<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
                    <input type="submit" name="submit" id="submit" class="button button-primary post-type-submit" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
                </div>
                <div class="ere-settings-message"></div>
            </form>
        </div>

        <div id="url-slugs" class="ere-section">
            <h2 class="title"><?php esc_html_e( 'Important Note for URL Slugs', ERE_TEXT_DOMAIN ); ?></h2>
            <div class="description">
                <p><?php esc_html_e( 'Make sure to re-save permalinks settings after every change in URL slugs to avoid 404 errors. You can do that from [ Settings > Permalinks ]', ERE_TEXT_DOMAIN ); ?></p>
            </div>
            <form method="post" action="" novalidate="novalidate">
                <table class="form-table">
                    <tbody>
                    <tr>
                        <th scope="row"><label for="inspiry_property_slug"><?php esc_html_e( 'Property Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="inspiry_property_slug" type="text" id="inspiry_property_slug" value="<?php echo esc_attr( $inspiry_property_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="inspiry_agent_slug"><?php esc_html_e( 'Agent Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="inspiry_agent_slug" type="text" id="inspiry_agent_slug" value="<?php echo esc_attr( $inspiry_agent_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="ere_agent_location_slug"><?php esc_html_e( 'Agent Location Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="ere_agent_location_slug" type="text" id="ere_agent_location_slug" value="<?php echo esc_attr( $ere_agent_location_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="inspiry_agency_slug"><?php esc_html_e( 'Agency Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="inspiry_agency_slug" type="text" id="inspiry_agency_slug" value="<?php echo esc_attr( $inspiry_agency_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="ere_agency_location_slug"><?php esc_html_e( 'Agency Location Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="ere_agency_location_slug" type="text" id="ere_agency_location_slug" value="<?php echo esc_attr( $ere_agency_location_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="inspiry_property_city_slug"><?php esc_html_e( 'Property Location Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="inspiry_property_city_slug" type="text" id="inspiry_property_city_slug" value="<?php echo esc_attr( $inspiry_property_city_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="inspiry_property_status_slug"><?php esc_html_e( 'Property Status Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="inspiry_property_status_slug" type="text" id="inspiry_property_status_slug" value="<?php echo esc_attr( $inspiry_property_status_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="inspiry_property_type_slug"><?php esc_html_e( 'Property Type Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="inspiry_property_type_slug" type="text" id="inspiry_property_type_slug" value="<?php echo esc_attr( $inspiry_property_type_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="inspiry_property_feature_slug"><?php esc_html_e( 'Property Feature Slug', ERE_TEXT_DOMAIN ); ?></label></th>
                        <td><span class="home-url"><?php echo home_url(); ?>/ </span><input name="inspiry_property_feature_slug" type="text" id="inspiry_property_feature_slug" value="<?php echo esc_attr( $inspiry_property_feature_slug ); ?>" class="regular-text code"></td>
                    </tr>
                    </tbody>
                </table>
                <div class="submit">
					<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
                </div>
            </form>
        </div>

        <div id="post-type-verification" class="ere-section">

            <form method="post" action="" novalidate="novalidate">
                <div class="main-options-wrap">
                    <div class="left">
						<?php
						$agent_post_type_verify_title = esc_html__( 'Agent Verification', ERE_TEXT_DOMAIN );
						$agent_post_type_verify_desc  = esc_html__( 'Show/Hide agent post type verification badges.', ERE_TEXT_DOMAIN );
						?>
                        <h4 aria-label="<?php echo esc_html( $agent_post_type_verify_title ); ?>"><?php echo esc_html( $agent_post_type_verify_title ); ?></h4>
                        <p aria-description="<?php echo esc_html( $agent_post_type_verify_desc ); ?>"><?php echo esc_html( $agent_post_type_verify_desc ); ?></p>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                        <span class="allow">
                            <input type="radio" id="ere_agent_post_type_verification_show" name="realhomes_agents_verification_status" value="show" <?php checked( $ere_agent_post_type_verification_status, 'show' ) ?>>
                            <label class="button-primary" for="ere_agent_post_type_verification_show"><?php esc_html_e( 'Show', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                            <span class="deny">
                            <input type="radio" id="ere_agent_post_type_verification_hide" name="realhomes_agents_verification_status" value="hide" <?php checked( $ere_agent_post_type_verification_status, 'hide' ) ?>>
                            <label class="button-primary" for="ere_agent_post_type_verification_hide"><?php esc_html_e( 'Hide', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                        </p>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
						<?php
						$agency_post_type_verify_title = esc_html__( 'Agency Verification', ERE_TEXT_DOMAIN );
						$agency_post_type_verify_desc  = esc_html__( 'Show/Hide agency post type verification badges.', ERE_TEXT_DOMAIN );
						?>
                        <h4 aria-label="<?php echo esc_html( $agency_post_type_verify_title ); ?>"><?php echo esc_html( $agency_post_type_verify_title ); ?></h4>
                        <p aria-description="<?php echo esc_html( $agency_post_type_verify_desc ); ?>"><?php echo esc_html( $agency_post_type_verify_desc ); ?></p>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                        <span class="allow">
                            <input type="radio" id="ere_agency_post_type_verification_show" name="realhomes_agencies_verification_status" value="show" <?php checked( $ere_agent_post_type_verification_status, 'show' ) ?>>
                            <label class="button-primary" for="ere_agency_post_type_verification_show"><?php esc_html_e( 'Show', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                            <span class="deny">
                            <input type="radio" id="ere_agency_post_type_verification_hide" name="realhomes_agencies_verification_status" value="hide" <?php checked( $ere_agent_post_type_verification_status, 'hide' ) ?>>
                            <label class="button-primary" for="ere_agency_post_type_verification_hide"><?php esc_html_e( 'Hide', ERE_TEXT_DOMAIN ); ?></label>
                        </span>
                        </p>
                    </div>
                </div>

                <div class="main-options-wrap">
                    <div class="left">
						<?php
						$owner_post_type_verify_title = esc_html__( 'Owner Verification', ERE_TEXT_DOMAIN );
						$owner_post_type_verify_desc  = esc_html__( 'Show/Hide owner post type verification badges.', ERE_TEXT_DOMAIN );
						?>
                        <h4 aria-label="<?php echo esc_html( $owner_post_type_verify_title ); ?>"><?php echo esc_html( $owner_post_type_verify_title ); ?></h4>
                        <p aria-description="<?php echo esc_html( $owner_post_type_verify_desc ); ?>"><?php echo esc_html( $owner_post_type_verify_desc ); ?></p>
                    </div>
                    <div class="right">
                        <p class="fancy-radio-option">
                            <span class="allow">
                                <input type="radio" id="ere_owner_post_type_verification_show" name="ere_owners_post_type_verification_status" value="show" <?php checked( $ere_owners_post_type_verification_status, 'show' ) ?>>
                                <label class="button-primary" for="ere_owner_post_type_verification_show"><?php esc_html_e( 'Show', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                            <span class="deny">
                                <input type="radio" id="ere_owner_post_type_verification_hide" name="ere_owners_post_type_verification_status" value="hide" <?php checked( $ere_owners_post_type_verification_status, 'hide' ) ?>>
                                <label class="button-primary" for="ere_owner_post_type_verification_hide"><?php esc_html_e( 'Hide', ERE_TEXT_DOMAIN ); ?></label>
                            </span>
                        </p>
                    </div>
                </div>

                <div class="submit">
					<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
                    <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
                </div>
            </form>
        </div>
        <!-- post type verification wrapper -->
    </div>
</div>