<?php
/**
 * Display Post Types options home page
 *
 * @package Display Post Types
 * @since 2.5.0
 */

?>

<div class="dpt-welcome-wrapper">
    <h3>Welcome to Display Post Types</h3>
    <ul class="dpt-list">
        <li><span style="font-weight: bold;">Display Post Types</span> helps retrieve, organize, and showcase posts, pages, or custom post types.</li>
        <li>Create <span style="font-weight: bold;">grids</span>, <span style="font-weight: bold;">lists</span>, or <span style="font-weight: bold;">sliders</span> to display your posts, pages, or custom post types in a visually stunning way.</li>
        <li>Includes a <span style="font-weight: bold;">user-friendly shortcode generator</span> for designing post layouts.</li>
        <li>Display content using <span style="font-weight: bold;">shortcodes, block editor, or WordPress widgets</span>.</li>
        <li><span style="font-weight: bold;">Shortcode generator is recommended</span> for simplicity and broad compatibility.</li>
    </ul>
    <p><?php $this->mlink( 'https://www.youtube.com/watch?v=tTVGMylfBhU', 'Check Getting Started Video', 'button dpt-pro-docs' ); ?></p>
    <h4>DPT Pro advanced features</h4>
    <p><?php $this->mlink( 'https://www.youtube.com/watch?v=v6dD4Eurs_Q', 'How many grid layouts you can make with DPT Pro?', 'button dpt-pro-docs' ); ?></p>
    <p><?php $this->mlink( 'https://www.youtube.com/watch?v=YDeygne5Kn4', 'Using Advanced Custom Fields and Shortcodes with DPT Pro.', 'button dpt-pro-docs' ); ?></p>
    <h4>Key Features</h4>
    <ul class="dpt-list">
        <li><span style="font-weight: bold;">Fetch and organize posts</span>, pages, or custom post types using available filters.</li>
        <li><span style="font-weight: bold;">Customize</span> which content items to display based on your preferences.</li>
        <li><span style="font-weight: bold;">Select a display style</span> from list, grid, or slider views.</li>
        <li><span style="font-weight: bold;">Preview changes live</span> within the Display Post Types block.</li>
    </ul>
    <p>If you need any more help with our plugin, please feel free to <a href="https://wordpress.org/support/plugin/display-post-types/" target="_blank">open a support ticket</a> or <a href="https://easyprolabs.com/contact-us-2/" target="_blank">contact us</a>.</p>
</div>