<?php
$classic_design = ( 'classic' == INSPIRY_DESIGN_VARIATION );
$last_columns   = 12;
$icon_columns   = 6;

$tabs['contact_form'] = array(
	'label' => esc_html__( 'Contact Form', RH_TEXT_DOMAIN ),
	'icon'  => 'dashicons-email',
);

$tabs['map'] = array(
	'label' => esc_html__( 'Contact Map', RH_TEXT_DOMAIN ),
	'icon'  => 'dashicons-location',
);

$tabs['detail'] = array(
	'label' => esc_html__( 'Contact Details', RH_TEXT_DOMAIN ),
	'icon'  => 'dashicons-businessperson',
);

// Contact Map
$fields[] = array(
	'name'    => esc_html__( 'Map', RH_TEXT_DOMAIN ),
	'id'      => 'theme_show_contact_map',
	'type'    => 'radio',
	'std'     => '1',
	'options' => array(
		'1' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
		'0' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
	),
	'columns' => 12,
	'tab'     => 'map',
);
$fields[] = array(
	'name'    => esc_html__( 'Map Latitude', RH_TEXT_DOMAIN ),
	'desc'    => 'You can use <a href="http://www.latlong.net/" target="_blank">latlong.net</a> OR <a href="http://itouchmap.com/latlong.html" target="_blank">itouchmap.com</a> to get Latitude and longitude of your desired location.',
	'id'      => 'theme_map_lati',
	'type'    => 'text',
	'std'     => '-37.817917',
	'columns' => 6,
	'tab'     => 'map',
);
$fields[] = array(
	'name'    => esc_html__( 'Map Longitude', RH_TEXT_DOMAIN ),
	'id'      => 'theme_map_longi',
	'type'    => 'text',
	'std'     => '144.965065',
	'columns' => 6,
	'tab'     => 'map',
);
$fields[] = array(
	'name'    => esc_html__( 'Map Zoom Level', RH_TEXT_DOMAIN ),
	'desc'    => esc_html__( 'Provide Map Zoom Level.', RH_TEXT_DOMAIN ),
	'id'      => 'theme_map_zoom',
	'type'    => 'text',
	'std'     => '17',
	'columns' => 6,
	'tab'     => 'map',
);

$map_type = inspiry_get_maps_type();
if ( 'google-maps' == $map_type ) {
	$fields[] = array(
		'name'    => esc_html__( 'Map Type', RH_TEXT_DOMAIN ),
		'desc'    => esc_html__( 'Choose Google Map Type', RH_TEXT_DOMAIN ),
		'id'      => 'inspiry_contact_map_type',
		'type'    => 'select',
		'options' => array(
			'global'    => esc_html__( 'Global Default', RH_TEXT_DOMAIN ),
			'roadmap'   => esc_html__( 'RoadMap', RH_TEXT_DOMAIN ),
			'satellite' => esc_html__( 'Satellite', RH_TEXT_DOMAIN ),
			'hybrid'    => esc_html__( 'Hybrid', RH_TEXT_DOMAIN ),
			'terrain'   => esc_html__( 'Terrain', RH_TEXT_DOMAIN ),
		),
		'std'     => 'global',
		'columns' => 6,
		'tab'     => 'map',
	);

	$icon_columns = 12;
}

$fields[] = array(
	'name'             => esc_html__( 'Maps Marker', RH_TEXT_DOMAIN ),
	'desc'             => esc_html__( 'Upload custom maps marker for the contact page map. Image size should be around 50px by 50px.', RH_TEXT_DOMAIN ),
	'id'               => 'inspiry_contact_map_icon',
	'type'             => 'image_advanced',
	'max_file_uploads' => 1,
	'columns'          => $icon_columns,
	'tab'              => 'map',
);

$fields[] = array(
	'name'             => esc_html__( 'Retina Maps Marker', RH_TEXT_DOMAIN ),
	'desc'             => esc_html__( 'Upload a retina (2x) version of the map marker for high-resolution displays.', RH_TEXT_DOMAIN ),
	'id'               => 'realhomes_contact_map_retina_icon',
	'type'             => 'image_advanced',
	'max_file_uploads' => 1,
	'columns'          => $icon_columns,
	'tab'              => 'map',
);

if ( 'mapbox' === $map_type ) {
	$fields[] = array(
		'name'       => esc_html__( 'Marker Color', RH_TEXT_DOMAIN ),
		'desc'       => esc_html__( 'Select the marker color if image is not uploaded.', RH_TEXT_DOMAIN ),
		'id'         => 'inspiry_contact_marker_color',
		'type'       => 'color',
		'columns'    => 12,
		'tab'        => 'map',
		'js_options' => array(
			'palettes' => array( '#125', '#459', '#78b', '#ab0', '#de3', '#f0f' )
		)
	);
}

// Contact Details
$fields[] = array(
	'name'    => esc_html__( 'Contact Detail', RH_TEXT_DOMAIN ),
	'id'      => 'theme_show_details',
	'type'    => 'radio',
	'std'     => '1',
	'options' => array(
		'1' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
		'0' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
	),
	'columns' => 12,
	'tab'     => 'detail',
);

if ( $classic_design ) {
	$fields[] = array(
		'name'    => esc_html__( 'Contact Details Title', RH_TEXT_DOMAIN ),
		'id'      => 'theme_contact_details_title',
		'type'    => 'text',
		'std'     => '',
		'columns' => 6,
		'tab'     => 'detail',
	);

	$last_columns = 6;
}

$fields[] = array(
	'name'    => esc_html__( 'Cell Number', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_cell',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'detail',
);
$fields[] = array(
	'name'    => esc_html__( 'Phone Number', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_phone',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'detail',
);
$fields[] = array(
	'name'    => esc_html__( 'Fax Number', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_fax',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'detail',
);
$fields[] = array(
	'name'    => esc_html__( 'Display Email', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_display_email',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'detail',
);
$fields[] = array(
	'name'    => esc_html__( 'Contact Address', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_address',
	'type'    => 'textarea',
	'std'     => '',
	'columns' => $last_columns,
	'tab'     => 'detail',
);

// Contact Form
$fields[] = array(
	'name'    => esc_html__( 'Contact Form Display', RH_TEXT_DOMAIN ),
	'id'      => 'realhomes_show_contact_form',
	'type'    => 'radio',
	'std'     => 'show',
	'options' => array(
		'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
		'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
	),
	'columns' => 12,
	'tab'     => 'contact_form',
);

if ( $classic_design ) {
	$fields[] = array(
		'name'    => esc_html__( 'Contact Form Heading', RH_TEXT_DOMAIN ),
		'id'      => 'theme_contact_form_heading',
		'type'    => 'text',
		'std'     => '',
		'columns' => 6,
		'tab'     => 'contact_form',
	);
}

$fields[] = array(
	'name'    => esc_html__( 'Name Field Label', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_form_name_label',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Email Field Label', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_form_email_label',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Phone Number Field Label', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_form_number_label',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Message Field Label', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_form_message_label',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Contact Form Email', RH_TEXT_DOMAIN ),
	'desc'    => esc_html__( 'Provide email address that will get messages from contact form.', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_email',
	'type'    => 'text',
	'std'     => get_option( 'admin_email' ),
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Contact Form CC Email', RH_TEXT_DOMAIN ),
	'desc'    => esc_html__( 'You can add multiple comma separated cc email addresses, to get a carbon copy of contact form message.', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_cc_email',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Contact Form BCC Email', RH_TEXT_DOMAIN ),
	'desc'    => esc_html__( 'You can add multiple comma separated bcc email addresses, to get a blind carbon copy of contact form message.', RH_TEXT_DOMAIN ),
	'id'      => 'theme_contact_bcc_email',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Contact Form Shortcode ( To Replace Default Form )', RH_TEXT_DOMAIN ),
	'desc'    => esc_html__( 'If you want to replace default contact form with a plugin based form then provide its shortcode here.', RH_TEXT_DOMAIN ),
	'id'      => 'inspiry_contact_form_shortcode',
	'type'    => 'text',
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
$fields[] = array(
	'name'    => esc_html__( 'Select Page For Redirection', RH_TEXT_DOMAIN ),
	'desc'    => esc_html__( 'User will be redirected to the selected page after successful submission of the contact form.', RH_TEXT_DOMAIN ),
	'id'      => 'inspiry_contact_form_success_redirect_page',
	'type'    => 'select',
	'options' => RH_Data::get_pages_array(),
	'std'     => '',
	'columns' => 6,
	'tab'     => 'contact_form',
);
