<?php
/**
 * This file contains admin area related functions
 *
 * @since 4.4.0
 */
if ( ! function_exists( 'realhomes_reorder_theme_submenus' ) ) {
	/**
	 * Moves specific submenus under the 'real_homes' menu to the end while keeping others unchanged.
	 *
	 * @since 4.3.9
	 */
	function realhomes_reorder_theme_submenus() {
		global $submenu;

		if ( isset( $submenu['real_homes'] ) ) {
			// Define the specific submenus to move to the end (use their slugs).
			$selected_slugs = array(
				'realhomes-currencies-settings',
				'realhomes-paypal-settings',
				'inspiry-stripe-payments-settings',
				'admin.php?page=realhomes-demo-import',
				'realhomes-feedback',
				'realhomes-help'
			);

			// Separate selected and unselected submenus.
			$selected_submenus  = array();
			$remaining_submenus = array();

			foreach ( $submenu['real_homes'] as $submenu_item ) {
				if ( in_array( $submenu_item[2], $selected_slugs, true ) ) {
					$selected_submenus[ $submenu_item[2] ] = $submenu_item;
				} else {
					$remaining_submenus[] = $submenu_item;
				}
			}

			// Arrange selected submenus in the desired order.
			$reordered_selected_submenus = array();
			foreach ( $selected_slugs as $slug ) {
				if ( isset( $selected_submenus[ $slug ] ) ) {
					$reordered_selected_submenus[] = $selected_submenus[ $slug ];
				}
			}

			// Merge remaining submenus first and move selected ones to the end.
			$submenu['real_homes'] = array_merge( $remaining_submenus, $reordered_selected_submenus );
		}
	}

	add_action( 'admin_menu', 'realhomes_reorder_theme_submenus', 999 );
}

if ( ! function_exists( 'realhomes_reorder_ere_submenus' ) ) {
	/**
	 * Reorders the Easy Real Estate submenus to ensure "New Fields Builder" appears before "Settings".
	 *
	 * @since 4.3.9
	 */
	function realhomes_reorder_ere_submenus() {
		global $submenu;

		$parent_slug     = 'easy-real-estate';
		$new_fields_slug = 'inspiry_property_additional_fields_page';
		$settings_slug   = 'ere-settings';

		if ( isset( $submenu[ $parent_slug ] ) ) {
			$new_submenu = [];

			// First, remove the "Settings" menu if it exists.
			foreach ( $submenu[ $parent_slug ] as $key => $item ) {
				if ( isset( $item[2] ) && $item[2] === $settings_slug ) {
					$settings_menu = $item;
					unset( $submenu[ $parent_slug ][ $key ] );
				}
			}

			// Now, rebuild the submenu, ensuring "New Fields Builder" is before "Settings".
			foreach ( $submenu[ $parent_slug ] as $item ) {
				$new_submenu[] = $item;

				// When "New Fields Builder" is found, insert "Settings" after it.
				if ( isset( $item[2] ) && $item[2] === $new_fields_slug && isset( $settings_menu ) ) {
					$new_submenu[] = $settings_menu;
				}
			}

			// Assign the reordered submenu back.
			$submenu[ $parent_slug ] = $new_submenu;
		}
	}

	add_action( 'admin_menu', 'realhomes_reorder_ere_submenus', 999 );
}

