<?php
/**
 * Section:  `WP Login Page`
 * Panel:    `Styles`
 *
 * @since   4.3.3
 * @package realhomes/customizer
 */
if ( ! function_exists( 'realhomes_wp_login_page_customizer' ) ) {
	/**
	 * WP Login Page Styles
	 *
	 * @since 4.3.3
	 *
	 * @param WP_Customize_Manager $wp_customize - Instance of WP_Customize_Manager.
	 */
	function realhomes_wp_login_page_customizer( WP_Customize_Manager $wp_customize ) {

		// Add Login Page Section
		$wp_customize->add_section( 'realhomes_wp_login_page_section', array(
			'title'    => esc_html__( 'WP Login Page', RH_TEXT_DOMAIN ),
			'panel'    => 'inspiry_styles_panel',
			'priority' => 10,
		) );

		// Enable/Disable Custom Styles
		$wp_customize->add_setting( 'realhomes_wp_login_page_styles', array(
			'type'              => 'option',
			'default'           => 'enable',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_styles', array(
			'label'   => esc_html__( 'Custom Styles', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'choices' => array(
				'enable'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
				'disable' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
			),
			'section' => 'realhomes_wp_login_page_section',
		) );

		// General Text Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_text_color', array(
			'type'              => 'option',
			'default'           => '#000',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_text_color', array(
			'label'           => esc_html__( 'General Text Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Link Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_link_color', array(
			'type'              => 'option',
			'default'           => '#0073aa',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_link_color', array(
			'label'           => esc_html__( 'Link Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Link Hover Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_link_hover_color', array(
			'type'              => 'option',
			'default'           => '#005177',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_link_hover_color', array(
			'label'           => esc_html__( 'Link Hover Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Page Background Heading
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_section', array( 'sanitize_callback' => 'sanitize_text_field', ) );
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_wp_login_page_background_section', array(
			'label'           => esc_html__( 'Page Background', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Background Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_color', array(
			'type'              => 'option',
			'default'           => '#f0f0f1',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_background_color', array(
			'label'           => esc_html__( 'Background Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Background Image
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_image', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'realhomes_wp_login_page_background_image', array(
			'label'           => esc_html__( 'Background Image', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Background Image Size
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_image_size', array(
			'type'              => 'option',
			'default'           => 'auto',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_background_image_size', array(
			'label'           => esc_html__( 'Image Size', RH_TEXT_DOMAIN ),
			'type'            => 'select',
			'section'         => 'realhomes_wp_login_page_section',
			'choices'         => array(
				'auto'    => esc_html__( 'Original', RH_TEXT_DOMAIN ),
				'contain' => esc_html__( 'Fit to Screen', RH_TEXT_DOMAIN ),
				'cover'   => esc_html__( 'Fill Screen', RH_TEXT_DOMAIN ),
			),
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Background Image Horizontal Position
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_image_position_x', array(
			'type'              => 'option',
			'default'           => 'center',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_background_image_position_x', array(
			'label'           => esc_html__( 'Image Horizontally Position', RH_TEXT_DOMAIN ),
			'type'            => 'select',
			'section'         => 'realhomes_wp_login_page_section',
			'choices'         => array(
				'left'   => esc_html__( 'Left', RH_TEXT_DOMAIN ),
				'center' => esc_html__( 'Center', RH_TEXT_DOMAIN ),
				'right'  => esc_html__( 'Right', RH_TEXT_DOMAIN ),
			),
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Background Image Vertical Position
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_image_position_y', array(
			'type'              => 'option',
			'default'           => 'center',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_background_image_position_y', array(
			'label'           => esc_html__( 'Image Vertically Position', RH_TEXT_DOMAIN ),
			'type'            => 'select',
			'section'         => 'realhomes_wp_login_page_section',
			'choices'         => array(
				'top'    => esc_html__( 'Top ', RH_TEXT_DOMAIN ),
				'center' => esc_html__( 'Center', RH_TEXT_DOMAIN ),
				'bottom' => esc_html__( 'Bottom', RH_TEXT_DOMAIN ),
			),
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Background Image Repeat
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_image_repeat', array(
			'type'              => 'option',
			'default'           => 'no-repeat',
			'sanitize_callback' => 'inspiry_sanitize_select',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_background_image_repeat', array(
			'label'           => esc_html__( 'Image Repeat', RH_TEXT_DOMAIN ),
			'type'            => 'select',
			'section'         => 'realhomes_wp_login_page_section',
			'choices'         => array(
				'no-repeat' => esc_html__( 'No Repeat', RH_TEXT_DOMAIN ),
				'repeat'    => esc_html__( 'Repeat', RH_TEXT_DOMAIN ),
				'repeat-x'  => esc_html__( 'Repeat Horizontally', RH_TEXT_DOMAIN ),
				'repeat-y'  => esc_html__( 'Repeat Vertically', RH_TEXT_DOMAIN ),
			),
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Background Attachment
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_attachment', array(
			'type'              => 'option',
			'default'           => false,
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_background_attachment', array(
			'label'           => esc_html__( 'Scroll with Page', RH_TEXT_DOMAIN ),
			'type'            => 'checkbox',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Overlay Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_overlay_color', array(
			'type'              => 'option',
			'default'           => '#3582c4',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_background_overlay_color', array(
			'label'           => esc_html__( 'Overlay Color', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Select an overlay color with transparency.', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Overlay Opacity
		$wp_customize->add_setting( 'realhomes_wp_login_page_background_opacity', array(
			'type'              => 'option',
			'default'           => '5',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_background_opacity', array(
			'label'           => esc_html__( 'Overlay Opacity', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter a value between 0 (fully transparent) and 100 (fully opaque).', RH_TEXT_DOMAIN ),
			'type'            => 'number',
			'section'         => 'realhomes_wp_login_page_section',
			'input_attrs'     => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 5,
			),
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Page Logo Heading
		$wp_customize->add_setting( 'realhomes_wp_login_page_logo_section', array( 'sanitize_callback' => 'sanitize_text_field', ) );
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_wp_login_page_logo_section', array(
			'label'           => esc_html__( 'Page Logo', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Logo Display
		$wp_customize->add_setting( 'realhomes_wp_login_page_logo_display', array(
			'type'              => 'option',
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_logo_display', array(
			'label'           => esc_html__( 'Logo Display', RH_TEXT_DOMAIN ),
			'type'            => 'radio',
			'choices'         => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Logo Top Space
		$wp_customize->add_setting( 'realhomes_wp_login_page_logo_top_space', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_logo_top_space', array(
			'label'           => esc_html__( 'Top Space', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example 10px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Logo Bottom Space
		$wp_customize->add_setting( 'realhomes_wp_login_page_logo_bottom_space', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_logo_bottom_space', array(
			'label'           => esc_html__( 'Bottom Space', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example 10px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		$wp_customize->add_setting( 'realhomes_wp_login_page_logo_type', array(
			'type'              => 'option',
			'default'           => 'image',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_logo_type', array(
			'label'           => esc_html__( 'Logo Type', RH_TEXT_DOMAIN ),
			'type'            => 'radio',
			'choices'         => array(
				'image' => esc_html__( 'Image', RH_TEXT_DOMAIN ),
				'text'  => esc_html__( 'Text', RH_TEXT_DOMAIN ),
			),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Logo Image
		$wp_customize->add_setting( 'realhomes_wp_login_page_logo', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'realhomes_wp_login_page_logo', array(
			'label'           => esc_html__( 'Image Logo', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Logo Width
		$wp_customize->add_setting( 'realhomes_wp_login_page_logo_width', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_logo_width', array(
			'label'           => esc_html__( 'Width', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example 10px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Logo Height
		$wp_customize->add_setting( 'realhomes_wp_login_page_logo_height', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_logo_height', array(
			'label'           => esc_html__( 'Height', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example 10px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Site Title Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_site_title_color', array(
			'type'              => 'option',
			'default'           => '#3c434a',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_site_title_color', array(
			'label'           => esc_html__( 'Site Title Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Page Form Heading
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_section', array( 'sanitize_callback' => 'sanitize_text_field', ) );
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_wp_login_page_form_section', array(
			'label'           => esc_html__( 'Page Form', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Form Label Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_label_color', array(
			'type'              => 'option',
			'default'           => '#3c434a',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_form_label_color', array(
			'label'           => esc_html__( 'Label Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Form Background Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_bg_color', array(
			'type'              => 'option',
			'default'           => '#fff',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_form_bg_color', array(
			'label'           => esc_html__( 'Background Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Form Border Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_border_color', array(
			'type'              => 'option',
			'default'           => '#c3c4c7',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_form_border_color', array(
			'label'           => esc_html__( 'Border Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Form Border Width
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_border_width', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_form_border_width', array(
			'label'           => esc_html__( 'Border Width', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example: 2px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Form Border Radius
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_border_radius', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_form_border_radius', array(
			'label'           => esc_html__( 'Border Radius', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example: 5px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Form Fields Heading
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_fields_section', array( 'sanitize_callback' => 'sanitize_text_field', ) );
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_wp_login_page_form_fields_section', array(
			'label'           => esc_html__( 'Form Fields', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Field Font Size
		$wp_customize->add_setting( 'realhomes_wp_login_page_input_font_size', array(
			'type'              => 'option',
			'default'           => '24px',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_input_font_size', array(
			'label'           => esc_html__( 'Font Size', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example: 24px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Field Text Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_input_text_color', array(
			'type'              => 'option',
			'default'           => '#000',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_input_text_color', array(
			'label'           => esc_html__( 'Field Text Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Field Background Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_input_bg_color', array(
			'type'              => 'option',
			'default'           => '#fff',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_input_bg_color', array(
			'label'           => esc_html__( 'Field Background Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Field Border Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_input_border_color', array(
			'type'              => 'option',
			'default'           => '#ccc',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_input_border_color', array(
			'label'           => esc_html__( 'Field Border Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Field Border Width
		$wp_customize->add_setting( 'realhomes_wp_login_page_input_border_width', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_input_border_width', array(
			'label'           => esc_html__( 'Border Width', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example: 2px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Field Border Radius
		$wp_customize->add_setting( 'realhomes_wp_login_page_input_border_radius', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_input_border_radius', array(
			'label'           => esc_html__( 'Field Border Radius', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example: 4px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Form Button Heading
		$wp_customize->add_setting( 'realhomes_wp_login_page_form_button_section', array( 'sanitize_callback' => 'sanitize_text_field', ) );
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_wp_login_page_form_button_section', array(
			'label'           => esc_html__( 'Form Button', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Button Text Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_text_color', array(
			'type'              => 'option',
			'default'           => '#fff',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_button_text_color', array(
			'label'           => esc_html__( 'Button Text Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Button Background Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_bg_color', array(
			'type'              => 'option',
			'default'           => '#0073aa',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_button_bg_color', array(
			'label'           => esc_html__( 'Button Background Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Button Border Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_border_color', array(
			'type'              => 'option',
			'default'           => '#0073aa',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_button_border_color', array(
			'label'           => esc_html__( 'Button Border Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Button Hover Background Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_hover_bg_color', array(
			'type'              => 'option',
			'default'           => '#005177',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_button_hover_bg_color', array(
			'label'           => esc_html__( 'Button Hover Background Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Button Hover Text Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_hover_text_color', array(
			'type'              => 'option',
			'default'           => '#fff',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_button_hover_text_color', array(
			'label'           => esc_html__( 'Button Hover Text Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Button Hover Border Color
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_hover_border_color', array(
			'type'              => 'option',
			'default'           => '#005177',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'realhomes_wp_login_page_button_hover_border_color', array(
			'label'           => esc_html__( 'Button Hover Border Color', RH_TEXT_DOMAIN ),
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) ) );

		// Button Border Width
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_border_width', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_button_border_width', array(
			'label'           => esc_html__( 'Button Border Width', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example: 2px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Button Border Radius
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_border_radius', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_button_border_radius', array(
			'label'           => esc_html__( 'Button Border Radius', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter the pixel value. Example: 4px.', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );

		// Button Padding
		$wp_customize->add_setting( 'realhomes_wp_login_page_button_padding', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'realhomes_wp_login_page_button_padding', array(
			'label'           => esc_html__( 'Button Padding', RH_TEXT_DOMAIN ),
			'description'     => esc_html__( 'Enter padding values (e.g., 10px 20px).', RH_TEXT_DOMAIN ),
			'type'            => 'text',
			'section'         => 'realhomes_wp_login_page_section',
			'active_callback' => 'realhomes_is_wp_login_page_styles_enabled',
		) );
	}

	add_action( 'customize_register', 'realhomes_wp_login_page_customizer' );
}

if ( ! function_exists( 'realhomes_is_wp_login_page_styles_enabled' ) ) {
	/**
	 * Check if WordPress Login Page Styles are enabled.
	 *
	 * Retrieves the 'realhomes_wp_login_page_styles' option and verifies if it is set to 'enable'.
	 *
	 * @since 4.3.9
	 *
	 * @return bool True if enabled, false otherwise.
	 */
	function realhomes_is_wp_login_page_styles_enabled() {
		return get_option( 'realhomes_wp_login_page_styles', 'enable' ) === 'enable';
	}
}