<?php
/**
 * Section:  `Styles`
 * Panel:    `Forms`
 *
 * @since 4.4.0
 */

if ( ! function_exists( 'realhomes_form_general_styles_customizer' ) ) {
	/**
	 * realhomes_form_general_styles_customizer.
	 *
	 * @since  4.4.0
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	function realhomes_form_general_styles_customizer( WP_Customize_Manager $wp_customize ) {

		/**
		 * Form Styles
		 */
		$wp_customize->add_section( 'realhomes_form_styles', array(
			'title'       => esc_html__( 'Forms', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'These styles will take affect on the form reside in content areas of the website excluding header, footer sidebar, and elementor forms', RH_TEXT_DOMAIN ),
			'panel'       => 'inspiry_styles_panel',
		) );

		$wp_customize->add_setting( 'realhomes_form_label_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color'
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_label_color',
				array(
					'label'   => esc_html__( 'Labels Text Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_field_background_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_field_background_color',
				array(
					'label'   => esc_html__( 'Field Background Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_field_text_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_field_text_color',
				array(
					'label'   => esc_html__( 'Field Text Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		if ( REALHOMES_DESIGN_VARIATION == 'ultra' ) {
			$wp_customize->add_setting( 'realhomes_form_field_icon_color', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_hex_color',
			) );
			$wp_customize->add_control(
				new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_field_icon_color',
					array(
						'label'   => esc_html__( 'Field Input Icon Color', RH_TEXT_DOMAIN ),
						'section' => 'realhomes_form_styles',
					)
				)
			);
			$wp_customize->add_setting( 'realhomes_form_field_icon_second_color', array(
				'type'              => 'option',
				'sanitize_callback' => 'sanitize_hex_color',
			) );
			$wp_customize->add_control(
				new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_field_icon_second_color',
					array(
						'label'   => esc_html__( 'Field Input Icon Second Color', RH_TEXT_DOMAIN ),
						'section' => 'realhomes_form_styles',
					)
				)
			);
		}

		$wp_customize->add_setting( 'realhomes_form_textarea_background_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_textarea_background_color',
				array(
					'label'   => esc_html__( 'Textarea Background Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_textarea_text_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_textarea_text_color',
				array(
					'label'   => esc_html__( 'Textarea Text Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_gdpr_text_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_gdpr_text_color',
				array(
					'label'   => esc_html__( 'GDPR Text Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_button_bg_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_button_bg_color',
				array(
					'label'   => esc_html__( 'Button Background Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_button_text_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_button_text_color',
				array(
					'label'   => esc_html__( 'Button Text Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_button_border_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_button_border_color',
				array(
					'label'   => esc_html__( 'Button Border Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_button_hover_bg_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_button_hover_bg_color',
				array(
					'label'   => esc_html__( 'Button Hover Background Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_button_hover_text_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_button_hover_text_color',
				array(
					'label'   => esc_html__( 'Button Hover Text Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

		$wp_customize->add_setting( 'realhomes_form_button_hover_border_color', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(
			new WP_Customize_Color_Control( $wp_customize, 'realhomes_form_button_hover_border_color',
				array(
					'label'   => esc_html__( 'Button Hover Border Color', RH_TEXT_DOMAIN ),
					'section' => 'realhomes_form_styles',
				)
			)
		);

	}

	add_action( 'customize_register', 'realhomes_form_general_styles_customizer' );
}