<?php
/**
 * Section: Print
 * Panel: Property Detail Page
 *
 * @since 4.0.1
 */
if ( ! function_exists( 'realhomes_single_property_print_customizer' ) ) {
	/**
	 * Adds the print related settings for single property page sections.
	 *
	 * @since 4.0.1
	 */
	function realhomes_single_property_print_customizer( WP_Customize_Manager $wp_customize ) {

		$wp_customize->add_section( 'realhomes_single_property_print_section', array(
			'title' => esc_html__( 'Print', RH_TEXT_DOMAIN ),
			'panel' => 'inspiry_property_panel',
		) );

		$wp_customize->add_setting( 'realhomes_single_property_print_setting', array(
			'type'              => 'option',
			'default'           => 'default',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_single_property_print_setting', array(
			'label'   => esc_html__( 'Sections in Property Print', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_single_property_print_section',
			'choices' => array(
				'default' => esc_html__( 'Default', RH_TEXT_DOMAIN ),
				'custom'  => esc_html__( 'Custom', RH_TEXT_DOMAIN ),
			)
		) );

		$property_sections = realhomes_single_property_print_sections();
		if ( ! empty( $property_sections ) && is_array( $property_sections ) ) {
			$wp_customize->add_setting( 'realhomes_single_property_printable_sections', array(
				'type'              => 'option',
				'default'           => array_keys( $property_sections ),
				'sanitize_callback' => 'inspiry_sanitize_multiple_checkboxes'
			) );
			$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control( $wp_customize, 'realhomes_single_property_printable_sections',
				array(
					'label'           => esc_html__( 'Custom Sections Select for Property Print', RH_TEXT_DOMAIN ),
					'description'     => esc_html__( 'Select the sections to add in property print.', RH_TEXT_DOMAIN ),
					'section'         => 'realhomes_single_property_print_section',
					'choices'         => $property_sections,
					'active_callback' => 'realhomes_is_custom_print_setting'
				)
			) );
		}

		$wp_customize->add_setting( 'realhomes_property_media_in_print', array(
			'type'              => 'option',
			'default'           => 'gallery-images',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'realhomes_property_media_in_print', array(
			'label'   => esc_html__( 'Property Media in Print', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'realhomes_single_property_print_section',
			'choices' => array(
				'gallery-images' => esc_html__( 'Gallery Images', RH_TEXT_DOMAIN ),
				'featured-image' => esc_html__( 'Featured Image', RH_TEXT_DOMAIN ),
			)
		) );

		$additional_fields = array();

		// Check if the additional fields class exists
		if ( class_exists( 'Property_Additional_Fields' ) ) {
			// Get all fields configured for single property meta.
			$additional_fields = Property_Additional_Fields::instance()->single_property_additional_meta_fields();
		}

		// Only register customizer settings if we have valid fields.
		if ( ! empty( $additional_fields ) ) {
			$wp_customize->add_setting( 'realhomes_printable_additional_meta_fields', array(
				'type'              => 'option',
				'default'           => array_keys( $additional_fields ),
				'sanitize_callback' => 'inspiry_sanitize_multiple_checkboxes',
			) );
			$wp_customize->add_control( new Inspiry_Multiple_Checkbox_Customize_Control( $wp_customize, 'realhomes_printable_additional_meta_fields',
				array(
					'label'       => esc_html__( 'Property Additional Meta Fields in Print', RH_TEXT_DOMAIN ),
					'description' => esc_html__( 'Select which additional field meta to include in print view', RH_TEXT_DOMAIN ),
					'section'     => 'realhomes_single_property_print_section',
					'choices'     => $additional_fields,
				)
			) );
		}

	}

	add_action( 'customize_register', 'realhomes_single_property_print_customizer' );
}