<?php
/**
 * Section:    `Map`
 * Panel:    `Property Detail Page`
 *
 * @since 2.6.3
 */

if ( ! function_exists( 'inspiry_property_map_customizer' ) ) :
	/**
	 * inspiry_property_map_customizer.
	 *
	 * @since  2.6.3
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	function inspiry_property_map_customizer( WP_Customize_Manager $wp_customize ) {
		/**
		 * Map Section
		 */
		$wp_customize->add_section( 'inspiry_property_map', array(
			'title'    => esc_html__( 'Map', RH_TEXT_DOMAIN ),
			'panel'    => 'inspiry_property_panel',
			'priority' => 13
		) );

		// Show/Hide Map
		$wp_customize->add_setting( 'theme_display_google_map', array(
			'type'              => 'option',
			'default'           => 'true',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'theme_display_google_map', array(
			'label'   => esc_html__( 'Property Map', RH_TEXT_DOMAIN ),
			'type'    => 'radio',
			'section' => 'inspiry_property_map',
			'choices' => array(
				'true'  => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'false' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		// Map Title
		$wp_customize->add_setting( 'theme_property_map_title', array(
			'type'              => 'option',
			'transport'         => 'postMessage',
			'default'           => esc_html__( 'Property on Map', RH_TEXT_DOMAIN ),
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'theme_property_map_title', array(
			'label'   => esc_html__( 'Map Section Title', RH_TEXT_DOMAIN ),
			'type'    => 'text',
			'section' => 'inspiry_property_map',
		) );

		// Video Title Selective Refresh
		$map_title_selector = '';
		if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
			$map_title_selector = '.map-wrap .map-label';
		} else {
			$map_title_selector = '.rh_property__map_wrap .rh_property__heading';
		}
		if ( isset( $wp_customize->selective_refresh ) ) {
			$wp_customize->selective_refresh->add_partial( 'theme_property_map_title', array(
				'selector'            => $map_title_selector,
				'container_inclusive' => false,
				'render_callback'     => 'inspiry_property_map_title_render',
			) );
		}

		// Google/OSM Map Zoom
		$wp_customize->add_setting( 'inspiry_property_map_zoom', array(
			'type'              => 'option',
			'default'           => '15',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_property_map_zoom', array(
			'label'       => esc_html__( 'Map Zoom Level', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Provide Map Zoom Level.', RH_TEXT_DOMAIN ),
			'type'        => 'number',
			'section'     => 'inspiry_property_map',
		) );

		$map_type = inspiry_get_maps_type();
		if ( 'google-maps' == $map_type ) {

			// Google Map Type
			$wp_customize->add_setting( 'inspiry_property_map_type', array(
				'type'              => 'option',
				'default'           => 'global',
				'sanitize_callback' => 'inspiry_sanitize_select',
			) );
			$wp_customize->add_control( 'inspiry_property_map_type', array(
				'label'       => esc_html__( 'Map Type', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Choose Google Map Type', RH_TEXT_DOMAIN ),
				'type'        => 'select',
				'section'     => 'inspiry_property_map',
				'choices'     => array(
					'global'    => esc_html__( 'Global Default', RH_TEXT_DOMAIN ),
					'roadmap'   => esc_html__( 'RoadMap', RH_TEXT_DOMAIN ),
					'satellite' => esc_html__( 'Satellite', RH_TEXT_DOMAIN ),
					'hybrid'    => esc_html__( 'Hybrid', RH_TEXT_DOMAIN ),
					'terrain'   => esc_html__( 'Terrain', RH_TEXT_DOMAIN ),
				),
			) );

			// Google Map Link Display Toggle
			$wp_customize->add_setting( 'realhomes_google_map_link_display', array(
				'type'              => 'option',
				'default'           => 'false',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'realhomes_google_map_link_display', array(
				'label'       => esc_html__( 'Display "Show on Map" Link', RH_TEXT_DOMAIN ),
				'description' => esc_html__( 'Enable or disable the interactive map link for property locations', RH_TEXT_DOMAIN ),
				'type'        => 'radio',
				'section'     => 'inspiry_property_map',
				'choices'     => array(
					'true'  => esc_html__( 'Enable', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Disable', RH_TEXT_DOMAIN ),
				),
			) );

            // Google Map Link Text
			$wp_customize->add_setting( 'realhomes_google_map_link_text', array(
				'type'              => 'option',
				'default'           => esc_html__( 'Show on Map', RH_TEXT_DOMAIN ),
				'sanitize_callback' => 'sanitize_text_field',
			) );

			$wp_customize->add_control( 'realhomes_google_map_link_text', array(
				'label'           => esc_html__( 'Map Link Label Text', RH_TEXT_DOMAIN ),
				'description'     => esc_html__( 'Customize the call-to-action text for the map link', RH_TEXT_DOMAIN ),
				'type'            => 'text',
				'section'         => 'inspiry_property_map',
				'active_callback' => function() {
					return ( 'true' === get_option( 'realhomes_google_map_link_display', 'false' ) );
				},
			) );

		}
		
		// Map Marker Type
		$wp_customize->add_setting(
			'inspiry_property_map_marker_type', array(
			'type'              => 'option',
			'default'           => 'pin',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_property_map_marker_type', array(
			'label'       => esc_html__( 'Marker Type', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'Choose Map Marker Type', RH_TEXT_DOMAIN ),
			'type'        => 'radio',
			'section'     => 'inspiry_property_map',
			'choices'     => array(
				'pin'    => esc_html__( 'Pin', RH_TEXT_DOMAIN ),
				'circle' => esc_html__( 'Circle', RH_TEXT_DOMAIN ),
			),
		) );

		$wp_customize->add_setting( 'inspiry_property_map_marker_color', array(
			'type'              => 'option',
			'default'           => '#ea723d',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'inspiry_property_map_marker_color', array(
				'label'           => esc_html__( 'Circle Color', RH_TEXT_DOMAIN ),
				'section'         => 'inspiry_property_map',
				'active_callback' => 'inspiry_property_map_marker_circle',
			)
		) );

	}

	add_action( 'customize_register', 'inspiry_property_map_customizer' );
endif;

if ( ! function_exists( 'inspiry_property_map_defaults' ) ) :
	/**
	 * inspiry_property_map_defaults.
	 *
	 * @since  2.6.3
	 */
	function inspiry_property_map_defaults( WP_Customize_Manager $wp_customize ) {
		$property_map_settings_ids = array(
			'theme_display_google_map',
			'theme_property_map_title',
			'inspiry_property_map_marker_type',
		);
		inspiry_initialize_defaults( $wp_customize, $property_map_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_property_map_defaults' );
endif;

if ( ! function_exists( 'inspiry_property_map_title_render' ) ) {
	function inspiry_property_map_title_render() {
		if ( get_option( 'theme_property_map_title' ) ) {
			echo get_option( 'theme_property_map_title' );
		}
	}
}

if ( ! function_exists( 'inspiry_property_map_marker_circle' ) ) {
	/**
	 * Check if Circle is selected as property map marker type.
	 *
	 * @return bool
	 */
	function inspiry_property_map_marker_circle() {

		if ( 'circle' === get_option( 'inspiry_property_map_marker_type', 'pin' ) ) {
			return true;
		}

		return false;
	}
}