<?php
/**
 * Currency Switcher Customizer Settings
 */

if ( ! function_exists( 'inspiry_language_switcher_customizer' ) ) :
	function inspiry_language_switcher_customizer( WP_Customize_Manager $wp_customize ) {

		if ( class_exists( 'SitePress' ) ) {

			$wp_customize->add_setting( 'realhomes_language_switcher_label', array( 'sanitize_callback' => 'sanitize_text_field', ) );
			$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_language_switcher_label',
				array(
					'label'   => esc_html__( 'Language Switcher Settings', RH_TEXT_DOMAIN ),
					'section' => 'inspiry_floating_features_section',
				)
			) );

			/* Enable / Disable WPML Language switcher */
			$wp_customize->add_setting( 'theme_wpml_lang_switcher', array(
				'type'              => 'option',
				'default'           => 'true',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'theme_wpml_lang_switcher', array(
				'label'   => esc_html__( 'WPML Language Switcher Display', RH_TEXT_DOMAIN ),
				'type'    => 'radio',
				'section' => 'inspiry_floating_features_section',
				'choices' => array(
					'true'  => esc_html__( 'Show', RH_TEXT_DOMAIN ),
					'false' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
				),
			) );

			$wp_customize->add_setting( 'theme_switcher_language_display', array(
				'type'              => 'option',
				'default'           => 'inspiry_name_and_flag',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'theme_switcher_language_display', array(
				'label'           => esc_html__( 'Switcher Language Display Options', RH_TEXT_DOMAIN ),
				'type'            => 'radio',
				'section'         => 'inspiry_floating_features_section',
				'choices'         => array(
					'language_name_and_flag' => esc_html__( 'Name and Flag', RH_TEXT_DOMAIN ),
					'language_name_only'     => esc_html__( 'Name Only', RH_TEXT_DOMAIN ),
					'language_flag_only'     => esc_html__( 'Flag Only ', RH_TEXT_DOMAIN ),
				),
				'active_callback' => 'inspiry_wpml_language_switcher_callback'
			) );
		}

	}

	add_action( 'customize_register', 'inspiry_language_switcher_customizer' );
endif;

if ( ! function_exists( 'inspiry_wpml_language_switcher_defaults' ) ) :

	/**
	 * inspiry_user_navigation_defaults.
	 *
	 * @since  2.6.3
	 */

	function inspiry_wpml_language_switcher_defaults( WP_Customize_Manager $wp_customize ) {
		$wpml_language_settings_ids = array(
			'theme_wpml_lang_switcher',
			'theme_switcher_language_display'
		);
		inspiry_initialize_defaults( $wp_customize, $wpml_language_settings_ids );
	}

	add_action( 'customize_save_after', 'inspiry_wpml_language_switcher_defaults' );
endif;


if ( ! function_exists( 'inspiry_wpml_language_switcher_callback' ) ) :

	function inspiry_wpml_language_switcher_callback() {


		if ( 'true' === get_option( 'theme_wpml_lang_switcher', 'true' ) ) {

			return true;
		}

		return false;
	}
endif;