<?php
/**
 * Misc Customizer Settings
 *
 * @package realhomes/customizer
 */
if ( ! function_exists( 'inspiry_floating_features_customizer' ) ) {
	function inspiry_floating_features_customizer( WP_Customize_Manager $wp_customize ) {

		$wp_customize->add_section( 'inspiry_floating_features_section', array(
			'title'    => esc_html__( 'Floating Features', RH_TEXT_DOMAIN ),
			'priority' => 130,
		) );

		$wp_customize->add_setting( 'realhomes_popup_panel_section_label', array( 'sanitize_callback' => 'sanitize_text_field', ) );
		$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_popup_panel_section_label',
			array(
				'label'   => esc_html__( 'Floating Panel Common Settings', RH_TEXT_DOMAIN ),
				'section' => 'inspiry_floating_features_section',
			)
		) );

		$wp_customize->add_setting( 'inspiry_floating_position', array(
			'type'              => 'option',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'inspiry_floating_position', array(
			'label'       => esc_html__( 'Position from Top', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'i.e 150px or 10%', RH_TEXT_DOMAIN ),
			'type'        => 'text',
			'section'     => 'inspiry_floating_features_section',
		) );

		$wp_customize->add_setting( 'inspiry_default_floating_bar_display', array(
			'default'           => 'show',
			'sanitize_callback' => 'inspiry_sanitize_radio',
		) );
		$wp_customize->add_control( 'inspiry_default_floating_bar_display', array(
			'label'       => esc_html__( 'Display on Small Devices', RH_TEXT_DOMAIN ),
			'description' => esc_html__( 'On small devices, the panel will be displayed as a bar.', RH_TEXT_DOMAIN ),
			'section'     => 'inspiry_floating_features_section',
			'type'        => 'radio',
			'settings'    => 'inspiry_default_floating_bar_display',
			'choices'     => array(
				'show' => esc_html__( 'Show', RH_TEXT_DOMAIN ),
				'hide' => esc_html__( 'Hide', RH_TEXT_DOMAIN ),
			),
		) );

		if ( function_exists( 'realhomes_currency_switcher_enabled' ) && realhomes_currency_switcher_enabled() ) {
			$wp_customize->add_setting( 'realhomes_currency_switcher_section_label', array( 'sanitize_callback' => 'sanitize_text_field', ) );
			$wp_customize->add_control( new Inspiry_Heading_Customize_Control( $wp_customize, 'realhomes_currency_switcher_section_label',
				array(
					'label'   => esc_html__( 'Currency Switcher Dropdown', RH_TEXT_DOMAIN ),
					'section' => 'inspiry_floating_features_section',
				)
			) );

			$wp_customize->add_setting( 'inspiry_default_floating_button', array(
				'default'           => 'half',
				'sanitize_callback' => 'inspiry_sanitize_radio',
			) );
			$wp_customize->add_control( 'inspiry_default_floating_button', array(
				'label'    => esc_html__( 'Button Display', RH_TEXT_DOMAIN ),
				'section'  => 'inspiry_floating_features_section',
				'type'     => 'radio',
				'settings' => 'inspiry_default_floating_button',
				'choices'  => array(
					'half' => esc_html__( 'Flag Only', RH_TEXT_DOMAIN ),
					'full' => esc_html__( 'Flag and Currency', RH_TEXT_DOMAIN ),
				),
			) );
		}
	}

	add_action( 'customize_register', 'inspiry_floating_features_customizer' );
}