<?php
/**
 * This file is responsible for displaying the lead detail drawer in CRM.
 *
 * @since 4.4.5
 */
use Realhomes\CRM\Helpers\Drawer_Helper;

$item_id        = $args['item_id'];
$item_type      = $args['item_type'];
$lead           = Realhomes_Crm_Leads::fetch_lead( $item_id );
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );


Drawer_Helper::header( $args['item_action'], $lead, $item_type );
?>

	<div class="relative mt-6 flex-1 px-4 sm:p-8">
		<!-- Avatar and initial details -->
		<div class="flex items-center mb-12">
			<div class="size-20 shrink-0">
				<img class="size-20 rounded-full" src="<?php
				echo get_avatar_url( $lead->email ) ?>" alt="Avatar">
			</div>
			<div class="ml-4">
				<div class="text-base font-medium text-gray-900 mb-2"><?php
					echo esc_html( ! empty( $lead->name_prefix ) ? $lead->name_prefix . ' ' : '' ) . esc_html( ! empty( $lead->display_name ) ? $lead->display_name : $lead->first_name . ' ' . $lead->last_name ); ?></div>
				<div class="flex items-center text-sm">
					<div class="text-gray-700 flex mr-4">
						<?php
						Realhomes_Crm_SVG::the_svg( 'email', 'size-8 mr-2' ); ?>
						<a href="mailto:<?php echo esc_html( $lead->email ); ?>"><?php echo esc_html( $lead->email ); ?></a>
					</div>
					<?php
					if ( $lead->mobile ) {
						?>
						<span class="size-2 bg-current rounded-full mr-4"></span>
						<div class="text-gray-700 flex">
							<?php
							Realhomes_Crm_SVG::the_svg( 'mobile', 'size-8 mr-2' );
							echo ! empty( $lead->mobile ) ? '<a href="tel:' . esc_attr( $lead->mobile ) . '" target="_blank">' . esc_html( $lead->mobile ) . '</a>' : $fallback_value;
							?>
						</div>
						<?php
					}
					?>
				</div>
			</div>
		</div>

		<!-- Lead complete details -->
		<div class="border-t border-gray-100 text-sm mb-16">
			<dl class="pt-14">
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-normal text-gray-900 flex items-center">
						<?php
						Realhomes_Crm_SVG::the_svg( 'user', 'size-6 mr-4' ); ?><?php
						esc_html_e( 'User Type', RH_TEXT_DOMAIN ); ?>
					</dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
                    <span class="px-4 py-1 bg-orange-100 rounded text-orange-700">
                        <span class="size-2 bg-orange-700 rounded-full mr-4 align-middle inline-block"></span>
                        <?php
                        echo esc_html( $lead->type ); ?>
                    </span>
					</dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-normal text-gray-900 flex items-center">
						<?php
						Realhomes_Crm_SVG::the_svg( 'stage', 'size-6 mr-4' ); ?><?php
						esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?>
					</dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
                        <span class="px-4 py-1 bg-green-100 rounded text-green-700">
                            <span class="size-2 bg-green-700 rounded-full mr-4 align-middle inline-block"></span>
                            <?php
                            echo esc_html( $lead->status ); ?>
                        </span>
					</dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-normal text-gray-900 flex items-center">
						<?php
						Realhomes_Crm_SVG::the_svg( 'clock', 'size-6 mr-4' ); ?><?php
						esc_html_e( 'Created At', RH_TEXT_DOMAIN ); ?>
					</dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( Realhomes_Crm_Helper::human_readable_date( $lead->created_at ) ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-normal text-gray-900 flex items-center">
						<?php
						Realhomes_Crm_SVG::the_svg( 'last_updated', 'size-6 mr-4' ); ?><?php
						esc_html_e( 'Last Updated', RH_TEXT_DOMAIN ); ?>
					</dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo esc_html( Realhomes_Crm_Helper::human_readable_date( $lead->updated_at ) ); ?></dd>
				</div>
			</dl>

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Person Details', RH_TEXT_DOMAIN ); ?></h3>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'First Name', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->first_name ) ? $fallback_value : esc_html( $lead->first_name ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Last Name', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->last_name ) ? $fallback_value : esc_html( $lead->last_name ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Home Phone', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->home_phone ) ? $fallback_value : esc_html( $lead->home_phone ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Work Phone', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->work_phone ) ? $fallback_value : esc_html( $lead->work_phone ); ?></dd>
				</div>
			</dl>

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Address Information', RH_TEXT_DOMAIN ); ?></h3>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'City', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->city ) ? $fallback_value : esc_html( $lead->city ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'State', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->state ) ? $fallback_value : esc_html( $lead->state ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Country', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->country ) ? $fallback_value : esc_html( $lead->country ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Zipcode', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $lead->zipcode ) ? $fallback_value : esc_html( $lead->zipcode ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Address', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:mt-0"><?php
						echo empty( $lead->address ) ? $fallback_value : esc_html( $lead->address ); ?></dd>
				</div>
			</dl>

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Other Details', RH_TEXT_DOMAIN ); ?></h3>
				<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex"><?php
						esc_html_e( 'User Message', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm/8 text-gray-700 sm:mt-0"><?php
						echo empty( $lead->message ) ? $fallback_value : esc_html( $lead->message ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6 bg-gray-100 rounded">
					<dt class="text-sm font-[500] text-gray-900 flex"><?php
						esc_html_e( 'Private Note', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm/8 text-gray-700 sm:mt-0 mb-0"><?php
						echo empty( $lead->private_note ) ? $fallback_value : esc_html( $lead->private_note ); ?></dd>
				</div>
			</dl>
		</div>

		<!-- Lead tabbed information -->
		<div class="realhomes-crm-tabs-wrapper">

			<div class="rh-crm-tabs-links">
				<div class="border-t border-b border-gray-200">
					<nav class="-mb-px flex space-x-8" aria-label="Tabs">
						<a id="rh-crm-notes-tab-link" data-tab="tab1" class="rh-crm-tab-link active" aria-current="page">
							<?php
							esc_html_e( 'Notes', RH_TEXT_DOMAIN ); ?>
							<span>
                                <?php
                                $notes = Realhomes_Crm_Notes::fetch_notes( $item_id, $item_type );
                                echo count( $notes );
                                ?>
                            </span>
						</a>
						<a data-tab="tab2" class="rh-crm-tab-link">
							<?php
							esc_html_e( 'Related Inquiries', RH_TEXT_DOMAIN ); ?>
							<span>
                                <?php
                                $inquiries = Realhomes_Crm_Inquiries::fetch_inquiries( array( 'lead_id' => $item_id ) );
                                echo count( $inquiries );
                                ?>
                            </span>
						</a>

						<a data-tab="tab3" class="rh-crm-tab-link">
							<?php
							esc_html_e( 'User Saved Searched', RH_TEXT_DOMAIN ); ?>
							<span>
                                <?php
                                $saved_searches = Realhomes_Crm_Leads::fetch_lead_saved_searches( $lead->email );
                                echo is_array( $saved_searches ) ? count( $saved_searches ) : 0;
                                ?>
                            </span>
						</a>
					</nav>
				</div>
			</div><!-- Tabs Links -->

			<div class="rh-crm-tabs-contents">
				<div class="rh-crm-tab-content py-10" id="tab1">
					<?php get_template_part( 'common/dashboard/crm/common/notes', null, array( 'item_id' => $item_id, 'item_type' => $item_type, 'notes' => $notes ) ) ?>
				</div>
				<div class="rh-crm-tab-content py-10 hidden" id="tab2">
					<?php
					get_template_part( 'common/dashboard/crm/leads/related-inquiries', null, array( 'inquiries' => $inquiries ) ); ?>
				</div>
				<div class="rh-crm-tab-content py-10 hidden" id="tab3">
					<?php
					get_template_part( 'common/dashboard/crm/leads/saved-searches', null, array( 'saved_searches' => $saved_searches ) ) ?>
				</div>
			</div><!-- CRM Tabs Contents -->

		</div><!-- CRM Tabs -->

	</div>
<?php
Drawer_Helper::footer( $args['item_action'] );