<?php
/**
 * This file is used to render the add/edit lead drawer form.
 *
 * @since 4.4.5
 *
 * @var array   $args        {
 *                           The arguments array.
 *
 * @type string $item_action The action being performed ('add' or 'edit').
 * @type int    $item_id     The ID of the item being edited (if action is 'edit').
 * @type string $item_type   The type of item ('lead').
 *                           }
 */

use Realhomes\CRM\Helpers\Drawer_Helper;

$is_edit = ( $args['item_action'] === 'edit' );

// Fetch the lead data only if editing
if ( $is_edit ) {
	$lead = Realhomes_Crm_Leads::fetch_lead( $args['item_id'] );
}

Drawer_Helper::header( $args['item_action'], $lead ?? null, $args['item_type'] );
?>

	<div class="border-b border-gray-900/10 pb-12 mb-12">
		<h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'Personal Information', RH_TEXT_DOMAIN ); ?></h2>

		<div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

			<div class="sm:col-span-2 sm:col-start-1">
				<label for="name-prefix" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Name Prefix', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2 grid grid-cols-1">
					<?php
					$name_prefixes = Realhomes_Crm_Helper::get_setting( 'lead_name_prefixes', explode: true ); ?>
					<select id="name-prefix" name="name_prefix" autocomplete="name-prefix" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $name_prefixes as $name_prefix ) {
							echo '<option value="' . esc_attr( $name_prefix ) . '" ' . selected( $name_prefix, $is_edit ? $lead->name_prefix : '' ) . '>' . esc_html( $name_prefix ) . '</option>';
						}
						?>
					</select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="first-name" class="block text-sm/6 font-medium text-gray-900">
					<i class="text-red-500 not-italic">*</i>
					<?php esc_html_e( 'First Name', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2">
					<input type="text" name="first_name" id="first-name" autocomplete="first-name" value="<?php
					echo esc_attr( $is_edit ? $lead->first_name : '' ); ?>" class="rh-crm-input" required>
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="last-name" class="block text-sm/6 font-medium text-gray-900">
					<i class="text-red-500 not-italic">*</i>
					<?php esc_html_e( 'Last Name', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2">
					<input type="text" name="last_name" id="last-name" autocomplete="last-name" value="<?php
					echo esc_attr( $is_edit ? $lead->last_name : '' ); ?>" class="rh-crm-input" required>
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="display-name" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Display Name', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="display_name" id="display-name" autocomplete="display-name" value="<?php echo esc_attr( $is_edit ? $lead->display_name : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="email" class="block text-sm/6 font-medium text-gray-900">
					<i class="text-red-500 not-italic">*</i>
					<?php esc_html_e( 'Email', RH_TEXT_DOMAIN ); ?>
				</label>
				<div class="mt-2">
					<input type="email" name="email" id="email" autocomplete="email" value="<?php
					echo esc_attr( $is_edit ? $lead->email : '' ); ?>" class="rh-crm-input" required>
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="mobile" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Mobile', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="mobile" id="mobile" autocomplete="mobile" value="<?php
					echo esc_attr( $is_edit ? $lead->mobile : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="home-phone" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Home Phone', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="home_phone" id="home-phone" autocomplete="home-phone" value="<?php
					echo esc_attr( $is_edit ? $lead->home_phone : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="work-phone" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Work Phone', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="work_phone" id="work-phone" autocomplete="work-phone" value="<?php
					echo esc_attr( $is_edit ? $lead->work_phone : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

		</div>
	</div>

	<div class="border-b border-gray-900/10 pb-12 mb-12">
		<h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'Lead Status', RH_TEXT_DOMAIN ); ?></h2>
		<p class="mt-1 text-sm/6 text-gray-600"><?php
			esc_html_e( 'You can manage the lead type, status and source in this section', RH_TEXT_DOMAIN ); ?></p>

		<div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

			<div class="sm:col-span-3 sm:col-start-1">
				<label for="type" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Lead Type', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2 grid grid-cols-1">
					<?php
					$lead_types = Realhomes_Crm_Helper::get_setting( 'lead_types', explode: true ); ?>
					<select id="type" name="type" autocomplete="type" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $lead_types as $lead_type ) {
							echo '<option value="' . esc_attr( $lead_type ) . '" ' . selected( $lead_type, $is_edit ? $lead->type : '' ) . '>' . esc_html( $lead_type ) . '</option>';
						}
						?>
					</select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="status" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Lead Status', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2 grid grid-cols-1">
					<?php
					$lead_statuses = Realhomes_Crm_Helper::get_setting( 'lead_statuses', explode: true ); ?>
					<select id="status" name="status" autocomplete="status" class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pl-3 pr-8 text-base text-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 focus:outline focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600 sm:text-sm/6">
						<?php
						foreach ( $lead_statuses as $lead_status ) {
							echo '<option value="' . esc_attr( $lead_status ) . '" ' . selected( $lead_status, $is_edit ? $lead->status : '' ) . '>' . esc_html( $lead_status ) . '</option>';
						}
						?>
					</select>
					<?php
					Realhomes_Crm_SVG::the_svg( 'chevron', 'size-4' ); ?>
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="source" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Lead Source', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="source" id="source" autocomplete="source" value="<?php
					echo esc_attr( $is_edit ? $lead->source : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-3">
				<label for="source-url" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Lead Source URL', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="url" name="source_url" id="source-url" autocomplete="source-url" value="<?php
					echo esc_attr( $is_edit ? $lead->source_url : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

		</div>
	</div>

	<div class="border-b border-gray-900/10 pb-12 mb-12">
		<h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'Address Information', RH_TEXT_DOMAIN ); ?></h2>

		<div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

			<div class="sm:col-span-2 sm:col-start-1">
				<label for="city" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'City', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="city" id="city" autocomplete="city" value="<?php
					echo esc_attr( $is_edit ? $lead->city : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="state" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'State', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="state" id="state" autocomplete="state" value="<?php
					echo esc_attr( $is_edit ? $lead->state : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="country" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Country', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="country" id="country" autocomplete="country" value="<?php
					echo esc_attr( $is_edit ? $lead->country : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-4">
				<label for="address" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Address', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="text" name="address" id="address" autocomplete="address" value="<?php
					echo esc_attr( $is_edit ? $lead->address : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="zipcode" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Zip Code', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="number" name="zipcode" id="zipcode" autocomplete="zipcode" value="<?php
					echo esc_attr( $is_edit ? $lead->zipcode : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

		</div>
	</div>

	<div class="border-b border-gray-900/10 pb-12 mb-12">
		<h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'Social Profiles', RH_TEXT_DOMAIN ); ?></h2>

		<div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

			<div class="sm:col-span-2 sm:col-start-1">
				<label for="x-url" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'X URL', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="url" name="x_url" id="x-url" autocomplete="x-url" value="<?php
					echo esc_attr( $is_edit ? $lead->x_url : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="facebook-url" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Facebook URL', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="url" name="facebook_url" id="facebook-url" autocomplete="facebook-url" value="<?php
					echo esc_attr( $is_edit ? $lead->facebook_url : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

			<div class="sm:col-span-2">
				<label for="linkedin-url" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Linkedin URL', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<input type="url" name="linkedin_url" id="linkedin-url" autocomplete="linkedin-url" value="<?php
					echo esc_attr( $is_edit ? $lead->linkedin_url : '' ); ?>" class="rh-crm-input">
				</div>
			</div>

		</div>
	</div>

	<div class="border-b border-gray-900/10 pb-12 mb-12">
		<h2 class="text-base/7 font-semibold text-gray-900"><?php
			esc_html_e( 'Lead Message & Private Note', RH_TEXT_DOMAIN ); ?></h2>

		<div class="mt-10 grid grid-cols-1 gap-x-6 gap-y-8 sm:grid-cols-6">

			<div class="sm:col-span-6 sm:col-start-1">
				<label for="message" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Message', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<textarea name="message" id="message" autocomplete="message" class="rh-crm-input"><?php echo esc_attr( $is_edit ? $lead->message : '' ); ?></textarea>
				</div>
			</div>

			<div class="sm:col-span-6">
				<label for="private-note" class="block text-sm/6 font-medium text-gray-900"><?php
					esc_html_e( 'Private Note', RH_TEXT_DOMAIN ); ?></label>
				<div class="mt-2">
					<textarea name="private_note" id="private-note" autocomplete="private-note" class="rh-crm-input"><?php echo esc_attr( $is_edit ? $lead->private_note : '' ); ?></textarea>
				</div>
			</div>
		</div>
	</div>

<?php
Drawer_Helper::footer( $args['item_action'], $lead ?? null, $args['item_type'] ); ?>