<?php
/**
 * This file is responsible for leads list page.
 *
 * @since 4.4.5
 */

$page_type = 'lead';

// Prepare args and fetch items from the CRM class
$args           = Realhomes_Crm_Helper::prepare_listing_page_args( $page_type );
$leads          = Realhomes_Crm_Leads::fetch_leads( [ 'number' => $args['items_per_page'], 'keyword' => $args['searched_word'], 'offset' => $args['offset'] ] );
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback' );

if ( ! empty( $leads ) || isset( $_GET['posts_search'] ) ) {
	?>
	<!--Leads Stats-->
	<div id="rh-crm-leads-stats" class=" grid grid-cols-3 divide-x item-center shadow-sm rounded-md py-4 bg-white my-10"></div>

	<!--Leads Header-->
	<?php
	Realhomes_Crm_Helper::listing_header( $page_type, $args['searched_word'] );
	if ( $leads ) {
		?>
		<!--Lead Items-->
		<div id="rh-crm-<?php echo Realhomes_Crm_Helper::get_page_type_plurals()[ $page_type ]; ?>-items" class="py-4 sm:px-6 lg:px-8 bg-white min-w-full max-w-full overflow-x-auto overflow-y-hidden">
			<table class="min-w-full divide-y divide-gray-200">
				<thead>
				<tr>
					<th scope="col" class="py-6 pl-4 pr-3 w-[40px]">
						<?php Realhomes_Crm_Helper::items_select_checkbox(); ?>
					</th>
					<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Person', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Contacts', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Type', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="py-6 pl-4 pr-3 text-left text-sm font-[500] text-gray-900"><?php esc_html_e( 'Source', RH_TEXT_DOMAIN ); ?></th>
					<th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-0">
						<span class="sr-only"><?php esc_html_e( 'Actions', RH_TEXT_DOMAIN ); ?></span>
					</th>
				</tr>
				</thead>
				<tbody class="divide-y divide-gray-200">
				<?php
				// Loop through each lead and output data in table rows
				$last_key = array_key_last( $leads );
				foreach ( $leads as $key => $lead ) {
					?>
					<tr class="rh-crm-item-wrapper hover:bg-gray-50 transition duration-200">
						<td class="whitespace-nowrap py-8 pl-4 pr-3 text-sm">
							<?php Realhomes_Crm_Helper::item_select_checkbox( $page_type, $lead->id ); ?>
						</td>
						<td class="whitespace-nowrap py-8 pl-4 pr-3 text-sm">
							<div class="flex items-center">
								<div class="size-14 shrink-0">
									<img class="size-14 rounded-full" src="<?php echo get_avatar_url( $lead->email ); ?>" alt="Avatar">
								</div>
								<div class="ml-4">
									<div class="font-medium text-gray-900"><?php echo esc_html( ! empty( $lead->display_name ) ? $lead->display_name : $lead->first_name . ' ' . $lead->last_name ); ?></div>
									<div class="mt-2 text-gray-500"><?php echo esc_html( Realhomes_Crm_Helper::human_readable_date( $lead->created_at ) ); ?></div>
								</div>
							</div>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<div class="mt-2 text-gray-900 flex items-center mb-2.5">
								<?php
								Realhomes_Crm_SVG::the_svg( 'email', 'size-6 mr-1' );
								echo ! empty( $lead->email ) ? '<a href="mailto:' . esc_attr( $lead->email ) . '" target="_blank">' . esc_html( $lead->email ) . '</a>' : $fallback_value;
								?>
							</div>
							<?php
							if ( ! empty( $lead->mobile ) ) {
								?>
								<div class="text-gray-900 flex items-center">
									<?php
									Realhomes_Crm_SVG::the_svg( 'mobile', 'size-6 mr-1' );
									echo ! empty( $lead->mobile ) ? '<a href="tel:' . esc_attr( $lead->mobile ) . '" target="_blank">' . esc_html( $lead->mobile ) . '</a>' : $fallback_value;
									?>
								</div>
								<?php
							}
							?>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500"><?php echo ! empty( $lead->type ) ? esc_html( $lead->type ) : $fallback_value; ?></td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							echo ! empty( $lead->type ) ? '<span class="inline-flex items-center rounded-md bg-green-50 px-2 py-1 text-xs font-medium text-green-700 ring-1 ring-inset ring-green-600/20">' . esc_html( $lead->status ) . '</span>' : $fallback_value;
							?>
						</td>
						<td class="whitespace-nowrap px-3 py-5 text-sm text-gray-500">
							<?php
							echo ( ! empty( $lead->source ) && ! empty( $lead->source_url ) ) ? '<a href="' . esc_url( $lead->source_url ) . '" target="_blank" class="text-[var(--dashboard-primary-color)] hover:text-slate-700">' . esc_html( $lead->source ) . '</a>' : $fallback_value;
							?>
						</td>
						<td class="whitespace-nowrap py-5 pl-3 pr-4 text-sm sm:pr-0">
							<?php Realhomes_Crm_Helper::the_item_actions( $lead->id, $page_type, $key === $last_key ); ?>
						</td>
					</tr>
				<?php } ?>

				</tbody>
			</table>
		</div>

		<!--Leads Footer & Action Buttons-->
		<?php
		Realhomes_Crm_Helper::listing_footer( $args['offset'], $args['current_page'], $args['items_per_page'], $args['total_items'], $page_type );
		Realhomes_Crm_Helper::selected_items_action_buttons( $page_type );
	} else {
		Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No leads found matching your query :(', RH_TEXT_DOMAIN ) );
	}
} else {
	Realhomes_Crm_Helper::no_item_found_note( page_type: $page_type );
}
?>

