<?php
/**
 * Display Matched Properties for an Inquiry
 *
 * This template displays the properties that match the criteria of a specific inquiry.
 *
 * @since 4.4.5
 *
 * @var array $args {
 *     @type int        $found       Number of matched properties found.
 *     @type WP_Query   $properties  WP_Query object containing the matched properties.
 *     @type array      $query       The query parameters used to find matched properties.
 *     @type string     $lead_email  The email address of the lead associated with the inquiry.
 * }
 */
$found      = $args['found'];
$properties = $args['properties'];
$query      = $args['query'];
$lead_email = $args['lead_email'];

// Display the matching properties
if ( $found > 0 && $properties->have_posts() ) {
	if ( ! empty( $lead_email ) && ! empty( $query ) ) {
		?>
		<!-- Form to send matched listing via email to lead email address -->
		<form id="rh-crm-send-matched-listing">
			<div class="flex justify-between mb-10">
				<div>
					<input type="hidden" name="lead_email" value="<?php echo sanitize_email( $lead_email ); ?>">
					<input type="hidden" name="inquiry_query" value="<?php echo esc_attr( json_encode( $query ) ); ?>">
				</div>
				<button class="inline-flex items-center gap-x-1.5 rounded-md bg-[var(--dashboard-primary-color)] px-3 py-2 text-sm font-semibold text-white shadow-sm hover:bg-slate-700 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-teal-600">
					<?php
					Realhomes_Crm_SVG::the_svg( 'paper-plane', 'size-5 -ml-0.5' );
					esc_html_e( 'Send Matched Listings via Email', RH_TEXT_DOMAIN )
					?>
				</button>
			</div>
		</form>
		<?php
	}
	?>

	<!--Matched Listings to the Inquiry-->
	<div id="rh-crm-matched-listing" class="max-w-full overflow-x-scroll shadow ring-1 ring-black/5 sm:rounded-lg">
		<table class="min-w-full divide-y divide-gray-300">
			<thead class="bg-gray-50">
			<tr>
				<th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-gray-900 sm:pl-6"><?php esc_html_e( 'ID', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Type', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Beds', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Baths', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Built Area', RH_TEXT_DOMAIN ); ?></th>
				<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900"><?php esc_html_e( 'Price', RH_TEXT_DOMAIN ); ?></th>
			</tr>
			</thead>
			<tbody class="divide-y divide-gray-200 bg-white">

			<?php
			while ( $properties->have_posts() ) {
				$properties->the_post();

				// Get all terms for property type and status
				$property_types    = get_the_terms( get_the_ID(), 'property-type' );
				$property_statuses = get_the_terms( get_the_ID(), 'property-status' );

				// Initialize variables with a default empty value
				$first_property_type   = '';
				$first_property_status = '';

				// Check for property types and get the name of the first one
				if ( ! empty( $property_types ) && ! is_wp_error( $property_types ) ) {
					$first_property_type = esc_html( $property_types[0]->name );
				}

				// Check for property statuses and get the name of the first one
				if ( ! empty( $property_statuses ) && ! is_wp_error( $property_statuses ) ) {
					$first_property_status = esc_html( $property_statuses[0]->name );
				}

				?>
				<tr>
					<td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-gray-900 sm:pl-6"><a target="_blank" href="<?php the_permalink(); ?>"><?php echo esc_html( get_post_meta( get_the_ID(), 'REAL_HOMES_property_id', true ) ); ?></a></td>
					<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( $first_property_type ); ?></td>
					<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( $first_property_status ); ?></td>
					<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( get_post_meta( get_the_ID(), 'REAL_HOMES_property_bedrooms', true ) ); ?></td>
					<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( get_post_meta( get_the_ID(), 'REAL_HOMES_property_bathrooms', true ) ); ?></td>
					<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( get_post_meta( get_the_ID(), 'REAL_HOMES_property_size', true ) ); ?></td>
					<td class="whitespace-nowrap px-3 py-4 text-sm text-gray-500"><?php echo esc_html( get_post_meta( get_the_ID(), 'REAL_HOMES_property_price', true ) ); ?></td>
				</tr>
				<?php
			}
			?>
			</tbody>
		</table>
	</div>
	<?php
	wp_reset_postdata();
} else {
	Realhomes_Crm_Helper::no_item_found_note( description: esc_html__( 'No matched properties found to this inquiry.', RH_TEXT_DOMAIN ), classes: 'bg-white', icon_size: 'size-20' );
}
?>