<?php
/**
 * Inquiry Detail Drawer
 *
 * @since 4.4.5
 *
 * @var array $args Drawer arguments.
 */
use \RealHomes\CRM\Helpers\Drawer_Helper;

$item_id   = $args['item_id'];
$item_type = $args['item_type'];
$inquiry   = Realhomes_Crm_Inquiries::fetch_inquiry( $item_id );

$lead_name      = $lead_email = '';
$fallback_value = Realhomes_Crm_Helper::get_setting( 'empty_values_fallback', '-' );

if ( ! empty( $inquiry->lead_id ) ) {
	$lead       = Realhomes_Crm_Leads::fetch_lead( (int) $inquiry->lead_id );
	$lead_name  = ! empty( $lead->display_name ) ? $lead->display_name : $lead->first_name . ' ' . $lead->lead_name;
	$lead_email = ! empty( $lead->email ) ? $lead->email : '';
}

$query = maybe_unserialize( $inquiry->query );


$draw_heading = ! empty( $lead_name ) ? esc_html( $lead_name ) . "<span class='text-gray-500'>" . esc_html__( "'s Inquiry Preview", RH_TEXT_DOMAIN ) . "</span>" : '';

Drawer_Helper::header( $args['item_action'], $inquiry, $args['item_type'], $draw_heading );
?>

	<div class="relative mt-6 flex-1 px-4 sm:p-8">

		<!-- Inquiry complete details -->
		<dl>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'stage', 'size-6 mr-4' ); ?><?php
					esc_html_e( 'Type', RH_TEXT_DOMAIN ); ?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
					<?php
					if ( ! empty( $inquiry->type ) ) {
						?>
						<span class="px-4 py-1 bg-orange-100 rounded text-orange-700">
                        <span class="size-2 bg-orange-700 rounded-full mr-4 align-middle inline-block"></span>
                            <?php
                            echo esc_html( $inquiry->type ); ?>
                        </span>
						<?php
					} else {
						echo $fallback_value;
					}
					?>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'stage', 'size-6 mr-4' ); ?><?php
					esc_html_e( 'Status', RH_TEXT_DOMAIN ); ?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
					<?php
					if ( ! empty( $inquiry->status ) ) {
						?>
						<span class="px-4 py-1 bg-green-100 rounded text-green-700">
                        <span class="size-2 bg-green-700 rounded-full mr-4 align-middle inline-block"></span>
                        <?php
                        echo esc_html( $inquiry->status ); ?>
                    </span>
						<?php
					} else {
						echo $fallback_value;
					}
					?>
				</dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'clock', 'size-6 mr-4' ); ?><?php
					esc_html_e( 'Created At', RH_TEXT_DOMAIN ); ?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
					echo esc_html( Realhomes_Crm_Helper::human_readable_date( $inquiry->created_at ) ); ?></dd>
			</div>
			<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
				<dt class="text-sm font-normal text-gray-900 flex items-center">
					<?php
					Realhomes_Crm_SVG::the_svg( 'last_updated', 'size-6 mr-4' ); ?><?php
					esc_html_e( 'Last Updated', RH_TEXT_DOMAIN ); ?>
				</dt>
				<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
					echo esc_html( Realhomes_Crm_Helper::human_readable_date( $inquiry->updated_at ) ); ?></dd>
			</div>
		</dl>

		<div class="border-t border-gray-100 text-sm mb-16">
			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Inquiry Query Information', RH_TEXT_DOMAIN ); ?></h3>

				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Property Type', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $query['property-type'] ) ? $fallback_value : esc_html( Realhomes_Crm_Helper::format_label( is_array( $query['property-type'] ) ? $query['property-type'][0] : $query['property-type'] ) ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Property Status', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $query['property-status'] ) ? $fallback_value : esc_html( Realhomes_Crm_Helper::format_label( is_array( $query['property-status'] ) ? $query['property-status'][0] : $query['property-status'] ) ); ?></dd>
				</div>

				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Beds', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
						<?php
						echo ! empty( $query['min-beds'] ) ? esc_html( $query['min-beds'] ) : '';
						echo ' - ';
						echo ! empty( $query['max-beds'] ) ? esc_html( $query['max-beds'] ) : '';
						?>
					</dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Baths', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
						<?php
						echo ! empty( $query['min-baths'] ) ? esc_html( $query['min-baths'] ) : '';
						echo ' - ';
						echo ! empty( $query['max-baths'] ) ? esc_html( $query['max-baths'] ) : '';
						?>
					</dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Garages', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
						<?php
						echo ! empty( $query['min-garage'] ) ? esc_html( $query['min-garage'] ) : '';
						echo ' - ';
						echo ! empty( $query['max-garage'] ) ? esc_html( $query['max-garage'] ) : '';
						?>
					</dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Built Area', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
						<?php
						echo ! empty( $query['min-area'] ) ? esc_html( $query['min-area'] ) : '';
						echo ' - ';
						echo ! empty( $query['max-area'] ) ? esc_html( $query['max-area'] ) : '';
						?>
					</dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Price', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0">
						<?php
						echo ! empty( $query['min-price'] ) ? esc_html( ere_format_amount( floatval( $query['min-price'] ) ) ) : '';
						echo ' - ';
						echo ! empty( $query['max-price'] ) ? esc_html( ere_format_amount( floatval( $query['max-price'] ) ) ) : '';
						?>
					</dd>
				</div>

				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Location', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $query['property-city'] ) ? $fallback_value : esc_html( Realhomes_Crm_Helper::format_label( is_array( $query['property-city'] ) ? $query['property-city'][0] : $query['property-city'] ) ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Zipcode', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $query['property-zipcode'] ) ? $fallback_value : esc_html( $query['property-zipcode'] ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex items-center"><?php
						esc_html_e( 'Address', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm text-gray-700 sm:col-span-2 sm:mt-0"><?php
						echo empty( $query['property-address'] ) ? $fallback_value : esc_html( $query['property-address'] ); ?></dd>
				</div>
			</dl>

			<dl class="pt-10">
				<h3 class="text-base"><?php
					esc_html_e( 'Other Details', RH_TEXT_DOMAIN ); ?></h3>
				<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6">
					<dt class="text-sm font-[500] text-gray-900 flex"><?php
						esc_html_e( 'User Message', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm/8 text-gray-700 sm:mt-0"><?php
						echo empty( $inquiry->message ) ? $fallback_value : esc_html( $inquiry->message ); ?></dd>
				</div>
				<div class="px-4 py-4 sm:grid sm:grid-cols-1 sm:gap-4 sm:px-6 bg-gray-100 rounded">
					<dt class="text-sm font-[500] text-gray-900 flex"><?php
						esc_html_e( 'Private Note', RH_TEXT_DOMAIN ); ?></dt>
					<dd class="mt-1 text-sm/8 text-gray-700 sm:mt-0 mb-0"><?php
						echo empty( $inquiry->private_note ) ? $fallback_value : esc_html( $inquiry->private_note ); ?></dd>
				</div>
			</dl>

		</div>

		<!-- Inquiry tabbed information -->
		<div class="realhomes-crm-tabs-wrapper">

			<div class="rh-crm-tabs-links">
				<div class="border-t border-b border-gray-200">
					<nav class="-mb-px flex space-x-8" aria-label="Tabs">
						<a data-tab="tab1" class="rh-crm-tab-link active" aria-current="page">
							<?php
							esc_html_e( 'Matched Properties', RH_TEXT_DOMAIN ); ?>
							<span>
                                <?php
                                $found_properties = 0;
                                if ( ! empty( $query ) && is_array( $query ) ) {
	                                $query_args       = apply_filters( 'realhomes_crm_match_listing_args', $query );
	                                $properties       = new WP_Query( $query_args );
	                                $found_properties = $properties->found_posts;
                                } else {
	                                $properties = array();
                                }
                                echo $found_properties;
                                ?>
                            </span>
						</a>
						<a id="rh-crm-notes-tab-link" data-tab="tab2" class="rh-crm-tab-link">
							<?php
							esc_html_e( 'Notes', RH_TEXT_DOMAIN ); ?>
							<span>
                                <?php
                                $notes = Realhomes_Crm_Notes::fetch_notes( $item_id, $item_type );
                                echo count( $notes );
                                ?>
                            </span>
						</a>
					</nav>
				</div>
			</div><!-- Tabs Links -->

			<div class="rh-crm-tabs-contents">
				<div class="rh-crm-tab-content py-10" id="tab1">
					<?php
					get_template_part( 'common/dashboard/crm/inquiries/matched-properties', null, array( 'found' => $found_properties, 'properties' => $properties, 'query' => $query, 'lead_email' => $lead_email ) ); ?>
				</div>
				<div class="rh-crm-tab-content py-10 hidden" id="tab2">
					<?php
					get_template_part( 'common/dashboard/crm/common/notes', null, array( 'item_id' => $item_id, 'item_type' => $item_type, 'notes' => $notes ) ) ?>
				</div>
			</div><!-- CRM Tabs Contents -->

		</div><!-- CRM Tabs -->

	</div>
<?php
Drawer_Helper::footer( $args['item_action'] );