<?php
/**
 * Containing dynamic css compare properties style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage common
 */

$compare_styles_keys = array(
	'theme_compare_switcher_background',
	'theme_compare_switcher_selected_text',
	'theme_compare_switcher_background_open',
	'theme_compare_switcher_text_open',
	'theme_compare_view_background',
	'theme_compare_view_title_color',
	'theme_compare_view_property_title_color',
	'theme_compare_view_property_title_hover_color',
	'theme_compare_view_property_button_background',
	'theme_compare_view_property_button_text',
	'theme_compare_view_property_button_hover',
	'theme_compare_view_property_button_text_hover',
	array( 'inspiry_stp_position_from_bottom', '40px' )
);

$compare_style_options = realhomes_get_options( $compare_styles_keys );

$compare_array[] = array(
	'elements' => '.rh_floating_compare_button',
	'property' => 'background',
	'value'    => $compare_style_options[ 'theme_compare_switcher_background' ],
);

$compare_array[] = array(
	'elements' => '.rh_floating_compare_button',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_switcher_selected_text' ],
);

$compare_array[] = array(
	'elements' => '.rh_floating_compare_button svg',
	'property' => 'fill',
	'value'    => $compare_style_options[ 'theme_compare_switcher_selected_text' ],
);

$compare_array[] = array(
	'elements' => '.rh_compare_open .rh_floating_compare_button',
	'property' => 'background',
	'value'    => $compare_style_options[ 'theme_compare_switcher_background_open' ],
);

$compare_array[] = array(
	'elements' => '.rh_floating_compare_button:hover',
	'property' => 'background',
	'value'    => $compare_style_options[ 'theme_compare_switcher_background_open' ],
);

$compare_array[] = array(
	'elements' => '.rh_floating_compare_button:hover',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_switcher_text_open' ],
);

$compare_array[] = array(
	'elements' => '.rh_floating_compare_button:hover svg',
	'property' => 'fill',
	'value'    => $compare_style_options[ 'theme_compare_switcher_text_open' ],
);

$compare_array[] = array(
	'elements' => '.rh_compare_open .rh_floating_compare_button',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_switcher_text_open' ],
);

$compare_array[] = array(
	'elements' => '.rh_compare_open .rh_floating_compare_button svg',
	'property' => 'fill',
	'value'    => $compare_style_options[ 'theme_compare_switcher_text_open' ],
);

$compare_array[] = array(
	'elements' => '.rh_compare',
	'property' => 'background',
	'value'    => $compare_style_options[ 'theme_compare_view_background' ],
);

$compare_array[] = array(
	'elements' => '.rh_compare .title',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_view_title_color' ],
);

$compare_array[] = array(
	'elements' => '.rh_compare__slide_img .rh_compare_view_title',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_view_property_title_color' ],
);

$compare_array[] = array(
	'elements' => '
		.rh_compare__slide_img .rh_compare_view_title:hover,
			.rh_floating_classic .rh_compare__slide_img .rh_compare_view_title:hover
		',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_view_property_title_hover_color' ],
);

$compare_array[] = array(
	'elements' => '.rh_fixed_side_bar_compare .rh_compare__submit',
	'property' => 'background',
	'value'    => $compare_style_options[ 'theme_compare_view_property_button_background' ],
);

$compare_array[] = array(
	'elements' => '.rh_fixed_side_bar_compare .rh_compare__submit',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_view_property_button_text' ],
);

$compare_array[] = array(
	'elements' => '.rh_fixed_side_bar_compare .rh_compare__submit:hover',
	'property' => 'background',
	'value'    => $compare_style_options[ 'theme_compare_view_property_button_hover' ],
);

$compare_array[] = array(
	'elements' => '.rh_fixed_side_bar_compare .rh_compare__submit:hover',
	'property' => 'color',
	'value'    => $compare_style_options[ 'theme_compare_view_property_button_text_hover' ],
);

$compare_array[] = array(
	'elements' => '#scroll-top.show',
	'property' => 'bottom',
	'value'    => $compare_style_options[ 'inspiry_stp_position_from_bottom' ],
);

return $compare_array;